{$M 1024, 196608, 196608} {(c) 1996 by Daniel Vollmer, based on something
                           by Paul H. Kahler}
Program orange;
const
     ratio=0.6;
     u:array[0..255] of byte=
     (
     56,56,57,57,58,58,59,59,59,60,60,60,60,60,60,59,59,59,58,58,57,57,
     56,56,55,54,53,53,52,51,50,49,48,47,47,46,45,44,43,43,42,41,40,40,
     39,39,38,38,37,37,37,37,36,36,36,35,35,35,34,34,33,33,32,32,31,31,
     30,29,29,28,27,26,26,25,24,23,23,22,21,20,20,19,18,18,17,17,16,16,
     15,15,15,15,14,14,14,14,14,14,14,15,15,15,15,15,16,16,16,16,17,17,
     17,17,17,16,16,16,15,15,14,14,13,12,12,11,10,10,9,8,7,7,6,6,5,5,4,
     4,4,4,4,3,3,4,4,4,4,4,5,5,6,6,7,8,8,9,10,11,12,12,13,14,15,16,17,
     18,19,19,20,21,22,22,23,24,24,25,25,25,26,26,27,27,27,28,28,28,29,
     29,29,30,30,31,31,32,32,33,34,34,35,36,37,37,38,39,40,40,41,42,43,
     43,44,45,45,46,46,47,47,48,48,49,49,49,49,49,49,49,49,49,49,49,49,
     48,48,48,48,47,47,47,47,47,46,46,47,47,47,47,48,48,49,49,50,51,51,
     52,53,53,54,55
     );

Var
      SinTable,CosTable: Array[0..255] of integer;
      Sin2Table,Cos2Table: Array[0..255] of integer;
      vmap:pointer;
      Map:word; {used as a pointer to the bitmap}
      vmap2:pointer;
      Map2:word; {used as a pointer to the bitmap}
      vscreen:pointer;
      vseg:word;
      rot:byte;
      x,y,dist,dist2:word;
      xcenter,ycenter:word;
      two:boolean;
      c:word;

Procedure MakeTables;                   {Creates sin/cos tables}
Var angle:real;
begin
     For c:=0 to 255 do begin   {use 256 degrees in circle}
         angle:=c;
         angle:=angle*pi/128;
         SinTable[c]:=round(Sin(angle)*256);
         CosTable[c]:=round(Cos(angle)*256);
         Sin2Table[c]:=round(Sin(angle+pi/2)*256*ratio);
         Cos2Table[c]:=round(Cos(angle+pi/2)*256*ratio);
     end;                 { the 1.2 accounts for pixel aspect ratio }
end;

procedure dopal(c,r,g,b:byte);assembler;
asm
   mov dx,3c8h
   mov al,c
   out dx,al
   inc dx
   mov al,r
   out dx,al
   mov al,g
   out dx,al
   mov al,b
   out dx,al
end;

procedure vlb;assembler;
asm
   mov dx,3d4h
   @1:
   in al,dx
   test al,8
   je @1
end;

Procedure DrawScreen(x,y,scale:word; rot:byte; offs,sourceseg,targseg:word);
var Temp:LongInt;
    ddx,ddy,d2x,d2y:integer;
    i,j:word;

begin
{ the following 8 lines of code calculate a 'right' and 'down' vector used
  for scanning the source bitmap. I use quotes because these directions
  depend on the rotation. For example, with a rotation, 'right' could mean
  up and to the left while 'down' means up and to the right. Since the
  destination image (screen) is scanned left-right/top-bottom, the bitmap
  needs to be scanned in arbitrary directions to get a rotation. }

     Temp:=(CosTable[rot]);Temp:=(Temp*Scale) div 256;
     ddx:=Temp;
     Temp:=(SinTable[rot]);Temp:=(Temp*Scale) div 256;
     ddy:=Temp;

{ Different tables are used for the 'down' vector to account for the non-
  square pixels in mode 13h (320x200). The 90 degree difference is built
  into the tables. If you don't like that, then use (rot+64)and255 here
  and take the pi/2 out of CreateTables. To each his own I guess. }

     Temp:=(Cos2Table[rot]);Temp:=(Temp*SCALE) div 256;
     d2x:=Temp;
     Temp:=(Sin2Table[rot]);Temp:=(Temp*SCALE) div 256;
     d2y:=Temp;

{ Since we want to rotate around the CENTER of the screen and not the upper
  left corner, we need to move 160 pixels 'left' and 100 'up' in the bitmap.}

     i:=(x-ddx*xcenter-d2x*ycenter) and 65535;
     j:=(y-ddy*xcenter-d2y*ycenter) and 65535;

{ The following chunk of assembly does the good stuff. It redraws the entire
  screen by scanning left-right/top-bottom on screen while also scanning the
  bitmap in the arbitrary directions determined above. }

         ASM
                 push ds
                 mov  ds,sourceseg
                 mov  es,targseg
                 mov  di,offs       {the video memory at beginning}
                 mov  si,ddx        {add ax,si  faster than  add ax,[ddx] }
                 mov  cx,100        {Number of rows on Screen}
         @vloop:
                 push cx
                 mov  ax,[i]        {start scanning the source bitmap}
                 mov  dx,[j]        {at i,j which were calculated above.}
                 mov  cx,80        {Number of coulumns on screen}
         @hloop1:
                 add  ax,si        {add the 'right' vector to the current}
                 add  dx,[ddy]     {bitmap coordinates.  8.8 fixed point}
                 mov  bl,ah        {  bx = 256*int(y)+int(x)  }
                 mov  bh,dh
                 mov  bl,[ds:bx]   { load a pixel from source }
                 mov  [es:di],bl   { copy it to destination }
{                 inc  di           { advance to next destination pixel }
                 add  di,4

                 dec  cx
                 jnz  @hloop1        {End of horizontal loop}
                 add  di,320
                 mov  ax,d2x        { get the 'down' vector }
                 mov  dx,d2y

{                 add  si,2     {** uncomment this instr. for extra fun **}

                 add  i,ax          { i,j is the starting coords for a line }
                 add  j,dx          { so this moves down one line }
                 pop  cx            { get the row count back and loop }
                 dec  cx
                 jnz  @vloop         { End of verticle loop }
                 pop  ds            { Restore the ds }
         end;
end;

procedure switch(source, dest : word);assembler;
asm
   push ds
   mov  es,dest
   mov  ds,source
   xor  si,si
   xor  di,di
   mov  cx,16000
   db $66
   rep  movsw
   pop  ds
end;

(*procedure cls(segment:word);assembler;
     asm
        mov cx, 16000
        mov es,segment
        xor di,di
        db $66
        xor ax,ax
        db $66
        rep stosw
     end;*)

Begin
     write('1 or 2 planes? ');
     repeat c:=port[$60]; until (c=2) or (c=3);
     if c=3 then two:=true else two:=false;
     getmem(vscreen,65535);
     vseg:=seg(vscreen^);
     getmem(vmap,65535);
     map:=seg(vmap^);
     if two then begin
        getmem(vmap2,65535);
        map2:=seg(vmap2^);
     end;
     Asm
        Mov     Ax,13h
        Int     10h
     end;
     MakeTables;
     for c:=0 to 127 do dopal(c,c div 4,0,c div 6);
     for c:=0 to 127 do dopal(c+128,c div 6,c div 20,c div 4);
{     for c:=0 to 127 do dopal(c+128,c div 4,0,c div 2);}
{     assign(f,'strich.raw');
     reset(f,1);
     blockread(f,vmap2^,65535);
     close(f);
     assign(f,'strich.raw');
     reset(f,1);
     blockread(f,vmap^,65535);
     close(f);}

{     for c:=0 to 65535 do mem[map:c]:=random(127);
     for c:=1 to 15 do smooth_cut(map,map,65535);
     for c:=1 to 65535 do mem[map:c]:=mem[map:c]+20;
     if two then begin
        for c:=0 to 65535 do mem[map2:c]:=random(127);
        for c:=1 to 15 do smooth_cut(map2,map2,65535);
        for c:=1 to 65535 do mem[map2:c]:=mem[map2:c]+148;
     end;}
     for c:=0 to 65535 do mem[map:c]:=hi(c) xor lo(c);
     if two then
          for c:=0 to 65535 do mem[map2:c]:=hi(c) xor lo(c);
{     for y:=0 to 255 do
         for x:=0 to 255 do mem[map2:y shl 8+x]:=u[(x+y) and 255]-c+u[(y+c) and 255] shl 1;}
     repeat
        rot:=(sintable[(c shr 1) and 255]+256) shr 3;
        x:=(costable[c and 255]+256) shl 5;
        y:=(sintable[c and 255]+256) shl 5;
        dist:=(sintable[c and 255]+290) shl 2;
        dist2:=(costable[c and 255]+290) shl 2;
        xcenter:=(costable[(c shr 2) and 255] +256) shr 2;
        ycenter:=(sintable[(c shr 2) and 255] +256) shr 2;
{        xcenter:=0;ycenter:=0;}
        inc(c);
        if two then
        Case c and 3 of
             0:begin
                    DrawScreen(x,y,dist,rot,0,map2,vseg);
                    DrawScreen(y,x,dist2,-rot and 255,1,map,vseg);
               end;
             1:begin
                    DrawScreen(x,y,dist,rot,2,map2,vseg);
                    DrawScreen(y,x,dist2,-rot and 255,3,map,vseg);
               end;
             2:begin
                    DrawScreen(x,y,dist,rot,321,map2,vseg);
                    DrawScreen(y,x,dist2,-rot and 255,320,map,vseg);
               end;
             3:begin
                    DrawScreen(x,y,dist,rot,323,map2,vseg);
                    DrawScreen(y,x,dist2,-rot and 255,322,map,vseg);
               end;
        end else
        Case c and 7 of
             0:DrawScreen(x,y,dist,rot,0,map,vseg);
             1:DrawScreen(x,y,dist,rot,2,map,vseg);
             2:DrawScreen(x,y,dist,rot,321,map,vseg);
             3:DrawScreen(x,y,dist,rot,323,map,vseg);
             4:DrawScreen(x,y,dist,rot,1,map,vseg);
             5:DrawScreen(x,y,dist,rot,3,map,vseg);
             6:DrawScreen(x,y,dist,rot,320,map,vseg);
             7:DrawScreen(x,y,dist,rot,322,map,vseg);
        end;
        vlb;
        switch(vseg,$a000);
     until port[$60]=1;
     ASM {back to 80x25}
      MOV AX,3
      INT 10h
     END;
     freemem(vscreen,65535);
     freemem(vmap,65535);
     if two then freemem(vmap2,65535);
end.