// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

// This is an example of a program using the C++ packing interface.
// It uses the standard C++ streams. I have never used these before,
// so I won't guarantee anything :-)

#include <suppack.hpp>
#include <fstream.h>
#include <ctype.h>

#define READ_ERR  1
#define WRITE_ERR 2

// Class that takes care of fileio
class fileio:public packing {
  ofstream outfile; // Destinations file
  ifstream infile;  // Source file
  long rd,written;  // Number of bytes read/written

  void write_status() {
    cout<<"\rRead "<<rd<<". Written "<<written<<'.';
  }

  virtual int read(char* buffer, unsigned* bufsize) {
    infile.read(buffer,*bufsize);     // Read from the file
    if(infile.bad()) return READ_ERR; // Return if an error occured
    *bufsize=infile.gcount();         // Number of bytes read
    rd+=*bufsize;
    return PACK_NOERR;
  }

  virtual int write(char* buffer, unsigned bufsize) {
    outfile.write(buffer,bufsize);
    if(outfile.fail()) return WRITE_ERR;
    written+=bufsize;
    write_status();
    return PACK_NOERR;
  }

  public:

  fileio(char* ifile, char* ofile) :
    infile(ifile,ios::binary), outfile(ofile,ios::binary), rd(0), written(0)
    { write_status(); }

  ~fileio() { write_status(); cout<<'\n'; }
};

main(int argc, char* argv[]) {
  if((argc!=4) || ((toupper(argv[1][0])!='A') && (toupper(argv[1][0])!='E'))) {
    cout<<"Syntax: SUPPACK.EXE a|e packedfile unpackedfile\n";
    return 1;
  }

  int err;

  if(toupper(argv[1][0])=='E') { // Unpack
    fileio f(argv[2],argv[3]);
    err=f.do_decode();
  } else { // Pack
    fileio f(argv[3],argv[2]);
    err=f.do_encode();
  }

  switch(err) {
    case PACK_EOD:    cout<<"Unexpected end of file\n"; break;
    case PACK_NO_MEM: cout<<"Not enough memory\n"; break;
    case READ_ERR:    cout<<"Read error\n"; break;
    case WRITE_ERR:   cout<<"Write error\n"; break;
  }

  return err;
}