Program Textured_Tunnel;

Uses
  Crt;

Const
  VidSeg    : Word = $A000;

Type
  TableType = Array[0..65534] of Byte;

Var
  RadTable,AngTable : ^TableType;
  TunTex            : Pointer;
  TunTexSeg         : Word;
  Time              : Longint ABSOLUTE $0040:$006C;
  T1,Frames         : LongInt;
  Ft                : Real;
  T                 : Byte;
  Loop1,Loop2,VAddr : Word;
  Count             : Integer;

{}
{                        Utility Routines                                }
{}

Procedure VideoMode(Mode : Byte); Assembler;

Asm
  Mov   AH,00
  Mov   AL,Mode
  Int   10h
End;

Procedure Mode_256;

Begin
  Port[$3D4]:=$11; Port[$3D5]:=Port[$3D5] AND $7F;
  Port[$3C2]:=$E3;
  Port[$3D4]:=$0;  Port[$3D5]:=$5F;
  Port[$3D4]:=$1;  Port[$3D5]:=$3F;
  Port[$3D4]:=$2;  Port[$3D5]:=$40;
  Port[$3D4]:=$3;  Port[$3D5]:=$82;
  Port[$3D4]:=$4;  Port[$3D5]:=$4A;
  Port[$3D4]:=$5;  Port[$3D5]:=$9A;
  Port[$3D4]:=$6;  Port[$3D5]:=$6F;
  Port[$3D4]:=$7;  Port[$3D5]:=$B2;
  Port[$3D4]:=$8;  Port[$3D5]:=$0;
  Port[$3D4]:=$9;  Port[$3D5]:=$61;
  Port[$3D4]:=$10; Port[$3D5]:=$28;
  Port[$3D4]:=$11; Port[$3D5]:=$8A;
  Port[$3D4]:=$12; Port[$3D5]:=$FF;
  Port[$3D4]:=$13; Port[$3D5]:=$20;
  Port[$3D4]:=$14; Port[$3D5]:=$40;
  Port[$3D4]:=$15; Port[$3D5]:=$7;
  Port[$3D4]:=$16; Port[$3D5]:=$1A;
  Port[$3D4]:=$17; Port[$3D5]:=$A3;
  Port[$3C4]:=$1;  Port[$3C5]:=$1;
  Port[$3C4]:=$3;  Port[$3C5]:=$0;
  Port[$3C4]:=$4;  Port[$3C5]:=$E;
  Port[$3CE]:=$5;  Port[$3CF]:=$40;
  Port[$3CE]:=$6;  Port[$3CF]:=$5;
End;

Function Pow(Base,P : Real) : Real;

Begin
  Pow:=Exp(Ln(Base)*P);
End;

Function IntSqrt(Const L : LongInt) : Word; Assembler;

(* This routine was "borrowed" from Demostu3.zip ;) *)

Asm
	Db $66; mov ax,WORD PTR [l]
	Db $66; mov bx,ax
	Db $66; mov cx, $0000; DW $4000;
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over1
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over1:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over2
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over2: Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over3
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over3:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over4
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over4:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over5
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over5:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over6
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over6:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over7
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over7:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over8
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over8:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over9
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over9:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over10
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over10:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over11
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over11:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over12
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over12:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over13
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over13:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over14
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over14:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over15
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over15:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over16
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over16:
End;

Procedure LoadTga(TgaName : String);

Var
  InF   : File; Loop : Word;
  Dummy : Array[1..18] of Byte;
  Pal   : Array[1..768] of Byte;

Begin
  Assign(Inf,TgaName);
  Reset(Inf,1);
  BlockRead(Inf,Dummy,18);
  BlockRead(Inf,Pal,768);
  BlockRead(Inf,TunTex^,65535);
  Close(Inf);
  Port[$3C8]:=0;
  Loop:=1;
  While Loop<768 Do
    Begin
      Port[$3C9]:=Pal[Loop+2] Div 4;
      Port[$3C9]:=Pal[Loop+1] Div 4;
      Port[$3C9]:=Pal[Loop] Div 4;
      Inc(Loop,3);
    End;
End;

{}
{                      Precalculation Routines                           }
{}

Procedure CalcTables;

Var
  X,Y,Angle            : Real;
  AngleI,I,I2,J,J2,Rad : LongInt;

Begin
  For J:=-128 to 128 Do
    For I:=-128 to 128 Do
      Begin
        If I<>0 Then I2:=I Else I2:=1;
        If J<>0 Then J2:=J Else J2:=1;
      	Rad:=IntSqrt((I2*I2)+(J2*J2));
        Rad:=Trunc(8*32*Pow((256*1024*Rad),0.1));
        Rad:=Rad+Trunc((32*Sin(Rad*1.284/64)));
        RadTable^[((J+128) shl 8)+I+128]:=Rad And 255;
      End;
  For J:=-128 to 128 Do
    For I:=-128 to 128 Do
      Begin
        If I<>0 Then X:=I Else X:=0.0001;
        If J<>0 Then Y:=J Else Y:=0.0001;
        Angle:=ArcTan(Y/X)*(256/6.284);
        AngleI:=Trunc(Angle);
        AngTable^[((J+128) shl 8)+(I+128)]:=AngleI And 255;
      End;
End;

{}
{                         Tunnel Routine                                 }
{}

Procedure DoTunnel(Radoff,AngOff : Integer); Assembler;

{ This routine demonstrates the use of the 386 segment regs fs & gs which
  aren't normaly usable from Turbo Pascal }

Asm
       Push  Ds
       Mov   Di,256
       Mov   Cx,65024
       Mov   Ax,Word ptr RadTable[2]
       Mov   Es,Ax
       Mov   Ax,Word ptr AngTable[2]
       Mov   Dx,Ax
       Mov   Ax,TunTexSeg
       Db    $8e,$e8         { Mov Gs,Ax }
       Mov   Ax,SegA000
       Db    $8e,$e0         { Mov Fs,Ax }
       Mov   Ds,Dx
       Mov   Dx,RadOff
@Loop: Mov   Al,Es:[Di]
       Add   Ax,Dx
       Shl   Ax,8
       Add   Ax,AngOff
       Mov   Si,Ax
       Xor   Ax,Ax
       Mov   Al,Ds:[Di]
       Shl   Ax,1
       Add   Si,Ax
       Db    65h
       Mov   Bl,[Si]         { Mov Bl,Gs:[Si] }
       Db    64h
       Mov   [Di],Bl         { Mov Fs:[Di],Bl }
       Inc   Di
       Dec   Cx
       Jnz   @Loop
       Pop   Ds
End;

{}
{                         Startup Routines                               }
{}

Procedure Initialize;

Begin
  ClrScr; Writeln;
  Writeln('This routine runs in a tweaked 256*256*256 mode so if your gfx card can''t handleit then Tough ;)');
  Writeln;
  Writeln('Please Wait - Performing some pre-calcs just now which can take a while :( ');
  GetMem(TunTex,65535); TunTexSeg:=Seg(TunTex^); T:=0; Ft:=0;
  Writeln; New(RadTable); New(AngTable);
  Writeln('Calcing Angle and Radius tables............... '); CalcTables;
  VideoMode($13); Mode_256;
  LoadTga('Mess.Tga');
End;

Begin
  Initialize;
  Frames:=0; T1:=Time;
  Repeat
    DoTunnel(-T*3,T);
    Ft:=Ft+0.9;
    T:=Trunc(Ft);
    Inc(Frames);
  Until (Keypressed);
  Textmode(3);
  T1:=Time-T1;
  Writeln('Code by Gedge'); Writeln;
  WriteLn(Frames/(T1/18.2):1:2,' Frames per second');
  Dispose(RadTable); Dispose(AngTable);
  FreeMem(TunTex,65535);
End.










