// Text mode library header file


// 
// Prototypes for Screen Routines
void InitTxt(int setscr);
void SetMode(int mode);
BYTE GetMode(void);
void FastWr(BYTE x, BYTE y, BYTE attr, BYTE *str);
void ChrWr(BYTE x, BYTE y, BYTE chr, BYTE attr);
void AttrWr(BYTE x, BYTE y, BYTE attr);
BYTE ChrRd(BYTE x, BYTE y);
BYTE AttrRd(BYTE x, BYTE y);
void ClrScr(void);
void HighBk(void);
void NormBk(void);
void CurPos(BYTE x, BYTE y);
BYTE GetCurX(void);
BYTE GetCurY(void);
void ShowCur(void);
void HideCur(void);
void SetCur(BYTE minrow, BYTE maxrow);
void SWPage(BYTE pgno);
void CpPage(char src, char dest);
void ScrollUp(BYTE x1, BYTE y1, BYTE x2, BYTE y2, BYTE lines);
void ScrollDown(BYTE x1, BYTE y1, BYTE x2, BYTE y2, BYTE lines);
void ShowBin(BYTE *buff);
void SaveBl(BYTE *buff, register int y1, register int y2);
void RestBl(BYTE *buff, register int y1, register int y2);
char LoadBin(char *filename);
void CutBinBlk(int x1, int y1, int x2, int y2, char *buff, char *cutbuff);
void PrintCode(BYTE *name, BYTE *text);
// Screen Definitions (MISC)
#define TEXT80x25       3
#define TEXT80x60       78
#define TEXT132x25      80
#define TEXT132x43      81
#define TEXT132x60      79
#define GRAPH320x200    19
#define GRAPH600x480    83
#define COLORSEG        0xB800
#define MONOSEG         0xB000
#define COLOR           0
#define MONO            1
// Boxes
void Box3D(int x1, int y1, int x2, int y2, int color, int shad, int indent, char type);
// Box Defines
#define SIDES   0
#define NOSIDES 1
// Screen Externals
extern  BYTE volatile *volatile videotxt;
extern  BYTE TMODEX;
extern  BYTE TMODEY;
// 
// Prototypes for Palette Routines
void PAL_Init(void);
void PAL_SetTextPal(int color, int r, int g, int b);
void PAL_GetTextPal(int color, int *r, int *g, int *b);
void PAL_Fade(int a);
void PAL_DimDown(int dly);
void PAL_DimUp(int dly);
void PAL_Blank(void);
void Wait_VRetrace(void);
// 
// Prototypes for Mouse Routines
WORD MousePosY(void);
WORD MousePosX(void);
WORD MouseBut(void);
void MousePos(WORD x, WORD y);
void ShowMouse(void);
void MouseBound(WORD x1,WORD y1,WORD x2,WORD y2);
void ShowMouse(void);
void HideMouse(void);
int InitMouse(void);
void MouseOff(void);
void MouseOn(void);
// Defines for Mouse Routines
#define MOUSEOFF        0
#define MOUSEGFX        1
#define MOUSETXT        2
#define S80x25          1                     // Mouse Standard 80x25 Mode
// Externals for Mouse Routines
extern int MOUSESTAT;
// 
// Prototypes for Pulldown Menu Routines
void WaitKMT(WORD time);
WORD Scan4Key(void);
BYTE GetCAS(void);
void SetCAS(BYTE val);
// 
// Prototypes for Pulldown Menu Routines
BYTE PullMenu(BYTE *mstruct);
// 
// Prototypes for Windows Routines
void WIN_Init(int x1, int y1, int x2, int y2);
void WIN_End(void);
int WIN_Open(int x1, int y1, int x2, int y2, char color, char shadow, char indent, char *header, char headerattr, char type);
void WIN_Close(int winid);
void WIN_Pop(int winid);
void WIN_Push(int winid);
void WIN_Redraw(int wnmv);
void WIN_Move(int winid);
void WIN_Cursor(int winid, int x, int y);
void WIN_Header(int winid, BYTE *header);
void WIN_Maximize(int winid);
void WIN_Resize(int winid);
WORD WIN_Size(int winid);
void WIN_Buff(int winid, BYTE *buff);
void WIN_ChrWr(int winid, int x1, int y1, int chr, char attr);
void WIN_FastWr(int winid, int x1, int y1, char *buff, char attr);
void WIN_Scroll(int winid, int dir);
int WIN_Control(int chr);
// Window Defines
#define WIN_NONE        0                       // NONE
#define WIN_MAXIMISE    1                       // MAXIMISE ENABLE
#define WIN_RESIZE      2                       // RESIZE ENABLE
#define WIN_MOVE        4                       // MOVE ENABLE
#define WIN_MESSAGE     8                       // ONLY USED FOR MESSAGES
#define WIN_ALL         0x0FF                   // FULL (ALL OPTIONS ENABLED)
// 
// Prototypes for button Routines
void BUT_Init(void);
void BUT_End(void);
BYTE BUT_Open(int x1, int y1, int x2, int y2, char color, char type, char switchstat, char *name, char nameattr);
void BUT_Close(BYTE butid);
void BUT_Redraw(void);
void BUT_HiLight(BYTE butid, char state);
void BUT_InOut(BYTE butid, char state);
BYTE BUT_Control(void);
// Defines for Button Routines
#define BPUSHBUT 0
#define BSWITCH  1
// 
// Prototypes for file Routines
void File_Window(BYTE *path);
// 
//  Colour Definitions
#define HIGH            8+
#define WHITE           7
#define BROWN           6
#define YELLOW          6
#define MAGNETTA        5
#define RED             4
#define CYAN            3
#define GREEN           2
#define BLUE            1
#define BLACK           0
#define GREY            0

// 
//  Miscellaneous Definitions
#define IN              1
#define ON              1
#define YES             1
#define TRUE            1
#define GOOD            1
#define PASS            1
#define ACTIVE          1
#define FORWARD         1
#define UP              1
#define OUT             0
#define BACKWARD        0
#define OFF             0
#define NO              0
#define FALSE           0
#define FAIL            0
#define BAD             0
#define INACTIVE        0
#define DOWN            0

#define ERROR           -1
#define MEMERROR        -2

#define INDENT          YES
#define EMBOSS          NO
