// C library for gate 32 dos extender

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef void *          PTR;
typedef char *          STR;
typedef int             BOOL;


#define  PAL_H

#ifndef FASTCALLS
#define _fastcall
#endif


#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
 *       STARTUP
 ***************************************************************************/
extern DWORD dos32version;       /* version of DOS32.                      */
extern char  dos32system;        /* system type-RAW,XMS,VCPI or DPMI       */
extern DWORD exesize;            /* size in bytes                          */
extern char * exename;           /* PSZ to executable name                 */
extern STR _psp;                 /* program segment prefix pointer         */
extern char *_environ;           /* environment pointer                    */
extern char **environ;           /* pointer of environment pointer table   */
extern DWORD envsize;            /* environment table size                 */
extern PTR _zero;                /* zero pointer                           */
extern DWORD _zero_sel;          /* selector of zero based semgnet         */

extern PTR DMA_addr;              /* DMA near pointer address         */
extern DWORD DMA_size;            /* DMA buffer size                  */
extern PTR DMA_phys;              /* DMA physical address             */
extern STR _BIOS;                // BIOS data area


/****************************************************************************
 * FILEIO - file I/O
 ***************************************************************************/
extern cdecl void driveex (void);
extern BYTE drives[26][4];
extern long _fastcall chdir(STR path);
extern long _fastcall getdir(char drive, STR path);
extern char _fastcall getdrive(void);
extern long _fastcall setdrive(char drive);
extern unsigned long _fastcall drsize(char drive);
extern unsigned long _fastcall drfree(char drive);
extern DWORD *_fastcall getdpblock(char drive);
extern long _fastcall close(long handle);
extern long _fastcall filelength(long handle);
extern long fprint(long handle,STR fmtstr,...);
extern long _fastcall lseek(long handle,long filepos,long whence);
extern long _fastcall mkdir(STR path);
extern long _fastcall open(STR filename,DWORD filemode);
extern long _fastcall read(long handle,PTR buf,DWORD len);
extern long _fastcall rename(STR oldname,STR newname);
extern long _fastcall rmdir(STR path);
extern long _fastcall unlink(STR filename);
extern long _fastcall write(long handle,PTR buf,DWORD len);
extern long _fastcall creat(STR filename, long filemode);

extern long _fastcall findfirst(STR filename, STR mask, DWORD attr);
extern long _fastcall findnext(STR filename);

extern long fprintf(long handle, STR fmtstr,...);

#define O_BINARY   0          /* Binary mode                                 */
#define O_RDONLY   0          /* Read only                                   */
#define O_WRONLY   1          /* Write only                                  */
#define O_RDWR     2          /* Read and write                              */
#define O_APPEND   4          /* File pointer will be set to the end of file */
#define O_CREAT    8          /* Creates the file if it doesn't exist        */
#define O_TRUNC    16	      /* Truncate the file when open                 */
#define O_EXCL     32         /* Returns an error if file exists (O_CREAT)   */

#define SEEK_SET   0          /* Seek from file beginning                    */
#define SEEK_CUR   1          /* Seek from current file position             */
#define SEEK_END   2          /* Seek from end of file                       */

#define DRIVEXISTS 1

#define REMOVEDRV  0
#define FIXEDDRV   1

#define LOCALDRV   0
#define REMOTEDRV  1
#define SHAREDRV   2

#define FLOPPY     0
#define HARD       1
#define RAM        2
#define SUBST      3
#define CDROM      4

/*****************************************************************************
 * MALLOC - memory allocation
 ****************************************************************************/
extern PTR _fastcall malloc(DWORD blocksize);
extern PTR _fastcall calloc(DWORD blocksize);
extern void _fastcall free(PTR blockptr);
extern DWORD maxavail(void);
extern DWORD memavail(void);
extern PTR _fastcall realloc(PTR blockptr,DWORD size);
extern PTR _fastcall resize(PTR blockptr,DWORD size);

/*****************************************************************************
 *   MATH - math functions
 ****************************************************************************/
extern DWORD _fastcall max(DWORD a,DWORD b);
extern DWORD _fastcall max3(DWORD a,DWORD b,DWORD c);
extern DWORD _fastcall min(DWORD a,DWORD b);
extern DWORD _fastcall max3(DWORD a,DWORD b,DWORD c);
extern DWORD _fastcall atoi(STR string);


/*****************************************************************************
 * STRINGS - various string I/O
 ****************************************************************************/
extern DWORD _fastcall isdigit(char chr);
extern DWORD _fastcall isxdigit(char chr);
extern DWORD _fastcall isalpha(char chr);
extern DWORD _fastcall islower(char chr);
extern DWORD _fastcall isupper(char chr);
extern DWORD _fastcall isalnum(char chr);
extern DWORD _fastcall iscntrl(char chr);
extern DWORD _fastcall isspace(char chr);
extern DWORD _fastcall ispunct(char chr);
extern DWORD _fastcall isascii(char chr);
extern DWORD _fastcall isprint(char chr);
extern DWORD _fastcall toupper(char chr);
extern DWORD _fastcall tolowwer(char chr);

extern STR _fastcall btoa(DWORD value,STR string);
extern STR _fastcall ltoa(long value,STR string,int radix);
extern STR _fastcall ultoa(DWORD value,STR string,int radix);
extern STR _fastcall otoa(DWORD value,STR string);
extern STR _fastcall xtoa(DWORD value,STR string);
extern STR _fastcall ptos(PTR pascalstr);
extern DWORD sprintf(STR dest,STR fmtstr,...);
extern STR _fastcall stpcpy(STR dest,STR source);
extern STR _fastcall strcat(STR dest,STR source);
extern STR _fastcall strchr(STR string,char chr);
extern STR _fastcall strchrn(char string,char chr);
extern STR _fastcall strcpy(STR destptr,STR srcptr);
extern STR _fastcall strdup(STR string);
extern long _fastcall strcmp(STR srcptr,STR destptr);
extern long _fastcall stricmp(STR srcptr,STR destptr);
extern DWORD _fastcall strlen(STR string);
extern STR _fastcall strlwr(STR string);
extern STR _fastcall strupr(STR string);
extern STR _fastcall strncpy(STR dest,STR source,DWORD length);
extern int strncmp(BYTE *src, BYTE *dest, DWORD length);
extern STR _fastcall strpbrk(STR s1,STR s2);


/**************************************************************************
 * CONIO - console I/O
 *************************************************************************/

extern long printf(STR fmtstr,...);
extern long kbhit(void);
extern WORD getch(void);
extern cdecl DWORD random(BYTE bits);


/*****************************************************************************
 * SYSTEM - system specific
 ****************************************************************************/
extern void delay(int millisecs);
extern void abort(void);
extern DWORD _fastcall atexit(PTR exitfunc);
extern void _fastcall exit(int errorlevel);
extern PTR _fastcall getvect(DWORD interrupt);
extern PTR _fastcall setvect(DWORD interrupt,PTR vector);
extern DWORD _fastcall MK_FP(PTR address);
extern PTR _fastcall MK_FAR(DWORD);
extern void _fastcall memset(PTR buf,char value,DWORD length);
extern PTR _fastcall memcpy(void * dest,void * source,int length);
extern PTR _fastcall memmove(void * dest, void * source, DWORD count);
extern void _fastcall _exit(DWORD errorlevel);
extern void _fastcall _cexit(void);
extern PTR _fastcall getenv(char * name);
extern int _fastcall inp(unsigned portid);
extern unsigned _fastcall inpw(unsigned portid);
extern int _fastcall outp(unsigned portid, int value);
extern unsigned _fastcall outpw(unsigned portid, unsigned value);

extern long errno;                      /* System error code */


#ifdef __cplusplus
}
#endif


/******************************************************************************
  *  Standed macros
******************************************************************************/
#define  EOF  -1
#define  NULL  0
#define  EXIT_SUCCESS 0
#define  EXIT_FAILURE 1



/* extern long _fastcall fopen(STR filename,STR filemode);


#define  stdin   0                          // Standard input file ptr
#define  stdout  1                          // Standard output file ptr
#define  stderr  2                          // Standard error file ptr

#define  fgetc  getc
#define  fputc  putc
#define  getchar() getc(stdin)
#define  putchar(c) putc((c),stdout)

extern long _fastcall putc(char chr,long handle);
extern long _fastcall getc(long handle);

*/

