unit s3mpl;

interface

procedure plays3m(s3mfile:string);
procedure bars;
procedure checkcfg;
procedure stopmusic;
procedure checkmusic;

implementation

uses crt, MIDAS, Errors, mMem, SDevice, DMA, MPlayer,
        S3M, MODp, MTM, mFile, mConfig, fadeunt;

const
    modulePlayers : array[0..(NUMMPLAYERS-1)] of PModulePlayer = (
        @mpS3M, @mpMOD, @mpMTM );

var isconfig,tmp,c,col,col1:integer;


procedure WaitVR; assembler;
asm
        mov     dx,03DAh
@wvr:   in      al,dx
        test    al,8
        jz      @wvr
end;


procedure WaitDE; assembler;
asm
        mov     dx,03DAh
@wde:   in      al,dx
        test    al,1
        jnz     @wde
end;

{}
procedure toASCIIZ(dest : PChar; str : string);
var
    spos, slen : integer;
    i : integer;

begin
    spos := 0;                          { string position = 0 }
    slen := ord(str[0]);                { string length }

    { copy string to ASCIIZ conversion buffer: }
    while spos < slen do
    begin
        dest[spos] := str[spos+1];
        spos := spos + 1;
    end;

    dest[spos] := chr(0);               { put terminating 0 to end of string }
end;
{}



var
    error, plMusic : integer;
    module : PmpModule;
    SD : PSoundDevice;
    MP : PModulePlayer;
    key : char;
    meter : word;
    info : PmpInformation;
    i : integer;
    stopPlay : boolean;
    str : array[0..256] of char;
    fname : string;
    chMuted : array[0..31] of integer;
    chNum : integer;


procedure DrawMeters;
var
    i, error : integer;
    meter, pos : word;
    rate : longint;
    chan : PmpChanInfo;

begin
    { do all channels: }
    for i := 0 to (info^.numChannels-1) do
    begin
        { point chan to current channel information: }
        chan := @info^.chans^[i];

        { check that the channel has a valid instrument set }
        if (chan^.instrument > 0) and
            (chan^.instrument <= module^.numInsts) and
            (chMuted[i] = 0) then
        begin
{$IFDEF REALVUMETERS}
            { read channel playing rate: }
            error := SD^.GetRate(i, @rate);
            if error <> OK then
                midasError(error);

            { read channel playing position: }
            error := SD^.GetPosition(i, @pos);
            if error <> OK then
                midasError(error);

            { if there is sound being player, calculate VU-meter value: }
            if rate <> 0 then
            begin
                error := vuMeter(
                    module^.insts^[chan^.instrument-1].sdInstHandle,
                    rate, pos, chan^.volume, @meter);
                if error <> OK then
                    midasError(error);
            end
            else
                { no sound - meter = 0; }
                meter := 0;
{$ELSE}
            meter := chan^.volumebar;
{$ENDIF}
        end
        else
        begin
            { no valid instrument - set meter to zero }
            meter := 0;
        end;

        { Draw the VU-meter: }
asm
        cld
        mov     es,SegB800              { point es to screen segment }

        mov     ax,160
        mul     i                       { i = channel number = y-coordinate }
        mov     di,ax                   { address = 160 * i }
        mov     bx,80                   { bx = total amount to draw }
        mov     cx,meter                { cx = vu meter }
        sub     bx,cx                   { bx = amount left after meter }
        test    cx,cx
        jz      @nometer
        mov     ax,$0BFE                { draw first 'meter' boxes with }
        rep     stosw                   { attribute $0B }

@nometer:
        mov     cx,bx                   { cx = amount to draw after meter }
        test    cx,cx
        jz      @done
        mov     ax,$0{8FE}              { draw the rest of the 64 boxes with }
        rep     stosw                   { attribute $0B }
@done:
end;

    end;
end;


{}
function PlayModule(fileName : Pchar) : PmpModule;
var
    header : pointer;
    f : fileHandle;
    module : PmpModule;
    error, mpNum, recognized : integer;
begin
    { allocate memory for module header: }
    error := memAlloc(MPHDRSIZE, @header);
    if error <> OK then
        midasError(error);

    { open module file: }
    error := fileOpen(fileName, fileOpenRead, @f);
    if error <> OK then
        midasError(error);

    { read MPHDRSIZE bytes of module header: }
    error := fileRead(f, header, MPHDRSIZE);
    if error <> OK then
        midasError(error);

    error := fileClose(f);
    if error <> OK then
        midasError(error);

    { Search through all Module Players to find one that recognizes the
      file header: }
    mpNum := 0;
    MP := NIL;
    while (mpNum < NUMMPLAYERS) and (MP = NIL) do
    begin
        error := modulePlayers[mpNum]^.Identify(header, @recognized);
        if error <> OK then
            midasError(error);
        if recognized = 1 then
            MP := modulePlayers[mpNum];
        mpNum := mpNum + 1;
    end;

    { deallocate module header: }
    error := memFree(header);
    if error <> OK then
        midasError(error);

    if MP = NIL then
    begin
        midasClose;
        errErrorExit('Error: Unknown module format')
    end;

    { load the module file using correct Module Player: }
{$IFDEF REALVUMETERS}
    module := midasLoadModule(fileName, MP, @vuPrepare);
{$ELSE}
    module := midasLoadModule(fileName, MP, NIL);
{$ENDIF

    { play the module: }
    midasPlayModule(module, 0);

    PlayModule := module;
end;
{}

{}
procedure FreeModule(module : PmpModule);
var
    i, error : integer;
    insthdl : word;
begin
{$IFDEF REALVUMETERS}
    { Deallocate VU-meter information for all instruments: }
    for i := 0 to (module^.numInsts-1) do
    begin
        insthdl := module^.insts^[i].sdInstHandle;
        if insthdl <> 0 then
        begin
            error := vuRemove(insthdl);
            if error <> OK then
                midasError(error);
        end
    end;
{$ENDIF}
    midasFreeModule(module);
end;
{}

procedure plays3m(s3mfile:string);
BEGIN
    midasSetDefaults;                   { set MIDAS defaults }
    midasLoadConfig('MIDAS.CFG');       { load configuration }
    midasInit;                          { initialize MIDAS Sound System }
    {midasParseEnvironment;                  { parse "MIDAS" environment }
    { midasConfig; }

    { parse MIDAS command line options: }
 {   for i := 2 to (ParamCount) do
    begin}
        toASCIIZ(str, s3mfile );
{        midasParseOption(@str[1]);
    end;}

    for i := 0 to 31 do
        chMuted[i] := 0;

{    midasInit;                              { initialize MIDAS }
   SD := midasSD;

{$IFDEF REALVUMETERS}
    Initialize real VU meters:
    error := vuInit;
    if error <> OK then
        midasError(error);
{$ENDIF}

    toASCIIZ(str, s3mfile);
    (**)
    module := PlayModule(str);              { load and play module }
    MP := midasMP;


    stopPlay := false;
    end;

    procedure bars;
    begin
    for tmp:=1 to 27 do begin delay(15);waitvr;writeln;end;
    clrscr;
    tmp:=1;
    randomize;
    while not stopPlay do
    begin
        WaitVR;                         { wait for Vertical Retrace }
        WaitDE;                         { wait for Display Enable }
{$IFDEF NOTIMER}

        { If timer is not being used, poll the player manually. Note that this
          should not normally be done, as it changes the tempo when playing
          with GUS, but is here to help debugging. }

        error := SD^.StartPlay;
        if error <> OK then
            midasError(error);

        if SD^.tempoPoll = 1 then
        begin
            error := SD^.Play(@plMusic);
            if error <> OK then
                midasError(error);
            SetBorder(14);
            error := MP^.Play;
            if error <> OK then
                midasError(error);
        end
        else
        begin
            error := SD^.Play(@plMusic);
            if error <> OK then
                midasError(error);

            while plMusic = 1 do
            begin
                SetBorder(14);
                error := MP^.Play;
                if error <> OK then
                    midasError(error);
                SetBorder(15);
                error := SD^.Play(@plMusic);
                if error <> OK then
                    midasError(error);
            end;
        end;

{$ENDIF}

        { read Module Player information to info^: }
        error := MP^.GetInformation(@info);
        if error <> OK then
            midasError(error);

        { draw VU-meters to top of display: }
        DrawMeters;

      gotoxy(33,23);textcolor(white);
      Write('Pat: ', info^.pos, '  Row: ', info^.row, '  ', chr(13));

      gotoxy(1,22);textcolor(col);writeln('Red Power Red Power Red Power Red Power Red Power Red Power Red Power Red PoweR');
      gotoxy(1,23);textcolor(col);writeln('R');gotoxy(79,23);writeln('R');
      gotoxy(1,24);textcolor(col);writeln('Red Power Red Power Red Power Red Power Red Power Red Power Red Power Red PoweR');
      col:=col+1;
      if col >15 then col:=1;

if info^.pos=0 then col1:=1;if info^.pos=2 then col1:=2;if info^.pos=4 then col1:=3;
if info^.pos=6 then col1:=4;if info^.pos=8 then col1:=5;if info^.pos=10 then col1:=6;
if info^.pos=12 then col1:=7;if info^.pos=14 then col1:=1;if info^.pos=16 then col1:=2;
if info^.pos=18 then col1:=3;if info^.pos=20 then col1:=4;if info^.pos=22 then col1:=5;
if info^.pos=24 then col1:=6;if info^.pos=26 then col1:=7;if info^.pos=28 then col1:=1;
if info^.pos=30 then col1:=2;if info^.pos=32 then col1:=3;if info^.pos=34 then col1:=4;
if info^.pos=36 then col1:=5;if info^.pos=38 then col1:=6;if info^.pos=40 then col1:=7;
if info^.pos=42 then col1:=1;if info^.pos=44 then col1:=2;if info^.pos=46 then col1:=3;
if info^.pos=48 then col1:=4;if info^.pos=50 then col1:=5;

      textcolor(col1);gotoxy(2,23);writeln('');
      textcolor(col1);gotoxy(49,23);writeln('');

      { Handle keypresses: }
        if KeyPressed then
        begin
            key := ReadKey;
            if ord(key) = 27 then exit end;
    end;
END;
{----------------------------------------------------------------------------}
procedure checkcfg;
BEGIN
    error := fileExists('MIDAS.CFG', @isConfig);
    if error <> OK then
        midasError(error);
    if isConfig <> 1 then
    begin
     textcolor(7);writeln;
     WriteLn('Configuration file not found - please run SETUP.EXE');
     Halt;
    end;
    end;
{----------------------------------------------------------------------------}
PROCEDURE STOPMUSIC;
 BEGIN
    midasStopModule(module);            { stop playing }
    midasFreeModule(module);            { deallocate module }
    midasClose;                         { uninitialize MIDAS }
END;
{----------------------------------------------------------------------------}
procedure checkmusic;
begin
if midasMPPlay=1 then
begin
stopmusic;
end;
end;
{----------------------------------------------------------------------------}
END.
