.286
.model small
.stack 100h

global  wormhole:proc

.data

xpage   db 0

sintbl  dw         0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
costbl  dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
        dw       128 , 128 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,126
        dw       126 , 126 , 126 , 126 , 125 , 125 , 125 , 125 , 124 ,124
        dw       124 , 124 , 123 , 123 , 123 , 122 , 122 , 122 , 121 ,121
        dw       120 , 120 , 120 , 119 , 119 , 118 , 118 , 118 , 117 ,117
        dw       116 , 116 , 115 , 115 , 114 , 114 , 113 , 113 , 112 ,112
        dw       111 , 110 , 110 , 109 , 109 , 108 , 108 , 107 , 106 ,106
        dw       105 , 104 , 104 , 103 , 102 , 102 , 101 , 100 , 100 , 99
        dw        98 ,  97 ,  97 ,  96 ,  95 ,  95 ,  94 ,  93 ,  92 , 91
        dw        91 ,  90 ,  89 ,  88 ,  87 ,  87 ,  86 ,  85 ,  84 , 83
        dw        82 ,  82 ,  81 ,  80 ,  79 ,  78 ,  77 ,  76 ,  75 , 74
        dw        74 ,  73 ,  72 ,  71 ,  70 ,  69 ,  68 ,  67 ,  66 , 65
        dw        64 ,  63 ,  62 ,  61 ,  60 ,  59 ,  58 ,  57 ,  56 , 55
        dw        54 ,  53 ,  52 ,  51 ,  50 ,  49 ,  48 ,  47 ,  46 , 45
        dw        44 ,  43 ,  42 ,  41 ,  40 ,  39 ,  37 ,  36 ,  35 , 34
        dw        33 ,  32 ,  31 ,  30 ,  29 ,  28 ,  27 ,  26 ,  24 , 23
        dw        22 ,  21 ,  20 ,  19 ,  18 ,  17 ,  16 ,  15 ,  13 , 12
        dw        11 ,  10 ,   9 ,   8 ,   7 ,   6 ,   4 ,   3 ,   2 ,  1
        dw         0 ,  -1 ,  -2 ,  -3 ,  -4 ,  -6 ,  -7 ,  -8 ,  -9 ,-10
        dw       -11 , -12 , -13 , -15 , -16 , -17 , -18 , -19 , -20 ,-21
        dw       -22 , -23 , -24 , -26 , -27 , -28 , -29 , -30 , -31 ,-32
        dw       -33 , -34 , -35 , -36 , -37 , -39 , -40 , -41 , -42 ,-43
        dw       -44 , -45 , -46 , -47 , -48 , -49 , -50 , -51 , -52 ,-53
        dw       -54 , -55 , -56 , -57 , -58 , -59 , -60 , -61 , -62 ,-63
        dw       -64 , -65 , -66 , -67 , -68 , -69 , -70 , -71 , -72 ,-73
        dw       -74 , -74 , -75 , -76 , -77 , -78 , -79 , -80 , -81 ,-82
        dw       -82 , -83 , -84 , -85 , -86 , -87 , -87 , -88 , -89 ,-90
        dw       -91 , -91 , -92 , -93 , -94 , -95 , -95 , -96 , -97 ,-97
        dw       -98 , -99 ,-100 ,-100 ,-101 ,-102 ,-102 ,-103 ,-104 ,-104
        dw      -105 ,-106 ,-106 ,-107 ,-108 ,-108 ,-109 ,-109 ,-110 ,-110
        dw      -111 ,-112 ,-112 ,-113 ,-113 ,-114 ,-114 ,-115 ,-115 ,-116
        dw      -116 ,-117 ,-117 ,-118 ,-118 ,-118 ,-119 ,-119 ,-120 ,-120
        dw      -120 ,-121 ,-121 ,-122 ,-122 ,-122 ,-123 ,-123 ,-123 ,-124
        dw      -124 ,-124 ,-124 ,-125 ,-125 ,-125 ,-125 ,-126 ,-126 ,-126
        dw      -126 ,-126 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-126
        dw      -126 ,-126 ,-126 ,-126 ,-125 ,-125 ,-125 ,-125 ,-124 ,-124
        dw      -124 ,-124 ,-123 ,-123 ,-123 ,-122 ,-122 ,-122 ,-121 ,-121
        dw      -120 ,-120 ,-120 ,-119 ,-119 ,-118 ,-118 ,-118 ,-117 ,-117
        dw      -116 ,-116 ,-115 ,-115 ,-114 ,-114 ,-113 ,-113 ,-112 ,-112
        dw      -111 ,-110 ,-110 ,-109 ,-109 ,-108 ,-108 ,-107 ,-106 ,-106
        dw      -105 ,-104 ,-104 ,-103 ,-102 ,-102 ,-101 ,-100 ,-100 ,-99
        dw       -98 , -97 , -97 , -96 , -95 , -95 , -94 , -93 , -92 ,-91
        dw       -91 , -90 , -89 , -88 , -87 , -87 , -86 , -85 , -84 ,-83
        dw       -82 , -82 , -81 , -80 , -79 , -78 , -77 , -76 , -75 ,-74
        dw       -74 , -73 , -72 , -71 , -70 , -69 , -68 , -67 , -66 ,-65
        dw       -64 , -63 , -62 , -61 , -60 , -59 , -58 , -57 , -56 ,-55
        dw       -54 , -53 , -52 , -51 , -50 , -49 , -48 , -47 , -46 ,-45
        dw       -44 , -43 , -42 , -41 , -40 , -39 , -37 , -36 , -35 ,-34
        dw       -33 , -32 , -31 , -30 , -29 , -28 , -27 , -26 , -24 ,-23
        dw       -22 , -21 , -20 , -19 , -18 , -17 , -16 , -15 , -13 ,-12
        dw       -11 , -10 ,  -9 ,  -8 ,  -7 ,  -6 ,  -4 ,  -3 ,  -2 , -1
        dw        0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128

scany   dw 0
     i = 80
     REPT 200
        dw i
     i = i+80
     ENDM

scanx   db 80 dup (1,2,4,8)   

real_x  dw ?
real_y  dw ?

color   db ?

circle  dw ?

channel label word
      i = 3
      rept 21
        dw 0,0,i
      i = i+3
      endm

x       dw ?
y       dw ?
z       dw ?

x_trail dw 66,84,50
y_trail dw 82,52,68

cur_x   dw 0,0,0
cur_y   dw 0,0,0

palette db 0,0,0
       i = 64
       rept 64
        db i,i,i
       i = i-1
       endm
        db (256-64)*3 dup (0)

current  dw ?

.code

        call    wormhole
        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h

proc    wormhole
        mov     ax,@data
        mov     ds,ax
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        push    0a000h
        pop     es
        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,109h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
        xor     al,al
load_nothing:
        out     dx,al
        loop    load_nothing

        lea     si,channel
        add     si,4
        mov     cx,21
set_up_position:
        push    cx
        call    new_position
        add     si,6
        pop     cx
        loop    set_up_position

        mov     current,0
        mov     cx,63
move_while_fading_in:
        push    cx
        call    draw_channel
        call    flip_page
        call    fade
        inc     current
        pop     cx
        loop    move_while_fading_in

        mov     cx,900
wormie_loop:
        push    cx
        call    draw_channel
        call    flip_page
        pop     cx
        loop    wormie_loop

        mov     cx,63
move_while_fading_out:
        push    cx
        call    draw_channel
        call    flip_page
        call    fade
        dec     current
        pop     cx
        loop    move_while_fading_out
        ret
endp    wormhole

proc    fade
        pusha
        mov     cx,768
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        lea     si,palette
        mov     bx,current

fade_all_5:
        push    cx
        lodsb
        cmp     bl,al
        jae     no_fade
        mov     al,bl
no_fade:
        out     dx,al
        pop     cx
        loop    fade_all_5
        popa
        ret
endp    fade

proc    draw_channel
        mov     cx,21
        lea     si,channel
channel_loop:
        push    cx
        lodsw
        mov     x,ax
        lodsw
        mov     y,ax
        mov     ax,[si]

        mov     z,ax
        cmp     z,4
        ja      z_ok
        mov     z,66
        call    new_position
z_ok:
        dec     z
        mov     ax,z
        mov     [si],ax
        add     si,2

        mov     ax,z
        mov     color,al
        mov     bx,3
        mul     bx
        shr     ax,1
        mov     z,ax

        call    circle_loop
        pop     cx
        loop    channel_loop
        ret

circle_loop:
        mov     circle,0
        mov     cx,40
draw_circle_loop:
        push    cx
        mov     bx,circle
        xor     dx,dx
        mov     ax,word ptr sintbl[bx]
        or      ax,ax
        jns     sine_ok
        not     dx
sine_ok:
        sal     ax,4
        idiv    z
        add     ax,y
        add     ax,100
        mov     real_y,ax

        xor     dx,dx
        mov     ax,word ptr costbl[bx]
        or      ax,ax
        jns     cos_ok
        not     dx
cos_ok:
        sal     ax,4
        idiv    z
        add     ax,x
        add     ax,160
        mov     real_x,ax

        add     circle,(2*720)/40
        call    draw_point
        pop     cx
        loop    draw_circle_loop
        ret
endp    draw_channel

proc    new_position
        mov     ax,x_trail[0]
        add     cur_x[0],ax
        cmp     cur_x[0],2*720
        jb      crx1
        sub     cur_x[0],2*720
crx1:
        mov     ax,x_trail[2]
        add     cur_x[2],ax
        cmp     cur_x[2],2*720
        jb      crx2
        sub     cur_x[2],2*720
crx2:
        mov     ax,x_trail[4]
        add     cur_x[4],ax
        cmp     cur_x[4],2*720
        jb      crx3
        sub     cur_x[4],2*720
crx3:
        mov     ax,y_trail[0]
        add     cur_y[0],ax
        cmp     cur_y[0],2*720
        jb      cry1
        sub     cur_y[0],2*720
cry1:
        mov     ax,y_trail[2]
        add     cur_y[2],ax
        cmp     cur_y[2],2*720
        jb      cry2
        sub     cur_y[2],2*720
cry2:
        mov     ax,y_trail[4]
        add     cur_y[4],ax
        cmp     cur_y[4],2*720
        jb      cry3
        sub     cur_y[4],2*720
cry3:
        mov     bx,cur_x[0]
        mov     ax,sintbl[bx]
        sar     ax,2
        mov     bx,cur_x[2]
        mov     cx,sintbl[bx]
        sar     cx,3
        mov     bx,cur_x[4]
        mov     dx,sintbl[bx]
        sar     dx,3
        add     ax,cx
        add     ax,dx
;        sar     ax,3
        mov     x,ax

        mov     bx,cur_y[0]
        mov     ax,costbl[bx]
        sar     ax,2
        mov     bx,cur_y[2]
        mov     cx,costbl[bx]
        sar     cx,3
        mov     bx,cur_y[4]
        mov     dx,costbl[bx]
        sar     dx,3
        add     ax,cx
        add     ax,dx
;        sar     ax,3
        mov     y,ax
        
        sub     si,4
        mov     ax,x
        mov     [si],ax
        add     si,2
        mov     ax,y
        mov     [si],ax
        add     si,2
        ret
endp    new_position    

proc    draw_point
        cmp     real_x,320
        jae     no_point
        cmp     real_y,200
        jae     no_point
        cmp     real_x,0
        jbe     no_point
        cmp     real_y,0
        jbe     no_point
        call    get_page
        mov     bx,real_y
        shl     bx,1
        add     di,word ptr scany[bx]
        mov     bx,real_x
        mov     ah,byte ptr scanx[bx]
        mov     al,2
        mov     dx,3c4h
        out     dx,ax
        shr     bx,2
        add     di,bx
        mov     al,color
        stosb
no_point:
        ret
endp    draw_point

proc    get_page
        cmp     xpage,1
        jz      page_one
        mov     di,16000
        ret
page_one:
        xor     di,di
        ret
endp    get_page

proc    flip_page
        cmp     xpage,0
        jz      page_two
        mov     xpage,0
        xor     bx,bx
        call    set_offset
        mov     di,16000
        call    clear_other_page
        jmp     pages_flipped
page_two:
        mov     xpage,1
        mov     bx,16000
        call    set_offset
        xor     di,di
        call    clear_other_page
pages_flipped:
        ret
clear_other_page:
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax
        mov     cx,8000
        xor     ax,ax
        rep     stosw
        ret
endp    flip_page

proc    set_offset
        pusha
        mov     dx,3d4h
        mov     al,0ch
        mov     ah,bh
        out     dx,ax
        inc     al
        mov     ah,bl
        out     dx,ax
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        popa
        ret
endp    set_offset
end
