;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Real 2 SuperReal Demo June/July 1995                                    ;
; SuperReal (my first SVGA demo)                                          ;
;                                                                         ;
; by Jason Nunn(JsNO)                                                     ;
;                                                                         ;
; Contacts:                                                               ;
;                                                                         ;
; Email: jsno@turtle.apana.org.au or root@superr.apana.org.au             ;
; Snail: 32 Rothdale Rd,Darwin,NT,0810,Australia                          ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
YES                   = 0
NO                    = 1

font_data:
  db  56, 56, 56, 56,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,126,195,129,129
  db 165,165,129,129,189,189,153,129,195,126,126,255,255,255,219,219,255,255
  db 195,195,231,255,255,126,  0, 68,238,238,254,254,254,124,124, 56, 56, 16
  db   0,  0, 16, 56, 56,124,124,254,254,124,124, 56, 56, 16,  0,  0,  0, 60
  db 126, 24, 90,219,255,219, 90, 24, 60, 60,  0,  0,  0, 24, 60, 60,126,126
  db 255,255,126, 24, 60, 60,  0,  0,  0,  0,  0,  0, 60,126,126,126,126, 60
  db   0,  0,  0,  0,255,255,255,255,195,129,129,129,129,195,255,255,255,255
  db   0,  0,  0, 60,102, 66, 66, 66,102, 60,  0,  0,  0,  0,255,255,255,195
  db 153,189,189,189,153,195,255,255,255,255,  0,127,  7, 15, 29,121,253,204
  db 204,204,252,120,  0,  0,  0, 60,126,102,102,126, 60, 24,126,126, 24, 24
  db   0,  0,  0, 62, 50, 62, 48, 48, 48, 48, 48,112,240, 96,  0,  0,  0, 63
  db 127, 99, 99,127,127, 99, 99,103,239,230,192,  0,219,219,219, 60, 60,231
  db 231,231,231, 60, 60,219,219,219,  0,192,224,240,248,252,254,252,248,240
  db 224,192,  0,  0,  0,  6, 14, 30, 62,126,254,126, 62, 30, 14,  6,  0,  0
  db   0, 24, 60,126,126, 24, 24, 24,126,126, 60, 24,  0,  0,  0,108,108,108
  db 108,108,108,108,  0,  0,108,108,  0,  0,  0,127,255,219,219,251,123, 27
  db  27, 27, 27, 27,  0,  0,  0, 28, 62, 99, 99, 56,108, 68,108, 56,140,204
  db 120,  0,  0,  0,  0,  0,  0,  0,126,126,126,126,126,126,  0,  0,  0, 24
  db  60,126,126, 24, 24,126,126, 60, 24,  0,255,255,  0, 24, 60,126,255, 24
  db  24, 24, 24, 24, 24, 24,  0,  0,  0, 24, 24, 24, 24, 24, 24, 24,255,126
  db  60, 24,  0,  0,  0,  0,  0, 48, 24, 12,254,254, 12, 24, 48,  0,  0,  0
  db   0,  0,  0, 24, 48, 96,254,254, 96, 48, 24,  0,  0,  0,  0,  0,  0,  0
  db 192,192,192,192,254,254,  0,  0,  0,  0,  0,  0,  0, 36,102, 66,255,255
  db  66,102, 36,  0,  0,  0,  0,  0, 16, 16, 56, 56,124,124,254,254,254,  0
  db   0,  0,  0,  0,  0,254,254,254,124,124, 56, 56, 16, 16,  0,  0,  0,  0
  db   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 60, 60, 60, 60
  db  24, 24,  0, 24, 60, 24,  0,  0,  0,102,102,102,102,102,  0,  0,  0,  0
  db   0,  0,  0,  0,  0,108,108,108,254,254,108,254,254,108,108,108,  0,  0
  db   0, 48, 48,120,204,192,120, 12,204,120, 48, 48,  0,  0,  0,198,204, 12
  db  24, 24, 48, 48, 96, 96,198,134,  0,  0,  0, 56,108,108, 56,112,122,222
  db 204,204,254,114,  0,  0,  0, 56, 56, 24, 16, 32,  0,  0,  0,  0,  0,  0
  db   0,  0,  0, 12, 24, 56, 48,112,112,112, 48, 56, 24, 12,  0,  0,  0, 96
  db  48, 56, 24, 28, 28, 28, 24, 56, 48, 96,  0,  0,  0,  0,  0,198,108, 56
  db 254,254, 56,108,198,  0,  0,  0,  0,  0,  0, 24, 24, 24,126,126, 24, 24
  db  24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56, 56, 24, 24, 48, 32,  0
  db   0,  0,  0,  0,  0,  0,126,126,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  db   0,  0,  0,  0,  0, 16, 56, 16,  0,  0,  0,  6, 14, 12, 28, 24, 56, 48
  db 112, 96,224,192,  0,  0,  0,124,254,198,198,214,214,214,198,198,254,124
  db   0,  0,  0, 48,112,240,240, 48, 48, 48, 48, 48,252,252,  0,  0,  0, 56
  db 124,238,198, 14, 28, 56,112,230,254,254,  0,  0,  0,124,254,198,  6, 14
  db  60, 14,  6,198,254,124,  0,  0,  0,  6, 14, 30, 54,102,198,254,254,  6
  db   6,  6,  0,  0,  0,254,254,192,192,252,254,  6,  6,198,254,124,  0,  0
  db   0, 28, 60,112,224,252,254,198,198,198,254,124,  0,  0,  0,254,254,198
  db 198, 12, 12, 24, 24, 48, 48, 48,  0,  0,  0,124,254,198,198,198,124,198
  db 198,198,254,124,  0,  0,  0,124,254,198,198,198,254,126, 14, 28,120,112
  db   0,  0,  0,  0,  0, 16, 56, 16,  0,  0, 16, 56, 16,  0,  0,  0,  0,  0
  db   0, 16, 56, 16,  0,  0, 56, 56, 24, 48, 96,  0,  0,  0, 14, 28, 56,112
  db 224,112, 56, 28, 14,  0,  0,  0,  0,  0,  0,126,126,  0,  0,  0,126,126
  db   0,  0,  0,  0,  0,  0,224,112, 56, 28, 14, 28, 56,112,224,  0,  0,  0
  db   0, 60,126,102,102, 14, 28, 24, 24,  0, 24, 24,  0,  0,  0,124,254,198
  db 198,222,222,222,192,192,254,126,  0,  0,  0, 16, 56,124,238,198,198,254
  db 254,198,198,198,  0,  0,  0,252,254,198,198,198,252,198,198,198,254,252
  db   0,  0,  0,124,254,198,198,192,192,192,198,198,254,124,  0,  0,  0,248
  db 252,206,198,198,198,198,198,206,252,248,  0,  0,  0,254,254,192,192,192
  db 252,192,192,192,254,254,  0,  0,  0,254,254,192,192,252,252,192,192,192
  db 192,192,  0,  0,  0,124,254,198,192,192,206,206,198,198,254,126,  0,  0
  db   0,198,198,198,198,254,254,198,198,198,198,198,  0,  0,  0,120,120, 48
  db  48, 48, 48, 48, 48, 48,120,120,  0,  0,  0, 30, 30, 12, 12, 12, 12, 12
  db 204,204,252,120,  0,  0,  0,194,198,206,220,248,240,248,220,206,198,194
  db   0,  0,  0,192,192,192,192,192,192,192,192,192,254,254,  0,  0,  0,130
  db 198,238,254,254,214,214,198,198,198,198,  0,  0,  0,198,230,230,246,246
  db 222,222,206,206,198,198,  0,  0,  0,124,254,198,198,198,198,198,198,198
  db 254,124,  0,  0,  0,252,254,198,198,198,254,252,192,192,192,192,  0,  0
  db   0,124,254,198,198,198,198,198,214,206,254,124,  6,  0,  0,252,254,198
  db 198,198,252,254,198,198,198,198,  0,  0,  0,124,254,198,192,240,124, 30
  db   6,198,254,124,  0,  0,  0,252,252, 48, 48, 48, 48, 48, 48, 48, 48, 48
  db   0,  0,  0,198,198,198,198,198,198,198,198,198,254,124,  0,  0,  0,198
  db 198,198,198,198,198,198,238,124, 56, 16,  0,  0,  0,198,198,198,198,198
  db 214,254,254,238,198,130,  0,  0,  0,198,198,238,108,124, 56,124,108,238
  db 198,198,  0,  0,  0,195,195,195,231,126, 60, 24, 24, 24, 24, 24,  0,  0
  db   0,254,254,  6, 14, 28, 56,112,224,192,254,254,  0,  0,  0, 60, 60, 48
  db  48, 48, 48, 48, 48, 48, 60, 60,  0,  0,  0,192,224, 96,112, 48, 56, 24
  db  28, 12, 14,  6,  0,  0,  0, 60, 60, 12, 12, 12, 12, 12, 12, 12, 60, 60
  db   0,  0,  0,  0, 16, 56,124,238,198,  0,  0,  0,  0,  0,  0,  0,  0,  0
  db   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,255,255,  0, 56, 56, 48, 16,  8
  db   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,124,126,  6,126,254,198
  db 254,118,  0,  0,  0,192,192,192,252,254,198,198,198,198,254,220,  0,  0
  db   0,  0,  0,  0,124,254,198,192,192,198,254,124,  0,  0,  0,  6,  6,  6
  db 126,254,198,198,198,198,254,118,  0,  0,  0,  0,  0,  0,124,254,198,254
  db 254,192,254,126,  0,  0,  0, 30, 62, 48,124,124, 48, 48, 48, 48, 48, 48
  db   0,  0,  0,  0,  0,  0,126,254,198,198,198,206,254,118,  6,124,  0,192
  db 192,192,220,254,230,198,198,198,198,198,  0,  0,  0, 24, 24,  0, 56, 56
  db  24, 24, 24, 24, 60, 60,  0,  0,  0, 24, 24,  0, 56, 56, 24, 24, 24, 24
  db  24,248,112,  0,  0,192,192,204,204,216,216,240,240,216,204,204,  0,  0
  db   0, 56, 56, 24, 24, 24, 24, 24, 24, 24, 60, 60,  0,  0,  0,  0,  0,  0
  db 196,238,254,254,214,198,198,198,  0,  0,  0,  0,  0,  0,220,254,230,198
  db 198,198,198,198,  0,  0,  0,  0,  0,  0,124,254,198,198,198,198,254,124
  db   0,  0,  0,  0,  0,  0,220,254,230,198,198,198,254,220,192,192,  0,  0
  db   0,  0,118,254,206,198,198,198,254,118,  6,  6,  0,  0,  0,  0,220,254
  db 230,192,192,192,192,192,  0,  0,  0,  0,  0,  0,124,254,192,252,126,  6
  db 254,124,  0,  0,  0, 16, 48, 48,124,124, 48, 48, 48, 48, 60, 28,  0,  0
  db   0,  0,  0,  0,198,198,198,198,198,198,254,118,  0,  0,  0,  0,  0,  0
  db 198,198,198,198,238,124, 56, 16,  0,  0,  0,  0,  0,  0,198,198,198,198
  db 214,254,254,108,  0,  0,  0,  0,  0,  0,198,238,124, 56, 56,124,238,198
  db   0,  0,  0,  0,  0,  0,198,198,198,198,206,206,254,118,  6,124,  0,  0
  db   0,  0,252,252, 28, 56,112,224,252,252,  0,  0,  0, 14, 28, 24, 24, 24
  db 112, 24, 24, 24, 28, 14,  0,  0,  0, 24, 24, 24, 24, 24,  0, 24, 24, 24
  db  24, 24,  0,  0,  0,112, 56, 24, 24, 24, 14, 24, 24, 24, 56,112,  0,  0
  db   0,  0,118,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16, 56,124
  db 238,198,198,198,198,198,254,254,  0,  0,  0,  0,124,254,198,192,198,254
  db 124, 28, 14,126,124,  0,  0,204,204,  0,204,204,204,204,204,204,254,118
  db   0,  0,  0, 14, 28,  0,124,254,198,254,254,192,254,126,  0,  0,  0,124
  db 198,  0,124,126,  6,126,254,198,254,118,  0,  0,  0,102,102,  0,124,126
  db   6,126,254,198,254,118,  0,  0,  0,112, 56,  0,124,126,  6,126,254,198
  db 254,118,  0,  0,  0, 48, 48,  0,124,126,  6,126,254,198,254,118,  0,  0
  db   0,  0,  0,  0,124,254,198,198,192,192,252,126, 14, 60,  0,124,198,  0
  db 124,254,198,254,254,192,254,126,  0,  0,  0,102,102,  0,124,254,198,254
  db 254,192,254,126,  0,  0,  0,112, 56,  0,124,254,198,254,254,192,254,126
  db   0,  0,  0,204,204,  0,112,112, 48, 48, 48, 48,120,120,  0,  0,  0,124
  db 198,  0, 56, 56, 24, 24, 24, 24, 60, 60,  0,  0,  0,224,112,  0,112,112
  db  48, 48, 48, 48,120,120,  0,  0,  0,198,198,  0, 16, 56,124,238,198,254
  db 198,198,  0,  0,  0, 48, 48,  0, 16, 56,124,238,198,254,198,198,  0,  0
  db   0, 14, 28,  0,254,254, 96,124,124, 96,254,254,  0,  0,  0,  0,  0,  0
  db 127,127, 12,127,255,204,255,111,  0,  0,  0, 62,126,236,204,204,254,204
  db 204,204,206,206,  0,  0,  0,124,198,  0,124,254,198,198,198,198,254,124
  db   0,  0,  0,102,102,  0,124,254,198,198,198,198,254,124,  0,  0,  0,112
  db  56,  0,124,254,198,198,198,198,254,124,  0,  0,  0,124,198,  0,198,198
  db 198,198,198,198,254,118,  0,  0,  0,112, 56,  0,198,198,198,198,198,198
  db 254,118,  0,  0,  0,198,198,  0,198,198,198,198,198,206,254,118,  6,124
  db   0,198,214, 56,124,238,198,198,238,124, 56, 16,  0,  0,  0,198,198,  0
  db 198,198,198,198,198,198,254,118,  0,  0,  0,  0, 24, 24,126,254,192,192
  db 254,126, 24, 24,  0,  0,  0, 56,124,100,100, 96,240, 96, 98,230,254,252
  db   0,  0,  0,204,204,204,120,120, 48,252, 48,252, 48, 48,  0,  0,  0,248
  db 252,204,204,252,250,194,198,207,198,198,198,195,  0, 14, 31, 27, 27, 24
  db  24, 60, 24, 24,216,216,248,112,  0, 14, 28,  0,124,126,  6,126,254,198
  db 254,118,  0,  0,  0, 28, 56,  0, 56, 56, 24, 24, 24, 24, 60, 60,  0,  0
  db   0, 14, 28,  0,124,254,198,198,198,198,254,124,  0,  0,  0, 14, 28,  0
  db 198,198,198,198,198,198,254,118,  0,  0,  0,116, 92,  0,220,254,230,198
  db 198,198,198,198,  0,  0,  0,254,  0,134,198,230,246,254,222,206,198,194
  db   0,  0,  0,  0, 60,126,102,102,102,126, 54,  0,126,126,  0,  0,  0,  0
  db  60,126,102,102,126, 60,  0,  0,126,126,  0,  0,  0, 24, 24,  0, 24, 24
  db 120,224,198,198,254,124,  0,  0,  0,  0,  0,  0,  0,126,126, 96, 96, 96
  db  96,  0,  0,  0,  0,  0,  0,  0,  0,126,126,  6,  6,  6,  6,  0,  0,  0
  db   0,198,198,204,204, 24, 24, 48, 48,102,105,194,196,143,  0,198,198,204
  db 204, 24, 24, 49, 51,101,105,223,193,129,  0, 24, 60, 24,  0, 24, 24, 60
  db  60, 60, 60, 24,  0,  0,  0,  0,  0,  0, 27, 54,108,216,108, 54, 27,  0
  db   0,  0,  0,  0,  0,  0,216,108, 54, 27, 54,108,216,  0,  0,  0, 34,136
  db  34,136, 34,136, 34,136, 34,136, 34,136, 34,136, 85,170, 85,170, 85,170
  db  85,170, 85,170, 85,170, 85,170,221,119,221,119,221,119,221,119,221,119
  db 221,119,221,119, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24
  db  24, 24, 24, 24, 24, 24,248,248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24
  db 248,248, 24, 24,248,248, 24, 24, 24, 24, 54, 54, 54, 54, 54, 54,246,246
  db  54, 54, 54, 54, 54, 54,  0,  0,  0,  0,  0,  0,254,254, 54, 54, 54, 54
  db  54, 54,  0,  0,  0,  0,248,248, 24, 24,248,248, 24, 24, 24, 24, 54, 54
  db  54, 54,246,246,  6,  6,246,246, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54
  db  54, 54, 54, 54, 54, 54, 54, 54,  0,  0,  0,  0,254,254,  6,  6,246,246
  db  54, 54, 54, 54, 54, 54, 54, 54,246,246,  6,  6,254,254,  0,  0,  0,  0
  db  54, 54, 54, 54, 54, 54,254,254,  0,  0,  0,  0,  0,  0, 24, 24, 24, 24
  db 248,248, 24, 24,248,248,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,248,248
  db  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 31, 31,  0,  0,  0,  0
  db   0,  0, 24, 24, 24, 24, 24, 24,255,255,  0,  0,  0,  0,  0,  0,  0,  0
  db   0,  0,  0,  0,255,255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24
  db  31, 31, 24, 24, 24, 24, 24, 24,  0,  0,  0,  0,  0,  0,255,255,  0,  0
  db   0,  0,  0,  0, 24, 24, 24, 24, 24, 24,255,255, 24, 24, 24, 24, 24, 24
  db  24, 24, 24, 24, 31, 31, 24, 24, 31, 31, 24, 24, 24, 24, 54, 54, 54, 54
  db  54, 54, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 48, 48
  db  63, 63,  0,  0,  0,  0,  0,  0,  0,  0, 63, 63, 48, 48, 55, 55, 54, 54
  db  54, 54, 54, 54, 54, 54,247,247,  0,  0,255,255,  0,  0,  0,  0,  0,  0
  db   0,  0,255,255,  0,  0,247,247, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55
  db  48, 48, 55, 55, 54, 54, 54, 54,  0,  0,  0,  0,255,255,  0,  0,255,255
  db   0,  0,  0,  0, 54, 54, 54, 54,247,247,  0,  0,247,247, 54, 54, 54, 54
  db  24, 24, 24, 24,255,255,  0,  0,255,255,  0,  0,  0,  0, 54, 54, 54, 54
  db  54, 54,255,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,255,255,  0,  0
  db 255,255, 24, 24, 24, 24,  0,  0,  0,  0,  0,  0,255,255, 54, 54, 54, 54
  db  54, 54, 54, 54, 54, 54, 54, 54, 63, 63,  0,  0,  0,  0,  0,  0, 24, 24
  db  24, 24, 31, 31, 24, 24, 31, 31,  0,  0,  0,  0,  0,  0,  0,  0, 31, 31
  db  24, 24, 31, 31, 24, 24, 24, 24,  0,  0,  0,  0,  0,  0, 63, 63, 54, 54
  db  54, 54, 54, 54, 54, 54, 54, 54, 54, 54,255,255, 54, 54, 54, 54, 54, 54
  db  24, 24, 24, 24,255,255, 24, 24,255,255, 24, 24, 24, 24, 24, 24, 24, 24
  db  24, 24,248,248,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31, 31
  db  24, 24, 24, 24, 24, 24,255,255,255,255,255,255,255,255,255,255,255,255
  db 255,255,  0,  0,  0,  0,  0,  0,  0,255,255,255,255,255,255,255,240,240
  db 240,240,240,240,240,240,240,240,240,240,240,240, 15, 15, 15, 15, 15, 15
  db  15, 15, 15, 15, 15, 15, 15, 15,255,255,255,255,255,255,255,  0,  0,  0
  db   0,  0,  0,  0,  0,  0,  0,  0,118,254,204,204,204,204,254,118,  0,  0
  db   0, 30, 63, 51,115, 98,254,227,227,227,255,222,192,  0,  0,  0,254,254
  db 198,198,192,192,192,192,192,192,  0,  0,  0,  0,254,254,108,108,108,108
  db 108,108,108,108,  0,  0,  0,252,252,204,224,112, 56, 56,112,224,204,252
  db 252,  0,  0,  0,  0,  0,126,254,204,204,204,204,252,120,  0,  0,  0,  0
  db 102,102,102,102,102,102,102,110,124,120,240,224,  0,  0, 50,126,220,152
  db  24, 24, 24, 24, 24, 24,  0,  0,  0,252,252, 48,120,252,204,204,204,252
  db 120, 48,252,252,  0, 56,124,238,198,198,254,198,198,238,124, 56,  0,  0
  db   0, 16, 56,124,238,198,198,198,108,108,238,238,  0,  0,  0, 28, 60, 48
  db  48, 24,124,252,204,204,204,252,120,  0,  0,  0,  0,  0,108,254,214,214
  db 214,214,254,108,  0,  0,  0,  4, 12,  8,124,254,214,214,214,214,254,124
  db  32, 96,  0, 60,124, 96,224,192,240,240,192,224, 96,124, 60,  0,  0, 60
  db 126,102,102,102,102,102,102,102,102,102,  0,  0,  0,  0,  0,  0,254,254
  db   0,254,254,  0,254,254,  0,  0,  0, 24, 24, 24,126,126, 24, 24, 24,  0
  db 126,126,  0,  0,  0,  0, 48, 24, 12,  6, 12, 24, 48,  0,126,126,  0,  0
  db   0,  0, 12, 24, 48, 96, 48, 24, 12,  0,126,126,  0,  0,  0, 14, 31, 27
  db  27, 27, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24
  db  24,216,216,216,248,112,  0,  0,  0, 24, 24,  0,126,126,  0, 24, 24,  0
  db   0,  0,  0,  0,  0,  0,118,220,  0,118,220,  0,  0,  0,  0,  0,  0, 60
  db 126,102,102,126, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  db  24, 24, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 24,  0
  db   0,  0,  0,  0,  0, 15, 15, 12, 12, 12, 12,236,108,108,124, 60, 28, 12
  db   0,108,126,118,102,102,102,  0,  0,  0,  0,  0,  0,  0,  0, 60,102, 76
  db  24, 48,126,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60, 60, 60, 60
  db  60, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  db   0,  0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  GET   IRQ vector             ;
;  expects  BL = IRQ (0..15)    ;
;  returns  CX = selector       ;
;           EDX = offset        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;proc getirqvector
;                push    eax ebx
;                and     bl,0fh
;                cmp     bl,8
;                jb      @@J2
;                add     bl,60h
;@@J2:           add     bl,8h
;                mov     ax,204h
;                int     31h
;                pop     ebx eax
;                ret
;endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;SET   IRQ vector               ;
;  expects  BL = IRQ (0..15)    ;
;           CX = selector       ;
;           EDX = offset        ;
;  returns Nothing              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;proc setirqvector
;                push    eax ebx
;                and     bl,0fh
;                cmp     bl,8
;                jb      @@J1
;                add     bl,60h
;@@J1:           add     bl,8h
;                mov     ax,205h
;                int     31h
;                pop     ebx eax
;                ret
;endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc key_pressed2
  push   esi
  mov    esi,[Zero_Addr]
  add    esi,41ah
  mov    ax,[esi]
  cmp    ax,[word esi+2]
  jne    @@l
  pop    esi
  clc
  ret
@@l:
  movzx  eax,ax
  add    eax,400h
  add    eax,[Zero_Addr]
  mov    ax,[word eax]
  pop    esi
  stc
  ret
endp

last_get_key          db ?

proc get_key
@@l:
  call   key_pressed2
  jnc    @@l
  mov    eax,0
  int    16h
  mov    [last_get_key],al
  ret
endp

;input: NIL; output: EAX
proc random
  mov    ebx,[@@seed1]
  mov    eax,[dword ebx*4+@@rantable]
  mov    ebx,[@@seed2]
  add    eax,[dword ebx*4+@@rantable]
  mov    [dword ebx*4+@@rantable],eax
  inc    [byte @@seed1]
  and    [byte @@seed1],011111b
  dec    [byte @@seed2]
  and    [byte @@seed2],011111b
  ret
@@seed1	              dd 2
@@seed2               dd 20
@@rantable            dd 423497850,293874509,872340985,720349875,029834709
                      dd 389735263,249879782,435345234,852938745,982697526
                      dd 924387349,824624386,423645625,602586386,478557463
                      dd 101398630,987197471,051798980,798517092,309717542
                      dd 523778179,801324079,705476523,976215378,913405967
                      dd 078231980,357243764,320743262,306743789,420970738
                      dd 437809432,784284784,789017893,478248247,437624367
                      dd 436984342,362436234,122433436,266802430,984360250
                      dd 346230523,487023872,436876234,987625978,632874675
                      dd 432689432,872398243,698259634,062398734,652986324
                      dd 439084327,623462397,823486567,243729784,376576237
                      dd 439082364,624397825,398749234,862354987,525268234
                      dd 342098742,397843269,234983498,986538974
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; SVGA/Invisable buffer (All aspect/Clipped) bitmap Blitter(1995)         ;
; Coded/Optimised for P-mode by Jason Nunn/Super Real Darwin!             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
RBBitmap_clipL        dd 0
RBBitmap_clipR        dd 640
RBBitmap_clipT        dd 0
RBBitmap_clipB        dd 480

struc RBBitmap_stack
  BP_save             dd ?
  caller              dd ?
  TARGET_WIDTH        dd ?
  Y_LINE_SIZE         dd ?
  X_LINE_SIZE         dd ?
  DestY               dd ?
  DestX               dd ?
  Dest_buffer         dd ?
  bitmap_ofs          dd ?
ends

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc RBBitmap
  push   ebp
  mov    ebp,esp
  mov    eax,[ebp+RBBitmap_stack.X_LINE_SIZE]
  mov    [dword @@lineX_length],eax
  mov    eax,[ebp+RBBitmap_stack.Y_LINE_SIZE]
  mov    [dword @@lineY_length],eax
  mov    esi,[ebp+RBBitmap_stack.bitmap_ofs]
  mov    edi,[ebp+RBBitmap_stack.Dest_buffer]
  add    edi,[dword RBBitmap_clipL]
  mov    eax,[dword RBBitmap_clipT]
  mul    [dword ebp+RBBitmap_stack.TARGET_WIDTH]
  add    edi,eax
;=========================================================================
  mov    eax,[dword RBBitmap_clipL]               ; clip x left
  sub    eax,[ebp+RBBitmap_stack.DestX]           ; X_POS
  js     @@dont_clipL
  sub    [dword @@lineX_length],eax               ; adjust line lenght
  js     @@exit_RBB
  add    esi,eax                                  ; adjust mb offs
  jmp    @@clipL_end
@@dont_clipL:
  add    edi,[ebp+RBBitmap_stack.DestX]
@@clipL_end:
;=========================================================================
  mov    eax,[ebp+RBBitmap_stack.DestX]           ; X_POS | clip x right
  add    eax,[ebp+RBBitmap_stack.X_LINE_SIZE]
  sub    eax,[dword RBBitmap_clipR]
  js     @@clipR
  sub    [dword @@lineX_length],eax               ; adjust line lenght only
  js     @@exit_RBB
@@clipR:
;=========================================================================
  mov    eax,[dword RBBitmap_clipT]               ; clip y top
  sub    eax,[ebp+RBBitmap_stack.DestY]           ; Y_POS
  js     @@dont_clipT
  sub    [dword @@lineY_length],eax               ; adjust line lenght
  js     @@exit_RBB
  mul    [dword ebp+RBBitmap_stack.X_LINE_SIZE]
  add    esi,eax                                  ; adjust mb offs
  jmp    @@end_clipT
@@dont_clipT:
  mov    eax,[ebp+RBBitmap_stack.DestY]
  mul    [dword ebp+RBBitmap_stack.TARGET_WIDTH]
  add    edi,eax
@@end_clipT:
;=========================================================================
  mov    eax,[ebp+RBBitmap_stack.DestY]           ; Y_POS | clip y right
  add    eax,[ebp+RBBitmap_stack.Y_LINE_SIZE]
  sub    eax,[dword RBBitmap_clipB]
  js     @@clipB
  sub    [dword @@lineY_length],eax               ; adjust line lenght only
  js     @@exit_RBB
@@clipB:
  mov    edx,[dword @@lineY_length]
  or     edx,edx
  jz     @@exit_RBB
@@paint_y:
  push   esi edi
  mov    ecx,[dword @@lineX_length]
  push   ecx
  shr    ecx,2                                    ; = no of 32bit loops
  jz     @@ignore_32
@@paint_x32:
  mov    eax,[esi]
  mov    [edi],eax
  add    esi,4
  add    edi,4
  dec    ecx
  jnz    @@paint_x32
@@ignore_32:
  pop    ecx                                      ; bytes to write left
  and    cl,3
  jz     @@done_x
@@paint_x8:
  mov    al,[esi]
  mov    [edi],al
  inc    esi
  inc    edi
  dec    cl
  jnz    @@paint_x8
@@done_x:
  pop    edi esi
  add    esi,[ebp+RBBitmap_stack.X_LINE_SIZE]
  add    edi,[ebp+RBBitmap_stack.TARGET_WIDTH]
  dec    edx
  jnz    @@paint_y
@@exit_RBB:
  pop    ebp
  ret
@@lineX_length        dd ?
@@lineY_length        dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc RBBitmap_TRANS
  push   ebp
  mov    ebp,esp
  mov    eax,[ebp+RBBitmap_stack.X_LINE_SIZE]
  mov    [dword @@lineX_length],eax
  mov    eax,[ebp+RBBitmap_stack.Y_LINE_SIZE]
  mov    [dword @@lineY_length],eax
  mov    esi,[ebp+RBBitmap_stack.bitmap_ofs]
  mov    edi,[ebp+RBBitmap_stack.Dest_buffer]
  add    edi,[dword RBBitmap_clipL]
  mov    eax,[dword RBBitmap_clipT]
  mul    [dword ebp+RBBitmap_stack.TARGET_WIDTH]
  add    edi,eax
;=========================================================================
  mov    eax,[dword RBBitmap_clipL]               ; clip x left
  sub    eax,[ebp+RBBitmap_stack.DestX]           ; X_POS
  js     @@dont_clipL
  sub    [dword @@lineX_length],eax               ; adjust line lenght
  js     @@exit_RBB
  add    esi,eax                                  ; adjust mb offs
  jmp    @@clipL_end
@@dont_clipL:
  add    edi,[ebp+RBBitmap_stack.DestX]
@@clipL_end:
;=========================================================================
  mov    eax,[ebp+RBBitmap_stack.DestX]           ; X_POS | clip x right
  add    eax,[ebp+RBBitmap_stack.X_LINE_SIZE]
  sub    eax,[dword RBBitmap_clipR]
  js     @@clipR
  sub    [dword @@lineX_length],eax               ; adjust line lenght only
  js     @@exit_RBB
@@clipR:
;=========================================================================
  mov    eax,[dword RBBitmap_clipT]               ; clip y top
  sub    eax,[ebp+RBBitmap_stack.DestY]           ; Y_POS
  js     @@dont_clipT
  sub    [dword @@lineY_length],eax               ; adjust line lenght
  js     @@exit_RBB
  mul    [dword ebp+RBBitmap_stack.X_LINE_SIZE]
  add    esi,eax                                  ; adjust mb offs
  jmp    @@end_clipT
@@dont_clipT:
  mov    eax,[ebp+RBBitmap_stack.DestY]
  mul    [dword ebp+RBBitmap_stack.TARGET_WIDTH]
  add    edi,eax
@@end_clipT:
;=========================================================================
  mov    eax,[ebp+RBBitmap_stack.DestY]           ; Y_POS | clip y right
  add    eax,[ebp+RBBitmap_stack.Y_LINE_SIZE]
  sub    eax,[dword RBBitmap_clipB]
  js     @@clipB
  sub    [dword @@lineY_length],eax               ; adjust line lenght only
  js     @@exit_RBB
@@clipB:
  mov    edx,[dword @@lineY_length]
  or     edx,edx
  jz     @@exit_RBB
@@paint_y:
  push   esi edi
  mov    ecx,[dword @@lineX_length]
  or     ecx,ecx
  jz     @@done_x
@@paint_x8:
  mov    al,[esi]
  or     al,al
  jz     @@skipb
  mov    [edi],al
@@skipb:
  inc    esi
  inc    edi
  dec    ecx
  jnz    @@paint_x8
@@done_x:
  pop    edi esi
  add    esi,[ebp+RBBitmap_stack.X_LINE_SIZE]
  add    edi,[ebp+RBBitmap_stack.TARGET_WIDTH]
  dec    edx
  jnz    @@paint_y
@@exit_RBB:
  pop    ebp
  ret
@@lineX_length        dd ?
@@lineY_length        dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc draw_FNT_stack
  caller              dd ?
  TARGET_WIDTH        dd ?
  DestY               dd ?
  DestX               dd ?
  Dest_buffer         dd ?
  font_data_ofs       dd ?
  character           dd ?
ends

draw_FNT_trans        db YES

proc draw_FNT
  mov    ebp,esp
  mov    esi,[ebp+draw_FNT_stack.font_data_ofs]         ;fontdata
  add    esi,3                                          ;point to offset table
  mov    ebx,[ebp+draw_FNT_stack.character]
  movzx  ecx,[word esi+ebx*2]
  add    esi,ecx                                        ;point to proper spot in font file
  movzx  ecx,[byte esi+1-3]                             ;get X size
  push   ecx
  movzx  edx,[byte esi+2-3]                             ;get Y size
  or     ecx,ecx
  jz     @@done
  or     edx,edx
  jz     @@done
  push   esi
  push   [dword ebp+draw_FNT_stack.Dest_buffer]
  push   [dword ebp+draw_FNT_stack.DestX]
  push   [dword ebp+draw_FNT_stack.DestY]
  push   ecx
  push   edx
  push   [dword ebp+draw_FNT_stack.TARGET_WIDTH]
  cmp    [draw_FNT_trans],NO
  je     @@notrans
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
  jmp    @@done
@@notrans:
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8
@@done:
  pop    eax
  ret
endp

;edi = fontdata
;eax = character
;returns = eax
proc get_FNT_size
  add    edi,3
  movzx  eax,[word edi+eax*2]
  add    edi,eax
  movzx  eax,[byte edi+1-3]
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pal_fade_buf          db 768 dup(?)

; esi = source pal, eax = start, ecx = count
proc fade_pal_init
  lea    eax,[eax*2+eax]
  lea    ecx,[ecx*2+ecx]
  mov    edi,offset pal_fade_buf
  add    edi,eax
  rep    movsb
  ret
endp

; eax = start, ecx = count, ebx = intensity (0-100h)
proc fade_pal
  cli
  mov    edx,03c8h
  out    dx,al
  lea    eax,[eax*2+eax]
  lea    ecx,[ecx*2+ecx]
  mov    esi,offset pal_fade_buf
  add    esi,eax
@@l:
  xor    eax,eax
  mov    al,[esi]
  mul    ebx
  sar    eax,8
  mov    edx,03c9h
  out    dx,al
  inc    esi
  dec    ecx
  jnz    @@l
  sti
  ret
endp

;eax = rate
;ebx = fade val
proc clip_dpal
  sub    ebx,eax
  js     @@z
  ret
@@z:
  mov    ebx,0
  ret
endp

;eax = rate
;ebx = fade val
proc clip_ipal
  add    ebx,eax
  cmp    ebx,256
  ja     @@c
  ret
@@c:
  mov    ebx,256
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; P-mode scaler. By JsNO/SuperReal. August 95                             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pscaler_clipL         dd 0
pscaler_clipR         dd 640
pscaler_clipT         dd 0
pscaler_clipB         dd 480

struc pscaler_stack
  BP_save             dd ?
  caller              dd ?
  TARGET_WIDTH        dd ?
  dst_size_y          dd ?
  dst_size_x          dd ?
  src_size_y          dd ?
  src_size_x          dd ?
  DestY               dd ?
  DestX               dd ?
  Dest_buffer         dd ?
  bitmap_ofs          dd ?
ends

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc pscaler
  push   ebp
  mov    ebp,esp
  mov    eax,[pscaler_clipL]
  sub    eax,[ebp+pscaler_stack.dst_size_x]
  cmp    eax,[ebp+pscaler_stack.DestX]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.DestX]
  cmp    eax,[pscaler_clipR]
  jge    @@exit_RBB
  mov    eax,[pscaler_clipT]
  sub    eax,[ebp+pscaler_stack.dst_size_y]
  cmp    eax,[ebp+pscaler_stack.DestY]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.DestY]
  cmp    eax,[pscaler_clipB]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.dst_size_x]
  mov    [dword @@lineX_length],eax
  mov    eax,[ebp+pscaler_stack.dst_size_y]
  mov    [dword @@lineY_length],eax
  mov    [@@x_total],0
  mov    [@@y_total],0
  mov    eax,[ebp+pscaler_stack.src_size_x]
  mov    [@@src_size_x],eax
  shl    eax,16
  xor    edx,edx
  div    [dword ebp+pscaler_stack.dst_size_x]
  mov    [dword @@inc_x],eax
  mov    eax,[ebp+pscaler_stack.src_size_y]
  shl    eax,16
  xor    edx,edx
  div    [dword ebp+pscaler_stack.dst_size_y]
  mov    [dword @@inc_y],eax
  mov    esi,[ebp+pscaler_stack.bitmap_ofs]
  mov    edi,[ebp+pscaler_stack.Dest_buffer]
  add    edi,[dword pscaler_clipL]
  mov    eax,[dword pscaler_clipT]
  mul    [dword ebp+pscaler_stack.TARGET_WIDTH]
  add    edi,eax
;=========================================================================
  mov    eax,[dword pscaler_clipL]                ; clip x left
  sub    eax,[ebp+pscaler_stack.DestX]            ; X_POS
  js     @@dont_clipL
  sub    [dword @@lineX_length],eax               ; adjust line lenght
  js     @@exit_RBB
  push   eax
  mul    [dword @@inc_x]
  shr    eax,16
  add    esi,eax                                  ; adjust mb offs
  pop    ecx
  mov    eax,[dword @@inc_x]
  shl    eax,16
  mul    ecx
  mov    [@@x_total],eax
  jmp    @@clipL_end
@@dont_clipL:
  add    edi,[ebp+pscaler_stack.DestX]
@@clipL_end:
;=========================================================================
  mov    eax,[ebp+pscaler_stack.DestX]           ; X_POS | clip x right
  add    eax,[ebp+pscaler_stack.dst_size_x]
  sub    eax,[dword pscaler_clipR]
  js     @@clipR_end
  sub    [dword @@lineX_length],eax
  js     @@exit_RBB
@@clipR_end:
;=========================================================================
  mov    eax,[ebp+pscaler_stack.DestY]           ; Y_POS | clip y bottom
  add    eax,[ebp+pscaler_stack.dst_size_y]
  sub    eax,[dword pscaler_clipB]
  js     @@clipB_end
  sub    [dword @@lineY_length],eax
  js     @@exit_RBB
@@clipB_end:
;=========================================================================
  mov    eax,[dword pscaler_clipT]                ; clip y top
  sub    eax,[ebp+pscaler_stack.DestY]            ; Y_POS
  js     @@dont_clipT
  sub    [dword @@lineY_length],eax               ; adjust line lenght
  js     @@exit_RBB
  push   eax
  mul    [dword @@inc_y]
  shr    eax,16
  mul    [ebp+pscaler_stack.src_size_x]
  add    esi,eax                                  ; adjust mb offs
  pop    ecx
  mov    eax,[dword @@inc_y]
  shl    eax,16
  mul    ecx
  mov    [@@y_total],eax
  jmp    @@clipT_end
@@dont_clipT:
  mov    eax,[ebp+pscaler_stack.DestY]
  mul    [dword ebp+pscaler_stack.TARGET_WIDTH]
  add    edi,eax
@@clipT_end:
  mov    eax,[dword ebp+pscaler_stack.dst_size_y]
  mov    [@@dst_size_y],eax
  mov    eax,[dword ebp+pscaler_stack.src_size_x]
  mov    [@@src_size_x],eax
  mov    eax,[dword ebp+pscaler_stack.TARGET_WIDTH]
  mov    [@@TARGET_WIDTH],eax
  mov    edx,[@@inc_y]
  mov    ebp,edx
  shl    edx,16
  shr    ebp,16
  push   edx
  mov    eax,[@@src_size_x]
  mul    ebp
  mov    ebp,eax
  pop    edx
  mov    ebx,[@@y_total]
  mov    ecx,[@@lineY_length]
@@paint_y:
  push   ecx esi edi ebx edx ebp
  mov    edx,[@@inc_x]
  mov    ebp,edx
  shl    edx,16
  shr    ebp,16
  mov    ebx,[@@x_total]
  mov    ecx,[@@lineX_length]
@@paint_x:
  mov    al,[esi]
  mov    [edi],al
  inc    edi
  add    ebx,edx
  adc    esi,ebp
  dec    ecx
  jnz    @@paint_x
@@end_x:
  pop    ebp edx ebx edi esi ecx
  add    ebx,edx
  jnc    @@dont_incy
  add    esi,[@@src_size_x]
@@dont_incy:
  add    esi,ebp
  add    edi,[@@TARGET_WIDTH]
  dec    ecx
  jnz    @@paint_y
@@exit_RBB:
  pop    ebp
  ret
@@lineX_length        dd ?
@@lineY_length        dd ?
@@inc_x               dd ?
@@inc_y               dd ?
@@dst_size_y          dd ?
@@TARGET_WIDTH        dd ?
@@src_size_x          dd ?
@@x_total             dd ?
@@y_total             dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc pscaler_TRANS
  push   ebp
  mov    ebp,esp
  mov    eax,[pscaler_clipL]
  sub    eax,[ebp+pscaler_stack.dst_size_x]
  cmp    eax,[ebp+pscaler_stack.DestX]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.DestX]
  cmp    eax,[pscaler_clipR]
  jge    @@exit_RBB
  mov    eax,[pscaler_clipT]
  sub    eax,[ebp+pscaler_stack.dst_size_y]
  cmp    eax,[ebp+pscaler_stack.DestY]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.DestY]
  cmp    eax,[pscaler_clipB]
  jge    @@exit_RBB
  mov    eax,[ebp+pscaler_stack.dst_size_x]
  mov    [dword @@lineX_length],eax
  mov    eax,[ebp+pscaler_stack.dst_size_y]
  mov    [dword @@lineY_length],eax
  mov    [@@x_total],0
  mov    [@@y_total],0
  mov    eax,[ebp+pscaler_stack.src_size_x]
  mov    [@@src_size_x],eax
  shl    eax,16
  xor    edx,edx
  div    [dword ebp+pscaler_stack.dst_size_x]
  mov    [dword @@inc_x],eax
  mov    eax,[ebp+pscaler_stack.src_size_y]
  shl    eax,16
  xor    edx,edx
  div    [dword ebp+pscaler_stack.dst_size_y]
  mov    [dword @@inc_y],eax
  mov    esi,[ebp+pscaler_stack.bitmap_ofs]
  mov    edi,[ebp+pscaler_stack.Dest_buffer]
  add    edi,[dword pscaler_clipL]
  mov    eax,[dword pscaler_clipT]
  mul    [dword ebp+pscaler_stack.TARGET_WIDTH]
  add    edi,eax
;=========================================================================
  mov    eax,[dword pscaler_clipL]                ; clip x left
  sub    eax,[ebp+pscaler_stack.DestX]            ; X_POS
  js     @@dont_clipL
  sub    [dword @@lineX_length],eax               ; adjust line lenght
  js     @@exit_RBB
  push   eax
  mul    [dword @@inc_x]
  shr    eax,16
  add    esi,eax                                  ; adjust mb offs
  pop    ecx
  mov    eax,[dword @@inc_x]
  shl    eax,16
  mul    ecx
  mov    [@@x_total],eax
  jmp    @@clipL_end
@@dont_clipL:
  add    edi,[ebp+pscaler_stack.DestX]
@@clipL_end:
;=========================================================================
  mov    eax,[ebp+pscaler_stack.DestX]           ; X_POS | clip x right
  add    eax,[ebp+pscaler_stack.dst_size_x]
  sub    eax,[dword pscaler_clipR]
  js     @@clipR_end
  sub    [dword @@lineX_length],eax
  js     @@exit_RBB
@@clipR_end:
;=========================================================================
  mov    eax,[ebp+pscaler_stack.DestY]           ; Y_POS | clip y bottom
  add    eax,[ebp+pscaler_stack.dst_size_y]
  sub    eax,[dword pscaler_clipB]
  js     @@clipB_end
  sub    [dword @@lineY_length],eax
  js     @@exit_RBB
@@clipB_end:
;=========================================================================
  mov    eax,[dword pscaler_clipT]                ; clip y top
  sub    eax,[ebp+pscaler_stack.DestY]            ; Y_POS
  js     @@dont_clipT
  sub    [dword @@lineY_length],eax               ; adjust line lenght
  js     @@exit_RBB
  push   eax
  mul    [dword @@inc_y]
  shr    eax,16
  mul    [ebp+pscaler_stack.src_size_x]
  add    esi,eax                                  ; adjust mb offs
  pop    ecx
  mov    eax,[dword @@inc_y]
  shl    eax,16
  mul    ecx
  mov    [@@y_total],eax
  jmp    @@clipT_end
@@dont_clipT:
  mov    eax,[ebp+pscaler_stack.DestY]
  mul    [dword ebp+pscaler_stack.TARGET_WIDTH]
  add    edi,eax
@@clipT_end:
  mov    eax,[dword ebp+pscaler_stack.dst_size_y]
  mov    [@@dst_size_y],eax
  mov    eax,[dword ebp+pscaler_stack.src_size_x]
  mov    [@@src_size_x],eax
  mov    eax,[dword ebp+pscaler_stack.TARGET_WIDTH]
  mov    [@@TARGET_WIDTH],eax
  mov    edx,[@@inc_y]
  mov    ebp,edx
  shl    edx,16
  shr    ebp,16
  push   edx
  mov    eax,[@@src_size_x]
  mul    ebp
  mov    ebp,eax
  pop    edx
  mov    ebx,[@@y_total]
  mov    ecx,[@@lineY_length]
@@paint_y:
  push   ecx esi edi ebx edx ebp
  mov    edx,[@@inc_x]
  mov    ebp,edx
  shl    edx,16
  shr    ebp,16
  mov    ebx,[@@x_total]
  mov    ecx,[@@lineX_length]
@@paint_x:
  mov    al,[esi]
  or     al,al
  jz     @@skipb
  mov    [edi],al
@@skipb:
  inc    edi
  add    ebx,edx
  adc    esi,ebp
  dec    ecx
  jnz    @@paint_x
@@end_x:
  pop    ebp edx ebx edi esi ecx
  add    ebx,edx
  jnc    @@dont_incy
  add    esi,[@@src_size_x]
@@dont_incy:
  add    esi,ebp
  add    edi,[@@TARGET_WIDTH]
  dec    ecx
  jnz    @@paint_y
@@exit_RBB:
  pop    ebp
  ret
@@lineX_length        dd ?
@@lineY_length        dd ?
@@inc_x               dd ?
@@inc_y               dd ?
@@dst_size_y          dd ?
@@TARGET_WIDTH        dd ?
@@src_size_x          dd ?
@@x_total             dd ?
@@y_total             dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Realtime Bitmap Rotation Routine (no clipping)                          ;
; by Soeren Holstebroe (seap)                                             ;
;                                                                         ;
; adapted for 386 P-mode by Jason Nunn/SuperReal - August 1995            ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;edi = multpliy buffer
;eax = height
;ebx = width
proc BM_rotate_init
  mul    ebx
  mov    ecx,eax
  xor    eax,eax
@@mulsloop:
  mov    [edi],ax
  add    eax,ebx
  add    edi,2
  dec    ecx
  jnz    @@mulsloop
  ret
endp

struc BM_rotate_stack
  caller              dd ?
  TARGET_WIDTH        dd ?
  src_size_y          dd ?
  src_size_x          dd ?
  angle               dd ?
  DestY               dd ?
  DestX               dd ?
  multiply_table      dd ?
  Dest_buffer         dd ?
  bitmap_ofs          dd ?
ends

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc BM_rotate
  mov    ebp,esp
  mov    eax,[ebp+BM_rotate_stack.angle]
  @find_cosine
  sar    eax,1
  mov    [@@cosv],eax
  mov    eax,[ebp+BM_rotate_stack.angle]
  @find_sine
  sar    eax,1
  mov    [@@sinv],eax
  mov    edi,[ebp+BM_rotate_stack.Dest_buffer]
  mov    eax,[ebp+BM_rotate_stack.DestY]
  mul    [dword ebp+BM_rotate_stack.TARGET_WIDTH]
  add    edi,eax
  add    edi,[ebp+BM_rotate_stack.DestX]
  mov    ebx,[ebp+BM_rotate_stack.src_size_x]
  sar    ebx,1
  neg    ebx
  mov    eax,ebx          ;  mov    eax,-(iwidth/2)
  imul   [@@cosv]
  mov    [@@cosvx],eax
  mov    eax,ebx          ;  mov    eax,-(iwidth/2)
  imul   [@@sinv]
  mov    [@@sinvx],eax
  mov    ecx,[ebp+BM_rotate_stack.src_size_y]   ; iheight;  mov    ebx,(-(iheight/2))
  mov    ebx,ecx
  sar    ebx,1
  neg    ebx
  mov    eax,ebx       ;  mov    eax,-(iheight/2)
  imul   [@@cosv]
  mov    [@@cosvy],eax
  mov    eax,ebx       ;  mov    eax,-(iheight/2)
  imul   [@@sinv]
  mov    [@@sinvy],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_x]
  sal    eax,8
  mov    [@@src_size_x8],eax
  sar    eax,1
  mov    [@@src_size_x7],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_y]
  sal    eax,7
  mov    [@@src_size_y7],eax
  mov    eax,[ebp+BM_rotate_stack.TARGET_WIDTH]
  sub    eax,[ebp+BM_rotate_stack.src_size_x]
  mov    [@@add_y_s],eax
  mov    eax,[ebp+BM_rotate_stack.bitmap_ofs]
  mov    [@@pic],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_x]
  mov    ebp,[ebp+BM_rotate_stack.multiply_table]
@@ry:
  push   ecx eax
  mov    ecx,eax          ;iwidth
  mov    edx,[@@sinvy]
  add    edx,[@@cosvx]
  mov    esi,[@@cosvy]
  sub    esi,[@@sinvx]
  add    edx,[@@src_size_x7] ;(iwidth/2)*256
  add    esi,[@@src_size_y7] ;(iheight/2)*256
@@rx:
  cmp    edx,[@@src_size_x8] ;iwidth*256
  jae    @@blackout
  cmp    esi,[@@src_size_x8]
  jae    @@blackout
  mov    ebx,esi
  xchg   bh,bl
  xor    bh,bh
  xor    eax,eax
  mov    ax,[ebx*2+ebp]
  xor    ebx,ebx
  mov    bl,dh
  add    ebx,eax
  add    ebx,[@@pic]
  mov    al,[ebx]
@@plot_pixel:
  mov    [edi],al
  inc    edi
  add    edx,[@@cosv]
  sub    esi,[@@sinv]
  dec    ecx
  jnz    @@rx
  add    edi,[@@add_y_s] ;screen_x-iwidth
  mov    eax,[@@cosv]
  add    [@@cosvy],eax
  mov    eax,[@@sinv]
  add    [@@sinvy],eax
  pop    eax ecx
  dec    ecx
  jnz    @@ry
  ret
@@blackout:
  xor    al,al
  jmp    @@plot_pixel
@@pic           dd ?
@@src_size_x7   dd ?
@@src_size_y7   dd ?
@@src_size_x8   dd ?
@@add_y_s       dd ?
@@cosvx         dd 0
@@sinvx         dd 0
@@cosvy         dd 0
@@sinvy         dd 0
@@cosv          dd 0
@@sinv          dd 0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc BM_rotate_TRANS
  mov    ebp,esp
  mov    eax,[ebp+BM_rotate_stack.angle]
  @find_cosine
  sar    eax,1
  mov    [@@cosv],eax
  mov    eax,[ebp+BM_rotate_stack.angle]
  @find_sine
  sar    eax,1
  mov    [@@sinv],eax
  mov    edi,[ebp+BM_rotate_stack.Dest_buffer]
  mov    eax,[ebp+BM_rotate_stack.DestY]
  mul    [dword ebp+BM_rotate_stack.TARGET_WIDTH]
  add    edi,eax
  add    edi,[ebp+BM_rotate_stack.DestX]
  mov    ebx,[ebp+BM_rotate_stack.src_size_x]
  sar    ebx,1
  neg    ebx
  mov    eax,ebx          ;  mov    eax,-(iwidth/2)
  imul   [@@cosv]
  mov    [@@cosvx],eax
  mov    eax,ebx          ;  mov    eax,-(iwidth/2)
  imul   [@@sinv]
  mov    [@@sinvx],eax
  mov    ecx,[ebp+BM_rotate_stack.src_size_y]   ; iheight;  mov    ebx,(-(iheight/2))
  mov    ebx,ecx
  sar    ebx,1
  neg    ebx
  mov    eax,ebx       ;  mov    eax,-(iheight/2)
  imul   [@@cosv]
  mov    [@@cosvy],eax
  mov    eax,ebx       ;  mov    eax,-(iheight/2)
  imul   [@@sinv]
  mov    [@@sinvy],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_x]
  sal    eax,8
  mov    [@@src_size_x8],eax
  sar    eax,1
  mov    [@@src_size_x7],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_y]
  sal    eax,7
  mov    [@@src_size_y7],eax
  mov    eax,[ebp+BM_rotate_stack.TARGET_WIDTH]
  sub    eax,[ebp+BM_rotate_stack.src_size_x]
  mov    [@@add_y_s],eax
  mov    eax,[ebp+BM_rotate_stack.bitmap_ofs]
  mov    [@@pic],eax
  mov    eax,[ebp+BM_rotate_stack.src_size_x]
  mov    ebp,[ebp+BM_rotate_stack.multiply_table]
@@ry:
  push   ecx eax
  mov    ecx,eax          ;iwidth
  mov    edx,[@@sinvy]
  add    edx,[@@cosvx]
  mov    esi,[@@cosvy]
  sub    esi,[@@sinvx]
  add    edx,[@@src_size_x7] ;(iwidth/2)*256
  add    esi,[@@src_size_y7] ;(iheight/2)*256
@@rx:
  cmp    edx,[@@src_size_x8] ;iwidth*256
  jae    @@dontplotdot
  cmp    esi,[@@src_size_x8]
  jae    @@dontplotdot
  mov    ebx,esi
  xchg   bh,bl
  xor    bh,bh
  xor    eax,eax
  mov    ax,[ebx*2+ebp]
  xor    ebx,ebx
  mov    bl,dh
  add    ebx,eax
  add    ebx,[@@pic]
  mov    al,[ebx]
  or     al,al
  je     @@dontplotdot
  mov    [edi],al
@@dontplotdot:
  inc    edi
  add    edx,[@@cosv]
  sub    esi,[@@sinv]
  dec    ecx
  jnz    @@rx
  add    edi,[@@add_y_s] ;screen_x-iwidth
  mov    eax,[@@cosv]
  add    [@@cosvy],eax
  mov    eax,[@@sinv]
  add    [@@sinvy],eax
  pop    eax ecx
  dec    ecx
  jnz    @@ry
  ret
@@pic           dd ?
@@src_size_x7   dd ?
@@src_size_y7   dd ?
@@src_size_x8   dd ?
@@add_y_s       dd ?
@@cosvx         dd 0
@@sinvx         dd 0
@@cosvy         dd 0
@@sinvy         dd 0
@@cosv          dd 0
@@sinv          dd 0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; X := cos(angle) * x - sin(Xan) * y                                      ;
; Y := sin(angle) * x + cos(Xan) * y                                      ;
;        ESI= angle                                                       ;
; Input: EBX= X ECX= Y which are rotated Angle degrees                    ;
; OutPut:EBX= X ECX= Y                                                    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc RotateXY
  mov    eax,esi
  @find_cosine
  imul   ebx
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,esi
  @find_sine
  imul   ecx
  shrd   eax,edx,9
  sub    edi,eax
  mov    ebp,edi
  mov    eax,esi
  @find_sine
  imul   ebx
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,esi
  @find_cosine
  imul   ecx
  shrd   eax,edx,9
  add    edi,eax
  mov    ebx,ebp
  mov    ecx,edi
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Triangle blitter                                                         ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fpoly3_SCRW           = 640
fpoly3_t_clip         dd 100
fpoly3_b_clip         dd 480
fpoly3_l_clip         dd 0
fpoly3_r_clip         dd 640

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fpoly3_xl_hi          dd ?
fpoly3_xr_hi          dd ?
fpoly3_l_incr         dd ?
fpoly3_r_incr         dd ?
;ebx = ;fpoly3_yt             dd ?
;ecx = ;fpoly3_yb             dd ?

proc fpoly3_trape
  mov    eax,[fpoly3_b_clip]
  cmp    eax,ebx ;[fpoly3_yt]
  jg     @@dcb
  ret
@@dcb:

  mov    eax,[fpoly3_b_clip]
  cmp    eax,ecx ;[fpoly3_yb]
  jg     @@dcb2
  mov    ecx,eax   ;[fpoly3_yb],eax
@@dcb2:

  mov    eax,ecx  ;[fpoly3_yb]
  cmp    eax,[fpoly3_t_clip]
  jg     @@dct
  sub    eax,ebx ;[fpoly3_yt]
  push   eax
  imul   [fpoly3_l_incr]
  add    [fpoly3_xl_hi],eax
  pop    eax
  imul   [fpoly3_r_incr]
  add    [fpoly3_xr_hi],eax
  ret
@@dct:

  mov    eax,ebx ;[fpoly3_yt]
  sub    eax,[fpoly3_t_clip]
  jns    @@dct2
  neg    eax
  add    ebx,eax   ;[fpoly3_yt],eax
  push   eax
  imul   [fpoly3_l_incr]
  add    [fpoly3_xl_hi],eax
  pop    eax
  imul   [fpoly3_r_incr]
  add    [fpoly3_xr_hi],eax
  mov    eax,[fpoly3_t_clip]
  jmp    @@done_dct2
@@dct2:
  add    eax,[fpoly3_t_clip]
@@done_dct2:
;edi = vline
  mov    edx,fpoly3_SCRW
  mul    edx
  mov    edi,eax
  add    edi,[dword Rendbuff]

;ebx >> 16 = edx, ecx << 16 = esi
  mov    eax,ecx  ;[fpoly3_yb]
  sub    eax,ebx  ;[fpoly3_yt]

  mov    edx,[fpoly3_xl_hi]
  mov    esi,[fpoly3_xr_hi]
  mov    ebx,edx
  sar    ebx,16
  mov    ecx,esi
  sar    ecx,16
@@nextline:
  push   eax edi

  cmp    ecx,[fpoly3_l_clip]
  jl     @@doneline
  cmp    ebx,[fpoly3_r_clip]
  jge    @@doneline
  cmp    ecx,[fpoly3_r_clip]
  jle    @@dont_clip_right
  mov    ecx,[fpoly3_r_clip]
@@dont_clip_right:
  cmp    ebx,[fpoly3_l_clip]
  jge    @@dont_clip_left
  mov    ebx,[fpoly3_l_clip]
@@dont_clip_left:

  add    edi,ebx
  sub    ecx,ebx
  jz     @@1pixel
  js     @@doneline

  mov    al,[byte ebp+fpoly3_stack.colour]

  push   ecx
  shr    ecx,2
  jz     @@ignore_32

  mov    ah,al
  shl    eax,16
  mov    al,[byte ebp+fpoly3_stack.colour]
  mov    ah,al

@@paint_x32:
  mov    [edi],eax
  add    edi,4
  dec    ecx
  jnz    @@paint_x32
@@ignore_32:
  pop    ecx                                      ; bytes to write left
  and    cl,3
  jz     @@doneline
@@paint_x8:
  mov    [edi],al
  inc    edi
  dec    cl
  jnz    @@paint_x8
@@doneline:
  pop    edi eax
  add    edi,fpoly3_SCRW
  add    edx,[fpoly3_l_incr]
  add    esi,[fpoly3_r_incr]
  mov    ebx,edx
  sar    ebx,16
  mov    ecx,esi
  sar    ecx,16
  dec    eax
  jg     @@nextline
  mov    [fpoly3_xl_hi],edx
  mov    [fpoly3_xr_hi],esi
  ret
@@1pixel:
  mov    al,[byte ebp+fpoly3_stack.colour]
  mov    [edi],al
  jmp    @@doneline
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc fpoly3_stack
  caller              dd ?
  colour              dd ?
  y3                  dd ?
  x3                  dd ?
  y2                  dd ?
  x2                  dd ?
  y1                  dd ?
  x1                  dd ?
ends

;(x2-x1)/(y2-y1)
;
; eax = x2
; ebx = x1
; ecx = y2
; edx = y1
macro @fpoly3_XYs
local @@roundpl
  sub    eax,ebx
  jz     @@roundpl
  sub    ecx,edx
  cdq
  shld   eax,edx,16
  idiv   ecx
@@roundpl:
endm

proc fpoly3
  mov    ebp,esp

;  i = poly_l_clip;
;  if(!( P1.x>=i || P2.x>=i || P3.x>=i )) return;
  mov    eax,[fpoly3_l_clip]
  cmp    eax,[ebp+fpoly3_stack.x1]
  jle    @@hlc_pass
  cmp    eax,[ebp+fpoly3_stack.x2]
  jle    @@hlc_pass
  cmp    eax,[ebp+fpoly3_stack.x3]
  jg     @@end
@@hlc_pass:

;  i = poly_r_clip;
;  if(!( P1.x<=i || P2.x<=i || P3.x<=i )) return;
  mov    eax,[fpoly3_r_clip]
  cmp    eax,[ebp+fpoly3_stack.x1]
  jg     @@hrc_pass
  cmp    eax,[ebp+fpoly3_stack.x2]
  jg     @@hrc_pass
  cmp    eax,[ebp+fpoly3_stack.x3]
  jle    @@end
@@hrc_pass:

;  i = poly_b_clip;
;  if(!( P1.y<=i || P2.y<=i || P3.y<=i )) return;
  mov    eax,[fpoly3_b_clip]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jg     @@hbc_pass
  cmp    eax,[ebp+fpoly3_stack.y2]
  jg     @@hbc_pass
  cmp    eax,[ebp+fpoly3_stack.y3]
  jle    @@end
@@hbc_pass:

;  i = poly_t_clip;
;  if(!( P1.y>=i || P2.y>=i || P3.y>=i )) return;
  mov    eax,[fpoly3_t_clip]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jle    @@htc_pass
  cmp    eax,[ebp+fpoly3_stack.y2]
  jle    @@htc_pass
  cmp    eax,[ebp+fpoly3_stack.y3]
  jg     @@end
@@htc_pass:

;  if(P2.y<P1.y) /* sort by vert pos'n */
;  {
;    temp_v = P1;
;    P1 = P2;
;    P2 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y1]
  cmp    ebx,[ebp+fpoly3_stack.y2]
  jle    @@dswap12

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x2]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y2]
  mov    [ebp+fpoly3_stack.y1],eax
@@dswap12:

;  if(P3.y<P1.y)
;  {
;    temp_v = P1;
;    P1 = P3;
;    P3 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y1]
  cmp    ebx,[ebp+fpoly3_stack.y3]
  jle    @@dswap31

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y1],eax
@@dswap31:

;  if(P3.y<P2.y)
;  {
;    temp_v = P2;
;    P2 = P3;
;    P3 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y2]
  cmp    ebx,[ebp+fpoly3_stack.y3]
  jle    @@dswap32

  mov    eax,[ebp+fpoly3_stack.x2]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x2],eax

  mov    eax,[ebp+fpoly3_stack.y2]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y2],eax
@@dswap32:

;  if(P3.y<poly_t_clip
  mov    eax,[ebp+fpoly3_stack.y3]
  cmp    eax,[fpoly3_t_clip]
  jl     @@end

;                     || P1.y>poly_b_clip) return; /* all above or below clip area */
  mov    eax,[ebp+fpoly3_stack.y1]
  cmp    eax,[fpoly3_b_clip]
  jg     @@end

;  if(P1.y==P2.y&&P2.y==P3.y) return;
;  if(P1.y==P2.y) /* case = 2 (flat top) */
;  {
  mov    eax,[ebp+fpoly3_stack.y2]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jne    @@not_flat_top
  cmp    eax,[ebp+fpoly3_stack.y3]
  je     @@end
;--flat_top -------------------------------------------------------
;    if(P2.x<P1.x)
;    {
;      temp_v = P1;
;      P1 = P2;
;      P2 = temp_v;
;    }
  mov    ebx,[ebp+fpoly3_stack.x1]
  cmp    ebx,[ebp+fpoly3_stack.x2]
  jle    @@ft_dswap32

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x2]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y2]
  mov    [ebp+fpoly3_stack.y1],eax
@@ft_dswap32:

;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_l_incr],eax

;    s23 = compute_XYslope(P2,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y2]
  @fpoly3_XYs
  mov    [fpoly3_r_incr],eax

;    GZ_trapezoid(P1.x,P2.x,s13,s23,
;                 P1.y,P3.y,
;                 HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xr_hi],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
;--flat_bottom-----------------------------------------------------
;  else if(P2.y==P3.y) /* case = 1 (flat bottom)*/
;  {
@@not_flat_top:
  cmp    eax,[ebp+fpoly3_stack.y3]
  jne    @@not_flat_bottom

;    if(P3.x<P2.x)
;    {
;      temp_v = P2;
;      P2 = P3;
;      P3 = temp_v;
;    }
  mov    ebx,[ebp+fpoly3_stack.x2]
  cmp    ebx,[ebp+fpoly3_stack.x3]
  jle    @@fb_dswap32

  mov    eax,[ebp+fpoly3_stack.x2]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x2],eax

  mov    eax,[ebp+fpoly3_stack.y2]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y2],eax
@@fb_dswap32:

;    s12 = compute_XYslope(P1,P2);
  mov    eax,[ebp+fpoly3_stack.x2]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_l_incr],eax

;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_r_incr],eax

;    GZ_trapezoid(P1.x,P1.x,s12,s13,
;                 P1.y,P3.y,
;                 HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
;--free angle------------------------------------------------------
@@not_flat_bottom:
;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [@@s13],eax

;    s23 = compute_XYslope(P2,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y2]
  @fpoly3_XYs
  mov    [@@s23],eax

;    s12 = compute_XYslope(P1,P2);
  mov    eax,[ebp+fpoly3_stack.x2]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [@@s12],eax

;    if(s12 > s13) /* case = 4 (3rd point on right) */
;    {
  cmp    eax,[@@s13]
  jle    @@3pol

;      GZ_trapezoid(P1.x,P1.x,s13,s12,
;                   P1.y,P2.y,
;                   HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s13]
  mov    [fpoly3_l_incr],eax
  mov    eax,[@@s12]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  call   fpoly3_trape

;      GZ_trapezoid(  -1,P2.x,s13,s23,
;                   P2.y,P3.y,
;                   HOLD_LEFT);
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s23]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
@@3pol:
;      GZ_trapezoid(P1.x,P1.x,s12,s13,
;                   P1.y,P2.y,
;                   HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s12]
  mov    [fpoly3_l_incr],eax
  mov    eax,[@@s13]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  call   fpoly3_trape


;      GZ_trapezoid(P2.x,  -1,s23,s13,
;                   P2.y,P3.y,
;                   HOLD_RIGHT);
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    eax,[@@s23]
  mov    [fpoly3_l_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

@@end:
  ret
@@s12                 dd ?
@@s13                 dd ?
@@s23                 dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; coordinate mapper                                                        ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc tf3d_point
  x                   dd ?
  y                   dd ?
  z                   dd ?
ends

struc tf3d_p_point
  x                   dd ?
  y                   dd ?
ends

struc tf3d_facet
  colour              db ?
  p1                  tf3d_point <>
  p2                  tf3d_point <>
  p3                  tf3d_point <>
ends

struc tf3d_projd
  colour              db ?
  p1                  tf3d_p_point <>
  p2                  tf3d_p_point <>
  p3                  tf3d_p_point <>
ends

struc tf3d_qsort
  index               dd ?
  Yorder              dd ?
ends

f3d_xangle            dd 0
f3d_yangle            dd 0
f3d_zangle            dd 1024+170

f3d_focus_x           dd 0
f3d_focus_y           dd 0
f3d_focus_z           dd 0

f3d_Distance          dd 800
f3d_postx             dd 640/2
f3d_posty             dd 480/2

f3d_no_facets         dd ?
f3d_qsort_count       dd ?
f3d_world_ptr         dd ?
f3d_projd_ptr         dd ?
f3d_qsort_ptr         dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_init
  mov    ecx,[f3d_no_facets]

  mov    eax,size tf3d_projd
  mul    ecx
  mov    edx,eax
  mov    AX,0EE42h
  int    31h
  mov    [f3d_projd_ptr],edx

  mov    eax,size tf3d_qsort
  mul    ecx
  mov    edx,eax
  mov    AX,0EE42h
  int    31h
  mov    [f3d_qsort_ptr],edx
  ret
endp

proc f3d_deinit
  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;  in:   EBX= X ECX= Y EBP= Z                                              ;
; out:   EBX= X ECX= Y EBP= Z                                              ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_rotate
; EBX = EBX * cos(f3d_xangle) - ECX * sin(f3d_xangle)
; ECX = EBX * sin(f3d_xangle) + ECX * cos(f3d_xangle)
  mov    eax,[f3d_xangle]
  @find_cosine
  imul   ebx
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,[f3d_xangle]
  @find_sine
  imul   ecx
  shrd   eax,edx,9
  sub    edi,eax

  mov    eax,[f3d_xangle]
  @find_sine
  imul   ebx
  shrd   eax,edx,9
  mov    esi,eax
  mov    eax,[f3d_xangle]
  @find_cosine
  imul   ecx
  shrd   eax,edx,9
  add    esi,eax

  mov    ebx,edi
  mov    ecx,esi

; EBX = EBX * cos(f3d_yangle) - EBP * sin(f3d_yangle)
; EBP = EBX * sin(f3d_yangle) + EBP * cos(f3d_yangle)
;  mov    eax,[f3d_yangle]
;  @find_cosine
;  imul   ebx
;  shrd   eax,edx,9
;  mov    edi,eax
;  mov    eax,[f3d_yangle]
;  @find_sine
;  imul   ebp
;  shrd   eax,edx,9
;  sub    edi,eax
;
;  mov    eax,[f3d_yangle]
;  @find_sine
;  imul   ebx
;  shrd   eax,edx,9
;  mov    esi,eax
;  mov    eax,[f3d_yangle]
;  @find_cosine
;  imul   ebp
;  shrd   eax,edx,9
;  add    esi,eax
;
;  mov    ebx,edi
;  mov    ebp,esi

; EBP = EBP * cos(f3d_zangle) - ECX * sin(f3d_zangle)
; ECX = EBP * sin(f3d_zangle) + ECX * cos(f3d_zangle)
  mov    eax,[f3d_zangle]
  @find_cosine
  imul   ebp
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,[f3d_zangle]
  @find_sine
  imul   ecx
  shrd   eax,edx,9
  sub    edi,eax

  mov    eax,[f3d_zangle]
  @find_sine
  imul   ebp
  shrd   eax,edx,9
  mov    esi,eax
  mov    eax,[f3d_zangle]
  @find_cosine
  imul   ecx
  shrd   eax,edx,9
  add    esi,eax

  mov    ebp,edi
  mov    ecx,esi

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc f3d_qsort_stack
  bp_r                dd ?
  caller              dd ?
  r                   dd ?
  l                   dd ?
ends

; eax = i
; edx = j
; ecx = x
; esi = sort list
proc f3d_qsort
  push   ebp
  mov    ebp,esp
  push   eax edx
  mov    eax,[ebp+f3d_qsort_stack.l]
  mov    edx,[ebp+f3d_qsort_stack.r]
  mov    ebx,eax
  add    ebx,edx
  shr    ebx,1
  mov    ecx,[esi+ebx*8+tf3d_qsort.Yorder]
@@repeat_loop1:
  cmp    [dword esi+eax*8+tf3d_qsort.Yorder],ecx
  jle    @@find_list_j_loop
  inc    eax
  jmp    @@repeat_loop1
@@find_list_j_loop:
  cmp    ecx,[dword esi+edx*8+tf3d_qsort.Yorder]
  jle    @@fin_retract
  dec    edx
  jmp    @@find_list_j_loop
@@fin_retract:
  cmp    eax,edx
  jg     @@done_sect_sort
  je     @@skip
  mov    edi,[dword esi+eax*8+tf3d_qsort.index]
  mov    ebx,[esi+eax*8+tf3d_qsort.Yorder]
  xchg   edi,[dword esi+edx*8+tf3d_qsort.index]
  xchg   ebx,[esi+edx*8+tf3d_qsort.Yorder]
  mov    [dword esi+eax*8+tf3d_qsort.index],edi
  mov    [esi+eax*8+tf3d_qsort.Yorder],ebx
@@skip:
  inc    eax
  dec    edx
@@done_sect_sort:
  cmp    eax,edx
  jle    @@repeat_loop1
  cmp    [dword ebp+f3d_qsort_stack.l],edx
  jge    @@nt1
  push   [dword ebp+f3d_qsort_stack.l]
  push   edx
  call   f3d_qsort
  add    esp,size f3d_qsort_stack-8
@@nt1:
  cmp    eax,[dword ebp+f3d_qsort_stack.r]
  jge    @@nt2
  push   eax
  push   [dword ebp+f3d_qsort_stack.r]
  call   f3d_qsort
  add    esp,size f3d_qsort_stack-8
@@nt2:
  pop    edx eax ebp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_project_world
  mov    ecx,[f3d_no_facets]
  mov    edi,[f3d_world_ptr]
  mov    esi,[f3d_projd_ptr]
  mov    ebx,[f3d_qsort_ptr]
@@project_l:
  push   ecx edi esi ebx

  mov    al,[edi+tf3d_facet.colour]
  mov    [esi+tf3d_projd.colour],al

  mov    [dword @@y_mean],0
  mov    cl,3
@@calc_3:
  push   ecx
  mov    ebx,[edi+tf3d_facet.p1.x]
  mov    ecx,[edi+tf3d_facet.p1.y]
  mov    ebp,[edi+tf3d_facet.p1.z]
  add    ebx,[f3d_focus_x]
  add    ecx,[f3d_focus_y]
  add    ebp,[f3d_focus_z]

  push   esi edi
  call   f3d_rotate
  pop    edi esi
  add    ecx,[f3d_Distance]

  cmp    ecx,0
  jle    @@zeroy

  mov    eax,ebx
  cdq
  shld   edx,eax,8
  sal    eax,8
  idiv   ecx
  add    eax,[f3d_postx]
  mov    [esi+tf3d_projd.p1.x],eax

  mov    eax,ebp
  cdq
  shld   edx,eax,8
  sal    eax,8
  idiv   ecx
  add    eax,[f3d_posty]
  mov    [esi+tf3d_projd.p1.y],eax
  jmp    @@fprojxy
@@zeroy:
  pop    ecx
  pop    ebx esi edi ecx
  jmp    @@zclip_facet
@@fprojxy:
  add    edi,size tf3d_point
  add    esi,size tf3d_p_point

  add    [@@y_mean],ecx

  pop    ecx
  dec    cl
  jnz    @@calc_3

  pop    ebx esi edi ecx

  mov    eax,[@@y_mean]
  mov    [ebx+tf3d_qsort.index],esi
  mov    [ebx+tf3d_qsort.Yorder],eax
  add    ebx,size tf3d_qsort
@@zclip_facet:
  add    edi,size tf3d_facet
  add    esi,size tf3d_projd

  dec    ecx
  jnz    @@project_l

  sub    ebx,[f3d_qsort_ptr]
  shr    ebx,3
  mov    [f3d_qsort_count],ebx
  cmp    ebx,1
  jbe    @@skip

  mov    esi,[f3d_qsort_ptr]
  push   0
  dec    ebx
  push   ebx
  call   f3d_qsort
  add    esp,(size f3d_qsort_stack)-8
@@skip:
  ret
@@y_mean              dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_draw_world
  cmp    [dword f3d_qsort_count],0
  je     @@skip
  mov    ecx,[f3d_qsort_count]
  mov    ebx,[f3d_qsort_ptr]
@@draw_l:
  push   ecx ebx
  mov    eax,[ebx+tf3d_qsort.index]
  push   [eax+tf3d_projd.p1.x]
  push   [eax+tf3d_projd.p1.y]
  push   [eax+tf3d_projd.p2.x]
  push   [eax+tf3d_projd.p2.y]
  push   [eax+tf3d_projd.p3.x]
  push   [eax+tf3d_projd.p3.y]
  push   [dword eax+tf3d_projd.colour]
  call   fpoly3
  add    esp,(size fpoly3_stack)-4

  pop    ebx ecx

  add    ebx,size tf3d_qsort
  dec    ecx
  jnz    @@draw_l
@@skip:
  ret
endp
