;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; First SVGA demo, by JsNO (9/6/95)                                       ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 2048
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?
_0A0000h              dd ?

YES                   = 0
NO                    = 1

filename1             db "sr_bar_1.tga",0
filename2             db "sr_bar_1.vga",0
pal_flag              db NO

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Load 256 color uncompressed TARGA file                                  ;
;      edi = file ptr                                                     ;
;  returns = edi = bitmap ptr                                             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc ttga_header
  id_length           db ?
  cmap_type           db ?
  image_type          db ?
  cmap_origin         dw ?
  cmap_length         dw ?
  cmap_size           db ?
  X_origin            dw ?
  Y_origin            dw ?
  Width               dw ?
  Height              dw ?
  Pixel_size          db ?
  Idescriptor         db ?
ends
tga_header            ttga_header <>

filename              db "face.tga",0
tgahandle             dd ?

proc TGA_load
  mov    eax,3d00h                                  ;open
  int    21h
  mov    [tgahandle],eax

  mov    ebx,eax                                    ;read
  mov    edx,offset tga_header
  mov    ecx,size ttga_header
  mov    ah,3fh
  int    21h

  movzx  eax,[word tga_header.Width]
  movzx  ecx,[word tga_header.Height]
  mul    ecx
  add    eax,768+8
  mov    edx,eax
  add    edx,1000h
  mov    eax,0EE42h                                 ;memory block
  Int    31h
  mov    esi,edx
  mov    edi,edx

  movzx  eax,[word tga_header.Width]
  mov    [esi],eax
  movzx  eax,[word tga_header.Height]
  mov    [esi+4],eax
  add    esi,8

  mov    ebx,[tgahandle]
  mov    ecx,768                                    ;read pal
  mov    edx,esi
  mov    ah,3fh
  int    21h
  mov    ecx,768/3
@@lp:
  mov    al,[esi]
  mov    ah,[esi+1]
  mov    bl,[esi+2]
  shr    al,2
  shr    ah,2
  shr    bl,2
  mov    [esi],bl
  mov    [esi+1],ah
  mov    [esi+2],al
  add    esi,3
  dec    ecx
  jnz    @@lp

  mov    ebx,[tgahandle]
  movzx  eax,[word tga_header.Width]
  movzx  ecx,[word tga_header.Height]
  mul    ecx
  mov    ecx,eax
  mov    edx,esi                                    ;read data
  mov    ah,3fh
  int    21h

  push   edi
  mov    edi,esi
  add    edi,eax
  movzx  ebx,[word tga_header.Width]
  sub    edi,ebx
  movzx  edx,[word tga_header.Height]
  shr    edx,1
@@cbm:
  push   edi
  mov    ecx,ebx
@@cbm2:
  mov    al,[esi]
  xchg   al,[edi]
  mov    [esi],al
  inc    esi
  inc    edi
  dec    ecx
  jnz    @@cbm2
  pop    edi
  sub    edi,ebx
  dec    edx
  jnz    @@cbm
  pop    edi

  mov    ebx,[tgahandle]                            ;close
  mov    ah,3eh
  int    21h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc tvga_header
  x_size              dw ?
  y_size              dw ?
ends
vga_header            tvga_header <>

proc save_vga
  mov    ax,[word tga_header.Width]
  mov    [vga_header.x_size],ax
  mov    ax,[word tga_header.Height]
  mov    [vga_header.y_size],ax

  mov    eax,3c00h                                  ;create
  xor    ecx,ecx
  int    21h
  mov    ebx,eax

  mov    edx,offset vga_header                      ;write header
  mov    ecx,size tvga_header
  mov    ah,40h
  int    21h

  movzx  eax,[word tga_header.Width]                ;write data
  movzx  ecx,[word tga_header.Height]
  mul    ecx
  mov    ecx,eax
  mov    edx,edi
  add    edx,768+8
  mov    ah,40h
  int    21h

  cmp    [byte pal_flag],NO
  je     @@skip_pal

  mov    edx,edi                                    ;write palette
  add    edx,8
  mov    ecx,768
  mov    ah,40h
  int    21h
@@skip_pal:

  mov    ebx,[tgahandle]                            ;close
  mov    ah,3eh
  int    21h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start:
  cld
  mov    ax,0EE02h       ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0A0000h
  mov    [_0A0000h],ebx
  add    ebx,0B8000h-0A0000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  mov    edx,offset filename1
  call   TGA_load
  mov    edx,offset filename2
  call   save_vga

  mov    eax,4c00h
  int    21h
ends

end Start
