
#include "pump.h"

#include <stdio.h>
#include <string.h>
#include <llkey.h>
#include <llscreen.h>
#include <jclib.h>
#include <ctype.h>
#include <stdarg.h>
#include <vga.h>
#include <vbl.h>

PRIVATE byte *image;
PRIVATE byte pal[768];
PRIVATE int time;
PRIVATE int state;
PRIVATE int come_in_finished = 0;
PRIVATE int come_out_finished = 0;

#define NSECS 2
#define SHOW_TIME 1

int tabla[70*NSECS] = {
#include "tabla.h"
};


void SHOW_DoFrame(void) {
    int i, localtime = time, scantime;
    byte *p = LLS_Screen[0];
    byte *q = image;

    if (state == 0) {
        for (i = 0; i < 200; i++) {
            scantime = localtime;
            if (scantime >= 70*NSECS)
                scantime = 70*NSECS-1;
            if (scantime < 0)
                scantime = 0;
            memcpy(p+tabla[scantime], q, 320-tabla[scantime]);
            p += 320;
            q += 320;
            if (!(i & 1)) {
                localtime -= 1;
                if (localtime == -1)
                    localtime = 0;
            }
        }
        if (localtime >= 70*NSECS-1)
            come_in_finished = 1;
        else
            come_in_finished = 0;
    } else if (state == 1) {
        memcpy(p, image, 64000);
    } else if (state == 2) {
    } else if (state == 3) {
        for (i = 0; i < 200; i++) {
            scantime = 70*NSECS + 35 - localtime;
            if (scantime >= 70*NSECS)
                scantime = 70*NSECS-1;
            if (scantime < 0)
                scantime = 0;
            memset(p, 0, tabla[scantime]);
            memcpy(p+tabla[scantime], q, 320-tabla[scantime]);
            p += 320;
            q += 320;
            if (!(i & 1)) {
                localtime -= 1;
                if (localtime == -1)
                    localtime = 0;
            }
        }
        if (localtime >= 35+70*NSECS-1)
            come_out_finished = 1;
        else
            come_out_finished = 0;
    }
}

void SHOW_Do(void) {
    int i;
    int delta;

    memset(LLS_Screen[0], 0, LLS_Size);
    LLS_Update();

    LLS_SetMode(LLSM_DIRECT, LLSVM_MODE13);

    if (JCLIB_Load("image.pal", pal, 768) != 768) {
        BASE_Abort("load image.pal");
    }
    image = NEW(320*200);
    if (!image) {
        BASE_Abort("not enough mem for image.pix");
    }
    if (JCLIB_Load("image.pix", image, 64000) != 64000) {
        BASE_Abort("load image.pix");
    }
    VBL_FadePos = 0;
    VBL_FadeSpeed = 0;
    VBL_DumpPalette(pal, 0, 256);

/*
    if (JCLIB_Load("image.pal", pal, 768) != 768) {
        BASE_Abort("load image.pal");
    }
    image = NEW(320*200);
    if (!image) {
        BASE_Abort("not enough mem for image.pix");
    }
    if (JCLIB_Load("image.pix", image, 64000) != 64000) {
        BASE_Abort("load image.pix");
    }
    VBL_DumpPalette(pal, 0, 256);
*/
    VBL_VSync(0);
    time = 0;
    state = 0;
    while (!LLK_SpacePressed) {
        SHOW_DoFrame();
        delta = VBL_VSync(1);
        if (state == 0) {
            if (come_in_finished) {
                state = 1;
                time = 0;
            }
        } else if (state == 1) {
            state = 2;
        } else if (state == 2) {
            ///////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////
            // Poner aqu la condicin para que deje de mostrar la imagen
            // esttica
            ///////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////
            if ((time <= 70*SHOW_TIME) && (time+delta > 70*SHOW_TIME)) {
                state = 3;
                time = 0;
            }
        } else if (state == 3) {
            if (come_out_finished)
                break;
        }
        time += delta;
    }
    DISPOSE(image);

    LLS_SetMode(LLSM_VIRTUAL, LLSVM_MODE13);

}
