
#include "pump.h"

#include <ctype.h>
#include <stdarg.h>
#include "rle.h"

#define NUM_GFX 32
byte *gfx[NUM_GFX];
byte *endlogo;

#define NUM_SHUFFLES NUM_GFX

#define TIME 15

void EPILEPSIA_Do(void) {
    int time, delta, mode = 0;
    int i;
    char buf[256];

    for (i = 0; i < NUM_GFX; i++) {
        sprintf(buf, "grt%d.rle", i+1);
        gfx[i] = fload(buf);
        if (!gfx[i])
            BASE_Abort("Load grt%d.rle", i+1);
        //printf("Loaded %s, ", buf);
    }
    // Shuffle el orden de los letreros
    {
        int i, j, k;

        for (i = 0; i < NUM_SHUFFLES; i++) {
            j = RND_GetNum() % NUM_GFX;
            k = RND_GetNum() % NUM_GFX;
            if (j != k) {
                byte *tmp;
                tmp = gfx[j];
                gfx[j] = gfx[k];
                gfx[k] = tmp;
            }
        }
    }
    //puts("");
    for (i = 0; i < NUM_GFX; i++) {
        //printf("Logo %d is now 0x%X, ", i, gfx[i]);
    }
    //puts("");

    endlogo = fload("endlogo.rle");
    if (!endlogo)
        BASE_Abort("Load endlogo.rle");


    while (!DVTInfo->semaphores[4]);
    DVTInfo->semaphores[4]--;


    VGA_PutColor(0, 0, 0, 0);
    VGA_SetBorder(0, 0, 0);
    VGA_PutColor(255, 63, 63, 63);

    VBL_VSync(0);
    time = 0;
    while (!LLK_SpacePressed) {
        RLE_Draw((byte *)0xA0000, gfx[mode]);
        delta = VBL_VSync(1);

        if (mode & 1) {
            VGA_PutColor(255, 0, 0, 0);
            VGA_PutColor(0, 63, 63, 63);
            VGA_SetBorder(63, 63, 63);
        } else {
            VGA_PutColor(0, 0, 0, 0);
            VGA_SetBorder(0, 0, 0);
            VGA_PutColor(255, 63, 63, 63);
        }

        time += delta;
        if (DVTInfo->semaphores[4]) {
            //printf("Mode era %d, ", mode);
            DVTInfo->semaphores[4]--;
            time = 0;
            mode++;
            if (mode == NUM_GFX)
                mode = 0;
            //printf("Ahora es %d\n", mode);
        }
        if (DVTInfo->semaphores[6]) {
            DVTInfo->semaphores[6]--;
            break;
        }
    }
    //puts("");

    RLE_Draw((byte *)0xA0000, endlogo);
    time = 0;
    for (;;) {
        time += VBL_VSync(1);
        if (time > 70)
            break;
    }

    VGA_GetPalette(VBL_Palette, 0, 256);
    VBL_DestPal = NULL;
    VBL_DestRed = 0;
    VBL_DestGreen = 0;
    VBL_DestBlue = 0;
    VBL_FadeMode = VBL_FADEFAST;
    VBL_FadeStartColor = 0;
    VBL_FadeNColors = 256;
    VBL_FadePos = 1;
    VBL_FadeSpeed = 1;

    while (VBL_FadePos);

    for (i = 0; i < NUM_GFX; i++) {
        free(gfx[i]);
    }
}
