{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{$M 2048,0,655360}

{ This UNIT was originally written by Pasi Kettunen }
{ ripped from Kimmo Fredriksson's L3D }
{ modified by Cazz, joystick procs removed }

Unit keyboard;


(****************************************************************************)
				 Interface
(****************************************************************************)

VAR	KeyHitC  :Boolean;

	Key      :array[0..127] of Boolean;

	SaveExit :Pointer;

(****************************************************************************)

Procedure InitKey;	   { set the new keyboard interrupt }
Procedure DisabKey;	   { restore normal interrupt }

(****************************************************************************)
				Implementation
(****************************************************************************)

uses    misc;

Var	Int9H   	:Pointer Absolute $0000:$0024;
	SaveInt 	:Pointer;

(****************************************************************************)

Procedure KeyInt; Assembler;
Asm
        PUSH	AX
        PUSH	BX
        PUSH	CX
        PUSH	DS
        MOV	AX,SEG KEY
        MOV	BX,OFFSET KEY
        MOV	DS,AX
        IN	AL,60H
        MOV	CL,AL
        AND	CX,7FH
        ADD	BX,CX
        NOT	AL
        AND	AL,80H
        MOV	[BX],AL
        MOV	KEYHITC,AL
        IN	AL,61H
        OR	AL,80H
        OUT	61H,AL
        AND	AL,7FH
        OUT	61H,AL
        MOV	AL,20H
        OUT	20H,AL
        POP	DS
        POP	CX
        POP	BX
        POP	AX
        IRET
End;

Procedure InitKey;
Begin
  keybactive:=true;
  FillChar(Key,SizeOf(Key),0);
  KeyHitC:=FALSE;
  Int9H:=@KeyInt
End;

Procedure DisabKey;
Begin
  keybactive:=false;
  Int9H:=SaveInt
End;

Procedure SafeExit; Far;
Begin
  ExitProc:=SaveExit;
  DisabKey
End;

(****************************************************************************)
(*                              INITIALIZATION                              *)
(****************************************************************************)


Begin
  FillChar(Key,SizeOf(Key),0);
  KeyHitC:=FALSE;
  SaveInt:=Int9H;
  SaveExit:=ExitProc;
  ExitProc:=@SafeExit;
End.
