;------------------------------------------------------------------------------
;     Relleno de tringulos en Phong (Envmap) + Textura + Bump Map
;                              15/16 bits
;                           nt/*INCOGNITA*
;------------------------------------------------------------------------------

.386p

AVOID_HOLES =   2               ; Para evitar que la interpolacin se salga
                                ; del intervalo debido a problemas de sub-
                                ; pixel. Debe ser como mnimo 1 para evitar
                                ; divisiones por 0

LOCALS

_DATA SEGMENT PAGE PUBLIC 'DATA'

EXTRN C virtual:dword
EXTRN C graphics_system:dword

INCLUDE vertex.inc

XR equ [graphics_system]
YR equ [graphics_system+4]
YS equ [graphics_system+8]

ALIGN 32

vr1     dd      ?               ; Punteros a los 3 vrtices
vr2     dd      ?
vr3     dd      ?

cur_x1  dd      ?
cur_x2  dd      ?
add_x1  dd      ?
add_x2  dd      ?
add_cte_u dd    ?
cur_u   dd      ?
add_u   dd      ?
add_cte_v dd    ?
cur_v   dd      ?
add_v   dd      ?
add_cte_u2 dd   ?
cur_u2   dd     ?
add_u2   dd     ?
add_cte_v2 dd   ?
cur_v2   dd     ?
add_v2   dd     ?
pscr    dd      ?               ; Direccin al frame_buffer
cur_h   dd      ?
map     dd      ?
add_cte_uv dd   ?

pack_add_uv dd  ?
pack_add_uv2 dd ?
pack_cur_uv  dd ?
pack_cur_uv2 dd ?

altura  dd      0               ; Y3-Y1
h12     dd      0
h23     dd      0
max_long dd     ?
xb      dd      ?
ub      dd      ?
vb      dd      ?
u2b      dd      ?
v2b      dd      ?
temp    dd      ?

_1      dd      1.0


_DATA ENDS

;       Trazador de lneas horizontales

HOR MACRO
        local @@inner,@@vloop,@@smf1,@@smf2,@@smf3,@@done_h,@@c1,@@c2

        mov ecx,[add_cte_v]
        sal ecx,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ecx,edx
        mov [pack_add_uv],ecx

        mov ecx,[add_cte_v2]
        sal ecx,16
        mov edx,[add_cte_u2]
        and edx,0ffffh
        or ecx,edx
        mov [pack_add_uv2],ecx

; Cdigo-Automodificable

        mov ebx,OFFSET @@smf1+2;
        mov ecx,[pack_add_uv2]
        mov dword ptr ds:[ebx],ecx
        mov ebx,OFFSET @@smf2+2
        mov edx,[pack_add_uv]
        mov dword ptr ds:[ebx],edx

@@vloop:

;   Clipping en Y

        cmp [cur_h],0
        jl @@done_h
        mov esi,YR
        cmp [cur_h],esi
        jge abs_fuera

        mov edi,[cur_x1]
        mov ebp,[cur_x2]

        sar edi,16
        mov edx,[cur_v]
        sar ebp,16
        mov ebx,[cur_u]

        sal edx,8               ; Cur_v
        and edx,0ffff0000h
        sar ebx,8               ; Cur_u
        and ebx,00000ffffh

        or edx,ebx

        mov ebx,[cur_v2]
        mov ecx,[cur_u2]

        sal ebx,8               ; Cur_v2
        mov [pack_cur_uv],edx

        sar ecx,8               ; Cur_u2
        and ebx,0ffff0000h

        and ecx,00000ffffh
        or ebx,ecx

        mov [pack_cur_uv2],ebx

;   Clipping en X

        cmp edi,XR
        jge @@done_h
        test ebp,ebp
        js @@done_h

        mov eax,XR      ; if(cur_x >= Xresolution) cur_x= Xresolution;
        dec eax
        sub eax,ebp
        sbb esi,esi
        and esi,eax
        add ebp,esi

        mov edx,[pack_cur_uv]
        mov ecx,[pack_cur_uv2]
@@c1:   cmp edi,0
        jge @@c2
        add edx,[pack_add_uv]
        add ecx,[pack_add_uv2]
        inc edi
        jmp @@c1

@@c2:   mov [pack_cur_uv],edx
        mov [pack_cur_uv2],ecx

        sub ebp,edi             ; Longitud de la linea horizontal
        js @@done_h
        add edi,edi
        add edi,[pscr]          ; Edi -> destino
        inc ebp                 ; Para evitar agujeros negros
        mov esi,[map]           ; Esi -> textura
        add ebp,ebp

; Cdigo-Automodificable
        add edi,ebp
        neg ebp
        mov eax,OFFSET @@smf3+3;
        mov dword ptr ds:[eax],edi

        xor eax,eax
        xor ecx,ecx
        xor edx,edx
        xor ebx,ebx
        mov cl,byte ptr [pack_cur_uv+1]
        mov dh,byte ptr [pack_cur_uv2+3]

;--------------------------------INNER LOOP------------------------------------

@@inner:mov edi,[pack_cur_uv2]                  ;1
        mov ch,byte ptr [pack_cur_uv+3]         ;0
        mov dl,byte ptr [pack_cur_uv2+1]        ;1
@@smf1: add edi,11223344h                       ;0      [pack_add_uv2]
        add dx,[esi+2*ecx+65536*3+256*4]        ;2+1
        mov [pack_cur_uv2],edi                  ;0 + BC
        mov ax,[esi+2*ecx]                      ;1+1
        mov edi,[pack_cur_uv]                   ;0 + BC
        mov bl,[esi+edx+65536*2]                ;1
@@smf2: add edi,11223344h                       ;0      [pack_add_uv]
        mov dh,byte ptr [pack_cur_uv2+3]        ;1
        mov [pack_cur_uv],edi                   ;0 + BC
        mov cx,[esi+4*ebx+65536*3]              ;1+1
        add eax,ecx                             ;1
        shr eax,1                               ;1
@@smf3: mov [ebp+11223344],ax                   ;1+1
        mov cl,byte ptr [pack_cur_uv+1]         ;0 + BC
        add ebp,2                               ;1
        jnz @@inner                             ;0      -> 16 ciclos/pixel +
                                                ;           4 Bank Conflict
;------------------------------------------------------------------------------
@@done_h:
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov edi,[add_u2]
        mov ecx,[add_v2]
        add [cur_u2],edi
        add [cur_v2],ecx
        mov ecx,YS
        add [pscr],ecx
        inc [cur_h]
        dec [altura]
        jnz @@vloop

ENDM


_TEXT SEGMENT PAGE PUBLIC 'CODE'
        assume cs:_text, ds:_data

        PUBLIC DRAW_PTEXTURE_POLY_

; void draw_ptexture_poly(VERTEX *, BYTE *);
; #pragma aux draw_ptexture_poly parm [esi][eax];

;       Esta es la rutina principal. Detecta si es necesario hacer clipping
;       del tringulo

DRAW_PTEXTURE_POLY_ PROC

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

;       Los trangulos que entren completamente en la pantalla (0<=x<XS) ^
;       (0<=y<YS) son trazados por una rutina que no hace clipping
;       Las comparaciones son sin signo, luego estoy comparando simultaneamente
;       el lmite superior e inferior.

        mov ecx,XR
        mov ebx,YR
        cmp dword ptr [esi+vertex.x],ecx
        jae clip
        cmp dword ptr [edi+vertex.x],ecx
        jae clip
        cmp dword ptr [ebp+vertex.x],ecx
        jae clip

        cmp dword ptr [esi+vertex.y],ebx
        jae clip
        cmp dword ptr [edi+vertex.y],ebx
        jae clip
        cmp dword ptr [ebp+vertex.y],ebx
        jae clip

        jmp no_clip

DRAW_PTEXTURE_POLY_ ENDP

;------------------------------------------------------------------------------
;                 Trazador de tringulos con CLIPPING
;------------------------------------------------------------------------------

DRAW_CLIP_POLY PROC

;       Esta primera parte, por si se llama a la rutina independientemente

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

clip:   mov [map],eax

;------------------------------------------------------------------------------
;       Clipping en X Sencillo : Aceptar/Rechazar
;------------------------------------------------------------------------------
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        cmp eax,ebx
        jge @@CX1
        mov ecx,ebx
        mov ebx,eax
        mov eax,ecx
@@CX1:  cmp eax,[ebp+vertex.x]
        jge @@CX2
        mov eax,[ebp+vertex.x]           ; Eax = X mayor
@@CX2:  cmp eax,0
        jl @@fuera
        cmp ebx,[ebp+vertex.x]
        jle @@CX3
        mov ebx,[ebp+vertex.x]           ; Ebx = X Menor
@@CX3:  cmp ebx,XR
        jg @@fuera
;------------------------------------------------------------------------------

;       Ordenar y1<y2<y3

        mov eax,[esi+vertex.y]
        cmp eax,[edi+vertex.y]
        jl @@sort1
        mov eax,esi
        mov esi,edi
        mov edi,eax
@@sort1:mov eax,[esi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort2
        mov eax,ebp
        mov ebp,esi
        mov esi,eax
@@sort2:mov eax,[edi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort3
        mov eax,edi
        mov edi,ebp
        mov ebp,eax
@@sort3:

;------------------------------------------------------------------------------
;       Clipping en Y Sencillo : Aceptar/Rechazar
;------------------------------------------------------------------------------
        mov eax,YR
        cmp [esi+vertex.y],eax
        jge @@fuera
        cmp [ebp+vertex.y],0
        jl @@fuera
;------------------------------------------------------------------------------

        mov [vr1],esi                   ; Guardar por si modificamos
        mov [vr2],edi
        mov [vr3],ebp

        mov eax,[esi+vertex.y]
        mov [cur_h],eax

        imul eax,YS
        add eax,[virtual]
        mov [pscr],eax

        mov eax,[ebp+vertex.y]
        sub eax,[esi+vertex.y]          ; Y3-Y1
        jnz @@n_neg
        inc eax
@@n_neg:mov [altura],eax

        mov eax,[edi+vertex.y]
        sub eax,[esi+vertex.y]          ; Y2-Y1
        jz @@tri1                       ; Lado largo arriba
        mov [h12],eax

        mov eax,[altura]
        sub eax,[h12]                   ; Y3-Y2
        jz @@tri2                       ; Lado largo arriba
        mov [h23],eax

        fild [h12]
        fild [altura]
        fdiv                            ; h12/h13


        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        mov ecx,[esi+vertex.v]
        sal ebx,16
        add eax,32768
        sal ecx,16
        mov [cur_u],ebx
        mov ebx,[esi+vertex.u2]
        mov [cur_v],ecx
        sal ebx,16
        mov ecx,[esi+vertex.v2]
        mov [cur_x1],eax
        mov [cur_x2],eax
        sal ecx,16
        mov [cur_u2],ebx
        mov [cur_v2],ecx


; Calculamos atributos del punto 4

; - Coordenada U

        mov edx,[ebp+vertex.u]
        sub edx,[esi+vertex.u]
        mov [temp],edx
        fild [temp]
        fmul st,st(1)

; - Coordenada V

        mov edx,[ebp+vertex.v]
        sub edx,[esi+vertex.v]
        mov [temp],edx
        fistp [ub]
        fild [temp]
        fmul st,st(1)

; - Coordenada U2

        mov edx,[ebp+vertex.u2]
        sub edx,[esi+vertex.u2]
        mov [temp],edx
        fistp [vb]
        fild [temp]
        fmul st,st(1)

; - Coordenada V2

        mov edx,[ebp+vertex.v2]
        sub edx,[esi+vertex.v2]
        mov [temp],edx
        fistp [u2b]
        fild [temp]
        fmul st,st(1)

; - Coordenada X

        mov edx,[ebp+vertex.x]
        sub edx,[esi+vertex.x]
        mov [temp],edx
        fistp [v2b]
        fild [temp]
        fmul

        mov edx,[esi+vertex.u]
        add [ub],edx
        mov edx,[esi+vertex.v]
        add [vb],edx
        mov edx,[esi+vertex.u2]
        add [u2b],edx
        mov edx,[esi+vertex.v2]
        add [v2b],edx

        fistp [xb]
        mov edx,[xb]
        add edx,[esi+vertex.x]

        cmp edx,[edi+vertex.x]
        mov [xb],edx
        jl @@tri3
        je @@fuera              ; x4=x2 Conviene pintarlo? :-???

;------------------------------------------------------------------------------
;                      Lado largo a la derecha 
;                     
;
;                               P1
;                               / \
;                             /     \
;                           /         \
;                         /             \
;                      P2 ----            \P4
;                             ----          \
;                                 ----        \
;                                     ----      \
;                                         ----   \
;                                             ----P3
;------------------------------------------------------------------------------

        fld [_1]
        fild [h12]
        fdiv                            ; 1/h12

        mov eax,[xb]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax

        mov eax,[ebp+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        sar edx,31
        idiv [altura]
        adc eax,1

        mov [add_x2],eax

        fld [_1]
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[ub]                    ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[vb]                    ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[u2b]                   ; Add_cte_u2
        sub eax,[edi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[v2b]                   ; Add_cte_v2
        sub eax,[edi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [h12]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;--

        fld [_1]
        fild [h23]
        fdiv                            ; 1/h23

        mov eax,[h12]
        mov [altura],eax

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR

; Esi,Edi y Ebp han sido mofificados!!!!!!!

        mov edi,[vr2]
        mov ebp,[vr3]

        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]
        sub eax,[edi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]
        sub eax,[edi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]
        sub eax,[edi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]
        sub eax,[edi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul

        mov eax,[h23]
        mov [altura],eax
        fistp [add_v2]
        HOR

        jmp @@fuera


@@tri3:
;------------------------------------------------------------------------------
;                     Lado largo a la izquierda
;                     
;
;                               P1
;                              / \
;                             /   \
;                            /     \
;                        P4 /     --P2
;                          /   ---
;                         / ---
;                     P3 /--
;
;------------------------------------------------------------------------------

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

        mov eax,[edi+vertex.x]
        sub eax,[xb]
        add eax,AVOID_HOLES
        mov [max_long],eax

        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        sar edx,31
        idiv [h12]
        adc eax,1

        mov [add_x2],eax

        fld [_1]
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[ub]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[vb]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_cte_u2
        sub eax,[u2b]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_cte_v2
        sub eax,[v2b]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]


;   La tercera divisin tambin en paralelo, pues no leemos el resultado hasta
;   el siguiente loop

        mov eax,[ebp+vertex.x]
        fild [h23]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fdivr                   ;*

        mov eax,[h12]
        mov [altura],eax

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR

; Esi,Edi y Ebp han sido mofificados

        fistp [add_x2]

        mov eax,[h23]
        mov [altura],eax

        HOR

@@fuera:
        popad
        ret

abs_fuera:
        fistp [temp]
        popad
        ret

;------------------------------------------------------------------------------
;                         Lado largo arriba
;                        
;                      P1                      P2
;                          -----------------
;                          -               -
;                           -             -
;                            -           -
;                             -         -
;                              -       -
;                               -     -
;                                -   -
;                                  -
;                                  P3
;----------------------------------------------------------------------------

@@tri1:

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P1X y P2X

        mov eax,[esi+vertex.x]
        cmp eax,[edi+vertex.x]
        jl @@no_problem
        mov eax,edi
        mov edi,esi
        mov esi,eax
@@no_problem:
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        sal eax,16
        sal ebx,16
        add eax,32768
        add ebx,32768
        mov [cur_x1],eax
        mov [cur_x2],ebx
        mov eax,[esi+vertex.u]
        mov ebx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        mov [cur_u],eax
        mov [cur_v],ebx
        mov eax,[esi+vertex.u2]
        mov ebx,[esi+vertex.v2]
        sal eax,16
        sal ebx,16
        mov [cur_u2],eax
        mov [cur_v2],ebx


        fld [_1]
        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long


; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[esi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[esi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_cte_u2
        sub eax,[esi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_cte_v2
        sub eax,[esi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR

        jmp @@fuera


;------------------------------------------------------------------------------
;                         Lado largo abajo
;                        
;                                  P1
;                                  -
;                                -   -
;                               -     -
;                              -       -
;                             -         -
;                            -           -
;                           -             -
;                          -               -
;                          -----------------
;                         P2               P3
;----------------------------------------------------------------------------
@@tri2:

; --- Lado largo abajo ---

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura


; Ordenacin de P2X y P3X

        mov eax,[edi+vertex.x]
        cmp eax,[ebp+vertex.x]
        jl @@no_problem2
        mov eax,ebp
        mov ebp,edi
        mov edi,eax
@@no_problem2:
        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        sal ebx,16
        add eax,32768
        mov [cur_x1],eax
        mov [cur_x2],eax
        mov [cur_u],ebx
        mov eax,[esi+vertex.v]
        mov ebx,[esi+vertex.u2]
        mov ecx,[esi+vertex.v2]
        sal eax,16
        sal ebx,16
        sal ecx,16
        mov [cur_v],eax
        mov [cur_u2],ebx
        mov [cur_v2],ecx

        fld [_1]
        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long


; Clculos con [max_long]

        mov eax,[ebp+vertex.u]          ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_cte_u2
        sub eax,[edi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_cte_v2
        sub eax,[edi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]          ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]          ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR

        jmp @@fuera



DRAW_CLIP_POLY ENDP


;------------------------------------------------------------------------------
;                 Trazador de tringulos sin CLIPPING
;------------------------------------------------------------------------------

;       Trazador de lneas horizontales sin clipping

HOR_NCLIP MACRO
        local @@inner,@@vloop,@@smf1,@@smf2,@@smf3

        mov ecx,[add_cte_v]
        sal ecx,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ecx,edx
        mov [pack_add_uv],ecx

        mov ecx,[add_cte_v2]
        sal ecx,16
        mov edx,[add_cte_u2]
        and edx,0ffffh
        or ecx,edx
        mov [pack_add_uv2],ecx

; Cdigo-Automodificable

        mov ebx,OFFSET @@smf1+2;
        mov ecx,[pack_add_uv2]
        mov dword ptr ds:[ebx],ecx
        mov ebx,OFFSET @@smf2+2
        mov edx,[pack_add_uv]
        mov dword ptr ds:[ebx],edx

@@vloop:

        mov edi,[cur_x1]
        mov ebp,[cur_x2]

        sar edi,16
        mov edx,[cur_v]
        sar ebp,16
        mov ebx,[cur_u]

        sal edx,8               ; Cur_v
        sub ebp,edi             ; Longitud de la linea horizontal
        sar ebx,8               ; Cur_u
        add edi,edi
        add edi,[pscr]          ; Edi -> destino
        inc ebp                 ; Para evitar agujeros negros
        mov esi,[map]           ; Esi -> textura
        add ebp,ebp

; Cdigo-Automodificable
        add edi,ebp
        neg ebp
        mov eax,OFFSET @@smf3+3;
        mov ecx,edi
        mov dword ptr ds:[eax],edi
;

        and edx,0ffff0000h
        and ebx,00000ffffh

        or edx,ebx

        mov ebx,[cur_v2]
        mov ecx,[cur_u2]

        sal ebx,8               ; Cur_v2
        mov [pack_cur_uv],edx

        sar ecx,8               ; Cur_u2
        and ebx,0ffff0000h

        and ecx,00000ffffh
        or ebx,ecx
        xor eax,eax
        mov [pack_cur_uv2],ebx
        xor ecx,ecx
        xor edx,edx
        xor ebx,ebx
        mov cl,byte ptr [pack_cur_uv+1]
        mov dh,byte ptr [pack_cur_uv2+3]

;--------------------------------INNER LOOP------------------------------------

@@inner:mov edi,[pack_cur_uv2]                  ;1
        mov ch,byte ptr [pack_cur_uv+3]         ;0
        mov dl,byte ptr [pack_cur_uv2+1]        ;1
@@smf1: add edi,11223344h                       ;0      [pack_add_uv2]
        add dx,[esi+2*ecx+65536*3+256*4]        ;2+1
        mov [pack_cur_uv2],edi                  ;0 + BC
        mov ax,[esi+2*ecx]                      ;1+1
        mov edi,[pack_cur_uv]                   ;0 + BC
        mov bl,[esi+edx+65536*2]                ;1
@@smf2: add edi,11223344h                       ;0      [pack_add_uv]
        mov dh,byte ptr [pack_cur_uv2+3]        ;1
        mov [pack_cur_uv],edi                   ;0 + BC
        mov cx,[esi+4*ebx+65536*3]              ;1+1
        add eax,ecx                             ;1
        shr eax,1                               ;1
@@smf3: mov [ebp+11223344],ax                   ;1+1
        mov cl,byte ptr [pack_cur_uv+1]         ;0 + BC
        add ebp,2                               ;1
        jnz @@inner                             ;0      -> 16 ciclos/pixel +
                                                ;           4 Bank Conflict
;------------------------------------------------------------------------------

        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov edi,[add_u2]
        mov ecx,[add_v2]
        add [cur_u2],edi
        add [cur_v2],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [altura]
        jnz @@vloop


ENDM

DRAW_NCLIP_POLY PROC

;       Esta primera parte, por si se llama a la rutina independientemente

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

no_clip: mov [map],eax

;       Ordenar y1<y2<y3

        mov eax,[esi+vertex.y]
        cmp eax,[edi+vertex.y]
        jl @@sort1
        mov eax,esi
        mov esi,edi
        mov edi,eax
@@sort1:mov eax,[esi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort2
        mov eax,ebp
        mov ebp,esi
        mov esi,eax
@@sort2:mov eax,[edi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort3
        mov eax,edi
        mov edi,ebp
        mov ebp,eax
@@sort3:

        mov [vr1],esi                   ; Guardar por si modificamos
        mov [vr2],edi
        mov [vr3],ebp

        mov eax,[esi+vertex.y]
        imul eax,YS
        add eax,[virtual]
        mov [pscr],eax

        mov eax,[ebp+vertex.y]
        sub eax,[esi+vertex.y]          ; Y3-Y1
        jnz @@n_neg
        inc eax
@@n_neg:mov [altura],eax

        mov eax,[edi+vertex.y]
        sub eax,[esi+vertex.y]          ; Y2-Y1
        jz @@tri1                       ; Lado largo arriba
        mov [h12],eax

        mov eax,[altura]
        sub eax,[h12]                   ; Y3-Y2
        jz @@tri2                       ; Lado largo arriba
        mov [h23],eax

        fild [h12]
        fild [altura]
        fdiv                            ; h12/h13


        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        mov ecx,[esi+vertex.v]
        sal ebx,16
        add eax,32768
        sal ecx,16
        mov [cur_u],ebx
        mov ebx,[esi+vertex.u2]
        mov [cur_v],ecx
        sal ebx,16
        mov ecx,[esi+vertex.v2]
        mov [cur_x1],eax
        mov [cur_x2],eax
        sal ecx,16
        mov [cur_u2],ebx
        mov [cur_v2],ecx


; Calculamos atributos del punto 4

; - Coordenada U

        mov edx,[ebp+vertex.u]
        sub edx,[esi+vertex.u]
        mov [temp],edx
        fild [temp]
        fmul st,st(1)

; - Coordenada V

        mov edx,[ebp+vertex.v]
        sub edx,[esi+vertex.v]
        mov [temp],edx
        fistp [ub]
        fild [temp]
        fmul st,st(1)

; - Coordenada U2

        mov edx,[ebp+vertex.u2]
        sub edx,[esi+vertex.u2]
        mov [temp],edx
        fistp [vb]
        fild [temp]
        fmul st,st(1)

; - Coordenada V2

        mov edx,[ebp+vertex.v2]
        sub edx,[esi+vertex.v2]
        mov [temp],edx
        fistp [u2b]
        fild [temp]
        fmul st,st(1)

; - Coordenada X

        mov edx,[ebp+vertex.x]
        sub edx,[esi+vertex.x]
        mov [temp],edx
        fistp [v2b]
        fild [temp]
        fmul

        mov edx,[esi+vertex.u]
        add [ub],edx
        mov edx,[esi+vertex.v]
        add [vb],edx
        mov edx,[esi+vertex.u2]
        add [u2b],edx
        mov edx,[esi+vertex.v2]
        add [v2b],edx

        fistp [xb]
        mov edx,[xb]
        add edx,[esi+vertex.x]

        cmp edx,[edi+vertex.x]
        mov [xb],edx
        jl @@tri3
        je @@fuera              ; x4=x2 Conviene pintarlo? :-???

;------------------------------------------------------------------------------
;                      Lado largo a la derecha 
;                     
;
;                               P1
;                               / \
;                             /     \
;                           /         \
;                         /             \
;                      P2 ----            \P4
;                             ----          \
;                                 ----        \
;                                     ----      \
;                                         ----   \
;                                             ----P3
;------------------------------------------------------------------------------

        fld [_1]
        fild [h12]
        fdiv                            ; 1/h12

        mov eax,[xb]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax

        mov eax,[ebp+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        sar edx,31
        idiv [altura]
        adc eax,1

        mov [add_x2],eax

        fld [_1]
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[ub]                    ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[vb]                    ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[u2b]                   ; Add_cte_u2
        sub eax,[edi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[v2b]                   ; Add_cte_v2
        sub eax,[edi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [h12]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;--

        fld [_1]
        fild [h23]
        fdiv                            ; 1/h23

        mov eax,[h12]
        mov [altura],eax

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR_NCLIP

; Esi,Edi y Ebp han sido mofificados!!!!!!!

        mov edi,[vr2]
        mov ebp,[vr3]

        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]
        sub eax,[edi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]
        sub eax,[edi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]
        sub eax,[edi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]
        sub eax,[edi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul

        mov eax,[h23]
        mov [altura],eax
        fistp [add_v2]
        HOR_NCLIP

        jmp @@fuera


@@tri3:
;------------------------------------------------------------------------------
;                     Lado largo a la izquierda
;                     
;
;                               P1
;                              / \
;                             /   \
;                            /     \
;                        P4 /     --P2
;                          /   ---
;                         / ---
;                     P3 /--
;
;------------------------------------------------------------------------------

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

        mov eax,[edi+vertex.x]
        sub eax,[xb]
        add eax,AVOID_HOLES
        mov [max_long],eax

        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        sar edx,31
        idiv [h12]
        adc eax,1

        mov [add_x2],eax

        fld [_1]
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[ub]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[vb]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_cte_u2
        sub eax,[u2b]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_cte_v2
        sub eax,[v2b]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]


;   La tercera divisin tambin en paralelo, pues no leemos el resultado hasta
;   el siguiente loop

        mov eax,[ebp+vertex.x]
        fild [h23]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fdivr                   ;*

        mov eax,[h12]
        mov [altura],eax

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR_NCLIP

; Esi,Edi y Ebp han sido mofificados

        fistp [add_x2]

        mov eax,[h23]
        mov [altura],eax

        HOR_NCLIP

@@fuera:
        popad
        ret

;------------------------------------------------------------------------------
;                         Lado largo arriba
;                        
;                      P1                      P2
;                          -----------------
;                          -               -
;                           -             -
;                            -           -
;                             -         -
;                              -       -
;                               -     -
;                                -   -
;                                  -
;                                  P3
;----------------------------------------------------------------------------

@@tri1:

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P1X y P2X

        mov eax,[esi+vertex.x]
        cmp eax,[edi+vertex.x]
        jl @@no_problem
        mov eax,edi
        mov edi,esi
        mov esi,eax
@@no_problem:
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        sal eax,16
        sal ebx,16
        add eax,32768
        add ebx,32768
        mov [cur_x1],eax
        mov [cur_x2],ebx
        mov eax,[esi+vertex.u]
        mov ebx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        mov [cur_u],eax
        mov [cur_v],ebx
        mov eax,[esi+vertex.u2]
        mov ebx,[esi+vertex.v2]
        sal eax,16
        sal ebx,16
        mov [cur_u2],eax
        mov [cur_v2],ebx


        fld [_1]
        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long


; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[esi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[esi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]         ; Add_cte_u2
        sub eax,[esi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]         ; Add_cte_v2
        sub eax,[esi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR_NCLIP

        jmp @@fuera


;------------------------------------------------------------------------------
;                         Lado largo abajo
;                        
;                                  P1
;                                  -
;                                -   -
;                               -     -
;                              -       -
;                             -         -
;                            -           -
;                           -             -
;                          -               -
;                          -----------------
;                         P2               P3
;----------------------------------------------------------------------------
@@tri2:

; --- Lado largo abajo ---

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura


; Ordenacin de P2X y P3X

        mov eax,[edi+vertex.x]
        cmp eax,[ebp+vertex.x]
        jl @@no_problem2
        mov eax,ebp
        mov ebp,edi
        mov edi,eax
@@no_problem2:
        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        sal ebx,16
        add eax,32768
        mov [cur_x1],eax
        mov [cur_x2],eax
        mov [cur_u],ebx
        mov eax,[esi+vertex.v]
        mov ebx,[esi+vertex.u2]
        mov ecx,[esi+vertex.v2]
        sal eax,16
        sal ebx,16
        sal ecx,16
        mov [cur_v],eax
        mov [cur_u2],ebx
        mov [cur_v2],ecx

        fld [_1]
        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long


; Clculos con [max_long]

        mov eax,[ebp+vertex.u]          ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u2]         ; Add_cte_u2
        sub eax,[edi+vertex.u2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v2]         ; Add_cte_v2
        sub eax,[edi+vertex.v2]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u2]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u2]          ; Add_u2
        sub eax,[esi+vertex.u2]
        sal eax,16
        mov [temp],eax
        fistp [add_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v2]          ; Add_v2
        sub eax,[esi+vertex.v2]
        sal eax,16
        mov [temp],eax
        fistp [add_u2]
        fild [temp]
        fmul
        fistp [add_v2]

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

        HOR_NCLIP

        jmp @@fuera

DRAW_NCLIP_POLY ENDP

_TEXT ENDS

	END
