#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <types.h>
#include <graphs.h>
#include <string.h>
#include <keyb_hnd.h>
#include <font.h>
#include <icp.h>

#include "..\seal\music.h"

#define DEGREE 4            // Grado del polinomio-1
#define POINTS 10           // Puntos de control
#define N POINTS-1
#define RESOLUTION 30       // Puntos a interpolar (horizontal y verticalmente)
#define DIST 1500
#define DELTA 50           // Posiciones intermedias en interpolacin de ruta

#pragma pack(1)
typedef struct {
        SDWORD x,y;
        SDWORD u,v;
        DWORD color;
}VERTEX;
#pragma pack()

typedef struct {
     float x,y,z;
}DOT;

typedef struct {
     DWORD x,y;
}PIX;

typedef struct {
     DWORD a,b,c;
}TRI;

typedef struct {
    BYTE u,v;
}TEXT;

typedef struct {
    BYTE alpha,red,green,blue;
}ORGB;

DOT control[POINTS][POINTS];
DOT mesh[RESOLUTION][RESOLUTION];
PIX pix[RESOLUTION*RESOLUTION];
TEXT text[RESOLUTION*RESOLUTION];
static TRI tri[(RESOLUTION-1)*(RESOLUTION-1)*2];
float knots[N+DEGREE+1];
float blend[RESOLUTION][POINTS];
DWORD *pseudo_code;
DWORD memory;

extern BYTE *virtual;
extern BOOLEAN icg_boss;

BYTE *credits;
BYTE *ent;
BYTE *ent2;
BYTE *ent3;

DOT *path_up,*path_down;
DWORD no_frames;

void move_control(DWORD);
void do_tri(void);
void do_control(void);
void do_code(void);
void calc_knots(void);
void calc_blend(void);
void assign_texture(void);
void put_pixel(float, float, float, DWORD);
DOT *do_path(BYTE *);
float get_blend(DWORD k, DWORD t, float u);
void render(void);
void read_control(DWORD);
void build_surface(void);
void project(void);
void fatal_error(const BYTE *, ...);

static BYTE fps_info[20];
static DWORD cur_frame=POINTS;
static DWORD last_frame,temp_frame;
static float last_time,temp_time,last_ani,ani,fps=0;

BYTE read_tga_map(BYTE *,BYTE *,BYTE *);
void convert_pal(BYTE *pal);

void draw_clip_line(int, int, int, int, unsigned char);
#pragma aux draw_clip_line parm [ecx][eax][esi][ebx][edx];

void draw_texture_poly15(VERTEX *, BYTE *);
#pragma aux draw_texture_poly15 parm [esi][eax];

void draw_texture_poly16(VERTEX *, BYTE *);
#pragma aux draw_texture_poly16 parm [esi][eax];

static void filter_pal(BYTE *pal) {

    DWORD i;
    WORD *wpal=(WORD *)pal;

    if(graphics_system.bbp==16)
        for(i=0;i<512;i++) *(wpal+i)&=63455;
    else if(graphics_system.bbp==15)
        for(i=0;i<512;i++) *(wpal+i)&=64479;
}


void show_blend16(BYTE *map, ORGB *pal, BYTE alpha) {


    DWORD i,j,base;
    WORD *wvirtual=(WORD *)virtual;
    BYTE color;
    WORD r,g,b;
    WORD fcolor;
    DWORD h=256,v=256;

    if(graphics_system.xresolution<h) h=graphics_system.xresolution;
    if(graphics_system.yresolution<v) v=graphics_system.yresolution;

    base=((graphics_system.yresolution-v)/2)*graphics_system.xresolution
         +(graphics_system.xresolution-h)/2;

    for(i=0;i<v;i++,base+=graphics_system.xresolution-h)
        for(j=0;j<h;j++,base++) {

        color=*(map+(i<<8)+j);
        if(!color) continue;

        r=((pal+color)->red*alpha)>>11;
        g=((pal+color)->green*alpha)>>10;
        b=((pal+color)->blue*alpha)>>11;

        fcolor=(b<<11)|(g<<5)|r;

        *(wvirtual+base)=((*(wvirtual+base)&63455)+fcolor&63455)>>1;
    }


}

void show_blend15(BYTE *map, ORGB *pal, BYTE alpha) {


    DWORD i,j,base;
    WORD *wvirtual=(WORD *)virtual;
    BYTE color;
    WORD r,g,b;
    WORD fcolor;
    DWORD h=256,v=256;

    if(graphics_system.xresolution<h) h=graphics_system.xresolution;
    if(graphics_system.yresolution<v) v=graphics_system.yresolution;

    base=((graphics_system.yresolution-v)/2)*graphics_system.xresolution
         +(graphics_system.xresolution-h)/2;

    for(i=0;i<v;i++,base+=graphics_system.xresolution-h)
        for(j=0;j<h;j++,base++) {

        color=*(map+(i<<8)+j);
        if(!color) continue;

        r=((pal+color)->red*alpha)>>11;
        g=((pal+color)->green*alpha)>>11;
        b=((pal+color)->blue*alpha)>>11;

        fcolor=(b<<10)|(g<<5)|r;

        *(wvirtual+base)=((*(wvirtual+base)&64479)+fcolor&64479)>>1;
    }


}

BOOLEAN up,down;
BYTE next;
BYTE alpha;
float stime;

void init_blanket(BYTE g1[20], BYTE g2[20], BYTE g3[20], BYTE g4[20],
                  DWORD xres, DWORD yres) {

    up=TRUE;
    down=FALSE;
    next=0;
    alpha=0;

    do_tri();
    do_control();
    calc_knots();
    calc_blend();
    do_code();
    assign_texture();
    path_up=do_path("ruta.nfo");
    path_down=do_path("ruta2.nfo");

    emulate_32=TRUE;
    virtual=lib_set_mode(xres,yres,16,GINFO);

    if(virtual==NULL)
        fatal_error("Can't init graphics mode");

    ent=malloc(256*256+256*4);
    if(ent==NULL)
        fatal_error("Not enough memory");

    ent2=malloc(256*256+256*4);
    if(ent2==NULL)
        fatal_error("Not enough memory");

    ent3=malloc(256*256+256*4);
    if(ent3==NULL)
        fatal_error("Not enough memory");

    if(read_tga_map(g2,ent,ent+256*256))
        fatal_error("Can't load tga");
    convert_pal(ent+256*256);

    if(read_tga_map(g3,ent2,ent2+256*256))
        fatal_error("Can't load tga");
    convert_pal(ent2+256*256);

    if(read_tga_map(g4,ent3,ent3+256*256))
        fatal_error("Can't load tga");
    convert_pal(ent3+256*256);

    emulate_32=FALSE;
    virtual=lib_set_mode(xres,yres,16,GLFB|GBANKS|GVIRTUAL);
    if(virtual==NULL)
        fatal_error("Can't init graphics mode");


    credits=malloc(256*256+256*4);
    if(credits==NULL)
        fatal_error("Not enough memory");

    if(read_tga_map(g1,credits,credits+256*256))
        fatal_error("Can't load tga");

    convert_pal(credits+256*256);
    filter_pal(credits+256*256);

    frames_dr=frames=0;
    last_ani=last_time=stime=lib_get_time();
    last_frame=0;
    ani=0.0;

}

#define PI 3.141592653589793238462643383279502884197169399375105820975

void frame_blanket(void) {

    float tf=lib_get_time();

    alpha=(BYTE)((-cos(((tf-stime)*PI)/18))*127+128);

    if(tf-stime>35.0) next=1;
    if(tf-stime>70.0) next=2;

    memset(virtual,0,graphics_system.image_size);

    read_control(cur_frame);
    if(cur_frame<no_frames-DELTA) cur_frame++;
    move_control(cur_frame);
    build_surface();
    project();
    render();

    if(next==0) {
        if(graphics_system.bbp==15)
            show_blend15(ent,(ORGB *)(ent+256*256),alpha);
        else
            show_blend16(ent,(ORGB *)(ent+256*256),alpha);
    }
    else if(next==1) {
        if(graphics_system.bbp==15)
            show_blend15(ent2,(ORGB *)(ent2+256*256),alpha);
        else
            show_blend16(ent2,(ORGB *)(ent2+256*256),alpha);
    }
    else if(next==2) {
        if(graphics_system.bbp==15)
            show_blend15(ent3,(ORGB *)(ent3+256*256),alpha);
        else
            show_blend16(ent3,(ORGB *)(ent3+256*256),alpha);
    }

    temp_frame=frames_dr;
    temp_time=lib_get_time();
    if (temp_time-last_time>0.25) {
        fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
        last_time=temp_time;
        last_frame=temp_frame;
    }
    if(K_F && icg_boss) {
        sprintf(fps_info,"Fps: %4.3f",fps);
        lib_write_string(fps_info,0,0,31,virtual);
    }

}

void end_blanket(void) {

    free(ent);
    free(ent2);
    free(ent3);
    free(credits);
    free(pseudo_code);
    free(path_up);
    free(path_down);

}

static void render(void) {

    DWORD i,x1,y1,x2,y2,x3,y3;
    VERTEX points[3];

    for(i=0;i<(RESOLUTION-1)*(RESOLUTION-1)*2;i++) {
        x1=pix[tri[i].a].x;
        y1=pix[tri[i].a].y;
        x2=pix[tri[i].b].x;
        y2=pix[tri[i].b].y;
        x3=pix[tri[i].c].x;
        y3=pix[tri[i].c].y;

        points[0].x=x1;
        points[1].x=x2;
        points[2].x=x3;
        points[0].y=y1;
        points[1].y=y2;
        points[2].y=y3;

        points[0].u=text[tri[i].a].u;
        points[0].v=text[tri[i].a].v;
        points[1].u=text[tri[i].b].u;
        points[1].v=text[tri[i].b].v;
        points[2].u=text[tri[i].c].u;
        points[2].v=text[tri[i].c].v;
        if(graphics_system.bbp==15)
            draw_texture_poly15(points,credits);
        else
            draw_texture_poly16(points,credits);

    }

}

void project(void) {

    DWORD i,j,t;
    float inv;

    for(i=t=0;i<RESOLUTION;i++) for(j=0;j<RESOLUTION;j++,t++) {
        inv=1/(mesh[i][j].z);
        pix[t].x=graphics_system.centerx+(SDWORD)mesh[i][j].x*
                 graphics_system.xratio*inv;
        pix[t].y=graphics_system.centery+(SDWORD)mesh[i][j].y*
                 graphics_system.yratio*inv;
        }
}

void build_surface(void) {

    SDWORD i,x,y,t,n,wcontrol;
    float *fix;
    static DOT *pcontrol=(DOT *)control;

    for(x=t=0;x<RESOLUTION;x++) for(y=0;y<RESOLUTION;y++) {
        n=*(pseudo_code+t++);
        mesh[x][y].x=mesh[x][y].y=mesh[x][y].z=0;
        for(i=0;i<n;i++) {
            wcontrol=*(pseudo_code+t++);
            fix=(float *)pseudo_code+t++;

            mesh[x][y].x+=(pcontrol+wcontrol)->x*(*fix);
            mesh[x][y].y+=(pcontrol+wcontrol)->y*(*fix);
            mesh[x][y].z+=(pcontrol+wcontrol)->z*(*fix);

            }
    }
}


void read_control(DWORD cur_frame) {

    SDWORD i,j,k;
    DOT up,down;
    float cn;

    for(i=0,j=cur_frame-POINTS;i<POINTS;i++,j++) {
        up.x=(path_up+j+i*(DELTA/POINTS))->x;
        up.y=(path_up+j+i*(DELTA/POINTS))->y;
        up.z=(path_up+j+i*(DELTA/POINTS))->z;
        down.x=(path_down+j+i*(DELTA/POINTS))->x;
        down.y=(path_down+j+i*(DELTA/POINTS))->y;
        down.z=(path_down+j+i*(DELTA/POINTS))->z;

        for(k=0,cn=0;k<POINTS;k++,cn+=(float)1/POINTS) {
            control[k][i].x=up.x*(1-cn)+ down.x*cn;
            control[k][i].y=up.y*(1-cn)+ down.y*cn;
            control[k][i].z=up.z*(1-cn)+ down.z*cn;
            }
        }
}

void calc_knots(void) {

    DWORD i;
    for(i=0;i<N+DEGREE+1;i++) {
        if(i<DEGREE) knots[i]=0;
        if(i>=DEGREE && i<=N) knots[i]=i-DEGREE+1;
        if(i>N) knots[i]=N-DEGREE+2;
    }

}

float get_blend(DWORD k, DWORD t, float u) {

    if(u>=N-DEGREE+2) u=N-DEGREE+2-.001;

    if(t!=1) {

        float lft,rgt,d;

        d=(knots[k+t-1]-knots[k]);
        if(!d) lft=0;
        else lft=(u-knots[k])/d;
        lft=lft*get_blend(k,t-1,u);

        d=(knots[k+t]-knots[k+1]);
        if(!d) rgt=0;
        else rgt=(knots[k+t]-u)/d;
        rgt=rgt*get_blend(k+1,t-1,u);

        return lft+rgt;
    }

    if(u>=knots[k] && u<knots[k+1]) return 1;

    return 0;

}

void do_control(void) {

    SDWORD i,j;
    for(i=0;i<POINTS;i++) for(j=0;j<POINTS;j++) {
        control[i][j].x=(float)100*(j-POINTS/2);
        control[i][j].y=(float)100*(i-POINTS/2);
        control[i][j].z=DIST;
    }

}

void do_tri(void) {

    DWORD i,j,t;
    for(i=t=0;i<RESOLUTION-1;i++) for(j=0;j<RESOLUTION-1;j++,t+=2) {
        tri[t].a=j+i*RESOLUTION;
        tri[t].b=j+1+i*RESOLUTION;
        tri[t].c=j+(i+1)*RESOLUTION;
        tri[t+1].a=j+1+i*RESOLUTION;
        tri[t+1].b=j+1+(i+1)*RESOLUTION;
        tri[t+1].c=j+(i+1)*RESOLUTION;
    }

}

void assign_texture(void) {

    SDWORD i,j,t;
    for(i=t=0;i<RESOLUTION;i++) for(j=0;j<RESOLUTION;j++,t++) {
        text[t].u=(j*255)/(RESOLUTION-1);
        text[t].v=(i*255)/(RESOLUTION-1);
    }

}

void calc_blend(void) {

    float uinc,u;
    SDWORD x,i;

    uinc=(float)(N-DEGREE+2)/(RESOLUTION-1);
    for(u=x=0;x<RESOLUTION;u+=uinc,x++) {
            for(i=0;i<POINTS;i++) {
                blend[x][i]=get_blend(i,DEGREE,u);
            }
    }
}

void do_code(void) {

    // Generacin de un pseudocdigo que indica que puntos de control
    //  son los que influyen en una determinada regin

    DWORD i,j,x,y,t,n;
    float *fix;

    // Primero un clculo de la memoria que se necesita

    for(i=memory=0;i<RESOLUTION;i++) for(j=0;j<RESOLUTION;j++) {
        for(y=n=0;y<POINTS;y++) for(x=0;x<POINTS;x++) {
            memory++;
            if(blend[i][y]!=0 && blend[j][x]!=0) memory++;
        }
    }

    pseudo_code=(DWORD *)malloc(memory*sizeof(DWORD));
    if(pseudo_code==NULL)
        fatal_error("Not enough memory");

    // Formato (para cada posicin (x,y) < (RESOLUCION,RESOLUCION)

   //     4 bytes   -> Nmero de puntos de control que influyen en esa zona
   //     4+4 bytes -> Por cada punto de control, el primero indica el n-
   //                   mero del punto de control (x+y*POINTS) y el segundo
   //                   el valor de la funcin Blend en ese punto

    for(i=t=0;i<RESOLUTION;i++) for(j=0;j<RESOLUTION;j++) {
        for(y=n=0;y<POINTS;y++) for(x=0;x<POINTS;x++)
            if(blend[i][y]!=0 && blend[j][x]!=0) n++;
        *(pseudo_code+t++)=n;
        for(y=0;y<POINTS;y++) for(x=0;x<POINTS;x++)
            if(blend[i][y]!=0 && blend[j][x]!=0) {
                *(pseudo_code+t++)=x+y*POINTS;
                fix=(float *)pseudo_code+t++;
                *fix=blend[i][y]*blend[j][x];
            }
    }

}

#define RT 5


void move_control(DWORD time) {

    DWORD i,j;
    float x,y,dist,ang;

    for(i=0;i<POINTS;i++) for(j=0;j<POINTS;j++) {
        x=control[i][j].x;
        y=control[i][j].y;
        dist=sqrt(x*x+y*y);

        if(
            (get_song_pos()>0x30008 && get_song_pos()<0x30008+RT) ||
            (get_song_pos()>0x40000 && get_song_pos()<0x40000+RT) ||
            (get_song_pos()>0x4002c && get_song_pos()<0x4002c+RT) ||
            (get_song_pos()>0x50018 && get_song_pos()<0x50018+RT) ||
            (get_song_pos()>0x60008 && get_song_pos()<0x60008+RT) ||
            (get_song_pos()>0x60018 && get_song_pos()<0x60018+RT) ||
            (get_song_pos()>0x60024 && get_song_pos()<0x60024+RT) ||
            (get_song_pos()>0x60030 && get_song_pos()<0x60030+RT) ||
            (get_song_pos()>0x70008 && get_song_pos()<0x70008+RT)
        )
        {
            control[i][j].x=x*cos(.4)-y*sin(.4);
            control[i][j].y=x*sin(.4)+y*cos(.4);
            control[i][j].z+=100*sin(time+dist);       // Agua
        }
//        control[i][j].z+=100*sin(time+dist/100);  // bandera

        ang=0.2*(dist/1000)*cos((float)time/15);  // Rotacin
        control[i][j].x=x*cos(ang)-y*sin(ang);
        control[i][j].y=x*sin(ang)+y*cos(ang);

    }
}

//-----------------------------------------------------------------------------
//               Generacin de la ruta mediante splines
//-----------------------------------------------------------------------------

void calc_coeff(float *, float *, float *, float *,
                float, float, float, float, float *);
void build_matrix(float *mtx, float, float, float);

#define CONTINUITY  0
#define BIAS        0
#define TENSION     0

DOT *do_path(BYTE *filename) {

    FILE *fp;
    FILEINFO fp_info;
    DWORD ptos,i,j;
    DOT *path_control,*path;
    DWORD cur_point=0;
    float mtx[4][4],t;
    float p1,p2,p3,p4;
    float ax,bx,cx,dx;
    float ay,by,cy,dy;
    float az,bz,cz,dz;

    fp_info=lib_getfileinfo(filename);
    fp=fopen(fp_info.name,"rt");
    if(fp==NULL)
        fatal_error("\n Can't find path");
    fseek(fp,fp_info.offset,SEEK_SET);

    fscanf(fp," %d",&ptos);
    no_frames=DELTA*(ptos-1);

    path=(DOT *)malloc(no_frames*sizeof(DOT));
    path_control=(DOT *)malloc(ptos*sizeof(DOT));
    if(path_control==NULL || path==NULL)
        fatal_error("Not enough memory");

    for(i=0;i<ptos;i++) {
        fscanf(fp," %f,%f,%f",&(path_control+i)->x,&(path_control+i)->y,
                              &(path_control+i)->z);
    }

    // Empieza la generacin de la ruta

    build_matrix(mtx,TENSION,CONTINUITY,BIAS);

    for(i=0;i<ptos-1;i++) {

        if(i==0) p1=path_control->x; else p1=(path_control+i-1)->x;
        p2=(path_control+i)->x;
        p3=(path_control+i+1)->x;
        if(i==ptos-2) p4=(path_control+i+1)->x; else p4=(path_control+i+2)->x;
        calc_coeff(&ax,&bx,&cx,&dx,p1,p2,p3,p4,mtx);

        if(i==0) p1=path_control->y; else p1=(path_control+i-1)->y;
        p2=(path_control+i)->y;
        p3=(path_control+i+1)->y;
        if(i==ptos-2) p4=(path_control+i+1)->y; else p4=(path_control+i+2)->y;
        calc_coeff(&ay,&by,&cy,&dy,p1,p2,p3,p4,mtx);

        if(i==0) p1=path_control->z; else p1=(path_control+i-1)->z;
        p2=(path_control+i)->z;
        p3=(path_control+i+1)->z;
        if(i==ptos-2) p4=(path_control+i+1)->z; else p4=(path_control+i+2)->z;
        calc_coeff(&az,&bz,&cz,&dz,p1,p2,p3,p4,mtx);

        for(j=0;j<DELTA;j++) {
            t=(float)j/DELTA;
            (path+cur_point+j)->x=((ax*t+bx)*t+cx)*t+dx;
            (path+cur_point+j)->y=((ay*t+by)*t+cy)*t+dy;
            (path+cur_point+j)->z=((az*t+bz)*t+cz)*t+dz;
        }
        cur_point+=DELTA;
    }

    free(path_control);
    return path;

}

void calc_coeff(float *a, float *b, float *c, float *d,
                float p1, float p2, float p3, float p4, float mtx[4][4]) {

    *a=mtx[0][0]*p1+mtx[0][1]*p2+mtx[0][2]*p3+mtx[0][3]*p4;
    *b=mtx[1][0]*p1+mtx[1][1]*p2+mtx[1][2]*p3+mtx[1][3]*p4;
    *c=mtx[2][0]*p1+mtx[2][1]*p2+mtx[2][2]*p3+mtx[2][3]*p4;
    *d=mtx[3][0]*p1+mtx[3][1]*p2+mtx[3][2]*p3+mtx[3][3]*p4;

}

void build_matrix(float mtx[4][4],float tension, float continuity, float bias) {


    float a=(1-tension)*(1+continuity)*(1+bias);
    float b=(1-tension)*(1-continuity)*(1-bias);
    float c=(1-tension)*(1-continuity)*(1+bias);
    float d=(1-tension)*(1+continuity)*(1-bias);

    mtx[0][0]=-a/2;                 mtx[0][1]=(4+a-b-c)/2;
    mtx[0][2]=(-4+b+c-d)/2;         mtx[0][3]=d/2;

    mtx[1][0]=a;                    mtx[1][1]=(-6-2*a+2*b+c)/2;
    mtx[1][2]=(6-2*b-c+d)/2;        mtx[1][3]=-d/2;

    mtx[2][0]=-a/2;                 mtx[2][1]=(a-b)/2;
    mtx[2][2]=b/2;                  mtx[2][3]=0;

    mtx[3][0]=0;                    mtx[3][1]=1;
    mtx[3][2]=0;                    mtx[3][3]=0;

}
