--              stupikeffyloopy
--
--              copyleft (c) 1998 by FAC
--              coded in TMT Pascal v2.0
--
--              comments? questions? flames?
--              shadowfac@hotmail.com
--
--              This material is freeware and can be used
--              to produce only freeware programs, which
--              means that if you do anything with this
--              routines, you can not sell it. And if
--              you use any of this stuff, you have to
--              credit me or else you'll be considered
--              a true lamer.
--
--              Thanks to Cesar Vellido for the Mod player
--              and to the TMT development crew for their
--              great compiler.
--
--              A special greet goes out to K!O for
--              introducing TMT Pascal to me.

-- Uncomment the next line if you don't have a Sound Blaster compatible
-- or if you don't have the registered version of TMT Pascal.

-- {$define NoMusic}     -- this is the line I'm talking about!

{$define AutoPoll}
{$define _TrianglesOnly_ }

program keffy;

{$ifdef NoMusic}
uses Mode13PM, PCharSet, Scrollie, WobObj, Intro, Triangle, PhongPal,
     Backgrs, Outro, Crt;
{$else}
uses TSS, Mode13PM, PCharSet, Scrollie, WobObj,
     Intro, Triangle, PhongPal, Backgrs, Outro, Crt;
{$endif}

{ defining a pointer to the picture of storm, which is 140*200 pixels }
type TStormPic = array[0..199] of array[0..139] of byte;
     PTStormPic = ^TStormPic;

var charset : PTCharSet;     { pointer to the character set object }
    StormPic : PTStormPic;   { pointer to my babe's pic            }
    StormOff : dword;        { the offset to that picture          }
    MainPal : TPalette;      { the main palette                    }
    IntroPic : PTTexture;    { pointer to the intro logo           }
    IntroPal : TPalette;     { the intro palette                   }

    frames, t0, backtimer : dword; { just for benchmarking and timing }

{ the mod player has it's own timer, so..... }
{$ifdef NoMusic}
    time : dword absolute $0046C;
{$endif}

{ the procedure that initializes stuff }
procedure Init;
var tempscr : PTVirtual;        { temporary virtual screen }
    tempoff, x, y : dword;      { and it's offset          }
begin
     clrscr;
     writeln;
     writeln('                                  Keffy by FAC');
     writeln('     ----------------------------------------------------------------------');
     writeln;
     writeln('           Allocating memory...');
     SetupVirtual(tempscr, tempoff);
     StormPic := new(PTStormPic);
     StormOff := ofs(StormPic^);
     IntroPic := new(PTTexture);
     TextureOffset := ofs(IntroPic^);

     writeln('           Loading my girlfriend''s pic...');
     LoadPCX('storm.pcx', tempoff, 140, 200, 0, 0, MainPal);
     for y := 0 to 199 do
         for x := 0 to 139 do StormPic^[y][x] := GetPixel(x, y, tempoff);

     writeln('           Loading some other pics...');
     LoadTexture('logo1.pcx', IntroPic, IntroPal);
     LoadLogo;  { LoadLogo is from BACKGRS.PAS }

     writeln('           Loading character set...');
     charset := new(PTCharSet, Init('charset.chr'));

     writeln('           Loading some background pics...');
     LoadBackgrounds;   { LoadBackgrounds is from BACKGRS.PAS }

     writeln('           Loading 3D objects...');
     LoadObjects;       { LoadObjects is from WOBOBJ.PAS      }

     writeln('           Loading text...');
     LoadText;          { LoadText is from SCROLLIE.PAS       }

     writeln('           Doing some stuff...');
     SetupOutro;        { SetupOutro is from OUTRO.PAS        }

     ShutDownVirtual(tempscr);

{$ifndef NoMusic}
     writeln('           Loading music...');
     write('          ');
     LoadMOD('1.mod');
     if ModStatus < 0 then
     begin
          writeln('Mod player error: ', ModStatus);
          halt(1);
     end;
{$endif}

--   This makes a nice green palette using the phong model for the cube
--   uses colors from 0 to 63

     MakePhongPal(0, 0, 250, 0, 80, 250, 0, 0, 250, 200, MainPal, 0, 63);

--   Colors from 224 to 245 are used for the character set (which is white)
     for x := 0 to 21 do
     begin
          MainPal[224 + x][0] := x * 3;
          MainPal[224 + x][1] := x * 3;
          MainPal[224 + x][2] := x * 3;
     end;
end;


{ the procedure that de-initializes everything }
procedure Finish;
begin
{$ifndef NoMusic}
     AutoPoll := false;
     TSS_Stop;
     FreeMOD;
{$endif}
     SetTextMode;
     dispose(StormPic);         { goodbye storm }
     dispose(IntroPic);         { goodbye logo  }
     dispose(charset, Done);    { goodbye charset }
     KillScrollie;              { goodbye scrollie     (from SCROLLIE.PAS) }
     KillObjects;               { goodbye cube         (from WOBOBJ.PAS)   }
     KillBackgrounds;           { goodbye backgrounds  (from BACKGRS.PAS)  }
     writeln;
     writeln('Wooooooooo!!!');  { stupid ending text }
     writeln;
{$ifdef NoMusic}
     writeln('About ', frames/(t0/18.2):1:2, ' fps in this machine');
{$else}
     writeln('About ', frames/(t0/50.0):1:2, ' fps in this machine');
{$endif}
     writeln;
     { important stuff }
     writeln('contact@me:       fac@slp1.telmex.net.mx');
     writeln;
     writeln('Thanks to Cesar Vellido for MOD player');
     writeln;
end;


{ the procedure that draws my girlfriend transparently }
procedure DrawBabe(where : dword); assembler;
asm
   mov edi, [where]             { destination screen }
   mov esi, [StormOff]          { offset to storm's picture }
   mov edx, 200                 { height of picture }
   @loopy:  mov ecx, 140        { width of picture }
   @loopx:  mov al, [esi]       { we read a pixel  }
            or al, al           { and check if it's zero }
            jz @nope
            mov [edi], al       { if <> zero, draw it }
   @nope:   inc edi             { increment pointers and stuff }
            inc esi
            dec ecx
            jnz @loopx
            add edi, 180        { go to the next line (180 + 140 = 320) }
            dec edx
            jnz @loopy
end;


{ this is actually the main procedure }
procedure DoIt;
var vscr : PTVirtual;   { a virtual screen }
    voff : dword;       { and it's offset }
    run : boolean;      { just some flag }

begin
     SetupVirtual(vscr, voff);
     ClearScreen(0, voff);
     run := true;

     SetMode13;
     SetPalette(IntroPal); { setting up the intro part }

{$ifndef NoMusic}
     IniTSS;
     AutoPoll := true;
     TSS_Play;
{$endif}

     DoIntro;  { what you think this procedure does?   (from INTRO.PAS) }

     SwitchBackground(MainPal); { setup the first background effect }
     GlobalStyle := FlatShaded; { the cube is always flatshaded     }
     SetPalette(MainPal);       { activate the super palette        }

{$ifdef NoMusic}
     frames := 0; t0 := time; backtimer := time;  { setup timing stuff }
{$else}
     frames := 0; t0 := timer50; backtimer := timer50;
{$endif}

     { main loop }
     while run do
     begin
          DoBackground(voff);   { draws the background effect }
          DoScrollie(voff + 43520, charset); { draws the scrollie }
          DoWobblingObject(voff);  { draws the green cube }
          DrawBabe(voff);          { draws storm }
          CopyScreen(voff, VGA);  { and shows it all }

{$ifdef NoMusic}
        { after about 8 seconds, switchs the background effect }
        { 8 * 18.2 = 145 }
          if (time - backtimer) > 145 then
          begin
               SwitchBackground(MainPal);
               backtimer := time;
          end;
{$else}
       { same as above, but different frequency:  8 * 50 = 400  }
          if (timer50 - backtimer) > 400 then
          begin
               SwitchBackground(MainPal);
               backtimer := timer50;
          end;
{$endif}

          inc(frames);  { just for benchmarking }
          if keypressed then if readkey = #27 then run := false; { ESC quits }
     end;
     { end of main loop }

{$ifdef NoMusic}
     t0 := time - t0;
{$else}
     t0 := timer50 - t0;
{$endif}
     ShutDownVirtual(vscr);  { we don't need it anymore }

     DoOutro(charset);  { do the ending stuff }
end;
{ end of main procedure }

begin
     Init;
     DoIt;
     Finish;
end.
