Unit devSB;
{$R-}
---------------------------------------------------------------------
--  *** TMT Sound System ***                                       --
--  Device:SoundBlaster 1.0,2.0,Pro, Pro2 & 16                     --
--                                                                 --
--                   by CiMEDIA/CiMEDIA iNC. [1/98]                --
--                   (a.k.a. Cesar Vellido)                        --
---------------------------------------------------------------------
{ $Define MixDebug}

interface

Const
  SB_Stereo      :boolean=False;
  SB_HighSpeed   :Boolean=False;
  NextNBuf       :DWORD=0; --Next NBuffer to be played
  NBufsReady     :DWORD=0; --#NBuffers Mixed
  MaxNBufs       =4;       --#NBuffers
  DMA_Addr       :word=$FF;
  DMA_Count      :word=$FF;
  DMA_Mask       :word=$0A;
  DMA_ModeReg    :word=$0B;
  DMA_FF         :word=$0C;
  DMA_Page       :word=$FF;
  DMA_Mode       :byte=$FF; {SB1 48h+Chnl/SB2-AutoInit 58h+Chnl}
  DMA_Buffer     :Pointer=NIL;
  DMA_BufSize    :DWORD=0;
  DMA_NewBufSize :DWORD=0; --if DMA_ChangeBS... (speed changes)
  DMA_ChangeBS   :Boolean=False;
  SB_MixerActive :Boolean=false;
  SB_IRQ         :byte=$FF;
  SB_DMAChnl     :byte=$FF;
  SB_Model       :byte=$FF;
  SB_ModelStr    :string='None.';
  SB_BASE        :Word=$200;
  SB_Reset       :Word=$206;
  SB_ReadData    :Word=$20A;
  SB_WriteData   :Word=$20C;
  SB_DataAvail   :Word=$20E;
  SB_IRQAcknowled:Word=$20E; {2xFh for SB16}
  SB_AutoInit    :Boolean=False;
  SB_OldInt      :FarPointer=(Seg:0;Ofs:nil);
  SB_Present     :Boolean=False;
  SB_DSPVer      :String[5]='[NUL]';
  SB_DSP         :WORD=0;
  SB16           :Boolean=False;

var
  MixBuffer       :array[0..(MaxNBufs-1)*16000]of byte;
  MixBufferM16    :array[0..(MaxNBufs-1)*16000]of Integer;
  SB_EnvStr       :String;

Function  SB_Detect(ShowInfo:Boolean):Boolean;
Procedure SB_ResetCard;
Function  SB_GetDSPversion:String;
Procedure SB_WriteDAC(sample:byte);
Function  SB_ReadDAC:byte;
Procedure SB_SpeakerOn;
Procedure SB_SpeakerOff;
Procedure SB_IniMixer;
Procedure SB_KillMixer;
Procedure SB_SetMixRate(Freq:WORD);
Function  SB_GetRealMixRate(Freq:WORD):WORD;
Procedure SB_PlaySample(n_smp,offset,Chnl,SmpPeriod:DWORD);
Procedure SB_Mix;


implementation

uses TSS,Crt,Dos,MiDebug,ZMSystem;

    ---==============================================---
     --------------------------------------------------
Procedure SB_WriteDSP(v:byte);
code;
asm
  mov  dx,[SB_WriteData]
 @Bucle_SB1:
  in    al,dx
  test  al,10000000b
  jnz   @Bucle_SB1
  mov   AL,[v]
  out   dx,al
  ret   4
end;
     --------------------------------------------------
Function SB_ReadDSP:Byte;
code;
asm
  mov  dx,[SB_DataAvail]
 @Bucle_SB1:
  in    al,dx
  test  al,10000000b
  jz    @Bucle_SB1
  mov   dx,[SB_ReadData]
  xor   eax,eax
  in    al,dx
  ret
end;
     --------------------------------------------------
Procedure SB_ResetCard;
var
  tt:dWORD;
begin
  Port[SB_Reset]:=1;
  Delay(10);
  Port[SB_Reset]:=0;
  Delay(300);
  tt:=0;
  repeat
   inc(tt);
  until (Port[SB_DataAvail] AND $80 = $80) or (tt>10000);
end;
     --------------------------------------------------
Procedure SB_GetDSPversion;
var
  s:String[2];
  VerMaj,VerMin:byte;
begin
  SB_WriteDSP($E1);
  VerMaj:=SB_ReadDSP;
  VerMin:=SB_ReadDSP;
  SB_DSP:=VerMaj*$100+VerMin;
  Str(VerMaj,SB_DSPVer);
  SB_DSPVer:=SB_DSPVer+'.';
  Str(VerMin,s);
  If VerMin>9 then
   SB_DSPVer:=SB_DSPVer+s
  else
   SB_DSPVer:=SB_DSPVer+'0'+s;
end;
     --------------------------------------------------
Function  SB_Detect(ShowInfo:Boolean):Boolean;
label
  Salir;
var
  t1:integer;
     -- -- -- -- --
 Function SB_Detected:Boolean;
 var
   tt:integer;
 begin
   Port[SB_Reset]:=1;
   Delay(10);
   Port[SB_Reset]:=0;
   Delay(300);
   tt:=0;
   repeat
    inc(tt);
   until (Port[SB_DataAvail] AND $80 = $80) or (tt>10000);
   SB_Detected:=(PORT[SB_ReadData] = $AA);
 end;
     -- -- -- -- --
begin
  If SB_Present then Goto Salir;

  Repeat
   SB_Base+:=$10;
   SB_Reset+:=$10;
   SB_ReadData+:=$10;
   SB_WriteData+:=$10;
   SB_DataAvail+:=$10;
   SB_IRQAcknowled+:=$10;
  until SB_Detected or (SB_Base>$280);

  if SB_Base>$280 then Goto Salir;

  SB_Present:=True;
  SB_GetDSPVersion;
  SB_EnvStr:=GetEnv('BLASTER');
  if length(SB_EnvStr)>0 then
   begin
     t1:=0; --Get DMA info--
     repeat
      inc(t1);
      if SB_EnvStr[t1]='D'
       then SB_DMAChnl:=Ord(SB_EnvStr[t1+1])-48;
     until (SB_DMAChnl<>255) or (t1>Length(SB_EnvStr));

     t1:=0; --Get IRQ info--
     repeat
      inc(t1);
      if SB_EnvStr[t1]='I'
       then SB_IRQ:=Ord(SB_EnvStr[t1+1])-48;
     until (SB_IRQ<>255) or (t1>Length(SB_EnvStr));

     t1:=0; --Get Model info--
     repeat
      inc(t1);
      if SB_EnvStr[t1]='T'
       then SB_Model:=Ord(SB_EnvStr[t1+1])-48;
     until (SB_Model<>255) or (t1>Length(SB_EnvStr));
     If SB_Model=255
      then SB_Model:=0;
     Case SB_Model of
      0:SB_ModelStr:='SoundBlaster';
      1:SB_ModelStr:='SoundBlaster 1.x';
      2:SB_ModelStr:='SoundBlaster Pro';
      3:SB_ModelStr:='SoundBlaster 2.0';
      4:SB_ModelStr:='SoundBlaster Pro2.0';
      5:SB_ModelStr:='SoundBlaster ProMCV';
      6:SB_ModelStr:='SoundBlaster 16/AWE32';
     end;
     If ShowInfo then
      WriteLn('',SB_ModelStr,' detected (Addr:',Hex(SB_Base),',IRQ:',SB_Irq,',DMA:',SB_DMAChnl,',DSP v',SB_DSPVer,')');

     if SB_DSP>=$200 then
      begin
        SB_AutoInit:=True;
        DMA_Mode:=$58+SB_DMAChnl;
      end
     else
      DMA_Mode:=$48+SB_DMAChnl;
     SB_HighSpeed:=FALSE; -- I can't change the DMA_BufSize in HS w/o Reset
     SB_Stereo:=SB_DSP>=$300;
     SB16:=SB_DSP>=$400;
   end
  else
   begin
     SB_DMAChnl:=1; -- Set default values
     SB_IRQ:=7;
     SB_Model:=1;
     SB_ModelStr:='SB unknown';
     If ShowInfo then
      WriteLn('SB detected (BLASTER EnvVar not found. Default values Addr:',Hex(SB_Base),',IRQ:',SB_Irq,',DMA:',SB_DMAChnl,',DSP v',SB_DSPVer,')');
   end;

  Case SB_DMAChnl of
   0:begin
       DMA_Page:=$87;
       DMA_Addr:=0;
       DMA_Count:=1;
     end;
   1:begin
       DMA_Page:=$83;
       DMA_Addr:=2;
       DMA_Count:=3;
     end;
   3:begin
       DMA_Page:=$82;
       DMA_Addr:=6;
       DMA_Count:=7;
     end;
  end;

  Salir:
  SB_Detect:=SB_Present;
end;

     --------------------------------------------------
Procedure SB_SetMixRate(Freq:WORD);
begin
  If Freq<5000 then
   Freq:=5000;
  If Freq>43478 then
   Freq:=43478;
  If (Freq>21739) and (SB_DSP<=$200) then
   Freq:=21739;
  If Freq<=21739 then
   SB_HighSpeed:=False;

  If SB16 then
   begin
     SB_WriteDSP($41);
     SB_WriteDSP(Hi(Freq));
     SB_WriteDSP(Lo(Freq));
   end
  else
   begin
     SB_WriteDSP($40);
     SB_WriteDSP(256-(1000000 div Freq));
   end;
end;
     --------------------------------------------------
Function SB_GetRealMixRate(Freq:WORD):WORD;
var
  tc:DWORD;
begin
  tc:=256-(1000000 div Freq);
  Result:=1000000 div (256-tc);
end;
     --------------------------------------------------
Procedure SB_WriteDAC(sample:byte);
begin
  SB_WriteDSP($10);
  SB_WriteDSP(sample);
end;
     --------------------------------------------------
Function SB_ReadDAC:byte;
begin
  SB_WriteDSP($20);
  SB_ReadDAC:=SB_ReadDSP;
end;
     --------------------------------------------------
Procedure SB_SpeakerOn;
begin
  SB_WriteDSP($D1);
end;
     --------------------------------------------------
Procedure SB_SpeakerOff;
begin
  SB_WriteDSP($D3);
end;
     --------------------------------------------------
Procedure SB_DMAStop;
begin
  SB_WriteDSP($D0);
end;
     --------------------------------------------------
Procedure SB_HaltAutoInit;
begin
  SB_WriteDSP($DA);
end;
     --------------------------------------------------
Procedure SB_DMAContinue;
begin
  SB_WriteDSP($D4);
end;
     --------------------------------------------------
Procedure SB_IntHandler;
assembler;
interrupt;
asm
  {$IfDef MixDebug}
  mov   MiDebug.Red,$39
  call  MiDebug.Border
  {$EndIf}

  cmp   [DMA_ChangeBS],True
  jne   @NoChangeBS
   mov  [DMA_ChangeBS],False
   {$IfDef MixDebug}
   mov  midebug.red,63
   mov  midebug.green,63
   call midebug.border
   {$EndIf}
   Call SB_HaltAutoInit
   Call SB_IniMixer            -- Set new DMA Transfer size for AutoInit mode
   {$IfDef MixDebug}
   mov  midebug.green,0
   mov  midebug.red,0
   call midebug.border
   {$EndIf}
  @NoChangeBS:

  mov   esi,offset MixBuffer
  mov   eax,[NextNBuf]
  mov   ecx,[DMA_BufSize]
  imul  ecx
  add   esi,eax
  inc   [NextNBuf]
  cmp   [NextNBuf],MaxNBufs
  jb    @NextNBufOK
   mov  [NextNBuf],0
  @NextNBufOK:
  sub   [NBufsReady],1
  adc   [NBufsReady],0
  add   ecx,3
  mov   edi,[DMA_Buffer]
  shr   ecx,2
  rep   movsd

  cmp    [SB_AutoInit],True
  je    @DMAStufDone
   --Program the DMA--
   mov   dx,[DMA_Mask]
   mov   al,[SB_DMAChnl]
   or    al,4
   out   dx,al       --Mask Channel
   mov   dx,[DMA_FF]
   xor   al,al
   out   dx,al       --Clear FlipFlop
   mov   dx,[DMA_ModeReg]
   mov   al,[DMA_Mode]
   out   dx,al       --Mode
   mov   dx,[DMA_Addr]
   mov   eax,[DMA_Buffer]
   out   dx,al       --LSB Offset
   xchg  ah,al
   out   dx,al       --MSB Offset
   mov   dx,[DMA_Page]
   mov   eax,[DMA_Buffer]
   shr   eax,16
   out   dx,al       --Page
   mov   eax,[DMA_BufSize]
   mov   dx,[DMA_Count]
   dec   eax
   out   dx,al       --LSB Size
   xchg  al,ah
   out   dx,al       --MSB Size
   mov   dx,[DMA_Mask]
   mov   al,[SB_DMAChnl]
   out   dx,al       --enable Channel
   --Program the DSP--
   push  $14         --DSP 8 bit PCM OutPut
   call  SB_WriteDSP
   mov   ebx,[DMA_BufSize]
   xor   eax,eax
   dec   ebx
   mov   al,bl
   push  eax
   call  SB_WriteDSP --LSB (Size-1)
   xor   eax,eax
   mov   al,bh
   push  eax
   call  SB_WriteDSP --MSB (Size-1)
  @DMAStufDone:

  mov   dx,[SB_IRQAcknowled]
  in    al,dx                  -- Acknowledge DSP Int
  mov   al,$20               
  out   $20,al                 -- EOI to PIC
  cmp   [SB_IRQ],7
  jbe   @EOI_Done
  out   $A0,al
  @EOI_Done:

  {$IfDef MixDebug}
  mov   MiDebug.Red,$0
  call  MiDebug.Border
  {$EndIf}
end;
     --------------------------------------------------
Procedure SB_KillMixer;
begin
  if not SB_MixerActive then
   exit;
  --DSP Stop--
  SB_DMAStop;
  if SB_AutoInit then
   begin
     SB_HaltAutoInit;
     SB_DMAStop;
   end;
  SB_ResetCard;
  --DMA Stop--
  Port[DMA_Mask]:=SB_DMAChnl+4;  --Mask Channel
  Port[DMA_FF]:=0;               --Clear FlipFlop
  --Restore old ISR--
  if SB_OldInt.Ofs<>Nil then
   begin
     If SB_IRQ<=7 then
      Port[$21]:=Port[$21] OR (1 shl SB_IRQ) --disable SB_IRQ
     else
      Port[$A1]:=Port[$A1] OR (1 shl (SB_IRQ-8));
     SetIntVec($8+SB_IRQ,SB_OldInt);
     SB_OldInt.ofs:=Nil;
   end;

  SB_MixerActive:=False;
end;
     --------------------------------------------------
Procedure SB_IniMixer;
Begin
  --Set the new ISR--
  If SB_OldInt.Ofs=Nil then
   begin
     GetIntVec($8+SB_IRQ,SB_OldInt);
     SetIntVec($8+SB_IRQ,@SB_IntHandler);
     SB_SetMixRate(MixFreq);
     If SB_IRQ<8 then
      Port[$21]:=Port[$21] AND Not(1 shl SB_IRQ) --enable SB_IRQ
     else
      Port[$A1]:=Port[$A1] AND Not(1 shl (SB_IRQ-8));
   end;
  --Program de DMA--
  Port[DMA_Mask]:=SB_DMAChnl+4; --Mask Channel
  Port[DMA_FF]:=0;              --Clear FlipFlop
  Port[DMA_ModeReg]:=DMA_Mode;
  Port[DMA_Addr]:=(DWORD(DMA_Buffer) AND $FF);
  Port[DMA_Addr]:=((DWORD(DMA_Buffer) shr 8) AND $FF);
  Port[DMA_Page]:=DWORD(DMA_Buffer) shr 16;
  Port[DMA_Count]:=Lo(DMA_BufSize-1);
  Port[DMA_Count]:=hi(DMA_BufSize-1);
  Port[DMA_Mask]:=SB_DMAChnl;   --enable Channel
  --Program the DSP--
  if SB16 then
   begin
     SB_WriteDSP($C6);          --Set 8 bit DMA-DAC, AutiInit, FIFO
     SB_WriteDSP($0);           --Set 8 bit DMA-Mode UnSigned-Mono
     SB_WriteDSP(Lo(DMA_BufSize-1));
     SB_WriteDSP(Hi(DMA_BufSize-1));
   end
  else if SB_AutoInit then
    begin
      SB_WriteDSP($48);         --Set BlockSize AutoInit
      SB_WriteDSP(Lo((DMA_BufSize-1)));
      SB_WriteDSP(hi((DMA_BufSize-1)));
      if not SB_HighSpeed
       then SB_WriteDSP($1C)    --Set 8 bit PCM AutoInit Output
       else SB_WriteDSP($90);   --Set 8 bit PCM HighSpeed AutoInit Output
    end
   else
    begin
      SB_WriteDSP($14);         --Set BlockSize SingleCycle
      SB_WriteDSP(Lo(DMA_BufSize-1));
      SB_WriteDSP(hi(DMA_BufSize-1));
    end;
  SB_MixerActive:=True;
end;
     --------------------------------------------------
Procedure SB_PlaySample(n_smp,offset,Chnl,SmpPeriod:DWORD);
begin
  --Nothing to do...
end;
     --------------------------------------------------
Procedure SB_Mix;
assembler;
var
  ActChnl:DWORD;
  NBufPtr:DWORD;
asm
  pushad
  mov   eax,[NextNBuf]
  add   eax,[NBufsReady]
  cmp   eax,MaxNBufs
  jb    @NBufOK
   sub  eax,MaxNBufs
  @NBufOK:
  imul  [DMA_BufSize]
  mov   [NBufPtr],eax
  {$IfDef MixDebug}
  mov   miDebug.Green,33 --<debug!!>
  call  miDebug.Border
  {$EndIf}
  --Init some regs--
  mov   eax,[NBufPtr]
  mov   edi,offset [MixBufferM16]
  shl   eax,1 -->16bit
  mov   esi,offset [Channel]
  add   edi,eax
  mov   eax,[MaxChnl]
  mov   [ActChnl],eax
  --Blank Mixing Buffer--
  push  edi
  mov   eax,$08000800 --Initial output=2048
  mov   ecx,[DMA_BufSize]
  add   ecx,1
  shr   ecx,1
  rep   stosd
  pop   edi
  xor   eax,eax

  --Mix every Channel--
 @MixOneChannel:
  cmp   DWORD Ptr [esi+4*6],0  --nothing to do if volume=0
  je    @ChnlMixed
  push  edi
  mov   ecx,[DMA_BufSize]
  mov   ebx,[esi]     --Actual Sample ptr
  push  ebp
  mov   ebp,[esi+4*6]
  shl   ebp,9         --ebp=sample_volume*256*2

  @MixOneSample:
   mov  edx,[esi+4*5]   --FPeriod FP:24.8
   add  edx,[esi+4*4]   --FPeriod+:=Period
   mov  [esi+4*5],dl    --store fract part of FPeriod
   shr  edx,8           --Get Integer Part of FPeriod
   add  ebx,edx         --new Sample ptr
   xor  eax,eax
   cmp  ebx,[esi+4*1]   --check for End_of_sample
   jb   @NotFinished
    cmp BYTE Ptr [esi+4*8],True --check for loop
    jne @CutSample
     mov ebx,[esi+4*2]  --ActPtr:=BLPtr
     mov eax,[esi+4*3]
     mov [esi+4*1],eax  --ESPtr:=ELPtr
     xor eax,eax
     jmp @NotFinished
    @CutSample:
    mov DWORD Ptr [esi+4*6],0 --Volume=0
    pop ebp
    pop edi
    jmp @ChnlMixed
   @NotFinished:
   mov  al,[ebx]        --EAX contains the 8 bit sample data
   mov  ax,WORD Ptr VolTable[ebp+eax*2]
   add  [edi],ax
   add  edi,2
   dec  ecx
   jnz  @MixOneSample
  
  pop   ebp
  mov   [esi],ebx       --store last Sample ptr
  pop   edi
  @ChnlMixed:
  add   esi,TYPE(tChannel)
  dec   [ActChnl]
  jnz   @MixOneChannel  --Repeat until all channels mixed...

  --PostProcessing wave--
  {$IfDef MixDebug}
  mov   miDebug.Green,0
  mov   miDebug.Red,0
  mov   miDebug.Blue,63
  call  miDebug.Border
  {$EndIf}
  mov   edx,[DMA_BufSize]
  mov   esi,Offset MixBufferM16
  mov   edi,Offset MixBuffer
  mov   ebx,[NBufPtr]   --ptr inside Mixing Buffers
  add   [NBufPtr],edx
  xor   eax,eax
  @Xlat:
   mov  ax,[esi+ebx*2]
   mov  al,BYTE Ptr PostTable[eax]
   mov  [edi+ebx],al
   inc  ebx
   dec  edx
  jnz   @Xlat

  {$IfDef MixDebug}
  mov   miDebug.Green,0
  mov   miDebug.Red,0
  mov   miDebug.Blue,0
  call  miDebug.Border
  {$EndIf}
  inc   [NBufsReady]
  popad
end;
    ---==============================================---

end.
