{$M 32000,0,655360}
(* TinyFont TED 2.0 Font program (C) '95 By Paradise *)

Unit TFont;

Interface

 Var
  FontPalette  : Array [0..255,1..3] of Byte;

 Procedure TFont_Init;
 Procedure TFont_Setup(IncF : Byte);
 Procedure TFont_Print(X, Y : Integer;  Str : String; GSeg : Word);
 Procedure TFont_Done;

Implementation

Uses Crt, Dos, Vga, TPUnpack;

Var
 TFFHeader    : Record
                 Id          : Array [0..5] of Char;
                 Version     : Word;
                 CharsNum    : Byte;
                 ColorsNum   : Byte;
                 Compression : Byte;
                 InfoOfs     : LongInt;
                 CharsOfs    : LongInt;
                 PaletteOfs  : LongInt;
                End;

 CharsInfo    : Array [0..255] of Record
                 Width       : Byte;
                 Height      : Byte;
                 Compression : Byte;
                End;


 CharsData    : Array [0..255] of Pointer;

 ConvertTab   : Array [0..255] of Byte;

 Count        : Word;
 Key          : Byte;

 Temp         : Array [0..20000] of Byte;
 IncFont      : Byte;

{$L TinyFont.Obj}
Function TinyFontSize : Word; Far; External;
Procedure UnpackTinyFont(Var Buffer); Far; External;

Procedure InitFont;
Var Wsk : Word;
Begin
 UnpackTinyFont(Temp);
 FillChar(CharsInfo,SizeOf(CharsInfo),0);
 FillChar(ConvertTab,SizeOf(ConvertTab),0);
 FillChar(FontPalette,SizeOf(FontPalette),0);
 Move(Temp, TFFHeader, SizeOf(TFFHeader));
 Wsk:=TFFHeader.InfoOfs;
 For Count:=1 to TFFHeader.CharsNum do
 Begin
  Key:=Temp[Wsk];
  ConvertTab[Count]:=Key;
  Move(Temp[Wsk+1], CharsInfo[Key], 3);
  Inc(Wsk, 4);
 End;
 Wsk:=TFFHeader.CharsOfs;
 For Count:=1 to TFFHeader.CharsNum do
 Begin
  Key:=ConvertTab[Count];
  GetMem(CharsData[Key], CharsInfo[Key].Width*CharsInfo[Key].Height);
  Move(Temp[Wsk], CharsData[Key]^, CharsInfo[Key].Width*CharsInfo[Key].Height);
  Inc(Wsk, CharsInfo[Key].Width*CharsInfo[Key].Height);
 End;
 Wsk:=TFFHeader.PaletteOfs;
 Move(Temp[Wsk], FontPalette, TFFHeader.ColorsNum*3);
End;

Procedure FreeFont;
Begin
 For Count:=1 to TFFHeader.CharsNum do
 Begin
  Key:=ConvertTab[Count];
  If CharsData[Key]<>Nil then
   FreeMem(CharsData[Key],CharsInfo[Key].Width*CharsInfo[Key].Height);
 End;
End;

Procedure RaWrite(X,Y : Integer; Width, Height : Word; Data : Pointer; GSeg : Word); Assembler;
Asm
 mov  ax, GSeg
 mov  es, ax
 mov  bx, Y
 shl  bx, 1
 mov  di, word ptr [YOfs+bx]
 add  di, X
 mov  ax, word ptr [Data+2]
 db   $8e,$e0
 mov  si, word ptr [Data]
 mov  dx, 320
 sub  dx, Width
 mov  cx, Height
@@y:
 push cx
 mov  cx, Width
@@x:
 db   $64,$8a,$04
 or   al, al
 jz   @@b
 add  al, IncFont
 stosb
 jmp  @@a
@@b:
 inc  di
@@a:
 inc  si
 dec  cx
 jnz  @@x
 add  di, dx
 pop  cx
 dec  cx
 jnz  @@y
End;

Procedure TFont_Print(X, Y : Integer;  Str : String; GSeg : Word);
Var
 AbsX   : Integer;
 Pos, Z : Byte;
Begin
 AbsX:=X;
 For Pos:=1 to Length(Str) do
 Begin
  Z:=Ord(UpCase(Str[Pos]));
  RaWrite(AbsX, Y, CharsInfo[Z].Width, CharsInfo[Z].Height, CharsData[Z], GSeg);
  Inc(AbsX, CharsInfo[Z].Width+1);
 End;
End;

Procedure TFont_Init;
Begin
 InitYOfs;
 InitFont;
 IncFont:=0;
End;

Procedure TFont_Done;
Begin
 FreeFont;
End;

Procedure TFont_Setup(IncF : Byte);
Begin
 IncFont:=IncF;
End;

End.