{$M 30720,0,655360}
(* Text showing part  (C) '95 By Paradise *)

Unit Greetz;

Interface

 Procedure Greetz_Init;
 Procedure Greetz_Run;
 Procedure Greetz_Done;

Implementation

Uses Crt, Dos, Vga, FP, TPUnpack;

Type
 PalType  = Array [0..255,1..3] of Byte;

Var
 Font     : Array [0..45,0..15,0..15] of Byte;
 FontPal,
 ZeroPal,
 MainPal,
 Palette,
 Target   : PalType;
 CharTab  : Array [0..255] of Byte;
 Count    : Integer;
 Teksty   : Array [1..100] of String[30];
 TekstNum : Byte;
 IncPal   : Array [0..255,1..3] of LongInt;
 TOffs    : Word;
 SNum         : Integer;
 Scroll       : Array [1..100] of String;
 MaxNum       : Integer;
 Step, Steps  : LongInt;
 GrayTab      : Array [0..255] of Byte;

{$L FoncikP.Obj}
Procedure FoncikPalette; External;

{$L Foncik.Obj}
Function FoncikSize: Word; Far; External;
Procedure UnpackFoncik(Var Buffer); Far; External;

Procedure InitCharTab;
Begin
 FillChar(CharTab,SizeOf(CharTab),45);
 For Count:=Ord('a') to Ord('z') do CharTab[Count]:=Count-80;
 For Count:=Ord('A') to Ord('Z') do CharTab[Count]:=Count-48;
 For Count:=Ord('0') to Ord('9') do CharTab[Count]:=Count-44;
 CharTab[Ord('(')]:=43; CharTab[Ord(')')]:=44;
 CharTab[Ord('{')]:=43; CharTab[Ord('}')]:=44;
 CharTab[Ord('[')]:=43; CharTab[Ord(']')]:=44;
 CharTab[Ord('!')]:=0;  CharTab[Ord('-')]:=1;
 CharTab[Ord('.')]:=2;  CharTab[Ord('/')]:=3;
 CharTab[Ord(':')]:=14; CharTab[Ord('_')]:=15;
 CharTab[Ord('?')]:=16;
End;

Procedure FontLoad;
Begin
 UnpackFoncik(Font);
 Move(@FoncikPalette^,FontPal,768);
End;

Procedure PlotChar(X, Y : Word; Z : Byte; GSeg : Word); Assembler;
Asm
 mov ax, GSeg
 mov es, ax
 mov bx, Y
 shl bx, 1
 mov di, word ptr YOfs[bx]
 add di, X
 xor bx, bx
 mov bl, Z
 shl bx, 8
 mov cx, 16
@yloop:
 push cx
 mov cx, 16
@xloop:
 mov al, byte ptr Font[bx]
 inc bx
 or  al, al
 jz  @nodraw
 push bx
 xor ah, ah
 mov bx, ax
 add bx, ax
 add bx, ax
 mov al, byte ptr FontPal[bx]
 pop bx
 mov es:[di], al
@nodraw:
 inc di
 dec cx
 jnz @xloop
 pop cx
 add di, 320-16
 dec cx
 jnz @yloop
End;

Procedure Printf(X, Y : Integer; St : String; GSeg : Word);
Var
 Count : Byte;
 NewX  : Word;
Begin
 NewX:=X;
 For Count:=1 to Length(St) do
 Begin
  PlotChar(NewX,Y,CharTab[Ord(St[Count])],GSeg);
  Inc(NewX,16);
 End;
End;

Procedure Blur(GSeg : Word); Assembler;
Const
 BlurStartLine =  40;
 BlurEndLine   = 160;
Asm
 push bp
 mov ax, GSeg
 mov es, ax
 mov di, BlurStartLine*320
@blurpixel:
 xor ah, ah
 mov al, es:[di+1]
 mov dx, ax
 mov al, es:[di-1]
 add dx, ax
 mov al, es:[di+320]
 add dx, ax
 mov al, es:[di-320]
 add dx, ax
 shr dx, 2
@@xx:
 or  dl, dl
 jz @nodec
 dec dl
@nodec:
 mov es:[di-320], dl
 inc di
 cmp di, BlurEndLine*320
 jnz @blurpixel
 pop bp
End;

Procedure UpdateIt;
Begin
 Blur(VSeg);
 ShowFake(VSeg);
 CopyFake($A000,VSeg);
End;

Procedure Greetz_Init;
Begin
 InitVPage;
 InitYOfs;
 FontLoad;
 InitCharTab;
 For Count:=0 to 63 do
  SetColor(Count,Count,Count,Count);
 SNum:=1;
 Scroll[01]:='   that was an    ';
 Scroll[02]:='     express      ';
 Scroll[03]:='  contribution to ';
 Scroll[04]:='    2nd polish    ';
 Scroll[05]:='    demo party    ';
 Scroll[06]:='   bydgoszcz 95   ';
 Scroll[07]:='                  ';
 Scroll[08]:='   __greetings__  ';
 Scroll[09]:='  jare / iguana   ';
 Scroll[10]:='   arm / iguana   ';
 Scroll[11]:='  jcab / iguana   ';
 Scroll[12]:='    simm / ac     ';
 Scroll[13]:='   pyrex / ac     ';
 Scroll[14]:='      tml         ';
 Scroll[15]:='     martist      ';
 Scroll[16]:=' mikmak / hardcode';
 Scroll[17]:=' jmagic / complex ';
 Scroll[18]:='  netron / remal  ';
 Scroll[19]:='   ped / 7 gods   ';
 Scroll[20]:='    firelight     ';
 Scroll[21]:='   cellebrandi    ';
 Scroll[22]:='   technomancer   ';
 Scroll[23]:='  maf / camorra   ';
 Scroll[24]:='      adrar       ';
 Scroll[25]:='and all i forgot__';
 Scroll[26]:='                  ';
 Scroll[27]:='   christ agony   ';
 Scroll[28]:='   morbid angel   ';
 Scroll[29]:='      samael      ';
 Scroll[30]:='      death       ';
 Scroll[31]:='     burzum       ';
 Scroll[32]:='     deicide      ';
 Scroll[33]:='    brutality     ';
 Scroll[34]:='    hypocrisy     ';
 Scroll[35]:='                  ';
 Scroll[36]:=' __and special__  ';
 Scroll[37]:='    bruce lee     ';
 Scroll[38]:='   brandon lee    ';
 Scroll[39]:='   kurt cobain    ';
 Scroll[40]:='   and polish     ';
 Scroll[41]:='kungfu and jujitsu';
 Scroll[42]:='     society      ';
 Scroll[43]:='                  ';
 Scroll[44]:='                  ';
 MaxNum:=44;
 Step:=0;
 SNum:=0;
End;

Procedure Greetz_Done;
Begin
 DoneVPage;
End;

Procedure Greetz_Run;
Var ExitOk : Boolean;
Begin
 ExitOk:=False;
 Repeat
  UpdateIt;
  If (Step mod 15=0) then
  Begin
   Inc(SNum);
   If SNum>MaxNum then ExitOk:=True else
   Begin
    Printf(20,80,Scroll[SNUm],VSeg);
    Printf(20,80,Scroll[SNUm],$A000);
   End;
  End;
  Inc(Step);
 Until ExitOk;
End;

End.
