Unit PCX; { PCX show procedure by Paradise (alias The Crow) }

Interface

 Procedure DisplayPCX(FileName : String; GSeg : Word; Var PCXPal : Array of Byte);
 Procedure DisplayPCXFast(FileName : String; GSeg : Word; Var PCXPal : Array of Byte);

Implementation

Type
 PCXHeaderType = Record
                  Manufacturer, Version,
                  Encoding, BitsPerPixel   : Byte;
                  XMin, YMin, XMax, YMax   : Word;
                  HRes, VRes               : Word;
                  ColorMap                 : Array [0..47] of Byte;
                  Reserved                 : Byte;
                  NPlanes                  : Byte;
                  BytesPerLine             : Word;
                  PaletteInfo              : Word;
                  Filler                   : Array [0..57] of Byte;
                 End;

 PCXPaletteType = Array [0..767] of Byte;
 PCXDataPtr = ^PCXDataType;
 PCXDataType = array [0..65534] of Byte;

Var
 PCXFile      : File;
 Header       : PCXHeaderType;
 Palette      : PCXPaletteType;
 PaletteID    : Byte;
 X, Y         : Word;
 Data,
 RunCount, R  : Byte;
 ScreenOffset : Word;
 PCXDataSize  : LongInt;
 DataPtr      : Word;
 PCXData      : PCXDataPtr;

Procedure DisplayPCX(FileName : String; GSeg : Word; Var PCXPal : Array of Byte);
Begin
 Assign(PCXFile, FileName);
 Reset(PCXFile, 1);
 BlockRead(PCXFile, Header, SizeOf(PCXHeaderType));
 Seek(PCXFile, FileSize(PCXFile)-769);
 BlockRead(PCXFile, PaletteID, 1);
 BlockRead(PCXFile, Palette, 768);
 For x := 0 to 767 do Palette[x] := Palette[x] shr 2;
 Move(Palette,PCXPal,768);
 PCXDataSize:=FileSize(PCXFile)-SizeOf(PCXHeaderType)-769;
 Seek(PCXFile, SizeOf(PCXHeaderType));
 ScreenOffset := 0;
 For Y:=0 to Header.YMax-Header.YMin+1 do
 Begin
  X:=0;
  While X<Header.BytesPerLine do
  Begin
   BlockRead(PCXFile,Data,1);
   If (Data and $C0) = $C0 then
   Begin
    RunCount:=Data and $3F;
    BlockRead(PCXFile,Data,1);
    For R:=1 to RunCount do
    Begin
     Mem[GSeg:ScreenOffset]:=Data;
     Inc(ScreenOffset);
    End;
    Inc(X,RunCount);
   End else
   Begin
    Mem[GSeg:ScreenOffset]:=Data;
    Inc(ScreenOffset);
    Inc(X);
   End;
  End;
 End;
 Close(PCXFile);
End;

Procedure DisplayPCXFast(FileName : String; GSeg : Word; Var PCXPal : Array of Byte);
Begin
 Assign(PCXFile, FileName);
 Reset(PCXFile, 1);
 BlockRead(PCXFile, Header, SizeOf(PCXHeaderType));
 Seek(PCXFile, FileSize(PCXFile)-769);
 BlockRead(PCXFile, PaletteID, 1);
 BlockRead(PCXFile, Palette, 768);
 For x := 0 to 767 do Palette[x] := Palette[x] shr 2;
 Move(Palette,PCXPal,768);
 PCXDataSize:=FileSize(PCXFile)-SizeOf(PCXHeaderType)-769;
 GetMem(PCXData, PCXDataSize);
 Seek(PCXFile, SizeOf(PCXHeaderType));
 BlockRead(PCXFile, PCXData^, PCXDataSize);
 Close(PCXFile);
 DataPtr := 0;
 ScreenOffset := 0;
 For Y:=0 to Header.YMax-Header.YMin+1 do
 Begin
  X:=0;
  While X<Header.BytesPerLine do
  Begin
   Data:=PCXData^[DataPtr];
   If (Data and $C0) = $C0 then
   Begin
    Inc(DataPtr);
    RunCount:=Data and $3F;
    Data:=PCXData^[DataPtr];
    For R:=1 to RunCount do
    Begin
     Mem[GSeg:ScreenOffset]:=Data;
     Inc(ScreenOffset);
    End;
    Inc(X,RunCount);
   End else
   Begin
    Mem[GSeg:ScreenOffset]:=Data;
    Inc(ScreenOffset);
    Inc(X);
   End;
   Inc(DataPtr);
  End;
 End;
 FreeMem(PCXData, PCXDataSize);
End;

End.
