.286
ideal
locals
jumps
model small
stack 100h


segment     Code
            ASSUME CS:Code, DS:Code
;
include     "modex.inc"
include     "palette.inc"
include     "freefall.inc"
include     "titlepal.dmp"
CurPalette  db 256 dup (0,0,0)
;
proc        Start
            ;**** change into mode X ****
            @SetModeX 0,320

            ;**** load the palette (all black) ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov cx,256
            xor al,al
            @WritePalette

            ;**** set the initial scrolling offset ****
            mov bx,200*(320/4)          ;start displaying on line 200
            @Set_Start_Offset

            ;**** load the second page of the image ****
            mov ax,PictureSegment2
            mov ds,ax
            mov si,offset Title_Picture
            mov bx,0/4+0*(320/4)        ;display at (0,0)
            call DisplayPBM

            ;**** load the first page of the image ****
            mov ax,PictureSegment1
            mov ds,ax
            mov si,offset JLE_Picture
            mov bx,0/4+200*(320/4)      ;display at (200,0)
            call DisplayPBM

            ;**** fade the image into view ****
            call FadeIn

            ;**** give a little pause ****
            mov cx,90
@@Delay:    @FullVertWait
            dec cx
            jnz @@Delay

            ;**** scroll the image up ****
            mov si,offset FreeFallData
            mov ax,cs
            mov ds,ax
@@ScrollUp: mov bx,[word ds:si]
            cmp bx,-1
            jz @@ScrollDone
            @Set_Start_Offset
            @FullVertWait
            add si,2
            jmp @@ScrollUp
@@ScrollDone:

            ;**** give a little pause ****
            mov cx,120
@@Delay2:   @FullVertWait
            dec cx
            jnz @@Delay2

            ;*** fade out ***
            call fade_out
            
            ;*** return to text mode ***
            ;mov ax,0003h
            ;int 10h

            ;*** terminate the program ***
            mov ax,4C00h
            int 21h
endp        Start
;
;           DS:SI ==> Xlib PBM image
;           BX = position to display:   col/4+row*(320/4)
proc        DisplayPBM
            add si,2                ;skip over length/width (assume 320x200)
            mov ax,0A000h
            mov es,ax
            cld
            mov bp,3        ;start on plane 0
@@PlaneLoop:mov ah,1000b
            mov cx,bp
            shr ah,cl
            @Set_Write_Plane
            mov di,bx
            mov cx,(320*200)/4
            rep movsb
            dec bp
            jns @@PlaneLoop

            ret
endp        DisplayPBM
;
proc        FadeIn
            ;**** converge the current palette to the desired one ****
            mov ax,cs
            mov ds,ax
            mov es,ax
            cld
            mov cx,256*3
            xor bx,bx
            mov si,offset TitlePalette
            mov di,offset CurPalette
@@NextColor:lodsb
            cmp [byte es:di],al
            jz @@ColorDone
            jb @@Increment
@@Decrement:dec [byte es:di]
            inc bx
            jmp @@ColorDone
@@Increment:inc [byte es:di]
            inc bx
@@ColorDone:inc di
            dec cx
            jnz @@NextColor
            cmp bx,0
            jz @@Done

            ;**** load in the new palette ****
            mov si,offset CurPalette
            mov cx,256
            xor al,al
            @WritePalette

            ;**** wait for a vertical retrace (for timing) ****
            mov cx,3
@@Delay:    @FullVertWait
            dec cx
            jnz @@Delay

            jmp FadeIn
@@Done:     ret
endp        FadeIn
;
ends        Code

segment     PictureSegment1
include     "jlepbm.dmp"
ends        PictureSegment1

segment     PictureSegment2
include     "titlepbm.dmp"
ends        PictureSegment2

            end Start
