/*
 * TChip  v0.1  Copyright (c) 1997 Image!
 *
 * Written by	: Mr.Aurum / Image!
 * Mail me at	: marm@hetnet.nl 
 *
*/

#include    <stdio.h>
#include    <stdlib.h>
#include    <math.h>


#define True    1
#define False   0

#define RegA    0
#define RegB    1
#define RegC    2
#define RegD    3
#define RegE    4
#define RegF    5
#define RegG    6
#define RegH    7
#define RegI    8
#define RegJ    9
#define RegK    10
#define RegL    11
#define RegM    12
#define RegN    13
#define RegO    14
#define RegP    15
#define RegQ    16
#define RegR    17
#define RegS    18
#define RegT    19
#define RegU    20
#define RegV    21
#define RegW    22
#define RegX    23
#define RegY    24
#define RegZ    25

#define	StackSize	50					// Alter if needed


typedef unsigned char   Bool;
typedef unsigned char   Byte;
typedef unsigned short  Word;

void    *CodeSeg=NULL;

Word    IP=0;
Word    STACK[StackSize];
Byte    STACKINDEX=0;
Byte    CURMAP=0;

Byte    RED[5][256][256];				// So what!!!!
Byte    GREEN[5][256][256];
Byte    BLUE[5][256][256];

float   REGS[26];
Bool    EQUAL=False,LESS=False,GREATER=False;

Byte    INSTRUCTION;
Byte    REGISTER[2];
Word    ADDRESS;
float   ABSOLUTE;

Word    CodeSize;

/*
typedef struct {
    Byte    Zero1;
    Byte    CMT;
    Byte    ITC;
    Word    COrigX;
    Word    COrigY;
    Byte    CMES;
    Word    OrigX;
    Word    OrigY;
    Word    Width;
    Word    Height;
    Byte    BPP;
    Byte    Descriptor;
} TARGA_Header;
*/

FILE	*OutFile;


#define BlurDiv 16
Byte    BlurForm[3][3] =
    { 1, 2, 1,
      2, 4, 2,
      1, 2, 1 };

// #define BlurDiv 19           smooth edged line blur
// Byte    BlurForm[3][3] =
//     { 0, 1, 6,
//       1, 5, 1,
//       4, 1, 0 };

// #define BlurDiv 6            sharp edged Line blur
// Byte    BlurForm[3][3] =
//     { 0, 0, 3,
//       0, 2, 0,
//       1, 0, 0 };


Byte    FetchByte()
{
    Byte    B;

    B = *((Byte *)((unsigned long)CodeSeg+IP));
    IP+=1;
    return B;
}


Word    FetchWord()
{
    Word    W;

    W = *((Word *)((unsigned long)CodeSeg+IP));
    IP+=2;
    return W;
}


float    Fetchfloat()
{
    float   f;

    f = *((float *)((unsigned long)CodeSeg+IP));
    IP+=4;
    return f;
}


void    Handle_a()
{
    ABSOLUTE = Fetchfloat();
}


void    Handle_r()
{
    REGISTER[0] = FetchByte();
}


void    Handle_i()
{
    ADDRESS = FetchWord();
}


void    Handle_rr()
{
    REGISTER[0] = FetchByte();
    REGISTER[1] = FetchByte();
}


void    Handle_ra()
{
    REGISTER[0] = FetchByte();
    ABSOLUTE = Fetchfloat();
}


void    SaveMapToFile()
{
    Word            X,Y;

    for (Y = 0; Y < 256; Y++) {
        for (X = 0; X < 256; X++) {
            fwrite(&RED[CURMAP][X][Y],1,1,OutFile);
            fwrite(&GREEN[CURMAP][X][Y],1,1,OutFile);
            fwrite(&BLUE[CURMAP][X][Y],1,1,OutFile);
        }
    }
}


void    ExecBlur()
{
    Word    X,Y;
    int     I,J;
    int     Redt,Greent,Bluet;

    for (Y = 0; Y <= 255; Y++) {
        for (X = 0; X <= 255; X++) {
            Redt = Greent = Bluet = 0;
            for (I = -1; I < 2; I++) {
                for (J = -1; J < 2; J++) {
                    Redt += BlurForm[I+1][J+1] * RED[CURMAP][(Byte)(X+J)][(Byte)(Y+I)];
                    Greent += BlurForm[I+1][J+1] * GREEN[CURMAP][(Byte)(X+J)][(Byte)(Y+I)];
                    Bluet += BlurForm[I+1][J+1] * BLUE[CURMAP][(Byte)(X+J)][(Byte)(Y+I)];
                }
            }
            RED[4][X][Y] = Redt / BlurDiv;
            GREEN[4][X][Y] = Greent / BlurDiv;
            BLUE[4][X][Y] = Bluet / BlurDiv;
        }
    }


    for (Y=0; Y<=255; Y++)
        for (X=0; X<=255; X++) {
            RED[CURMAP][X][Y] = RED[4][X][Y];
            GREEN[CURMAP][X][Y] = GREEN[4][X][Y];
            BLUE[CURMAP][X][Y] = BLUE[4][X][Y];
        }
}


void    ExecRNDD(Byte size)
{
    int     C,X,Y,XPos,YPos;
    Byte    rR,rB,rG;
    float   S_2;
    int     ofs;

    Byte    *Dot;

    size++;

    Dot = malloc(size*size);
    if (Dot == NULL) {
        printf("FATAL: Not enough memory\n");
        exit(EXIT_FAILURE);
    }

    S_2 = (float)size / 2;
    ofs = 0;
    for (Y = 0; Y < size; Y++) {
        for (X = 0; X < size; X++) {
            if (sqrt(((float)X-S_2)*((float)X-S_2) + ((float)Y-S_2)*((float)Y-S_2)) < (S_2-0.5)) *(Dot+ofs++) = 1;
            else *(Dot+ofs++) = 0;
        }
    }

    for (C=0; C<10000; C++) {
        rR = rand()%256;
        rG = rand()%256;
        rB = rand()%256;

        XPos = rand()%256;
        YPos = rand()%256;

        ofs = 0;
        for (Y = 0; Y < size; Y++) {
            for (X = 0; X < size; X++) {
                if (*(Dot+ofs) == 1) {
                    RED[CURMAP][(Byte)(XPos+X)][(Byte)(YPos+Y)] = rR;
                    GREEN[CURMAP][(Byte)(XPos+X)][(Byte)(YPos+Y)] = rG;
                    BLUE[CURMAP][(Byte)(XPos+X)][(Byte)(YPos+Y)] = rB;
                }
                ofs++;
            }
        }
    }

    free(Dot);
}


void    ProgramRun()
{
    float   Val1,Val2;
    Word    XPos,YPos;

	printf("\nPlease wait...");
	fflush(stdout);

    while (IP < CodeSize) {
        INSTRUCTION = FetchByte();
        switch(INSTRUCTION) {
            case  0 :   Handle_rr();        // MOVr,r
                        REGS[REGISTER[0]] = REGS[REGISTER[1]];
                        break;

            case  1 :   Handle_ra();        // MOVr,a
                        REGS[REGISTER[0]] = ABSOLUTE;
                        break;

            case  2 :   Handle_rr();        // ADDr,r
                        REGS[REGISTER[0]] += REGS[REGISTER[1]];
                        break;

            case  3 :   Handle_ra();        // ADDr,a
                        REGS[REGISTER[0]] += ABSOLUTE;
                        break;

            case  4 :   Handle_rr();        // SUBr,r
                        REGS[REGISTER[0]] -= REGS[REGISTER[1]];
                        break;

            case  5 :   Handle_ra();        // SUBr,a
                        REGS[REGISTER[0]] -= ABSOLUTE;
                        break;

            case  6 :   Handle_rr();        // MULr,r
                        REGS[REGISTER[0]] *= REGS[REGISTER[1]];
                        break;

            case  7 :   Handle_ra();        // MULr,a
                        REGS[REGISTER[0]] *= ABSOLUTE;
                        break;

            case  8 :   Handle_rr();        // DIVr,r
                        REGS[REGISTER[0]] /= REGS[REGISTER[1]];
                        break;

            case  9 :   Handle_ra();        // DIVr,a
                        REGS[REGISTER[0]] /= ABSOLUTE;
                        break;

            case 10 :   Handle_r();         // SQRr
                        REGS[REGISTER[0]] *= REGS[REGISTER[0]];
                        break;

            case 11 :   Handle_r();         // SQRTr
                        Val1 = REGS[REGISTER[0]];
                        REGS[REGISTER[0]] = sqrt(REGS[REGISTER[0]]);
                        break;

            case 12 :   Handle_rr();        // LDCr,r
                        XPos = (Byte)REGS[REGISTER[0]];
                        YPos = (Byte)REGS[REGISTER[1]];
                        REGS[RegR] = RED[CURMAP][XPos][YPos];
                        REGS[RegG] = GREEN[CURMAP][XPos][YPos];
                        REGS[RegB] = BLUE[CURMAP][XPos][YPos];
                        break;

            case 13 :   Handle_rr();        // STCr,r
                        XPos = (Byte)REGS[REGISTER[0]];
                        YPos = (Byte)REGS[REGISTER[1]];
                        RED[CURMAP][XPos][YPos] = (Byte)REGS[RegR];
                        GREEN[CURMAP][XPos][YPos] = (Byte)REGS[RegG];
                        BLUE[CURMAP][XPos][YPos] = (Byte)REGS[RegB];
                        break;

            case 14 :   Handle_r();         // INCr
                        REGS[REGISTER[0]]++;
                        break;

            case 15 :   Handle_r();         // DECr
                        REGS[REGISTER[0]]--;
                        break;

            case 16 :   Handle_rr();        // CMPr,r
                        Val1 = REGS[REGISTER[0]];
                        Val2 = REGS[REGISTER[1]];
                        EQUAL = LESS = GREATER = False;
                        if (Val1 == Val2) EQUAL = True;
                        if (Val1 < Val2) LESS = True;
                        if (Val1 > Val2) GREATER = True;
                        break;

            case 17 :   Handle_ra();        // CMPr,a
                        Val1 = REGS[REGISTER[0]];
                        Val2 = ABSOLUTE;
                        EQUAL = LESS = GREATER = False;
                        if (Val1 == Val2) EQUAL = True;
                        if (Val1 < Val2) LESS = True;
                        if (Val1 > Val2) GREATER = True;
                        break;

            case 18 :   Handle_i();         // JMPi
                        IP = ADDRESS;
                        break;

            case 19 :   Handle_i();         // JGi
                        if (GREATER == True) IP = ADDRESS;
                        break;

            case 20 :   Handle_i();         // JEi
                        if (EQUAL == True) IP = ADDRESS;
                        break;

            case 21 :   Handle_i();         // JLi
                        if (LESS == True) IP = ADDRESS;
                        break;

            case 22 :   Handle_i();         // JGEi
                        if (LESS == False) IP = ADDRESS;
                        break;

            case 23 :   Handle_i();         // JLEi
                        if (GREATER == False) IP = ADDRESS;
                        break;

            case 24 :   if (STACKINDEX == 0) {
                            printf("FATAL: Stack underflow\n");
                            exit(EXIT_FAILURE);
                        }
                        STACKINDEX--;
                        IP = STACK[STACKINDEX];
                        break;

            case 25 :   Handle_r();         // STMr
                        CURMAP = (Byte)REGS[REGISTER[0]]%4;
                        break;

            case 26 :   Handle_a();         // STMa
                        CURMAP=(Byte)ABSOLUTE;
                        if (CURMAP > 3) {
                            printf("FATAL: Mapnumber may not become larger than 3\n");
                            exit(EXIT_FAILURE);
                        }
                        break;

            case 27 :   Handle_r();         // LDZr
                        REGS[REGISTER[0]] = 0.0;
                        break;

            case 28 :   for (YPos = 0; YPos < 256; YPos++) {
                            for (XPos = 0; XPos < 256; XPos++) {
                                RED[CURMAP][XPos][YPos] = (Byte)REGS[RegR];
                                GREEN[CURMAP][XPos][YPos] = (Byte)REGS[RegG];
                                BLUE[CURMAP][XPos][YPos] = (Byte)REGS[RegB];
                            }
                        }
                        break;

            case 29 :   SaveMapToFile();	// SAVM
                        break;

            case 30 :   Handle_i();         // CALLi
                        STACK[STACKINDEX++] = IP;
                        IP = ADDRESS;
                        break;

            case 31 :   Handle_r();         // LDPIr
                        REGS[REGISTER[0]] = 3.1415926535;
                        break;

            case 32 :   Handle_r();         // SINr
                        REGS[REGISTER[0]] = sin(REGS[REGISTER[0]]);
                        break;

            case 33 :   Handle_r();         // COSr
                        REGS[REGISTER[0]] = cos(REGS[REGISTER[0]]);
                        break;

            case 34 :   ExecBlur();         // BLUR
                        break;
                        
			case 35	:						// MONO
						for (YPos = 0; YPos < 256; YPos++) {
							for (XPos = 0; XPos < 256; XPos++) {
								Val1 = (float)RED[CURMAP][XPos][YPos] * 0.3;
								Val1 += (float)GREEN[CURMAP][XPos][YPos] * 0.59;
								Val1 += (float)BLUE[CURMAP][XPos][YPos] * 0.11;
								RED[CURMAP][XPos][YPos] = (Byte)Val1;
								GREEN[CURMAP][XPos][YPos] = (Byte)Val1;
								BLUE[CURMAP][XPos][YPos] = (Byte)Val1;
							}
						}
						break;

            case 36 :   for (YPos = 0; YPos < 256; YPos++) {
                            for (XPos = 0; XPos < 256; XPos++) {
                                RED[CURMAP][XPos][YPos] = rand()%256;
                                GREEN[CURMAP][XPos][YPos] = rand()%256;
                                BLUE[CURMAP][XPos][YPos] = rand()%256;
                            }
                        }
                        break;

            case 37 :   ExecRNDD(5);        // RNDD
                        break;

            case 38 :   Handle_a();         // RNDDa
                        ExecRNDD((Byte)ABSOLUTE);
                        break;

            case 41 :   Handle_r();         // CLIPr
                        if (REGS[REGISTER[0]] > 255.0) REGS[REGISTER[0]] = 255.0;
                        if (REGS[REGISTER[0]] < 0.0) REGS[REGISTER[0]] = 0.0;
                        break;

            default :   printf("FATAL: Unknown instruction at IP address %d\n",IP-1);
                        printf(" Instruction code %d\n",INSTRUCTION);
                        exit(EXIT_FAILURE);
                        break;
        }
    }
    
    printf("Done\n");
}


void    LoadTChipCode(char *FileName)
{
    FILE    *CodeFile;

    Word    EntryPoint;

    if (CodeSeg != NULL) free(CodeSeg);

    CodeFile = fopen(FileName,"rb");
    if (CodeFile == NULL) {
        printf("FATAL: Unable to open the input file for reading (%s)\n\n",FileName);
        exit(EXIT_FAILURE);
    }

    fseek(CodeFile,0,SEEK_END);
    CodeSize = ftell(CodeFile);
    fseek(CodeFile,0,SEEK_SET);

    if (CodeSize < 5) {
        printf("FATAL: Not enough TChip input code\n");
        exit(EXIT_FAILURE);
    }

    if (fread(&EntryPoint,2,1,CodeFile) != 1) {
        printf("FATAL: Unable to read from the input file (%s)\n",FileName);
        exit(EXIT_FAILURE);
    }

	CodeSize -= 2;

    printf(" Input file          : %s\n",FileName);
    printf(" Code size           : %d\n",CodeSize);
    printf(" Entry point         : %d\n",EntryPoint);

    CodeSeg = malloc(CodeSize);
    if (CodeSeg == NULL) {
        printf("FATAL: Not enough memory\n");
        exit(EXIT_FAILURE);
    }

    if (fread(CodeSeg,CodeSize,1,CodeFile) != 1) {
        printf("FATAL: Unable to read code from the input file (%s)\n",FileName);
        exit(EXIT_FAILURE);
    }

    fclose(CodeFile);

    IP = EntryPoint;
}



void	main(int argc,char **argv)
{
    printf("\nTChip  v0.1  Copyright (c) 1997 Image!\n\n");

	if (argc != 3) {
		printf("Usage:\n  tchip <infile.ext> <outfile.ext>\n\n");
		printf("Be aware that you specify a file with assembled tchip code!\n");
		printf("The output file will be saved in RGB format (8 bits per pixel)\n\n");
		exit(EXIT_FAILURE);
	}

    LoadTChipCode(argv[1]);
    
    OutFile = fopen(argv[2],"wb");
    if (!OutFile) {
    	printf("FATAL: Unable to create the output file (%s)\n",argv[2]);
    	exit(EXIT_FAILURE);
    }

	printf(" Output file         : %s\n",argv[2]);

    ProgramRun();
    
    if (!CodeSeg) free(CodeSeg);
    fclose(OutFile);
}

