/***************************************************************
 *         aPLib v0.12b  -  the smaller the better :)          *
 *                                                             *
 *    Copyright (c) 1998 by  Jibz  All Rights Reserved     *
 ***************************************************************/

#include <string.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <conio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include "cursor.h"
#include "..\watcom\apdepack.h"
#include "..\watcom\aplib.h"

char *versionstr = "aPLib-Pack v0.12b";

unsigned char rotator[] = "-\\|/";
int rotatorpos = 0;

// File-stuff
int pl = -1, pl2 = -1;   // pl - source file, pl2 - destination file

// Global variables used
unsigned int plsize, pl2size;
unsigned int imagesize, codesize;
unsigned char *outbuffer = NULL, *inbuffer = NULL, *testbuffer = NULL;
unsigned char *output = NULL, *input = NULL, *test = NULL;

// counter to keep track of when to output info
unsigned int counter = 0;

// FUNCTIONS................................

// Some I/O error handler :)
void error(int n)
{
        printf("\n\n\007ERR: ");
        switch (n)
        {
                case 1: printf("Unable to open input-file!\n"); break;
                case 3: printf("Unable to read from input-file!\n"); break;
                case 4: printf("Unable to create output-file!\n"); break;
                case 5: printf("Aborted by user!\n"); break;
                case 6: printf("Not enough memory!\n"); break;
                case 7: printf("Unable to write to output-file!\n"); break;
                case 8: printf("An error occured while packing!\n"); break;
                default: printf("An unknown error occured!\n");
        }
        if (outbuffer != NULL) free(outbuffer);
        if (inbuffer != NULL) free(inbuffer);
        if (pl != -1) close(pl);
        if (pl2 != -1) close(pl2);
#ifdef __CURSOR_H
        curson();
#endif
        exit(n);
}

void syntax()
{
                printf("  Syntax:   aPPack <input file> [output file]\n\n");
}

void __near __cdecl callback(unsigned int inpos, unsigned int outpos)
{
                  unsigned char ch;
                  printf("\r%c Packing data                 -> %3d%%", rotator[rotatorpos], inpos * 100 / plsize);
                  rotatorpos = (rotatorpos + 1) & 0x0003;

                  // Check for ESC-hit
                  if (kbhit())
                  {
                          ch = getch();
                          if (ch == 0) ch = getch();
                          if (ch == 27)
                          {
                            error(5);
                          }
                  }
}

// Here main code begins!
int main(int argc, char *argv[])
{
        unsigned int i, j, ile, lasti, packedlength, an_error;
        int infilearg = 0, outfilearg = 0;

        printf("\n");
        printf("%-20s       Copyright (c) 1998 by  Jibz  All Rights Reserved\n", versionstr);
        printf("\n\n");

        // Write syntax when not enough parameters
        if (argc < 2)
        {
                syntax();
                return(1);
        }

        // Parse command line
        for (i = 1; i < argc; i++)
        {
             if (infilearg != 0)
             {
                 if (outfilearg == 0) outfilearg = i;
             } else infilearg = i;
        }

        // print syntax if no in-file
        if (infilearg == 0)
        {
                syntax();
                return(1);
        }

#ifdef __CURSOR_H
        cursoff();
#endif

        printf(" Opening files\n");

        // Open source file
        if ((pl = open(argv[infilearg], O_RDONLY | O_BINARY)) == -1) error(1);

        lseek(pl, 0, SEEK_SET);
        plsize = filelength(pl);
        if (plsize < 64) error(2);

        imagesize = plsize;
        codesize = imagesize;

        printf("   - Data size    : %lu bytes\n", codesize);

        // Create out file
        if (outfilearg != 0)
        {
                if ((pl2 = open(argv[outfilearg], O_WRONLY | O_CREAT | O_BINARY | O_TRUNC, S_IREAD | S_IWRITE)) == -1) error(4);
        } else {
                printf("   - No output file specified ... writing to 'OUT.DAT'\n");
                if ((pl2 = open("OUT.DAT", O_WRONLY | O_CREAT | O_BINARY | O_TRUNC, S_IREAD | S_IWRITE)) == -1) error(4);
        }

        printf(" Allocating memory\n");
        // Allocate memory for compression buffers
        if ((inbuffer = input = (unsigned char *) malloc(plsize)) == NULL) error(6);
        if ((testbuffer = test = (unsigned char *) malloc(plsize)) == NULL) error(6);
        if ((outbuffer = output = (unsigned char *) malloc(((codesize*9)/8)+16)) == NULL) error(6);

        // Read data into memory
        lseek(pl, 0, SEEK_SET);
        read(pl, inbuffer, codesize);

        // Pack data
        if ((packedlength = aP_pack(inbuffer, outbuffer, codesize, callback)) == 0) error(8);

        output = output + packedlength;

        printf("\r Packing data                 -> %u bytes\n", output - outbuffer);

        // Write code to output file
        lseek(pl2, 0, SEEK_SET);
        write(pl2, outbuffer, output-outbuffer);
        pl2size = filelength(pl2);


        printf(" Depacking and comparing      -> ");

        // Depack compressed data
        aP_depack_asm_fast(outbuffer, test);

        // Compare decompressed data to original data
        an_error = 0;
        for (i = 0; i < plsize; i++) if (test[i] != inbuffer[i]) an_error = 1;

        if (an_error) printf("There were errors!\n"); else printf("Ok.\n");

        // Free memory for compression buffers
        printf(" Freeing memory\n");
        if (outbuffer != NULL) free(outbuffer);
        if (inbuffer != NULL) free(inbuffer);

        // close in and out files
        printf(" Closing files\n");
        if (pl2 != -1) close(pl2);
        if (pl != -1) close(pl);

        printf("\nDone ... compression ratio: %d%% ", 100 - ((pl2size * 100) / plsize));
        printf("(%lu bytes -> %lu bytes)\n", plsize, pl2size);

#ifdef __CURSOR_H
        curson();
#endif

        return (0);
}
