;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        macros for system and real-time clock (TRC) handling         
;     

;-----------------------------------------------------------------------------
ReadInt8Vect     macro    address         ; destroys ES, EAX
                 xor      ax,ax
                 mov      es,ax
                 mov      eax,es:[8*4]
                 mov      dword ptr address,eax
                 endm
;-----------------------------------------------------------------------------
SetInt8VectTo    macro    seg_, label_    ; destroys ES
                 push     0
                 pop      es
                 mov      word ptr es:[8*4],offset label_
                 mov      word ptr es:[8*4+2],seg_
                 endm
;-----------------------------------------------------------------------------
SetInt8VectFrom  macro    address         ; destroys ES, EAX
                 xor      ax,ax
                 mov      es,ax
                 mov      eax,dword ptr address
                 mov      es:[8*4],eax
                 endm
;-----------------------------------------------------------------------------
SetTimerFreq     macro    frequence       ; destroys AX CX DX
                 local    @@1, @@2
                 mov      al,36h
                 out      43h,al
                 mov      ax,34DCh
                 mov      dx,12h
                 mov      cx,frequence
                 cmp      cx,18
                 ja       short @@1
                 mov      ax,0FFFFh
                 jmp      short @@2
@@1:             div      cx
@@2:             out      40h,al
                 mov      al,ah
                 out      40h,al
                 endm
;-----------------------------------------------------------------------------
SetDefTimerFreq  macro                ; destroys AX
                 mov      al,36h
                 out      43h,al
                 mov      al,0FFh
                 out      40h,al
                 out      40h,al  ; 1234dch/0ffffh = 18.2067
                 endm
;-----------------------------------------------------------------------------
RTC_GetReg       macro    reg  ; returns in AL the specified Real-Time-Clock register
                 mov      al,reg
                 out      70h,al
                 nop      
                 nop
                 nop
                 nop  ; four nops!... awful... 
                 in       al,71h
                 endm
;-----------------------------------------------------------------------------
RTC_SetRegAL     macro    idx  ; sets the specified RTC register to the given value in AL
                 mov      ah,al
                 mov      al,idx
                 out      70h,al
                 nop
                 nop
                 nop
                 nop  ; another four nops... undescriptable...
                 mov      al,ah
                 out      71h,al
                 endm
;-----------------------------------------------------------------------------
RTC_SetReg       macro    idx,value   ; sets the specified RTC register to a given value
                 mov      al,idx
                 out      70h,al
                 nop
                 nop
                 nop
                 nop  ; I'll quit for sure...
                 mov      al,value
                 out      71h,al
                 endm
;-----------------------------------------------------------------------------
RTC_Enable       macro                ; activate the 1024 Hz RTC

                 RTC_GetReg   0Ah
                 or           al,82h     ; "update in progress" flag  - is it necessarry ?
                 RTC_SetRegAL 0Ah

                 RTC_GetReg   0Bh
                 and          al,7Fh     ; "run" flag
                 or           al,40h     ; "enable periodic interrupt" flag
                 RTC_SetRegAL 0Bh

                 RTC_GetReg   0Ch
                 or           al,0F0h    ; interrupt request
                 RTC_SetRegAL 0Ch

                 in       al,0A1h
                 and      al,0FEh
                 nop
                 out      0A1h,al        ; unmask IRQ8

                 endm
;-----------------------------------------------------------------------------
RTC_Disable      macro            ; Deactivate the 1024 Hz RTC

                 RTC_SetReg   0Ah,26h      ; divider=2, use 1024 Hz rate, no half

                 RTC_GetReg   0Bh
                 and          al,0BFh
                 RTC_SetRegAL 0Bh

                 RTC_GetReg   0Ch
                 and          al,7Fh      ; interrupt request flag off
                 RTC_SetRegAL 0Ch

                 in       al,0A1h
                 or       al,1
                 nop  ; NOPs suck !!!!!
                 out      0A1h,al          ; mask IRQ8

                 endm
;-----------------------------------------------------------------------------
RTC_Request      macro              ; send a request for a new interrupt
                 RTC_GetReg   0Ch                      ; get RTC register # 0Ch
                 or           al,0F0h                  ; interrupt request flags
                 RTC_SetRegAL 0Ch                      ; set it
                 endm
;-----------------------------------------------------------------------------
ReadInt70Vect    macro    address         ; destroys ES, EAX
                 xor      ax,ax
                 mov      es,ax
                 mov      eax,es:[70h*4]
                 mov      dword ptr address,eax
                 endm
;-----------------------------------------------------------------------------
SetInt70VectTo   macro    seg_, label_    ; destroys AX
                 push     es
                 xor      ax,ax
                 mov      es,ax
                 mov      ax,offset label_
                 mov      es:[70h*4],ax
                 mov      es:[70h*4+2],seg_
                 pop      es
                 endm
;-----------------------------------------------------------------------------
SetInt70VectFrom macro    address         ; destroys AX
                 push     es
                 push     0
                 pop      es
                 mov      eax,dword ptr address
                 mov      es:[70h*4],eax
                 pop      es
                 endm
