COMMENT _

     /-----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996-1997                   |
     |   Windows Sound System driver                                  |
     |  Notes:                                                         |
     |    * only in stereo, mono is not implemented                    |
     |    * This driver hasn't been tested yet!                        |
     \-----------------------------------------------------------------/
_

wssDesc   db       "Windows Sound System driver v0.05"
          db       " (Crystal/Analog CODEC - CS4231 and AD1848),"
          db       " by Maple Leaf, 1996-1997"

;
;   Functions-Offsets Table
;

wss_driver dw       offset drvg_InitDriver     ;;
           dw       offset drvg_DoneDriver     ;;
           dw       offset wss_StartMixer      ;;
           dw       offset wss_StopMixer       ;;
           dw       offset mx_SetVoiceVolume   ;;
           dw       offset mx_GetVoiceVolume   ;;
           dw       offset mx_SetVoicePanning  ;;
           dw       offset mx_GetVoicePanning  ;;
           dw       offset mx_SetVoiceFreq     ;;
           dw       offset mx_GetVoiceFreq     ;;
           dw       offset mx_PlayVoice        ;;
           dw       offset mx_StopVoice        ;;
           dw       offset mx_SetGlobalVolume  ;;
           dw       offset mx_SetAmplification ;;
           dw       offset mx_DoPoll_stereo    ;; poll
           dw       offset wss_NOP             ;; set master volume - does WSS have something like that ?
           dw       offset mx_TickAwaited      ;;


;
;   Driver's internal data
;

;
; Windows Sound System's base port addresses are:
; 530h (default), 604h, 0E80h, 0F40h, 32Ch(?)
;

wssRates dw	 8000, 0000h
         dw	 5513, 0001h
         dw	16000, 0002h
         dw	11025, 0003h
         dw	27429, 0004h
         dw	18900, 0005h
         dw	32000, 0006h
         dw	22050, 0007h
         dw	    0, 0008h    ; N/A
         dw	37800, 0009h
         dw	    0, 000Ah    ; N/A
         dw	44100, 000Bh
         dw	48000, 000Ch
         dw	33075, 000Dh
         dw	 9600, 000Eh
         dw	 6615, 000Fh

wss_MixSpd dw    48000
wssSpd     db    0
wssOLmute  db    0
wssORmute  db    0

wss_NOP:retn

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

nproc   wss_StartMixer

        ClipFreq 5513, 48000  ; min 5513 Hz, max 48 kHz

        and      edx,0FFFFh
        call     wss_StoreFrequency

        mov      cs:dmAutoInit,1 ; WSS supports autoinit dma, so here we go !

        call     wss_Init       ; Configure and init WSS, start 8-bit output
                                ; this routine will also overwrite the values
                                ; of mxMixSpd and cMixSpd

        ClipVoices 4, 32

        mov      cs:mxVoices,ax        ; Store max # of active voices

        mov      dx,cs:cMixSpd

        call     mxBuildPeriods_stereo ; Build the periods table
        call     mxBuildProcTab_stereo ; Build the Post-Processing Table

        call     mxInitVars_stereo     ; Init all internal counters

        call     dmStartDMA            ; Start 8-bit DMA, WSS uses Autoinit mode

        retn
nendp   wss_StartMixer

;
;   StopMixer ()
;

nproc   wss_StopMixer
        call     dmStopDMA           ; turn off DMA transmission
        call     wss_Close           ; uninitialize WSS, shut it up
        retn
nendp   wss_StopMixer

;-- Other routines (internally used) ----------------------------------------

nproc   wssWait
        push     ax cx dx
        clc
        mov      dx,cs:mxPort
        add      dx,4
        mov      cx,8000h
wssL1:  in       al,dx
        test     al,al
        jns      wssok1      ; wait until bit 7 is zero
        loop     wssL1
        stc                  ; CODEC has a fuckin problem...
wssok1: pop      dx cx ax
        retn
nendp   wssWait

nproc   wss_Init             ; In: DX=mix rate
        push     si eax bx cx edx

        mov      dx,cs:mxPort
        add      dx,4              ; CODEC index address register
        in       al,dx             ; busy ?
        test     al,al
        jns      wssNB
        jmp      wssError

     ; the following part is not necessarry

wssNB:  mov      al,0Ch
        out      dx,al             ; select misc. register
        inc      dx
        in       al,dx             ; get CODEC version
        mov      bl,al             ; save it into BL
        xor      al,al
        out      dx,al             ; try to overwrite the misc. reg
        jmp      short $+2
        in       al,dx             ; read it again
        cmp      al,bl             ; has the value changed ?
        je       wssok2            ; if yes, this is not a CODEC
        jmp      wssError

     ; test IRQ number and determine CODEC's value for that IRQ

wssok2: mov      bl,cs:mxIrq
        cmp      bl,7               ; IRQ7 ?
        je       wssi7
        cmp      bl,9               ; IRQ9 ?
        je       wssi9
        cmp      bl,10              ; IRQ10 ?
        je       wssi10
        cmp      bl,11              ; IRQ11 ?
        je       wssi11
        ; else set the default (IRQ7)...

wssi7:  mov      al,08h
        jmp      short wssd
wssi9:  mov      al,10h
        jmp      short wssd
wssi10: mov      al,18h
        jmp      short wssd
wssi11: mov      al,20h

     ; test DMA channel used and determine CODEC value for that DMA chn.

wssd:   mov      bl,cs:mxDma
        cmp      bl,0               ; DMA #0 ?
        je       short wssd0
        cmp      bl,1               ; DMA #1 ?
        je       short wssd1
        cmp      bl,3               ; DMA #3 ?
        je       short wssd3
        jmp      short wssd1        ; else, the default (DMA #1)

wssd0:  or       al,01h
        jmp      short wssset
wssd1:  or       al,02h
        jmp      short wssset
wssd3:  or       al,03h

     ; set the IRQ and DMA value just determined

wssset: mov      dx,cs:mxPort
        out      dx,al              ; set IRQ and DMA

 ; I personally do not have the WSS SDK, but in the "documentation" I have
 ; there is specified that WSS doesn't use any interrupts when using Autoinit
 ; DMA, so I won't set any IRQ handler.

     ; find the closest match of the Mixing Rate in the wssRates table

        mov      cx,16
        mov      si,offset wssRates
        mov      bx,si
        mov      dx,32767
wssL3:  mov      ax,cs:[si]         ; extract rate from the table
        add      si,2
        sub      ax,cs:wss_MixSpd   ; compute distance from wanted mix. rate
        js       wssign
        cmp      ax,dx              ; distance greater than best match ?
        jae      wssign             ; yeah, ignore it
        mov      dx,ax              ; store new distance
        mov      bx,cs:[si]         ; rate number for this match
wssign: add      si,2
        loop     wssL3
        mov      cs:wssSpd,bl       ; store rate number
        shl      bx,2
        mov      ax,cs:wssRates[bx] ; get rate from table


        movzx    edx,ax
        call     wss_StoreFrequency


     ; External mute ON

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0Ah
        out      dx,al
        inc      dx
        in       al,dx
        or       al,40h
        out      dx,al

     ; small delay to prevent clicks

        mov      cx,1200h
wssL4:  in       al,84h
        loop     wssL4

     ; write zero to Pin Control

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0Ah
        out      dx,al
        inc      dx
        xor      al,al
        out      dx,al

     ; set single DMA mode and start autocalibration

        dec      dx            ; Base+4
        mov      al,49h        ; Enable MCE
        out      dx,al
        inc      dx
        mov      al,04h or 08h ; single DMA channel, enable
        out      dx,al         ; autocalibration
        in       al,dx
        in       al,dx

     ; set playing rate and output format

        dec      dx            ; Base+4
        mov      al,48h
        out      dx,al         ; enable MCE and set Clock and Data Format Register (08h)
        inc      dx            ; Base+5
        mov      al,cs:wssSpd  ; get predetermined rate id
        or       al,0          ; 8 bit unsigned linear (or al,40h for 16 bit signed linear)
        or       al,10h        ; bit 4 = 1 = stereo (0 for mono)
        out      dx,al         ; set mode
        in       al,dx
        in       al,dx
        call     wssWait       ; wait for CODEC initialization to complete
        jnc      wssok3
        jmp      wssError      ; error, cannot init CODEC

     ; disable MCE

wssok3: mov      dx,cs:mxPort
        add      dx,4

wssL5:  mov      al,8
        out      dx,al         ; Disable MCE
        jmp      short $+2
        in       al,dx
        cmp      al,08h        ; the OUT got through ?
        jne      wssL5         ; hope it won't lock the computer...

     ; delay to ensure the autocalibration has started

        mov      cx,10000
wssL6:  in       al,84h
        loop     wssL6

     ; Wait until the autocalibration is finished. First check that we
     ; do get the Test and the Initialization register number written to
     ; the index

wssL7:  mov      al,0Bh
        out      dx,al
        jmp      short $+2
        in       al,dx
        cmp      al,0Bh
        jne      wssL7

     ; wait until the autocalibration is finished (bit 5 becomes 0)

wssL8:  mov      al,0Bh
        out      dx,al
        inc      dx
        in       al,dx
        dec      dx
        test     al,20h
        jnz      wssL8

     ; Set single DMA channel mode, disable autocalibration

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,49h
        out      dx,al
        inc      dx
        mov      al,04h
        out      dx,al
        dec      dx
        xor      al,al
        out      dx,al   ; Disable MCE

     ; delay to prevent clicks

        mov      cx,1200h
wssL10: in       al,84h
        loop     wssL10

     ; external mute OFF

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0Ah
        out      dx,al
        inc      dx
        in       al,dx
        and      al,NOT 40h
        out      dx,al

     ; acknowledge CODEC interrupt

        mov      dx,cs:mxPort
        add      dx,6
        xor      al,al
        out      dx,al

     ; set DMA transfer count (buffer's size)

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0Fh
        out      dx,al
        inc      dx
        mov      ax,DMABufSize*16       ; could be set to 0FFFFh, since
                                        ; DMA controller takes care of
                                        ; wrapping in autoinit dma mode

        out      dx,al                  ; set lower 8 bits
        dec      dx
        mov      al,0Eh
        out      dx,al
        inc      dx
        mov      al,ah
        out      dx,al                  ; set upper 8 bits

     ; write 0 to Pin Control register

        dec      dx
        mov      al,0Ah
        out      dx,al
        inc      dx
        xor      al,al
        out      dx,al

     ; write to Interface Configuration

        mov      dx,cs:mxPort
        add      dx,4
        mov      al,9
        out      dx,al
        inc      dx                     ; Base+5
        mov      al,5
        out      dx,al                  ; use DMA playback
        dec      dx                     ; Base+4
        mov      al,6
        out      dx,al
        inc      dx                     ; Base+5
        in       al,dx
        mov      cs:wssOLmute,al        ; save old left mute
        and      al,NOT 128
        out      dx,al                  ; mute off Left channel
        dec      dx                     ; Base+4
        mov      al,7
        out      dx,al
        inc      dx                     ; Base+5
        in       al,dx
        mov      cs:wssORmute,al        ; save old mute right
        and      al,NOT 128
        out      dx,al                  ; mute off right channel

     ; Now the WSS is ready to receive data from DMA controller.
     ; It is assumed that no IRQs will be generated or that DMA is
     ; scanning in Autoinit status.

        pop      edx cx bx eax si
        retn

wssError:                             ; there's a problem with the CODEC
        pop      edx cx bx eax si     ; or the CODEC is busy
        retn
nendp   wss_Init

nproc   wss_Close
        push     dx ax

        mov      dx,cs:mxPort
        add      dx,4

     ; restore old mute status to the Left channel

        mov      al,6
        out      dx,al
        inc      dx
        mov      al,cs:wssOLmute
        out      dx,al

     ; restore old mute status to the Right channel

        dec      dx
        mov      al,7
        out      dx,al
        inc      dx
        mov      al,cs:wssORmute
        out      dx,al

     ; turn off interrutps

        dec      dx
        mov      al,0Ah
        out      dx,al
        inc      dx
        mov      al,0
        out      dx,al

     ; acknowledge outstanding interrupts

        inc      dx   ; Base+6
        out      dx,al

     ; turn off CODEC's DMA

        sub      dx,2
        mov      al,9
        out      dx,al
        inc      dx
        mov      al,0
        out      dx,al

     ; WSS has been shut down

        pop      ax dx
        retn
nendp   wss_Close

;****************************************************************************

nproc   wss_StoreFrequency       ; in: EDX = frequency

        mov      cs:wss_MixSpd,dx

; There is a small problem here... I really don't know whether the CODEC
; supports 48 kHz stereo (48 kHz/channel) or 24 kHz stereo (48 kHz/total).
; I only suppose that the first is correct... So, if you have more information
; about this problem and you're absolutely sure that the second is the correct
; one, then comment the first marked area and uncomment the second.

; for 48 kHz/channel 
        mov      cs:cMixSpd,dx
        add      edx,edx
        mov      cs:mxMixSpd,edx
;

; for 24 kHz/channel (48 kHz/total) 
;       mov      cs:mxMixSpd,edx
;       shr      edx,1
;       mov      cs:cMixSpd,dx
;

        retn

nendp   wss_StoreFrequency
