COMMENT $

     Ŀ
       Sound Deluxe System 5                                          
       by Maple Leaf (a.k.a Gruian Radu), 1996-97                     
        Sound Cards detection and initialization routines            
       Assemble it with TASM 3.x: tasm /mx /o /w0 sds_det.asm         
     
$

.model TPascal
.386

.DATA
;*****************************************************************************
;   Data Definitions
;*****************************************************************************

        extrn    Base:WORD
        extrn    Irq:WORD
        extrn    Dma:WORD
        extrn    Card:WORD  ; 0=none(not detected)
        local    OIrq2:DWORD
        local    OIrq3:DWORD
        local    OIrq5:DWORD
        local    OIrq7:DWORD
        local    OIrq10:DWORD
        local    OIrq12:DWORD

        local    OMask:WORD
.CODE
;*****************************************************************************
;   Code's Public Definitions
;*****************************************************************************
        ;  SoundBlaster v1.0 and 2.0
        public   InitSB
        public   DetectSB
        ;  SoundBlaster Pro (DSP 3.x)
        public   InitSBPro
        public   DetectSBPro
        ;  SoundBlaster 16ASP & 32AWE  (DSP v4.0 & v5.0)
        public   InitSB16
        public   DetectSB16
        ;  Gravis UltraSound & UltraSound MAX
        public   InitGUS
        public   DetectGUS
        ;  MediaVision ProAudio Spectrum
        public   InitPAS
        public   DetectPAS
        ;  Windows Sound System (Crystal/Analog CODEC)
        public   InitWSS
        public   DetectWSS
        ;  ARIA soundcard
        public   InitARIA
        public   DetectARIA


;*****************************************************************************
;   Code's Local Definitions
;*****************************************************************************

include macros.inc  ; uyseful macros
include equ.inc     ; symbols, constants

Descrip db       "Detection/Initialization routines v0.5, by Maple Leaf, 1996-1997"

DmaPage dw       0087h, 0083h, 0081h, 0082h, 0000, 008bh, 0089h, 008ah
IrqNo   dw       0
BaseNo  dw       0

GUSenv  db       "ULTRASND",0
SBenv   db       "BLASTER",0   ; although not used yet...
ARIAenv db       "ARIA",0

PASdef  equ      388h   ; Default base
PASb1   equ      384h   ;
PASb2   equ      38Ch   ;
PASb3   equ      288h   ; The other possible basis
PASb4   equ      280h   ;
PASb5   equ      284h   ;
PASb6   equ      28Ch   ;

WSSb1   equ      530h   ; default base
WSSb2   equ      604h   ;
WSSb3   equ      0E80h  ; the other possible basis
WSSb4   equ      0F40h  ;

;*****************************************************************************
;   SoundBlaster v1.0 and v2.0 (mono)
;   Note: without using the BLASTER environment variable !
;*****************************************************************************

SB_Desc db       "Sound Blaster and Sound Blaster 2.0"

SBCommand:  ; Send to SB's DSP a command specified into AL
        push     cx dx ax
        mov      dx,Base
        add      dx,0Ch
        mov      cx,1000     ; It works alright, although it's a quite short time loop ...
sb_l3:  in       al,dx
        or       al,al
        jns      sb_o1
        loop     sb_l3
        jmp      short sb_err4
sb_o1:  pop      ax
        out      dx,al
        push     ax
sb_err4:pop      ax dx cx
        retn

ResetSB proc     near
        push     ax cx dx
        mov      dx,Base
        add      dx,6
        mov      al,1
        out      dx,al
        db       7 dup (0ECh) ; in al,dx   -> 7 times
        sub      al,al
        out      dx,al
        add      dx,8       ; 2xEh
        mov      cx,1000
sb_1:   in       al,dx
        and      al,80h
        loopz    sb_1
        jcxz     sb_Nobase
        sub      dx,4
        in       al,dx
        cmp      al,0aah
        jne      sb_Nobase
        ; Test version ...
        add      dx,2
        mov      al,0e1h
        out      dx,al
        add      dx,2       ; 2xEh
sb_2:   in       al,dx
        or       al,al
        jns      sb_2
        sub      dx,4       ; 2xAh
        in       al,dx
        mov      ah,al      ; Store high version
        add      dx,4
sb_3:   in       al,dx
        or       al,al
        jns      sb_3
        sub      dx,4            ; 2xAh
        in       al,dx           ; Store low version
        cmp      ax,100h         ; CHECK VERSION
        jb       sb_Nobase
sb_ok2: mov      Card,SB          ; STORE CARD # (0=none, 1=SB, ...)
        pop      dx cx ax
        clc      ; Success
        retn
sb_NoBase:
        pop      dx cx ax
        stc      ; Error
        retn
ResetSB endp

SBRestoreIrqs:
        push     dx ds
        cli
        mov      ax,250Ah
        lds      dx,dword ptr ds:OIrq2
        int      21h
        pop      ds
        push     ds
        mov      ax,250Bh
        lds      dx,dword ptr ds:OIrq3
        int      21h
        pop      ds
        push     ds
        mov      ax,250Dh
        lds      dx,dword ptr ds:OIrq5
        int      21h
        pop      ds
        push     ds
        mov      ax,250Fh
        lds      dx,dword ptr ds:OIrq7
        int      21h
        pop      ds
        push     ds
        mov      ax,2572h
        lds      dx,dword ptr ds:OIrq10
        int      21h
        pop      ds
        push     ds
        mov      ax,2574h
        lds      dx,dword ptr ds:OIrq12
        int      21h
        pop      ds
        mov      ax,OMask
        out      21h,al
        mov      al,ah
        out      0A1h,al
        sti
        pop      dx
        retn

Irq2:   mov      cs:IrqNo,2
        jmp      short sb_e1

Irq3:   mov      cs:IrqNo,3
        jmp      short sb_e1

Irq5:   mov      cs:IrqNo,5
        jmp      short sb_e1

Irq7:   mov      cs:IrqNo,7
        jmp      short sb_e1

Irq10:  mov      cs:IrqNo,10
        jmp      short sb_e1

Irq12:  mov      cs:IrqNo,12
        jmp      short sb_e1

sb_e1:  push     ax dx
        mov      dx,cs:BaseNo
        add      dx,0Eh
        in       al,dx
        pop      dx
        mov      al,20h
        out      20h,al
        out      0a0h,al
        pop      ax
        iret

nproc   StoreOldVect
        mov      ax,350Ah
        int      21h
        mov      word ptr OIrq2,bx
        mov      word ptr OIrq2[2],es
        mov      ax,350Bh
        int      21h
        mov      word ptr OIrq3,bx
        mov      word ptr OIrq3[2],es
        mov      ax,350Dh
        int      21h
        mov      word ptr OIrq5,bx
        mov      word ptr OIrq5[2],es
        mov      ax,350Fh
        int      21h
        mov      word ptr OIrq7,bx
        mov      word ptr OIrq7[2],es
        mov      ax,3572h
        int      21h
        mov      word ptr OIrq10,bx
        mov      word ptr OIrq10[2],es
        mov      ax,3574h
        int      21h
        mov      word ptr OIrq12,bx
        mov      word ptr OIrq12[2],es
        retn
nendp   StoreOldVect

MaskDet proc     near
        in       al,0A1h
        mov      ah,al
        in       al,21h
        mov      OMask,ax
        and      al,53h  ; not((1 shl 2) or (1 shl 3) or (1 shl 5) or (1 shl 7))
        out      21h,al
        mov      al,ah
        and      al,0EBh
        out      0A1h,al ; not((1 shl 2) or (1 shl 4))
        retn
MaskDet endp

nproc   SetTempVect
        cli
        push     ds
        push     cs
        pop      ds
        mov      dx,offset irq2
        mov      ax,250Ah
        int      21h
        mov      dx,offset irq3
        mov      ax,250Bh
        int      21h
        mov      dx,offset irq5
        mov      ax,250Dh
        int      21h
        mov      dx,offset irq7
        mov      ax,250Fh
        int      21h
        mov      dx,offset irq10
        mov      ax,2572h
        int      21h
        mov      dx,offset irq12
        mov      ax,2574h
        int      21h
        sti
        pop      ds
        retn
nendp   SetTempVect

nproc   Setup8237   ; in AX = dma channel #
        cmp      al,3
        ja       s_16bit
        mov      ah,al
        or       al,4
        out      0Ah,al  ; Mask DMA channel
        xor      al,4Ch
        out      0Bh,al  ; Select mode
        out      0Ch,al  ; Flip-Flop
        movzx    si,ah
        add      si,si
        mov      dx,cs:dmapage[si]
        xor      al,al
        out      dx,al   ; DMA page = 0
        mov      dx,si
        out      dx,al   ; linear 24-bit addr = 00000
        out      dx,al   ;
        inc      dx
        inc      al
        out      dx,al   ;
        dec      al      ; size = 1 byte
        out      dx,al   ;
        ; Enabling DMA channel ...
        mov      al,ah
        out      0Ah,al
        retn
s_16bit:
        sub      al,4    ; channel-4
        mov      ah,al   ; save it
        or       al,4
        out      0D4h,al ; Mask DMA channel
        mov      al,0
        out      0D8h,al ; clear flip-flop
        mov      al,ah
        or       al,48h
        out      0D6h,al ; set mode
        movzx    si,ah
        add      si,4
        add      si,si
        mov      dx,cs:dmapage[si]
        xor      al,al
        out      dx,al   ; DMA page = 0
        movzx    dx,ah
        shl      dx,2
        add      dx,0C0h
        xor      al,al
        out      dx,al   ; linear 24-bit addr = 00000
        out      dx,al   ;
        add      dx,2
        inc      al
        out      dx,al   ;
        dec      al      ; size = 1 byte
        out      dx,al   ;
        ; Enabling DMA channel ...
        mov      al,ah
        out      0D4h,al
        retn
nendp   Setup8237

nproc   Stop8237  ; ax=dma channel #
        cmp      al,3
        ja       st_16bit
        mov      ah,al
        or       al,4
        out      0Ah,al   ; mask channel again
        xor      al,4Ch   ; invalidate autoinit mode
        out      0Ch,al
        out      0Bh,al
  ; -----------
        movzx    si,ah
        add      si,si
        mov      dx,cs:dmapage[si]
        mov      al,0
        out      dx,al
        mov      dx,si
        out      dx,al
        out      dx,al
        inc      dx
        out      dx,al
        out      dx,al
  ; -----------
        mov      al,ah
        out      0Ah,al   ; enable
        retn
st_16bit:
        sub      al,4
        mov      ah,al
        or       al,4
        out      0D4h,al   ; mask channel again
        xor      al,4Ch    ; invalidate autoinit mode
        out      0D8h,al
        out      0D6h,al
  ; -----------
        movzx    si,ah
        add      si,4
        add      si,si
        mov      dx,cs:dmapage[si]
        mov      al,0
        out      dx,al ; page = 0
        movzx    dx,ah
        shl      dx,2
        add      dx,0C0h
        out      dx,al
        out      dx,al ; address
        add      dx,2
        out      dx,al
        out      dx,al ; counter
  ; -----------
        mov      al,ah
        out      0D4h,al   ; enable
        retn
nendp   Stop8237

IsSBDma proc     _Dma:WORD  ; :boolean
        push     bx cx dx si es
        mov      Irq,0
        mov      cs:IrqNo,0
        mov      ax,Base
        mov      cs:BaseNo,ax
        ; Store old interrupt vectors ...
        call     StoreOldVect
        ; Masking interrupts for detection ...
        call     MaskDet
        ; Set temporary interrupt vectors ...
        call     SetTempVect
        ; Turn off the SoundBlaster speaker ...
        mov      al,0D3h
        call     SBCommand
        ; Set the frequency = 22.05 KHz
        mov      al,040h
        call     SBCommand
        mov      al,0D3h
        call     SBCommand
        mov      ax,_Dma
        call     Stop8237
        ; Setup the 8237 DMA #1 controller ...
        mov      ax,_Dma
        call     Setup8237
        ; Send "Start Play" command to the SoundBlaster card
        mov      al,14h
        call     SBCommand
        mov      al,1
        call     SBCommand
        mov      al,0
        call     SBCommand
        ; A little loop for reaching the IRQ number ...
        mov      cx,0FFFFh
sb_l2:  cmp      cs:irqno,0
        jne      sb_f2
        loop     sb_l2
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        sub      al,al  ; Error !
        mov      Irq,0FFFFh
        pop      es si dx cx bx
        leave
        retf
sb_f2:  mov      ax,cs:irqno
        mov      Irq,ax
        mov      ax,_Dma
        mov      Dma,ax
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        mov      al,1   ; Success !
        pop      es si dx cx bx
        leave
        retf
IsSBDma endp

IsSBBase proc    _Base:WORD ; :boolean
        push     dx
        mov      ax,_Base
        mov      Base,ax
        call     ResetSB    ; Try to reset DSP using given base port
        jc       sb_err2
        mov      dx,0       ; No error, start w/ DMA channel #0
sb_l1:  push     dx
        call     far ptr cs:IsSBDma ; Is DX the correct DMA channel ?
        or       al,al
        jz       sb_nx1     ; No, check next
        jmp      short sb_f1
sb_nx1: inc      dx
        cmp      dx,2       ; Skip channel #2, used by the floppy-disk controller
        jne      sb_e4
        inc      dx
sb_e4:  cmp      dx,3       ; Exhausted all DMA channels ?
        jbe      sb_l1      ; If no, test the next DMA channel
sb_err2:mov      al,0       ; Error !
        mov      Dma,0FFFFh
        pop      dx
        leave
        retf
sb_f1:  mov      al,1       ; Success !
        mov      Dma,dx
        pop      dx
        leave
        retf
IsSBBase endp

InitSB  proc     _Base:WORD, _Irq:WORD, _Dma:WORD   ; :boolean
        mov      ax,_Base
        push     ax
        call     far ptr cs:IsSBBase
        or       al,al       ; Is the base correct ?
        jz       sb_err1     ; If no, error
        mov      ax,_Dma
        cmp      ax,Dma      ; Is the DMA channel correct ?
        jne      sb_err1     ; If no, error
        mov      ax,_Irq
        cmp      ax,Irq      ; Is the IRQ correct ?
        jne      sb_err1     ; If no, error
        mov      al,1        ; Success !
        leave
        retf
sb_err1:mov      al,0        ; Error !
        leave
        retf
InitSB  endp

DetectSB proc    _BasePtr:DWORD, _IrqPtr:DWORD, _DmaPtr:DWORD  ; :boolean
        push     di es
        push     210h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        push     220h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        push     230h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        push     240h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        push     250h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        push     260h
        call     far ptr cs:IsSBBase
        or       al,al
        jnz      sb_f3
        mov      al,0      ; Error, SB cannot be detected
        pop      es di
        leave
        retf
sb_f3:  les      di,_BasePtr    ; Success, store parameters ...
        mov      ax,Base
        stosw
        les      di,_IrqPtr
        mov      ax,Irq
        stosw
        les      di,_DmaPtr
        mov      ax,Dma
        stosw
        mov      al,1      ; Returns "TRUE"
        pop      es di
        leave
        retf
DetectSB endp

;*****************************************************************************
;   SoundBlaster Pro (DSP 3.x)
;   Note: without using the BLASTER environment variable !
;*****************************************************************************

SBPro_Desc db    "Sound Blaster Pro (DSP 3.x)"

ResetSBPro:
        push     ax cx dx
        mov      dx,Base
        add      dx,6
        mov      al,1
        out      dx,al
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        sub      al,al
        out      dx,al
        add      dx,8       ; 2xEh
        mov      cx,1000
sbp_1:  in       al,dx
        and      al,80h
        loopz    sbp_1
        jcxz     sbp_Nobase
        sub      dx,4
        in       al,dx
        cmp      al,0aah
        jne      sbp_Nobase
        ; Test version ...
        add      dx,2
        mov      al,0e1h
        out      dx,al
        add      dx,2       ; 2xEh
sbp_2:  in       al,dx
        or       al,al
        jns      sbp_2
        sub      dx,4       ; 2xAh
        in       al,dx
        mov      ah,al      ; Store high version
        add      dx,4
sbp_3:  in       al,dx
        or       al,al
        jns      sbp_3
        sub      dx,4       ; 2xAh
        in       al,dx      ; Store low version
        cmp      ax,300h    ; CHECK VERSION - Is SBPro indeed ?
        jb       sbp_Nobase ; If no, exit
sbp_ok2:mov      Card,SBP   ; STORE CARD # (0=none, 1=SB, 2=SBPro ...)
        pop      dx cx ax
        clc      ; Success
        retn
sbp_NoBase:
        pop      dx cx ax
        stc      ; Error
        retn

IsSBProDma proc     _Dma:WORD  ; :boolean
        push     bx cx dx si es
        mov      Irq,0
        mov      cs:IrqNo,0
        mov      ax,Base
        mov      cs:BaseNo,ax
        ; Store old interrupt vectors ...
        call     StoreOldVect
        ; Masking interrupts for detection ...
        call     MaskDet
        ; Set temporary interrupt vectors ...
        call     SetTempVect
        ; Turn off the SoundBlaster speaker ...
        mov      al,0D3h
        call     SBCommand
        ; Set the frequency = 22.05 KHz
        mov      al,040h
        call     SBCommand
        mov      al,0D3h
        call     SBCommand
        ; Stop the shitty channel
        mov      ax,_Dma
        call     Stop8237
        ; Setup the 8237 DMA #1 controller ...
        mov      ax,_Dma
        call     Setup8237
        ; Set transfer block size and start playing
        mov      al,48h
        call     SBCommand
        mov      al,1
        call     SBCommand
        mov      al,0
        call     SBCommand
        mov      al,91h
        call     SBCommand
        ; Enabling DMA channel ...
        ; A little loop for reaching the IRQ number ...
        mov      cx,0FFFFh
sbp_l2: cmp      cs:irqno,0
        jne      sbp_f2
        loop     sbp_l2
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        sub      al,al  ; Error !
        mov      Irq,0FFFFh
        pop      es si dx cx bx
        leave
        retf
sbp_f2:  mov      ax,cs:irqno
        mov      Irq,ax
        mov      ax,_Dma
        mov      Dma,ax
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        mov      al,1   ; Success !
        pop      es si dx cx bx
        leave
        retf
IsSBProDma endp

IsSBProBase proc    _Base:WORD ; :boolean
        push     dx
        mov      ax,_Base
        mov      Base,ax
        call     ResetSBPro ; Try to reset DSP using given base port
        jc       sbp_err2
        mov      dx,0       ; No error, start w/ DMA channel #0
sbp_l1: push     dx
        call     far ptr cs:IsSBProDma ; Is DX the correct DMA channel ?
        or       al,al
        jz       sbp_nx1     ; No, check next
        jmp      short sbp_f1
sbp_nx1:inc      dx
        cmp      dx,2       ; Skip channel #2, used by the floppy-disk controller
        jne      sbp_e4
        inc      dx
sbp_e4: cmp      dx,7       ; Exhausted all DMA channels ?
        jbe      sbp_l1      ; If no, test the next DMA channel
sbp_err2:mov     al,0       ; Error !
        mov      Dma,0FFFFh
        pop      dx
        leave
        retf
sbp_f1: mov      al,1       ; Success !
        mov      Dma,dx
        pop      dx
        leave
        retf
IsSBProBase endp

InitSBPro proc     _Base:WORD, _Irq:WORD, _Dma:WORD   ; :boolean
        mov      ax,_Base
        push     ax
        call     far ptr cs:IsSBProBase
        or       al,al       ; Is the base correct ?
        jz       sbp_err1     ; If no, error
        mov      ax,_Dma
        cmp      ax,Dma      ; Is the DMA channel correct ?
        jne      sbp_err1     ; If no, error
        mov      ax,_Irq
        cmp      ax,Irq      ; Is the IRQ correct ?
        jne      sbp_err1     ; If no, error
        mov      al,1        ; Success !
        leave
        retf
sbp_err1:mov      al,0        ; Error !
        leave
        retf
InitSBPro endp

DetectSBPro proc    _BasePtr:DWORD, _IrqPtr:DWORD, _DmaPtr:DWORD  ; :boolean
        push     di es
        push     210h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        push     220h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        push     230h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        push     240h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        push     250h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        push     260h
        call     far ptr cs:IsSBProBase
        or       al,al
        jnz      sbp_f3
        mov      al,0      ; Error, SB cannot be detected
        pop      es di
        leave
        retf
sbp_f3: les      di,_BasePtr    ; Success, store parameters ...
        mov      ax,Base
        stosw
        les      di,_IrqPtr
        mov      ax,Irq
        stosw
        les      di,_DmaPtr
        mov      ax,Dma
        stosw
        mov      al,1      ; Returns "TRUE"
        pop      es di
        leave
        retf
DetectSBPro endp

;*****************************************************************************
;   SoundBlaster 16ASP and AWE32 (DSP v4.00+)
;   Note: without using the BLASTER environment variable !
;*****************************************************************************

SB16_Desc db    "SoundBlaster 16 ASP (DSP 4.00+)"

ResetSB16:
        push     ax cx dx
        mov      dx,Base
        add      dx,6
        mov      al,1
        out      dx,al
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        sub      al,al
        out      dx,al
        add      dx,8       ; 2xEh
        mov      cx,1000
sba_1:  in       al,dx
        and      al,80h
        loopz    sba_1
        jcxz     sba_Nobase
        sub      dx,4
        in       al,dx
        cmp      al,0aah
        jne      sba_Nobase
        ; Test version ...
        add      dx,2
        mov      al,0e1h
        out      dx,al
        add      dx,2       ; 2xEh
sba_2:  in       al,dx
        or       al,al
        jns      sba_2
        sub      dx,4       ; 2xAh
        in       al,dx
        mov      ah,al      ; Store high version
        add      dx,4
sba_3:  in       al,dx
        or       al,al
        jns      sba_3
        sub      dx,4       ; 2xAh
        in       al,dx      ; Store low version
        cmp      ax,400h    ; CHECK VERSION - Is SB16 indeed ?
        jb       sba_Nobase ; If no, exit
sba_ok2:mov      Card,SB16  ; STORE CARD # (0=none)
        pop      dx cx ax
        clc      ; Success
        retn
sba_NoBase:
        pop      dx cx ax
        stc      ; Error
        retn

IsSB16Dma proc   _Dma:WORD  ; :boolean
        push     bx cx dx si es
        mov      Irq,0
        mov      cs:IrqNo,0
        mov      ax,Base
        mov      cs:BaseNo,ax
        ; Store old interrupt vectors ...
        call     StoreOldVect
        ; Masking interrupts for detection ...
        call     MaskDet
        ; Set temporary interrupt vectors ...
        call     SetTempVect
        ; Turn off the SoundBlaster speaker ...
        mov      al,0D3h
        call     SBCommand
        ; Set the frequency = 22.05 KHz
        mov      al,41h
        call     SBCommand
        mov      al,56h      ; high(frequency)
        call     SBCommand
        mov      al,22h      ; low(frequency)
        call     SBCommand
        ; Stop the shitty channel
        mov      ax,_Dma
        call     Stop8237
        ; Setup the 8237 DMA #1 controller ...
        mov      ax,_Dma
        call     Setup8237
        ; Start playing
        mov      al,0C6h
        call     SBCommand
        mov      al,20h
        call     SBCommand
        mov      al,1
        call     SBCommand
        mov      al,0
        call     SBCommand
        ; A little loop for reaching the IRQ number ...
        mov      cx,0FFFFh
sba_l2: cmp      cs:irqno,0
        jne      sba_f2
        loop     sba_l2
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        sub      al,al  ; Error !
        mov      Irq,0FFFFh
        pop      es si dx cx bx
        leave
        retf
sba_f2: mov      ax,cs:irqno
        mov      Irq,ax
        mov      ax,_Dma
        mov      Dma,ax
        call     SBRestoreIrqs
        mov      al,0D0h
        call     SBCommand        ; "Halt DMA"

        mov      ax,_Dma
        call     Stop8237

        mov      al,1   ; Success !
        pop      es si dx cx bx
        leave
        retf
IsSB16Dma endp

IsSB16Base proc    _Base:WORD ; :boolean
        push     dx
        mov      ax,_Base
        mov      Base,ax
        call     ResetSB16  ; Try to reset DSP using given base port
        jc       sba_err2
        mov      dx,0       ; No error, start w/ DMA channel #0
sba_l1: push     dx
        call     far ptr cs:IsSB16Dma ; Is DX the correct DMA channel ?
        or       al,al
        jz       sba_nx1     ; No, check next
        jmp      short sba_f1
sba_nx1:inc      dx
        cmp      dx,2       ; Skip channel #2, used by the floppy-disk controller
        jne      sba_e4
        inc      dx
sba_e4: cmp      dx,7       ; Exhausted all DMA channels ?
        jbe      sba_l1      ; If no, test the next DMA channel
sba_err2:mov     al,0       ; Error !
        mov      Dma,0FFFFh
        pop      dx
        leave
        retf
sba_f1: mov      al,1       ; Success !
        mov      Dma,dx
        pop      dx
        leave
        retf
IsSB16Base endp

InitSB16 proc     _Base:WORD, _Irq:WORD, _Dma:WORD   ; :boolean
        mov      ax,_Base
        push     ax
        call     far ptr cs:IsSB16Base
        or       al,al       ; Is the base correct ?
        jz       sba_err1     ; If no, error
        mov      ax,_Dma
        cmp      ax,Dma      ; Is the DMA channel correct ?
        jne      sba_err1     ; If no, error
        mov      ax,_Irq
        cmp      ax,Irq      ; Is the IRQ correct ?
        jne      sba_err1     ; If no, error
        mov      al,1        ; Success !
        leave
        retf
sba_err1:mov      al,0        ; Error !
        leave
        retf
InitSB16 endp

DetectSB16 proc    _BasePtr:DWORD, _IrqPtr:DWORD, _DmaPtr:DWORD  ; :boolean
        push     di es
        push     210h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        push     220h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        push     230h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        push     240h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        push     250h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        push     260h
        call     far ptr cs:IsSB16Base
        or       al,al
        jnz      sba_f3
        mov      al,0      ; Error, SB cannot be detected
        pop      es di
        leave
        retf
sba_f3: les      di,_BasePtr    ; Success, store parameters ...
        mov      ax,Base
        stosw
        les      di,_IrqPtr
        mov      ax,Irq
        stosw
        les      di,_DmaPtr
        mov      ax,Dma
        stosw
        mov      al,1      ; Returns "TRUE"
        pop      es di
        leave
        retf
DetectSB16 endp

;*****************************************************************************
;   Gravis UltraSound and UltraSound MAX
;*****************************************************************************

GUS_Desc db     "Gravis UltraSound"


GUSPeek proc    near     ; In: BL:AX = location, Out: AL = byte at that GUS address
        push    dx ax

        mov     dx,Base
        add     dx,103h  ; Base+103h

        mov     al,43h
        out     dx,al
        inc     dx       ; Base+104h
        pop     ax
        out     dx,ax
        dec     dx       ; Base+103h
        mov     al,44h
        out     dx,al
        add     dx,2     ; Base+105h
        mov     al,bl
        out     dx,al

        ; Now peek the value ...
        add     dx,2     ; Base+107h
        in      al,dx

        pop     dx
        retn
GUSPeek endp

GUSPoke proc     near   ; In: BL:AX = location, BH = Value to poke
        push     dx ax

        mov      dx,Base
        add      dx,103h   ; Base+103h

        mov      al,43h
        out      dx,al
        inc      dx        ; Base+104h
        pop      ax
        out      dx,ax
        dec      dx        ; Base+103h
        mov      al,44h
        out      dx,al
        add      dx,2      ; Base+105h
        mov      al,bl
        out      dx,al

        ; Now poke the value ...
        add      dx,2      ; Base+107h
        mov      al,bh
        out      dx,al

        pop      dx
        retn
GUSPoke endp

nproc   GUSDelay
        push     dx ax
        mov      dx,300h
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        pop      ax dx
        retn
nendp   GUSDelay

IsGUSBase proc   _Base:WORD   ; Returns 1 (True) if base is correct  - Hardware detection
        push     dx
        mov      dx,_Base
        mov      Base,dx
        mov      dx,Base
        add      dx,103h
        mov      al,4Ch
        out      dx,al
        add      dx,2
        sub      al,al
        out      dx,al
        call     GUSDelay
        call     GUSDelay
        sub      dx,2
        mov      al,4Ch
        out      dx,al
        add      dx,2
        mov      al,1
        out      dx,al

        sub      ax,ax         ;
        mov      bx,0AA00h     ; At GUS's DRAM addres 0, a byte of 0AAh
        call     GUSPoke       ; Write it

        sub      ax,ax         ;
        mov      bx,ax         ; From address 0
        call     GUSPeek       ; Read a byte

        cmp      al,0AAh       ; Was the value written correctly ?
        jne      gus_Nobase    ; No, fuck off.

        mov      ax,0100h      ;
        mov      bx,5500h      ; At GUS's DRAM address 100h, a byte of 55h
        call     GUSPoke       ; Write it

        mov      ax,0100h      ;
        mov      bx,0000h      ; From address 100h
        call     GUSPeek       ; Read it

        cmp      al,55h        ; Was the byte written correctly ?
        jne      gus_Nobase    ; No, fuck off.

        mov      al,1          ; Success ! Everything went fine. GUS found at specified base.
        pop      dx
        mov      Card,GUS      ; Card ID
        leave
        retf
gus_Nobase:
        mov      al,0          ; Error !
        pop      dx
        leave
        retf
IsGUSBase endp


GetEnv  proc     near       ; In:  CS:SI - environment string;  Out: ES:DI - Pointer to env. data
        push     bx
        mov      ax,6200h
        int      21h
        mov      es,bx
        mov      es,es:2ch
        xor      di,di
gen_l1: xor      bx,bx
gen_l2: mov      al,es:[di]
        inc      di
        cmp      al,0
        je       gen_err1
        cmp      al,cs:[si+bx]
        jne      short gen_nx1
        inc      bx
        jmp      short gen_l2
gen_nx1:cmp      al,'='
        jne      short gen_l3
        jmp      short gen_got
gen_l3: mov      al,es:[di]
        inc      di
        cmp      al,0
        jne      short gen_l3
        jmp      short gen_l1
gen_err1:stc
        jmp      short gen_end
gen_got:clc
gen_end:pop      bx
        retn
GetEnv  endp

nproc   GetValue
        push     bx
        xor      ax,ax
        xor      bx,bx
gus_e1: mov      al,es:[di]
        inc      di
        cmp      al,' '
        je       short gus_e1
        jmp      short gus_e3
gus_e2: mov      al,es:[di]
        inc      di
gus_e3: cmp      al,' '
        je       short gus_en2
        cmp      al,','
        je       short gus_en2
        and      al,11011111b
        cmp      al,40h
        jb       short gus_noc
        add      al,9
gus_noc:and      al,0fh
        shl      bx,4
        add      bx,ax
        jmp      short gus_e2
gus_en1:stc
        mov      ax,bx
        pop      bx
        retn
gus_en2:clc
        mov      ax,bx
        pop      bx
        retn
nendp   GetValue

InitGUS proc     _Base:WORD, _Irq:WORD, _Dma:WORD
        push     si di es
        mov      si,offset gusenv
        call     GetEnv     ; Get environment start address in ES:DI
        jc       short gus_er4
        ; Get all values ...
        call     GetValue   ; Get Base Port from environment
        jc       short gus_er4
        and      ax,0FFFh
        mov      Base,ax
        call     GetValue   ; Get the first DMA channel from environment
        jc       short gus_er4
        and      ax,000Fh
        mov      Dma,ax
        call     GetValue   ; Get the second DMA channel from environment
        jc       short gus_er4
        call     GetValue   ; Get GUS' IRQ number from environment
        jc       short gus_er4
        and      ax,00FFh
        mov      Irq,ax
        ; Hardware checking ...
        push     Base
        call     IsGUSBase
        or       al,al
        jz       short gus_er4
        mov      ax,_Dma
        cmp      ax,Dma
        jne      short gus_er4
        mov      ax,_Irq
        cmp      ax,Irq
        jne      short gus_er4
        mov      al,1      ; Success !
        pop      es di si
        leave
        retf
gus_er4:mov      al,0      ; Error, ULTRASND environment string was not found.
        pop      es di si
        leave
        retf
InitGUS endp

DetectGUS proc   _Base:DWORD, _Irq:DWORD, _Dma:DWORD
        push     si di es
        mov      si,offset gusenv
        call     GetEnv
        jc       gus_Er3
        ; Get all the values ...
        call     GetValue   ; Get Base Port from environment
        jc       gus_er3
        and      ax,0FFFh
        mov      Base,ax
        call     GetValue   ; Get the first DMA channel from environment
        jc       gus_er3
        and      ax,000Fh
        mov      Dma,ax
        call     GetValue   ; Get the second DMA channel from environment
        jc       gus_er3
        call     GetValue   ; Get GUS' IRQ number from environment
        jc       gus_er3
        and      ax,00FFh
        mov      Irq,ax
        ; Hardware checking ...
        push     Base
        call     IsGUSBase
        or       al,al
        jz       gus_er3
        les      di,_Base  ; Store parameters ...
        mov      ax,Base
        stosw
        les      di,_Irq
        mov      ax,Irq
        stosw
        les      di,_Dma
        mov      ax,Dma
        stosw
        mov      al,1      ; Success !
        pop      es di si
        leave
        retf
gus_er3:mov      al,0      ; Error, ULTRASND environment string was not found.
        pop      es di si
        leave
        retf
DetectGUS endp

;*****************************************************************************
;   MediaVision ProAudio Spectrum
;*****************************************************************************

PAS_Desc db      "MediaVision Pro Audio Spectrum"

IsPASBase proc   _Base:WORD
        push     bx cx dx di si
        mov      di,_Base
        xor      di,PASdef   ; Calculate the translation code
        mov      ax,0BC00h
        mov      bx,'??'
        xor      cx,cx
        mov      dx,cx
        int      2fh         ; MVSOUND.SYS must be loaded into memory
        xor      bx,cx
        xor      bx,dx
        cmp      bx,'MV'     ; Is PAS at base port _Base ?
        jne      pas_noway   ; No way. Jump to exit.
pas_found:
        mov      ax,_Base
        mov      Base,ax     ; Store the base found
        mov      ax,0BC04h
        int      2Fh         ; Get DMA channel and IRQ number
        mov      Dma,0              ;
        mov      byte ptr Dma,bl    ; Store'em ...
        mov      Irq,0              ;
        mov      byte ptr Irq,cl    ;
        mov      dx,0B8Bh    ; Interrupt Control Register
        xor      dx,di       ; Adjust to other address
        in       al,dx
        cmp      al,-1
        je       pas_noway
        mov      ah,al
        xor      al,11100000b ; Revision Mask Field Bits
        out      dx,al
        jmp      short $+2    ; Some jumps for
        jmp      short $+2    ; a short delay
        in       al,dx
        cmp      al,ah        ; The original copy and this one read should match ...
        xchg     al,ah
        out      dx,al        ; Restore status
        jne      pas_noway    ; Match ? If not, it is probably a bad board.
pas_yeah:
        mov      ax,1
        pop      si di dx cx bx
        mov      Card,PAS     ; Card ID. 5=PAS
        leave
        clc
        retf
pas_noway:
        mov      ax,0         ; Error ! PAS base not found.
        pop      si di dx cx bx
        leave
        stc
        retf
IsPASBase endp

InitPAS proc     _Base:WORD, _Irq:WORD, _Dma:WORD
        push     dx
        mov      dx,_Base
        push     dx
        call     IsPASBase
        jc       short pas_er2
        mov      dx,_Irq
        cmp      ax,Irq
        jne      short pas_er2
        mov      ax,_Dma
        cmp      ax,Dma
        jne      short pas_er2
pas_f2: mov      al,1         ; Success ! PAS found at base _BASE etc...
        pop      dx
        leave
        retf
pas_er2:mov      al,0         ; Error !
        pop      dx
        leave
        retf
InitPAS endp

DetectPAS proc   _Base:DWORD, _Irq:DWORD, _Dma:DWORD
        push     es di
        push     PASdef
        call     IsPASBase
        jnc      pas_f1
        push     PASb1
        call     IsPASBase
        jnc      pas_f1
        push     PASb2
        call     IsPASBase
        jnc      pas_f1
        push     PASb3
        call     IsPASBase
        jnc      pas_f1
        push     PASb4
        call     IsPASBase
        jnc      pas_f1
        push     PASb5
        call     IsPASBase
        jnc      pas_f1
        push     PASb6
        call     IsPASBase
        jnc      pas_f1
        mov      ax,0      ; Error ! PAS was not found.
        pop      di es
        leave
        retf
pas_f1: les      di,_Base  ; Store parameters ...
        mov      ax,base
        stosw
        les      di,_Irq
        mov      ax,Irq
        stosw
        les      di,_Dma
        mov      ax,Dma
        stosw
        mov      ax,1      ; Success !
        pop      di es
        leave
        retf
DetectPAS endp

;*****************************************************************************
;   Windows Sound System and compatibles
;   should also work on:
;   Crystal CODEC (CS4231):   GUS MAX, AudioTrix Pro, Orchid SoundWave32
;   Analog CODEC (AD1848) :   Ensoniq Soundscape
;*****************************************************************************

WSS_Desc db      "Windows Sound System (Crystal/Analog CODEC)"

InitWSS proc     _Base:WORD, _Irq:WORD, _Dma:WORD

     ; just store parameters...

        mov      ax,_Base
        mov      Base,ax

        mov      ax,_Irq
        mov      Irq,ax

        mov      ax,_Dma
        mov      Dma,ax

        mov      Card,WSS

        mov      ax,1         ; Success ! (...)
        leave
        retf
InitWSS endp

; ***************************************************************************
; The following routine was "thought" and made by me, so I'm not sure if it
; works ok for any CODEC. But hey, this is just a fuckin beta version, right ?
; ***************************************************************************

IsWSSBase proc   far   _Base:WORD ; test if there really is a CODEC on the given base port address
                                  ; returns CF=0 if found, CF=1 if not
        push     ax bx dx

        mov      dx,_Base         ; use this CODEC base from now on...
        add      dx,4

        in       al,dx
        test     al,al            ; CODEC busy ?
        jns      wssnb
        stc
        jmp      wss_out
wssnb:  mov      al,0Ch
        out      dx,al            ; select misc. register
        inc      dx
        in       al,dx            ; get CODEC version
        mov      bl,al            ; save it
        xor      al,al
        out      dx,al            ; try to overwrite reg
        jmp      short $+2
        in       al,dx            ; read it again
        cmp      al,bl            ; has the value changed ?
        je       wss_ok           ; if not, CODEC found
        stc
        jmp      wss_out
wss_ok: clc
        mov      dx,_Base
        mov      Base,dx
        mov      Irq,7            ; I don't know how to detect these two,
        mov      Dma,1            ; so set the default values. User should know them... :)
wss_out:pop      dx bx ax
        leave
        retf
IsWSSBase endp

DetectWSS proc   _Base:DWORD, _Irq:DWORD, _Dma:DWORD
        push     es di
        push     WSSb1
        call     IsWSSBase
        jnc      wss_f1
        push     WSSb2
        call     IsWSSBase
        jnc      wss_f1
        push     WSSb3
        call     IsWSSBase
        jnc      wss_f1
        push     WSSb4
        call     IsWSSBase
        jnc      wss_f1
        mov      ax,0      ; Error ! WSS was not found.
        pop      di es
        leave
        retf
wss_f1: les      di,_Base  ; Store parameters ...
        mov      ax,base
        stosw
        les      di,_Irq
        mov      ax,Irq
        stosw
        les      di,_Dma
        mov      ax,Dma
        stosw
        mov      ax,1      ; Success !
        mov      Card,WSS  ;
        pop      di es
        leave
        retf
DetectWSS endp

;****************************************************************************
;  Sierra Semiconductors' ARIA soundcard
;****************************************************************************

ariaDesc db      "ARIA soundcard"


InitARIA proc     _Base:WORD, _Irq:WORD, _Dma:WORD

        push     dx si di es

        mov      si,offset ARIAenv
        call     GetEnv     ; Get environment start address in ES:DI
        jc       short aria_er4

        ; Get FOUR parameters from the environment string...

        call     GetValue2   ; Get parameter from the environment
        jc       short aria_er4
        call     ariaStoreValue

        call     GetValue2   ; Get the next para from environment
        jc       short aria_er4
        call     ariaStoreValue

        call     GetValue2   ; Get the next para from environment
        jc       short aria_er4
        call     ariaStoreValue

        call     GetValue2   ; Get the next para from environment
        jc       short aria_er4
        call     ariaStoreValue

        ; Hardware checking:
        ; ... no hardware checking yet ...

        mov      Card,Aria
        mov      al,1      ; Success !
        pop      es di si dx
        leave
        retf

aria_er4:
        mov      Card,0
        mov      al,0      ; Error, ARIA environment string was not found or too few parameters within.
        pop      es di si dx
        leave
        retf

InitARIA endp


DetectARIA proc   _Base:DWORD, _Irq:DWORD, _Dma:DWORD

        push     dx si di es

        mov      si,offset ARIAenv
        call     GetEnv
        jc       aria_er3

        ; Get FOUR values ...

        call     GetValue2
        jc       aria_er3
        call     ariaStoreValue

        call     GetValue2
        jc       aria_er3
        call     ariaStoreValue

        call     GetValue2
        jc       aria_er3
        call     ariaStoreValue

        call     GetValue2
        jc       aria_er3
        call     ariaStoreValue

        ; Hardware checking ...
        ; ... no hardware checking yet ...

        les      di,_Base  ; Store parameters ...
        mov      ax,Base
        stosw

        les      di,_Irq
        mov      ax,Irq
        stosw

        les      di,_Dma
        mov      ax,Dma
        stosw

        mov      Card, Aria

        mov      al,1      ; Success !
        pop      es di si dx
        leave
        retf

aria_er3: mov    Card,0
        mov      al,0      ; Error, ARIA environment string was not found or it has too few parameters within.
        pop      es di si dx
        leave
        retf
DetectARIA endp


nproc   GetValue2   ; ES:DI = pointer to env. str. data

        mov      dx,0  ; dumb init (type)
        mov      bx,0  ; dumb init (value)

gv2_1:  mov      al,es:[di]
        inc      di
        cmp      al,0  ; end of env. string ?
        je       short gv2_out
        cmp      al,' '
        je       short gv2_1
        cmp      al,','
        je       short gv2_1
        jmp      short gv2_cn

gv2_2:  mov      al,es:[di]
        inc      di
gv2_cn:
        cmp      al,0    ; end of data ?
        je       short gv2_out
        cmp      al,' '  ; end of parameter ?
        je       short gv2_out
        cmp      al,','  ; end of parameter ?
        je       short gv2_out
        cmp      al,'0'
        jb       gv2_2   ; trash, ignore it...
        cmp      al,'9'
        ja       short gv2_ty

        cmp      dl,'A'
        je       gv2_hex
        cmp      dl,'a'
        je       gv2_hex

        imul     bx,0Ah

gv2_cn2:sub      al,'0'
        xor      ah,ah
        add      bx,ax
        jmp      short gv2_2

gv2_hex:shl      bx,4
        jmp      short gv2_cn2

gv2_ty: mov      dl,al   ; got the type !
        mov      bx,0
        jmp      short gv2_2

gv2_out:mov      ax,bx
        retn

nendp   GetValue2


nproc   ariaStoreValue       ; In: DL=what to write? ('A'=base,'D'=dma,'I'=IRQ,'T'=version(not used))
                             ;     AX=value
        cmp      dl,'A'
        je       asv_setbase
        cmp      dl,'a'
        je       asv_setbase
        cmp      dl,'D'
        je       asv_setdma
        cmp      dl,'d'
        je       asv_setdma
        cmp      dl,'I'
        je       asv_setirq
        cmp      dl,'i'
        je       asv_setirq
        retn
asv_setbase:
        and      ax,0FFFh
        mov      Base,ax
        retn
asv_setdma:
        and      ax,000Fh
        mov      Dma,ax
        retn
asv_setirq:
        and      ax,00FFh
        mov      Irq,ax
        retn
nendp   ariaStoreValue

        END
