;*****************************************************************************
; Sound Deluxe System 5, a Maple Leaf production, 1996-1997
; PMODE 2.4 interface for SDS5, by Maple Leaf
; Definitions.
;*****************************************************************************

        .386p	            ; do YOU still use 286 ?
        locals @@           ; the labels marked with '@@' will be local

include pmodesds.inc

public API_address

API_address    DD 0         ; API address (real seg:offs)
POLL_address   DD 0         ; POLL MIX address (real seg:offs)
ESB_address    DD 0         ; ESB address (32bit linear)

;***************************************************************************
;******************************* FUNCTIONS *********************************
;***************************************************************************

;***************************************************************************
; SDS_DetectSession
;   In: nothing
;   Out: DL = 0  SDS not found
;             1  SDS found
;   Note: this routine detects whether a SDS session is active or not, using
;         API #2 method (see SERVICES.DOC)
;***************************************************************************

public SDS_DetectSession
SDS_DetectSession:
                push    eax edi

                mov     [v86r_ah],0a0h     ; SDS's multiplex no = 0A0h
                mov     [v86r_dh],17h      ; serv. 17h = "identify API"
                mov     al,2Fh             ; execute real mode INT 2Fh
                int     33h                ; Go!

                mov     eax,[v86r_eax]     ; get it back from the virtual reg
		xor     dl,dl              ; suppose not found

                cmp     eax,35534453h      ; is the signature returned ?
                jne     short @@no         ; no, fuck off

		                           ; yes! sds is present!

                mov     eax,gs:[4fch]      ; get ESB address as seg:offs

                mov     edi,eax            ;
                shr     edi,12             ;
                and     edi,0FFFF0h        ; convert it to linear address
                movzx   eax,ax             ;
                add     edi,eax            ;

                mov     [ESB_address],edi  ; store it for later usage

                mov     eax,gs:[edi]       ; ESB offset #0: POLLMIX address
                mov     [POLL_address],eax ; store it for later usage

                mov     eax,gs:[edi+2Ch]   ; ESB offset 44: API entry point
                mov     [API_address],eax  ; store it for later usage

                inc     dl                 ; acknowledge user we've found it...

        @@no:   pop     edi eax
                ret


;***************************************************************************
; sds_API func_number (macro)
; Executes a specified SDS API service
;***************************************************************************

sds_API         macro  num
                mov    [v86r_dh],&num
                mov    [v86r_ah],0a0h
                mov    al,2Fh
                int    33h
                endm


;***************************************************************************
; SDS_Poll
;   In: nothing
;   Out: nothing
;   Note: this routine performs a bit of mixing-ahead, in order to keep up
;         the music (sds internal vars and dma sound if needed)
;   Obs:  you can do this operation in two ways, using either API #2 or
;         a direct real-mode far call. THE FIRST MODE IS PREFERRED!
;***************************************************************************

public SDS_Poll
SDS_Poll:

                sds_API 18h              ; using API #2 (preferred)

             ;  mov edx,[POLL_address]   ; ... or using a direct real-mode
             ;  mov ecx,edx              ; far call (seems slower and has
	     ;  shr ecx,16               ; very weird effects sometimes.
             ;  int 32h                  ; Better use the first calling mode)

                ret

;***************************************************************************
; SDS_SetTimer
;   In: nothing
;   Out: nothing
;   Note: this routine switches SDS into TIMER mode
;***************************************************************************

public SDS_SetTimer
SDS_SetTimer:
                mov    [v86r_al],0
                sds_API 5
                ret

;***************************************************************************
; SDS_SetPoll
;   In: nothing
;   Out: nothing
;   Note: this routine switches SDS into POLL mode. From now on your
;         application has to perform succesive calls of SDS_Poll to keep up
;         the music
;***************************************************************************

public SDS_SetPoll
SDS_SetPoll:
                mov    [v86r_al],1
                sds_API 5
                ret


;***************************************************************************
; SDS_GetUsrCounter
;   In: nothing
;   Out: EAX = user counter (incremented BPM*2/5 times per second)
;   Note: this routine returns the value of the so called "user counter"
;***************************************************************************

public SDS_GetUsrCounter
SDS_GetUsrCounter:
                push   edi
                mov    edi,[ESB_address]       ; we'll read the counter from
                                               ; the External Syncronization
                                               ; Block (ESB), from offset 35h

                mov    eax,gs:[edi+35h]        ; read it!

                pop    edi
                ret

;***************************************************************************
; SDS_Jump
;   In: AH = order
;   Out: nothing
;   Note: this routine performs an immediate jump to the order specified
;         in AH register
;***************************************************************************

public SDS_Jump
SDS_Jump:
                mov    [v86r_al],ah
                sds_API 10h
                ret

;***************************************************************************
; SDS_SetVolume
;   In: AL = volume
;   Out: nothing
;   Note: this routine changes the global volume of the replayed sound to
;         the value specified in AL. Valid values are the std ones: 0-40h
;***************************************************************************

public SDS_SetVolume
SDS_SetVolume:
                mov    [v86r_al],al
                sds_API 1
         	ret

;***************************************************************************
; SDS_SlideVolumeDn
;   In: nothing
;   Out: nothing
;   Note: this routine decreases the global volume by one
;***************************************************************************

public SDS_SlideVolumeDn
SDS_SlideVolumeDn:
                sds_API 7
         	ret

;***************************************************************************
; SDS_SlideVolumeUp
;   In: nothing
;   Out: nothing
;   Note: this routine increases the global volume by one
;***************************************************************************

public SDS_SlideVolumeUp
SDS_SlideVolumeUp:
                sds_API 6
         	ret

ENDS
END
