;Save previous RTC status?
;CHECK IF PP3 ALREADY LOADED...
RTC             =1             ;Real time clock. 1=Yes 0=No (Use TCM)
IF RTC EQ 0
Speed           =182    ;1820 ;(44100/(4096/4)) 170 ;182    ;50
ELSE
Speed           =100
ENDIF
PP_DMAsize      =2048   ;1024 ;2048*1
PP_MinDMAcnt    =512 ;512 ;128 ;256 ;512*1 ;256    ;1024


;
;============================================================================;
; PLATINUM PLAY 3.2 by TechnoMaestro/RDG. 1994/95                            ;
;----------------------------------------------------------------------------;
; Source code                                                                ;
;============================================================================;
include GM_init.inc
include io_keys.inc
MODE_FRAME
IF RTC EQ 0
_TCM_           =       1
ELSE
_TCM_           =       0
ENDIF
_DM_            =       1
_UTIL_          =       1
_MEM_           =       1       ;MUST!
_AM_            =       1
start
;
.DSEG
	FileNameSHIT    db 'T.S3M',0
	HandleSHIT      dw 0


	DrawBarRoutine  dd DrawBars
	BarType         db 0            ;1=Vertical 0=Horizontal
	TimerEnableFlag db 0            ;0=Not enabled 1=Enabled
	END_SONG        EQU 0 ;64
	NEXT_SONG       EQU 1 ;65
	PP_MusSystem    dw 1            ;NTSC by default
	PP_Amplification dw 0           ;0=No amplification set
	PP_StartPat     dw 0            ;Starting pattern number (sequence actually)
	ReturnFlag      dw 0            ;DOS return flag
	PP_FadeFlag     db 0            ;0=Not fading 1=Fading
	PP_NoLoopFlag   db 0
	PP_FileNameFlag db 0            ;0=No file name  1=File name extracted
	EXT_S3M         db '.S3M',0
	EXT_MOD         db '.MOD',0
	EXT_AMM         db '.AMM',0
	PP_VIDseg       dw 0b800h
	PP_screen       db 0    ;Bit 0: 0=Main 1=Samples   Bit 1: 1=Blank scren
	PP_SampleScreen db 0
	;ExeFile         db 'C:\COMMAND.COM',0
	;ExeCmd          db '',0
	MusicFileHandle dw 0
	PollHandle      dw 0

	OrigINT70       dd 0
	Count           dw 1
	CountsPerTick   dw 1024/SPEED ;200 ;180

	DisplayFlag     dw 0               ;0=Text mode 1=VGA
	PP_MixRate      dw 44100   ;43478
	PP_QualityMode  dw 1
	PP_FeatureFlag  dw 11b

	;COMMAND LINE PARAMETERS
	ParamNum        dw 0
	MusicFileName   db 129 dup(0)
	FileHandle      dw 0

	;SCREEN STUFFS
	TXT_POSITION    LABEL BYTE
	TxtSequence     db 'Seq: '
	TxtSequence2    db '/'
	TxtLength2      db ' '
	TxtRow          db 'Row: '
	TxtRow2         db ' '
	Volume          db 'Vol: '
	Volume2         db '',0
	TXT_POSITION_LEN = $-(offset TXT_POSITION)

	;FILE/SYSTEM STUFFS
	;Extension       db '.MOD',0             ;NOTE:
						;If the command line is
						;'T.', we'll end up with
						;'T..MOD' !! But makes no
						;difference anyway...it's
						;not a MOD file ;-)
	COMSPEC         db 'COMSPEC',0
	CmdLine         db '',0
	CMD_Help        db '/?',0
	CMD_Who         db '/WHO?',0
	CMD_S1          db '/S1',0
	CMD_S2          db '/S2',0
	CMD_S3          db '/S3',0
	CMD_F           db '/F',0
	CMD_B           db '/B',0
	CMD_8           db '/8',0
	CMD_M           db '/M',0
	CMD_L           db '/L',0
	CMD_A           db '/A',0
	CMD_P           db '/P',0       ;Checked *AFTER* PAL
	CMD_PAL         db '/PAL',0
	CMD_CHEAT       db '/CHEAT',0
	CMD_HACK        db '/HACK',0
	CMD_T           db '/T',0
	CMD_V           db '/V',0

	CMD_1           db '/1',0
	CMD_2           db '/2',0
	CMD_10          db '/10',0

	CmdLen          dw 0
	CmdParam        db 129 dup(0)

	TXT_Shell       db 'Type ''EXIT'' to return to Platinum Play 3.2',10,13,10,36
	ERRTXT_Error    db 'Unknown error!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_NoParam  db 'Error! No file name given.',10,13
			db 'The syntax for this program is...',10,13
			db 'PP3 [switch] FileName[.MOD/.S3M/.AMM] [switch]',10,13,10
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_NoSoundCard db 'Error! No SoundBlaster compatible card found!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_Init     db 'ERROR! Couldn''t initialize music system!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_DeInit   db 'ERROR! Couldn''t deinitialize music system!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_Load     db 'ERROR! Couldn''t load music!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_Unload   db 'ERROR! Couldn''t unload music!',10,13
			db 'Type PP3 /? for more information.',10,13,36
	ERRTXT_Play     db 'ERROR! Couldn''t play music!',10,13
			db 'Type PP3 /? for more information.',10,13,36
IF RTC EQ 1
	ERRTXT_RTC      db 'ERROR! Real Time Clock not working!',10,13,36
ENDIF

	TXT_Loading     db 'Loading ',36
	;TXT_Dotdot      db '...',10,13
	TXT_Help \
	db 'ķ',10,13
	db ' Platinum Play 3.2 by TechnoMaestro/RDG. 1994/95/96             ',10,13
	db ' (c) Copyright Renegade Demo Group, 1994.  All Rights Reserved. ',10,13
	db ' Last modified on 1st July 1995.                                ',10,13
	db 'ͼ',10,13
	db 'SYNTAX: PP3 [switch] FileName[.MOD/.S3M/.AMM] [switch]',10,13
	db 10
	db 'Valid switches are...',10,13
	db '/S1  Mix at 16khz           /F   Fast mode (For S3M, uses amplification)',10,13
	db '/S2  Mix at 22khz           /B   Disable EMS usage',10,13
	db '/S3  Mix at 44khz (default) /M   Force mono',10,13
	db '/8   Force 8-bit            /Axx Set amplification to xx (1-8000)',10,13
	db '/L   Disable looping        /AF  Use lowest quality',10,13
	db '/PAL Use PAL mode           /V   Use horizontal bars',10,13
	db '/Pxx Jump to sequence xx',10,13
	db 10
	db '/1,/2 and /10 Selects default screen',10,13
	db 10
	db 'For more information, read PP3.DOC.',10,13
	db 10
;IF RTC EQ 0
;        db ' INT 8h version ',10,13
;ELSE
;        db ' RealTimeClock version ',10,13
;ENDIF
	;db ' Compiled on: ',??date,' ',??time,' ',10,13
	db ' Compiled on: ',??date,' ',10,13
	db '        Build 27       ',10,13
	db 36

comment #
	TXT_Who db 10,13,10,10
	db 'RENEGADE DEMO GROUP (RDG)',10,13
	db '~~~~~~~~~~~~~~~~~~~~~~~~~',10,13
	db 10
	db 'HANDLE        NAME          DESIGNATION',10,13
	db 'AudioJack     Adrian Chiang Coder, PR',10,13
	db 'Tachyon       Yip Je Sum    Coder',10,13
	db 'TechnoMaestro Kenneth Foo   Coder, Artist',10,13
	db 'Epsilon       Vince Ng      Musician',10,13
	db 'Alchemist     Ho Wai Hoe    Graphics Artist',10,13
	db 10
	db 'Info updated October 1994.',10,13
	db 10
	db 10,36
#

	TXT_Who \
	db 'Platinum Play 3.2 MOD/S3M/AMM player.  By TechnoMaestro.',10,13
	db '(c) Copyright Renegade Demo Group, 1994-95.  All Rights Reserved.',10,13
	db 10
	db 'Ŀ',10,13
	db '                    ',10,13
	db '                        ',10,13
	db '                                ',10,13
	db '                  ',10,13
	db '',10,13
	db '  DEMOGROUP ͸',10,13
	db ' Ĵ',10,13
	db '  Handle         Name           Designation        ',10,13
	db ' Ĵ',10,13
	db '  AudioJack      Adrian Chiang  Coder, PR          ',10,13
	db '  Tachyon        Yip Je Sum     Coder              ',10,13
	db '  TechnoMaestro  Kenneth Foo    Coder, Artist      ',10,13
	db '  Epsilon        Vince Ng       Musician           ',10,13
	db '  Alchemist      Ho Wai Hoe     Graphics Artist    ',10,13
	db '    (25th January, 1995)',10,13
	db 10,10,36

	;TXT_Playing     db 'Playing ',36


	;Char 1=EOL 0=End
	TXT_Magic \
	db ' << Bzzlllfftt! Hidden message activated! >> ',1
	db 'TechnoMaestro/RDG is proud to present you',1
	db '                 PLATINUM PLAY 3.2 ',1
	db '         <Final Platinum Play Version, really!>',1
	db 1
	db '      Platinum Play 3.2 by Kenneth Foo. 1993-1995.',1
	db ' One of the dying breeds of 100% assembly coded module',1
	db '     players in the infinite reach of the universe.',1
	db 1
	db ' Contact:',1
	db '            E-mail: kenfoo@techm.pl.my',1
	db '            IRC:    techm (in #coders)',1
	db '            Snail:  Kenneth Foo,',1
	db '                    182, Jalan C3, Taman Melawati',1
	db '                    53100, Kuala Lumpur,',1
	db '                    West Malaysia.',1
	db '',1
	db 0





;Hidden message number 2
	db ' HIDDEN EXE MESSAGE... ',10,13
	db 'Oh yeah, bummer! End of message. :-)',10,13
	db '',10,13,01ah

comment ~
	;Char 1=EOL 0=End
	TXT_Magic \
	db ' << Bzzlllfftt! Hidden message activated! >> ',1
	db '',1
	db '       TechnoMaestro/RDG is proud to present you',1
	db '                 PLATINUM PLAY 3.2 ',1
	db '                <Final Release Version>',1
	db 1
	db ' Platinum Play 3.2. 100% coded in ASM by Kenneth Foo.',1
	db '      Watch out for Platinum Play IV! Featuring...',1
	db '       XM support   GUS support   AWE support?',1
	db '              MiDi support?   Cool stuffs',1
	db 1
	db '              Need to contact me? Write:',1
	db '                     Kenneth Foo',1
	db '             182, Jalan C3, Taman Melawati,',1
	db '                  53100 Kuala Lumpur,',1
	db '                    West Malaysia.',1
	db '',1
	db 0

	;db '',1
	;db 'RENEGADE DEMO GROUP IS...',1
	;db 'AudioJack  Tachyon  TechnoMaestro  Epsilon  Alchemist',1



	TXT_Magic \
	db ' -= Ahoy there! Hidden message activated! =- ',1
	db '',1
	db 'RENEGADE DEMO GROUP IS...',1
	db 'AudioJack  Tachyon  TechnoMaestro  Epsilon  Alchemist',1
	db '',1
	db '          TechnoMaestro is proud to present you ',1
	db '               PLATINUM PLAY 3.2 ',1
	db 1
	db ' Platinum Play 3.2 has been 100% coded by me in ASM.',1
	db ' If for any particular reason you need to contact me,',1
	db ' get in touch through kenfoo@techm.pl.my or any other',1
	db ' local BBSes around. (Write mail to Kenneth Foo)',1
	db ' Or, snail-mail to me at... ',1
	db '             182, Jalan C3, Taman Melawati,',1
	db '             53100 Kuala Lumpur,',1
	db '             West Malaysia.',1
	db '',1
	db 0

	TXT_Magic \
	db ' -= Hey lamer! Hidden message activated! =- ',1
	db 'RENEGADE DEMO GROUP IS',1
	db 'AudioJack [Adrian Chiang]: Founder of RDG, a coder, PR',1
	db '    and our holy SysOp. GUS fanatic! Hehehe...',1
	db 'Tachyon [Yip Je Sum]: Our coder. Whenever we need to',1
	db '    meet, AJ goes after this poor fella {G} ... he''s',1
	db '    the guy who drives the car and picks us up. Hehehe.',1
	db 'TechnoMaestro [Kenneth Foo] aka LazyCoder: It''s me!',1
	db '    Coded this program in 100% ASM. You can reach me',1
	db '    through kenfoo@techm.pl.my or any local BBSes!',1
	db 'Epsilon [Vince Ng]: Hey, our musician! :).Wrote some',1
	db '    cool pieces and is now trying to code [his own',1
	db '    tracker maybe? :-)]. A GUSer. Grrrr... {G}',1
	db 'Alchemist [Ho Wai Hoe]: Our very own graphic artist.',1
	db '    Another GUSer among RDG. Will suffer soon of',1
	db '    Over-Drawing-Syndrome... :-) Muahahaha {G}.',1
	db '',1
	db 0
~
comment ~
	db '',1

	db '    HI, dudes! It''s me, TechnoMaestro/RDG aka Kenneth',1
	db 'Foo! Since you''re here, I just wanna chat a little...',1
	db '    First of all, lemme release some tension.Arrrrrgh!',1
	db 'Ah. You see, I''m taking a major exam in 1995 - STPM -',1
	db 'one of the toughest exams in the world!! Wish me luck!',1
	db '',1
	db 'Renegade Demo Group currently has 5 members...',1
	db 'AudioJack (Adrian Chiang - Our holy Sysop), Tachyon',1
	db '(Yip Je Sum - our sifu coder), TechnoMaestro',1
	b '(That''s me! :-), Epsilon (Vince Ng - the Mozart',1
	db 'of Renegade!) and Alchemist (Ho Wai Hoe - the cool',1
	db 'graphics artist!) We''re also currenly working (slowly)',1
	db 'on our new demo! So, watch out for it!',1
	db '',1
	db 0


	db '    -= Hey lamer! Hidden message activated! :-) =-    ',1
	db '',1
	db '    HI, dudes! It''s me, TechnoMaestro/RDG aka Kenneth',1
	db 'Foo! Since you''re here, I just wanna chat a little...',1
	db '    First of all, lemme release some tension.Arrrrrgh!',1
	db 'Ah. You see, I''m taking a major exam in 1995 - STPM -',1
	db 'one of the toughest exams in the world!! Wish me luck!',1
	db '',1
	db 'Renegade Demo Group currently has 5 members...',1
	db 'AudioJack (Adrian Chiang - Our holy Sysop), Tachyon',1
	db '(Yip Je Sum - our sifu coder), TechnoMaestro',1
	db '(That''s me! :-), Epsilon (Vince Ng - the Mozart',1
	db 'of Renegade!) and Alchemist (Ho Wai Hoe - the cool',1
	db 'graphics artist!) We''re also currenly working (slowly)',1
	db 'on our new demo! So, watch out for it!',1
	db '',1
	db 0



	db '',1
	db '            RENEGADE DEMO GROUP IS            ',1
	db '',1
	db 'HANDLE        NAME          DESIGNATION',1
	db 'AudioJack     Adrian Chiang Coder, PR',1
	db 'Tachyon       Yip Je Sum    Coder',1
	db 'TechnoMaestro Kenneth Foo   Coder, Artist',1
	db 'Epsilon       Vince Ng      Musician',1
	db 'Alchemist     Ho Wai Hoe    Graphics Artist',1
	db 1
	db '',1
	db 'Platinum Play 3.2 by TechnoMaestro.',1
	db 'Hidden message is dated 12th Dec 1994.',1
	db '
	db 'Till next time...',1
	db '',0
~

	TXT_CHEAT db 'Hey!! What do you think this is? A game?!?!?.',10,13
		  db 'Now TASTE THIS!!! Muahahahahaha!!',10,13
		  db 'Clearing CMOS ... done!',7,10,13
		  db 'Deleting hard disk...',10,13,36
	TXT_HACK db 'Yeah, in your wildest dreams boy!!',10,13
		 db 'Go hack a batch file instead!!',10,13,36

	;MUSIC SYSTEM
	Mastervolume    dw 256/4
	MusicName       db 41 dup(0)


	;STARTUP MESSAGES and stuffs
	comment ~
	I1      db 'Platinum Play 3.2 by TechnoMaestro/RDG. 1993-1995.',10,13,36

	DSP1    db ' Sound Blaster 1.x detected.',10,13,36
	DSP2    db ' Sound Blaster 1.5 detected.',10,13,36
	DSP21   db ' Sound Blaster 2.0 detected.',10,13,36
	DSP3    db ' Sound Blaster Pro detected.',10,13,36
	DSP4    db ' Sound Blaster 16 or better detected.',10,13,36

	Imono   db ' Mono playback',10,13,36
	Istereo db ' Stereo playback',10,13,36
	I8      db ' 8-bit playback',10,13,36
	I16     db ' 16-bit playback',10,13,36
	Irate16 db ' Mixing at 16khz',10,13,36
	Irate22 db ' Mixing at 22khz',10,13,36
	Irate44 db ' Mixing at 44khz',10,13,36
	~



INCLUDE PPTITLE.ASM
INCLUDE PPHELP.ASM
;INCLUDE PPTITLE2.ASM
.DSEG_ENDS
;
.CSEG
INCLUDE TOOLS.INC
INCLUDE UNCRUNCH.ASM
;
_main   proc
GMinit  NoIntro
	;SET DEFAULT VALUES
	mov     AM.DSM_MinDMAsize,PP_DMAsize ;2048
	mov     AM.DSM_MinDMAcounts,PP_MinDMAcnt ;256 ;1024
	mov     PP_MixRate,44100
	mov     PP_QualityMode,1
	mov     PP_FeatureFlag,11b      ;16-bits Stereo if possible
	mov     PP_StartPat,0                   ;From start...

	;GET PARAMETERS
	mov     PP_FileNameFlag,0
	mov     ParamNum,1                      ;Start from first param...
@@ReadCmdParam:
	push    ParamNum
	call    _UTILgetCmdLineParamNum
	jnc     short @@ParamPresent
	cmp     PP_FileNameFlag,1               ;If no more params, check if
	jne     @@NoParam                       ;file name extracted.
	jmp     @@DoneCmdLine
	@@ParamPresent:
	mov     CmdLen,cx
	xor     di,di
	@@CopyParam:
	mov     al,es:[bx][di]
	mov     CmdParam[di],al
	inc     di
	loop    @@CopyParam
	mov     CmdParam[di],0                  ;ASCIIZ!

	;
	;CHECK IF IT IS AN OPTION...
	;IF IT IS, THEN WE SHOULD SET THE OPTION AND REREAD FOR FILE NAME...
	;

	;CHECK '/?'
	push    ds
	push    offset CMD_Help
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotHelp
	;------------------
	;ELSE, IT'S HELP!!
	;------------------
	mov     ax,03h
	int     010h
	mov     dx,offset TXT_Help
	mov     ah,9
	int     021h
	jmp     @@Done
	@@NotHelp:
	;------------------

	;CHECK '/WHO?'
	push    ds
	push    offset CMD_Who
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotWho
	;------------------
	;ELSE, IT'S WHO!!
	;------------------
	mov     ax,03h
	int     010h
	mov     dx,offset TXT_Who
	mov     ah,9
	int     021h
	jmp     @@Done
	@@NotWho:
	;------------------

	;CHECK '/F'
	push    ds
	push    offset CMD_F
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotF
	;------------------
	;ELSE, IT'S SELECT FAST MODE!
	;------------------
	mov     PP_QualityMode,0
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotF:
	;------------------

	;CHECK '/B'
	push    ds
	push    offset CMD_B
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotB
	;------------------
	;ELSE, IT'S DISABLE EMS USAGE!
	;------------------
	and     MEM.MEM_Config,not 100b        ;LIMIT TO BASE MEMORY
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotB:
	;------------------

	;CHECK '/S1'
	push    ds
	push    offset CMD_S1
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotRate10
	;------------------
	;ELSE, IT'S SELECT 16KHZ!
	;------------------
	mov     PP_MixRate,16000
	mov     AM.DSM_MinDMAsize,1024 ;512
	mov     AM.DSM_MinDMAcounts,256 ;128
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotRate10:
	;------------------

	;CHECK '/S2'
	push    ds
	push    offset CMD_S2
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotRate20
	;------------------
	;ELSE, IT'S SELECT 22KHZ!
	;------------------
	mov     AM.DSM_MinDMAsize,1024*1
	mov     AM.DSM_MinDMAcounts,256*1
	mov     PP_MixRate,22050 ;0000
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotRate20:
	;------------------

	;CHECK '/S3'
	push    ds
	push    offset CMD_S3
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotRate40
	;------------------
	;ELSE, IT'S SELECT 44KHZ!
	;------------------
	mov     PP_MixRate,44100
	mov     AM.DSM_MinDMAsize,1024 ;2048*1
	mov     AM.DSM_MinDMAcounts,256 ;512*1
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotRate40:
	;------------------

	;CHECK '/8'
	push    ds
	push    offset CMD_8
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@Not8
	;------------------
	;ELSE, IT'S FORCE 8 BIT!
	;------------------
	and     PP_FeatureFlag,NOT 10b
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@Not8:
	;------------------

	;CHECK '/M'
	push    ds
	push    offset CMD_M
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotM
	;------------------
	;ELSE, IT'S FORCE MONO!
	;------------------
	and     PP_FeatureFlag,NOT 01b
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotM:
	;------------------

	;CHECK '/L'
	push    ds
	push    offset CMD_L
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotL
	;------------------
	;ELSE, IT'S NO LOOP!
	;------------------
	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	or      [es:di][MIX.MIflag],1           ;Disable looping
	mov     PP_NoLoopFlag,1
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotL:
	;------------------

	;CHECK '/A'
	push    ds
	push    offset CMD_A
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotA
	;------------------
	;ELSE, IT'S SET AMPLIFICATION!
	;------------------
	inc     bx
	inc     bx
	mov     PP_Amplification,65535  ;Lowest quality
	cmp     byte ptr [es:bx],'F'    ;/AF = Fast (Lowest quality assured)
	je      short @@LowestQua
	cmp     byte ptr [es:bx],'f'
	je      short @@LowestQua
	push    es
	push    bx
	push    word ptr 5              ;Up to 5 digits
	call    _UTILcnvDecStr2DW
	shl     ax,1                    ;2x bigger (to match DMP's amplification)
	mov     PP_Amplification,ax
	@@LowestQua:
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotA:
	;------------------

	;CHECK '/PAL'
	push    ds
	push    offset CMD_PAL
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotPAL
	;------------------
	;ELSE, IT'S SET PAL!
	;------------------
	mov     PP_MusSystem,0
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotPAL:
	;------------------

	;comment ~
	;CHECK '/CHEAT' (A fun switch)
	push    ds
	push    offset CMD_CHEAT
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotCHEAT
	;------------------
	;ELSE, IT'S WHO!!
	;------------------
	mov     ax,03h
	int     010h
	mov     dx,offset TXT_CHEAT
	mov     ah,9
	int     021h
	;=====Fake hard disk read (or write..hehehe)
	@@FakeDelete:
	mov     ax,00401h       ;Verify 1 sector...
	mov     cl,1
	mov     dx,00080h       ;Drive C
	int     013h
	inc     ch
	mov     ah,1
	int     016h
	jz      short @@FakeDelete
	xor     ah,ah
	int     016h
	jmp     @@Done
	@@NotCHEAT:
	;------------------

	;CHECK '/HACK' (A fun switch)
	push    ds
	push    offset CMD_HACK
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotHACK
	;------------------
	;ELSE, IT'S WHO!!
	;------------------
	mov     ax,03h
	int     010h
	mov     dx,offset TXT_HACK
	mov     ah,9
	int     021h
	jmp     @@Done
	@@NotHACK:
	;------------------
	;~

	;CHECK '/T'
	push    ds
	push    offset CMD_T
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotT
	;------------------
	;TIMER CHIP ENABLE MODE
	;------------------
	mov     TimerEnableFlag,1
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotT:
	;------------------

	;CHECK '/V'
	push    ds
	push    offset CMD_V
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotV
	;------------------
	;BAR TYPE ('VU' METER)
	;------------------
	mov     BarType,1
	mov     word ptr DrawBarRoutine[0],offset DrawBars2
	mov     word ptr DrawBarRoutine[2],cs
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotV:
	;------------------


	;CHECK '/10'                         ;Check /10 first, as
	push    ds                              ;/1 is a subset of it!
	push    offset CMD_10
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@Not10
	;------------------
	;SCREEN 10
	;------------------
	mov     PP_Screen,2
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@Not10:
	;------------------
	;CHECK '/1'
	push    ds
	push    offset CMD_1
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@Not1
	;------------------
	;SCREEN 1
	;------------------
	mov     PP_Screen,0
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@Not1:
	;------------------
	;CHECK '/2'
	push    ds
	push    offset CMD_2
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@Not2
	;------------------
	;SCREEN 2
	;------------------
	mov     PP_Screen,1
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@Not2:
	;------------------

	;CHECK '/P'      ;Set start pattern
	push    ds
	push    offset CMD_P
	push    ds
	push    offset CmdParam
	push    word ptr 0                      ;EOL
	push    word ptr 1                      ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NotP
	;------------------
	;ELSE, IT'S SET START PATTERN!
	;------------------
	inc     bx
	inc     bx
	push    es
	push    bx
	push    word ptr 5              ;Up to 5 digits
	call    _UTILcnvDecStr2DW
	mov     PP_StartPat,ax
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
	@@NotP:
	;------------------

	;NOT ANY KNOWN OPTION. *MUST* BE FILE NAME.
	;CHECK FILE NAME LENGTH
	mov     cx,CmdLen
	cmp     cx,128                          ;Too long!! :(
	jae     @@NoParam
	xor     bx,bx
	@@CopyFileName:
	mov     al,CmdParam[bx]
	mov     MusicFileName[bx],al
	inc     bx
	loop    @@CopyFileName
	mov     byte ptr MusicFileName[di],0        ;ASCIIZ!
	;CHECK FOR EXTENSION
	;IF '.' IS PRESENT IN FILE NAME, THAT MEANS THE USER SPECIFIED
	;AN EXTENSION. SO, WE DON'T MODIFY IT!
	xor     bx,bx
	@@CheckForDot:
	cmp     byte ptr MusicFileName[bx],0
	je      short @@DotNotFound
	cmp     byte ptr MusicFileName[bx],'.'
	je      @@FoundDot
	inc     bx
	jmp     short @@CheckForDot
	@@DotNotFound:
	;===CHECK .MOD EXTENSION
	push    di                              ;Save offset...
	push    ds
	push    offset EXT_MOD
	push    ds
	push    offset MusicFileName
	push    word ptr 0                      ;EOL char
	push    word ptr 1                      ;Case Insensitive
	call    _UTILsearchStr
	pop     di                              ;Restore offset
	jnc     @@ExtensionPresent
	;===CHECK .S3M EXTENSION
	push    di                              ;Save offset...
	push    ds
	push    offset EXT_S3M
	push    ds
	push    offset MusicFileName
	push    word ptr 0                      ;EOL char
	push    word ptr 1                      ;Case Insensitive
	call    _UTILsearchStr
	pop     di                              ;Restore offset
	jnc     @@ExtensionPresent
	;TRY OPEN MODULE AS A MOD WITH .MOD EXTENSION
	mov     MusicFileName[di+0],'.'
	mov     MusicFileName[di+1],'M'
	mov     MusicFileName[di+2],'O'
	mov     MusicFileName[di+3],'D'
	mov     MusicFileName[di+4],0
	push    ds
	push    offset MusicFileName
	call    _DMopenFile
	jc      short @@NotMODF
	push    ax
	call    _DMcloseFile
	jmp     short @@ExtensionPresent
      @@NotMODF:
	;TRY OPEN MODULE AS A S3M WITH .S3M EXTENSION
	mov     MusicFileName[di+0],'.'
	mov     MusicFileName[di+1],'S'
	mov     MusicFileName[di+2],'3'
	mov     MusicFileName[di+3],'M'
	mov     MusicFileName[di+4],0
	push    ds
	push    offset MusicFileName
	call    _DMopenFile
	jc      @@NotS3MF
	push    ax
	call    _DMcloseFile
	jmp     short @@ExtensionPresent
      @@NotS3MF:
	;TRY OPEN MODULE AS A AMM WITH .AMM EXTENSION
	mov     MusicFileName[di+0],'.'
	mov     MusicFileName[di+1],'A'
	mov     MusicFileName[di+2],'M'
	mov     MusicFileName[di+3],'M'
	mov     MusicFileName[di+4],0
	push    ds
	push    offset MusicFileName
	call    _DMopenFile
	jc      @@LoadError
	push    ax
	call    _DMcloseFile
	;jmp     short @@ExtensionPresent
	@@ExtensionPresent:
	@@FoundDot:
	mov     PP_FileNameFlag,1               ;Set -- file name specified
	inc     ParamNum                        ;Next param!
	jmp     @@ReadCmdParam                  ;Read for next option.
@@DoneCmdLine:


IF RTC EQ 0
	;RE-SET THE SPEED OF TCM
	mov     TCM_SpeedScale, 1 ;10
	mov     TCM_MaxRate,    Speed
	mov     TCM_Divisor[0], 1193180/SPEED ;16500
	mov     TCM_Divisor[2], 1193180/SPEED ;16900
	call    _TCMreinit
ELSE
	mov     al,0Eh
	out     070h,al
	in      al,071h
	test    al,10000000b
	jnz     @@Error
ENDIF

	;PREPARE SYSTEM - Does cumulative errors

comment #

push    word ptr 1 ; Use No-sound 65535
call    _AMinitSystem

;*********************************************************************
push    word ptr 44100/1  ;Rate
push    word ptr 11b    ;16-bits, stereo .8-bit, Mono
call    _AMstart
call    _AMmusicInit
;------------------------------------------------------------------
	push    ds
	push    offset FileNameSHIT
	call    _DMopenFile

	mov     HandleSHIT,ax
	push    HandleSHIT
	push    dword ptr 0
	call    _AMmusicLoadS3M
	;push    word ptr 0              ;Sequence 0
	push    PP_StartPat
	call    _AMmusicPlay



comment ~




	;push    word ptr 256/2 ;32768+1
	;call    _AMamplification
	;push    word ptr 32
	;call    _AMmusicMasterVolume

	@@AgainSHIT:
	call    _AMpoll
	hlt
	hlt
	hlt
	hlt
	mov     ah,1
	int     016h
	jz      @@AgainSHIT


~


	call    _AMmusicStop
	call    _AMmusicUnload
	push    HandleSHIT
	call    _DMcloseFile




call    _AMmusicDeinit
call    _AMstop

call    _AMdeinitSystem


#

























	;INIT STAGE
	push    word ptr 65535                  ;Autodetect
	call    _AMsearchHardware
	jc      @@NoSoundCard
	cmp     ax,0
	je      @@NoSoundCard
	push    ax                              ;Initialize system
	call    _AMinitSystem
	push    word ptr PP_MixRate             ;Start sounds playback
	push    PP_FeatureFlag ;word ptr 00b                    ;8-bits mono
	call    _AMstart
	call    _AMmusicInit                    ;Initialize music system
	jc      @@InitError                     ; ACCUMULATES ERRORS! 


	;PRINT HARDWARE INFO!
	comment ~
	push    AM@SB                      ;Print sound card type
	call    _AMgetHardwareInfo
	mov     es,dx
	mov     bx,ax
	mov     dx,OFFSET DSP1
	cmp     [es:bx][SDIhardware.SDIVersion],0200h
	jb      short @@FoundDSP
	mov     dx,OFFSET DSP2
	cmp     [es:bx][SDIhardware.SDIVersion],0201h
	jb      short @@FoundDSP
	mov     dx,OFFSET DSP21
	cmp     [es:bx][SDIhardware.SDIVersion],0300h
	jb      short @@FoundDSP
	mov     dx,OFFSET DSP3
	cmp     [es:bx][SDIhardware.SDIVersion],0400h
	jb      short @@FoundDSP
	mov     dx,OFFSET DSP4
	@@FoundDSP:
	mov     ah,9
	int     21h
	mov     dx,OFFSET Imono                 ;Mono/stereo
	test    [es:bx][SDIhardware.SDIflags],1b
	jz      short @@Mono
	mov     dx,OFFSET Istereo
	@@Mono:
	mov     ah,9
	int     21h
	mov     dx,OFFSET I8                    ;8/16 bit
	test    [es:bx][SDIhardware.SDIflags],10b
	jz      short @@bit16
	mov     dx,OFFSET I16
	@@bit16:
	mov     ah,9
	int     21h

	mov     dx,OFFSET Irate16               ;Rate
	cmp     [es:bx][SDIhardware.SDIMixingRate],21379
	jb      short @@FoundRate
	mov     dx,OFFSET Irate22
	cmp     [es:bx][SDIhardware.SDIMixingRate],43478
	jb      short @@FoundRate
	mov     dx,OFFSET Irate44
	@@FoundRate:
	mov     ah,9
	int     21h
	~

	;LOADING STAGE
	;OPEN MODULE...
	push    ds
	push    offset MusicFileName
	call    _DMopenFile
	mov     MusicFileHandle,ax
	;LOAD MODULE...
	mov     dx,offset TXT_Loading
	mov     ah,9
	int     21h
	xor     bx,bx
	mov     ah,0eh
	@@PrintFileName:
	mov     al,MusicFileName[bx]
	or      al,al
	jz      short @@EOFN
	push    bx
	mov     bx,00007h       ;Just in case...correct colour and page
	int     010h
	pop     bx
	inc     bx
	jmp     @@PrintFileName
	@@EOFN:

	push    MusicFileHandle                 ;Try as AMM
	push    dword ptr 0
	call    _AMmusicLoadAMM
	jnc     short @@Loaded
	cmp     ax,ERR_BadData ;If not bad data, must be some other error!
	jne     short @@LoadErr1
	push    MusicFileHandle                 ;Try as S3M
	push    dword ptr 0
	call    _AMmusicLoadS3M
	jnc     short @@Loaded
	cmp     ax,ERR_BadData ;If not bad data, must be some other error!
	jne     short @@LoadErr1
	push    MusicFileHandle                 ;Try as MOD
	push    dword ptr 0
	call    _AMmusicLoadMOD
	jnc     short @@Loaded
	;cmp     ax,ERR_BadData ;If not bad data, must be some other error!
	;jne     short @@LoadErr1
      @@LoadErr1:
	;CLOSE MODULE...
	push    MusicFileHandle
	call    _DMcloseFile
	jmp     @@LoadError
      @@Loaded:                                 ;.MOD.
	;CLOSE MODULE...
	push    MusicFileHandle
	call    _DMcloseFile
	;jmp     @@LoadError
	jc      @@LoadError                     ; ACCUMULATES ERRORS! 

	;PLAYING STAGE
	;PLAY MODULE...
	;mov     dx,offset TXT_Playing           ;PIG
	;mov     ah,9
	;int     21h
	;push    word ptr 0                      ;Sequence 0
	push    PP_StartPat
	call    _AMmusicPlay
	jc      @@PlayError
	;SET AMPLIFICATION AND MASTER VOLUME
	mov     ax,MasterVolume
	shl     ax,2
	push    ax
	call    _AMmasterVolume

	cmp     PP_Amplification,0              ;Overrides /F switch
	je      short @@DefAmplification
	push    PP_Amplification
	call    _AMamplification
	jmp     short @@NormalQuality
	@@DefAmplification:

	;mov     ax,32768+1
	cmp     PP_QualityMode,0
	je      short @@NormalQuality
	;jne     short @@Quality
	;mov     ax,65535
	;@@Quality:
	push    word ptr 32768+1 ;ax
	call    _AMamplification
	@@NormalQuality:                        ;Normal for MODs...but
						;for S3Ms, we use their
						;amplification.


	push    PP_MusSystem                    ;Set PAL/NTSC system...
	call    _AMmusicSetSystem


	;HOOK POLLING ROUTINE TO INT 8
IF RTC EQ 0
	push    cs
	push    offset _Handler
	push    word ptr Speed
	push    word ptr 100                    ;Priority
	call    _TCMsetProc
	mov     PollHandle,ax
ELSE

	;ENABLE PERIODIC RTC INTERRUPT AT 1024 HZ
	cli
	mov     al,0bh                  ;Disable periodic int
	out     070h,al
	mov     al,00000010b
	out     071h,al

	mov     al,0ah                  ;Set speed
	out     070h,al
	;in      al,071h
	;;and     al,0F0h
	;;;or      al,0110b                ;Rate selection - 1024hz
	mov     al,16-6  ;64hz ;64hz (6=> 2 to the power of 6 = 64 hertz!)
	or      al,00100000b
	out     071h,al                 ;It's a divisor. Larger=Slower.

	;mov     al,0bh
	;out     070h,al
	;in      al,071h
	;;and     al,00001111b            ;Set normal block count, disable INTs
	;or      al,01000000b            ;Enable periodic int
	;out     071h,al

	mov     al,0bh                  ;Enable periodic int
	out     070h,al
	mov     al,01000010b
	out     071h,al

	push    word ptr 070h
	call    GetINT
	mov     word ptr OrigINT70[2],es
	mov     word ptr OrigINT70[0],bx
	push    word ptr 070h
	push    cs
	push    offset _Handler
	call    SetINT
	push    word ptr 8
	call    EnableIRQ
	push    word ptr 2              ;IRQ 2 also!
	call    EnableIRQ
	sti
ENDIF

	;------------------------------------------
	call    _Foreground
	mov     ReturnFlag,ax
	;;SHELL TO DOS
	;        push    ds
	;        push    offset ExeFile
	;        push    ds
	;        push    offset ExeCmd
	;        call    _UTILexec
	;-------------------------------------------
	;UNHOOK POLLING ROUTINE
IF RTC EQ 0
	push    PollHandle
	call    _TCMdelProc
ELSE
	mov     al,0bh                          ;Disable RTC interrupt.
	out     070h,al
	in      al,071h
	and     al,NOT 01000000b
	out     071h,al
	push    word ptr 070h
	push    OrigINT70
	call    SetINT
ENDIF

	;DEINIT STAGE
	;STOP AND UNLOAD MODULE
	call    _AMmusicStop
	call    _AMmusicUnload
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	jc      @@DeinitError

;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;



@@Done:
mov     bx,ReturnFlag
GMdeinit        bx
ret
@@Error:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_Error
	mov     ah,9
	int     021h
	mov     ReturnFlag,2
	jmp     short @@Done
@@NoSoundCard:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_NoSoundCard
	mov     ah,9
	int     21h
	mov     ReturnFlag,3
	jmp     @@Done
@@NoParam:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_NoParam
	mov     ah,9
	int     21h
	mov     ReturnFlag,4
	jmp     @@Done
IF RTC EQ 1
@@RTCerror:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_RTC
	mov     ah,9
	int     21h
	mov     ReturnFlag,5
	jmp     @@Done
ENDIF
@@InitError:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_Init
	mov     ah,9
	int     21h
	mov     ReturnFlag,6
	jmp     @@Done
@@PlayError:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_Play
	mov     ah,9
	int     21h
	;UNLOAD MODULE
	call    _AMmusicUnload
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	mov     ReturnFlag,7
	jmp     @@Done
@@LoadError:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_Load
	mov     ah,9
	int     21h
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	mov     ReturnFlag,8
	jmp     @@Done
@@DeinitError:
	mov     ax,03h
	int     010h
	mov     dx,offset ERRTXT_Deinit
	mov     ah,9
	int     21h
	mov     ReturnFlag,9
	jmp     @@Done
_main   endp

;
SetupScreen     proc    uses ax bx cx dx si di es
	;xor     bh,bh
	;mov     ah,2                    ;SET CURSOR POS
	;mov     dh,255  ;Row 255 - turn off cursor by positioning it outside!
	;xor     dl,dl   ;Col 0
	;int     010h

	;Load screen!
;mov     PP_VIDseg,0b000h
	mov     ax,03h  ;07h  ;
	int     010h
	mov     si,offset PPTITLE       ;TheDraw uncrunch routine...
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     di,0
	mov     cx,PPTITLE_LENGTH
	call    uncrunch
	;PRINT MUSIC NAME
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	add     di,MusicX.MUSname
	push    bp
	mov     ax,01301h               ;String with attrib in BL
	xor     bh,bh                   ;Page0
	mov     bl,01bh                 ;Attribute
	mov     cx,40                   ;40 chars
	mov     dh,4                    ;Row 4
	mov     dl,1                    ;Col 1
	mov     bp,di                   ;ES:BP=String
	int     010h
	pop     bp

	;DISABLE CURSOR
	mov     ah,1
	mov     cx,0ffffh
	int     010h


	clc
	ret
	ENDP

;
BarScreenOffset dw (160*6)+(2*8)+1 ;(160*21)+(2*8)+1     ;(160*6)+(2*4)+1      ;



;
;VERTICAL BARS

DrawBars proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

Attribute    = 02Ah ;02Ah
BlankAttribute=008h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,BarScreenOffset

	cmp     cx,16
	jbe     short @@BigBars
@@SmallBars:
	CODE_ALIGN
      @@DrawChannelBars2:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,2 ;1                           ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar2
	@@DrawActive2:
	mov     byte ptr es:[di],Attribute
	sub     di,160
	loop    @@DrawActive2
	@@NoBar2:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,16   ;32 ;64 ;
	jz      short @@NoBlankBar2
	@@DrawBlank2:
	mov     byte ptr es:[di],BlankAttribute
	sub     di,160
	loop    @@DrawBlank2
	@@NoBlankBar2:
      pop       di cx
	add     di,2*2 ;2*2 ;2*4   ;(160) ;       ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars2
	ret
@@BigBars:
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,2 ;1                           ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	mov     byte ptr es:[di],Attribute
	mov     byte ptr es:[di+2],Attribute
	mov     byte ptr es:[di+4],Attribute
	sub     di,160
	loop    @@DrawActive
	@@NoBar:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,16   ;32 ;64 ;
	jz      short @@NoBlankBar
	@@DrawBlank:
	mov     byte ptr es:[di],BlankAttribute
	mov     byte ptr es:[di+2],BlankAttribute
	mov     byte ptr es:[di+4],BlankAttribute
	sub     di,160
	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,2*4 ;2*2 ;2*4   ;(160) ;       ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars endp



;
;HORIZONTAL BARS
DrawBars2 proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

Attribute    = 02Ah ;02Ah
BlankAttribute=008h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1

	mov     dx,cx                   ;Limit to 16 channels per side
	cmp     cx,16
	jbe     short @@LeftOnly
	mov     cx,16
	@@LeftOnly:
	sub     dx,cx

	mov     di,BarScreenOffset
	push    dx
	;=============DRAW LEFT BARS (CHANNEL 1 TO 16)
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     al,[fs:si][TrackX.TRKvolumeBar]
	xor     ah,ah
	shr     al,1                    ;Div volume bar. Make 0-32!
	jz      @@NoBar
	;===DRAW ACTIVE PART===
	push    ax
	@@DrawActive:
	mov     byte ptr es:[di],Attribute
	add     di,2
	dec     ax
	jnz     short @@DrawActive
	pop     ax
	@@NoBar:
	;===DRAW BLANK PART===
	neg     ax
	add     ax,32
	jz      short @@NoBlankBar
	@@DrawBlank:
	mov     byte ptr es:[di],BlankAttribute
	add     di,2
	dec     ax
	jnz     short @@DrawBlank
	@@NoBlankBar:
      pop       di cx
      add       di,160
      inc       ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	pop     dx



	;=============DRAW RIGHT BARS (CHANNEL 16 TO 32)
	or      dx,dx
	jz      short @@NoRightBar
	mov     di,BarScreenOffset
	add     di,63*2           ;Right of screen
	mov     cx,dx
      @@DrawChannelBars2:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     al,[fs:si][TrackX.TRKvolumeBar]
	xor     ah,ah
	shr     al,1                    ;Div volume bar. Make 0-32!
	jz      @@NoBar2
	;===DRAW ACTIVE PART===
	push    ax
	@@DrawActive2:
	mov     byte ptr es:[di],Attribute
	sub     di,2
	dec     ax
	jnz     short @@DrawActive2
	pop     ax
	@@NoBar2:
	;===DRAW BLANK PART===
	neg     ax
	add     ax,32
	jz      short @@NoBlankBar2
	@@DrawBlank2:
	mov     byte ptr es:[di],BlankAttribute
	sub     di,2
	dec     ax
	jnz     short @@DrawBlank2
	@@NoBlankBar2:
      pop       di cx
      add       di,160
      inc       ChannelNum
      dec       cx
      jnz       @@DrawChannelBars2
      @@NoRightBar:

	ret
DrawBars2 endp








comment ~
;
DrawBars proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

ScreenOffset = (160*6)+(2*4)+1      ;(160*21)+8+1
Attribute    = 02Ah ;02Ah
BlankAttribute=019h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,ScreenOffset
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,1 ;2                            ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	;mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di+2],Attribute
	;mov     byte ptr es:[di+4],Attribute
	;sub     di,160

	mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di-1],254
	inc     di
	inc     di

	loop    @@DrawActive
	@@NoBar:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,32 ;64 ;16
	jz      short @@NoBlankBar
	@@DrawBlank:
	;mov     byte ptr es:[di],BlankAttribute
	;mov     byte ptr es:[di+2],BlankAttribute
	;mov     byte ptr es:[di+4],BlankAttribute
	;sub     di,160

	mov     byte ptr es:[di],BlankAttribute
	inc     di
	inc     di

	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,(160) ;2*4          ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars endp

;
DrawBars proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

ScreenOffset = (160*6)+(2*4)+1      ;(160*21)+8+1
Attribute    = 02Ah ;02Ah
BlankAttribute=019h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,ScreenOffset
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,1 ;2                            ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	;mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di+2],Attribute
	;mov     byte ptr es:[di+4],Attribute
	;sub     di,160

	mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di-1],254
	inc     di
	inc     di

	loop    @@DrawActive
	@@NoBar:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,32 ;64 ;16
	jz      short @@NoBlankBar
	@@DrawBlank:
	;mov     byte ptr es:[di],BlankAttribute
	;mov     byte ptr es:[di+2],BlankAttribute
	;mov     byte ptr es:[di+4],BlankAttribute
	;sub     di,160

	mov     byte ptr es:[di],BlankAttribute
	inc     di
	inc     di

	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,(160) ;2*4          ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars endp







DrawBars2 proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

CAttribute   = 00ADBh
CAttribute2  = 00ADCh
CBlankAttribute=008FAh          ;'' dot is drawn !

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,BarScreenOffset
	dec     di      ;Even address start!
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,1                    ;Reduce to 0-32
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	mov     word ptr es:[di],CAttribute
	mov     word ptr es:[di+2],CAttribute
	mov     word ptr es:[di+4],CAttribute
	sub     di,160
	sub     cx,2
	jz      @@DoneBright
	jnc     short @@DrawActive
	;--Overflow, means there is a small line (sub-row)
	mov     word ptr es:[di],CAttribute2
	mov     word ptr es:[di+2],CAttribute2
	mov     word ptr es:[di+4],CAttribute2
	sub     di,160
	pop     cx              ;Decrement count... so that blanking won't overwrite
	dec     cx
	push    cx
	@@DoneBright:
	@@NoBar:
	pop     cx

	;===DRAW BLANK PART===
	shr     cx,1            ;From here, all are multiples of 2...
	neg     cx
	add     cx,16 ;32
	jz      short @@NoBlankBar
	@@DrawBlank:
	mov     word ptr es:[di],CBlankAttribute
	mov     word ptr es:[di+2],CBlankAttribute
	mov     word ptr es:[di+4],CBlankAttribute
	sub     di,160
	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,2*4   ;(160) ;       ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars2 endp
~
;
DrawPosition proc   uses eax ebx cx dx si di es

ProgressLen = 78
ProgressBarOffset = (160*24)+(1*2)

	;xor     bh,bh
	;mov     ah,2                    ;SET CURSOR POS
	;mov     dh,8    ;Row 7
	;xor     dl,dl   ;Col 0
	;int     010h


	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	push    ds                      ;LENGTH:
	push    offset TxtLength2
	mov     ax,[es:di][MusicX.MUSsongPlayLength]
	dec     ax
	push    ax
	push    word ptr 0              ;Not signed
	call    _UTILcnvDW2DecStr


	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	mov     dx,[es:di][MIX.MIcurrentSequence]


	;mov     ax,AM.AM_MasterVolume      ;Update master vol
	;shr     ax,2
	;mov     MasterVolume,ax

	push    ds                      ;SEQ:
	push    offset TxtSequence2
	push    [es:di][MIX.MIcurrentSequence]
	push    word ptr 0              ;Not signed
	call    _UTILcnvDW2DecStr
	push    ds                      ;ROW
	push    offset TxtRow2
	push    [es:di][MIX.MIcurrentRow]
	push    word ptr 0              ;Not signed
	call    _UTILcnvDW2DecStr
	push    ds                      ;MASTERVOLUME
	push    offset Volume2
	push    MasterVolume
	push    word ptr 0              ;Not signed
	call    _UTILcnvDW2DecStr

	;mov     dx,offset TxtSequence
	;mov     ah,9
	;int     021h

	;mov     dx,offset TxtSequence
	;mov     ah,9
	;int     021h

	push    bp
	mov     ax,01301h               ;String with attrib in BL
	xor     bh,bh                   ;Page0
	mov     bl,017h                 ;Attribute
	mov     cx,TXT_POSITION_LEN
	mov     dh,4                    ;Row 4
	mov     dl,40                   ;Col 40
	push    ds
	pop     es
	mov     bp,offset TXT_POSITION  ;ES:BP=String
	int     010h
	pop     bp

	;DRAW PROGRESS BAR
	cld
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][MusicX.MUSsongPlayLength]
	;dec     cx
	shl     cx,6
dec     cx      ;!! MUST DECREMENT BY 1 FOR FULL BAR...
	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	mov     bx,[es:di][MIX.MIcurrentSequence]
	shl     bx,6                    ;x 64 rows per pattern
	add     bx,[es:di][MIX.MIcurrentRow]
	mov     ax,ProgressLen          ;78 chars wide!
	mul     bx
	div     cx
	mov     cx,ax
	mov     es,PP_VIDseg
	mov     di,ProgressBarOffset
	push    cx
	mov     al,0DCh                  ;Char   ;ACTIVE
	mov     ah,01Eh                 ;Attrib
	rep     stosw
	pop     cx
	neg     cx
	add     cx,ProgressLen
	;mov     al,0DFh                 ;Char   ;BLANK
	mov     ah,018h                 ;Attrib
	rep     stosw

	ret
DrawPosition    endp

;
DrawSamples proc   uses ax bx cx dx si di es fs
	local   TMPnumberRows:WORD

	;cmp     PP_Screen,1
	;je      short @@ScreenAlreadySet
	;
	;Check for VGA
	;
	mov     ax,03h                          ;Set TEXT MODE
	int     010h
	mov     TMPnumberRows,25
	mov     ax,01a00h
	int     010h
	cmp     al,01ah
	jne     short @@NoVGA
	;cmp     bl,08h                          ;VGA colour
	;jne     short @@NoVGA
	mov     TMPnumberRows,50
	;===SET 50 ROWS
	xor     ax,ax
	mov     es,ax
	mov     dx,es:[0463h]   ;[045bh]   ;
	mov     byte ptr es:[0484h],031h        ;Number rows-1
	mov     word ptr es:[044ah],050h        ;Number columns
	mov     word ptr es:[0485h],8           ;Bytes per character (EGA)
						;should be 8...but Adrian
						;put it as 7 ???
	mov     ax,01112h                       ;Load ROM 8x8 font
	mov     bl,0
	int     010h
	mov     ah,03h                          ;Recommended for MCGA...
	mov     bl,0                            ;Set Block Specifier ???
	int     010h
	cmp     byte ptr es:[0484h],031h        ;50 rows mode set.
	je      short @@NoVGA
	;ELSE, NOT 50 ROWS! MIGHT BE EGA. FORCE 80X25.
	mov     ax,03h
	int     010h
	mov     TMPnumberRows,25
	@@NoVGA:

	;CLEAR SCREEN
	mov     es,PP_VIDseg
	xor     di,di
	mov     ax,80
	mul     TMPnumberRows
	mov     cx,ax
	mov     al,' '
	mov     ah,01Eh
	cld
	rep     stosw
	;xor     bh,bh   ;Turn off cursor (pos outside screen)
	;mov     ah,2
	;mov     dh,255
	;xor     dl,dl
	;int     010h
	;DISABLE CURSOR
	mov     ah,1
	mov     cx,0ffffh
	int     010h

	;DRAW SEPARATING LINE...
	mov     es,PP_VIDseg
	mov     di,(2*40)
	mov     ah,019h ;Attribute
	mov     al,''
	mov     cx,TMPnumberRows
	@@SLine:
	mov     es:[di],ax
	add     di,160
	loop    @@Sline
	@@ScreenAlreadySet:


	;SCREEN 1       1-25          51-75
	;SCREEN 2       26-50         76-100    Screen 2 => +25...
	mov     bx,1
	cmp     TMPnumberRows,50        ;If VGA, unnecessary
	je      short @@FullScreen
	cmp     PP_SampleScreen,0
	je      @@First
	add     bx,25
	@@First:
	@@FullScreen:

;DRAW SAMPLE NAMES...
	;===DRAW LEFT COLUMN
	push    bx
	mov     di,(2*5)
	mov     cx,TMPnumberRows
      @@Left:
	push    di
	push    bx
	call    _AMmusicGetSampleInfo
	mov     fs,dx
	mov     si,ax
	mov     dx,30           ;Sample name 30 chars long
	mov     ah,01Fh         ;Attribute
	@@CopyLeft:
	mov     al,[fs:si][SmpX.SMPname]
	or      al,al
	jz      short @@DoneL   ;NAME ENDS WITH CHAR 0
	mov     es:[di],ax
	inc     si
	inc     di
	inc     di
	dec     dx
	jnz     short @@CopyLeft
	@@DoneL:
	pop     di
	add     di,(160*1)
	inc     bx
	loop    @@Left
	pop     bx

	;===DRAW RIGHT COLUMN
	add     bx,50
	mov     di,(2*(40+5))
	mov     cx,TMPnumberRows
      @@Right:
	push    di
	push    bx
	call    _AMmusicGetSampleInfo
	mov     fs,dx
	mov     si,ax
	mov     dx,30           ;Sample name 30 chars long
	mov     ah,01Fh         ;Attribute
	@@CopyRight:
	mov     al,[fs:si][SmpX.SMPname]
	or      al,al
	jz      short @@DoneR   ;NAME ENDS WITH CHAR 0
	mov     es:[di],ax
	inc     si
	inc     di
	inc     di
	dec     dx
	jnz     short @@CopyRight
	@@DoneR:
	pop     di
	add     di,(160*1)
	inc     bx
	loop    @@Right

	ret
DrawSamples ENDP

;
;PERIODICAL POLLING ROUTINE
;
	TMPmyStack      dd 0
	TMPstack        dw 128 dup(0)
	TMPstackLen = $-(offset TMPstack)
CODE_ALIGN
_Handler proc far
	mov     word ptr TMPmyStack[0],sp
	mov     word ptr TMPmyStack[2],ss
	mov     sp,seg TMPstack
	mov     ss,sp
	mov     sp,(offset TMPstack)+TMPstackLen-2
	push    eax ds

	setDS

	cmp     TimerEnableFlag,0               ;Enable int?
	je      short @@NoTimerEnable
	mov     al,020h
	out     020h,al
	sti
	@@NoTimerEnable:

IF RTC NE 0
	;dec     Count                           ;Poll
	;jnz     short @@NotYet
	;mov     ax,CountsPerTick
	;mov     Count,ax
ENDIF


	comment ~
	;SYNC TO VERTICAL RETRACE
		PUSH    AX BX DX
		mov     dx,03dah
		mov     bx,04204h ;TCM_Divisor[0]       ;04204h
		in      al,dx
		test    al,1
		jnz     short @@Ok1
		mov     bx,04074h ;TCM_Divisor[0]       ;04074h
		@@Ok1:
		in      al,dx
		test    al,1
		jnz     short @@Ok1
		mov     al,036h
		out     043h,al
		mov     al,bl   ;ax,bx
		out     040h,al
		mov     al,bh   ;al,ah
		out     040h,al
		@@NormalUpdateMethod:
		POP     DX BX AX

	push    dx
	mov     dx,03dah
	in      al,dx
	mov     dx,03c0h
	mov     al,011h or 020h
	out     dx,al
	mov     al,12
	out     dx,al
	pop     dx
	~

	call    _AMpoll

	comment ~
	push    dx
	mov     dx,03dah
	in      al,dx
	mov     dx,03c0h
	mov     al,011h or 020h
	out     dx,al
	mov     al,0
	out     dx,al
	pop     dx
	~


	;int 028h

	@@NotYet:

IF RTC NE 0
;        pushf                                   ;Call original
;        call    OrigINT70
;        ;Dunno why, but I need to do this here.
;        ;ENABLE PERIODIC RTC INTERRUPT AT 1024 HZ
;        mov     al,0bh
;        out     070h,al
;        jmp     $+2
;        in      al,071h
;        ;or      al,01110000b
;        or      al,01000000b
;        out     071h,al
;        jmp     $+2

	mov     al,0ch  ;Dunno if this is useful...
	out     070h,al ;Found it in a RTC example...
	jmp     $+2
	in      al,071h

	mov     al,020h                         ;EOI
	out     020h,al         ;This is required (dunno why)
	out     0A0h,al

ENDIF
	pop     ds eax
	lss     sp,TMPmyStack
	iret
	ENDP



;
;---------------------------------------------------------------------
;
;
ClockSpeed      =  10
ClockDelay      dw ClockSpeed
ClockCount      dw 0
ClockChars      db '/\/\'
;ClockChars      db ' ۲'
TxtSystem       db ' PALNTSC'

Shades          db ' '
;Shades          db ''

_UpdateScreen   PROC
	cmp     PP_Screen,1
	je      short @@DrawSam
	;test    PP_Screen,1
	;jnz     short @@DrawSam
	;cmp     PP_Screen,1
	ja      short @@DrawBlank

mov     BarScreenOffset,(160*21)+(2*8)+1        ;Vertical
cmp     BarType,0
je      short @@B1
mov     BarScreenOffset,(160*6)+(2*8)+1         ;Horizontal
@@B1:

	call    SetupScreen
	jmp     short @@MainS
	@@DrawSam:
	call    DrawSamples
	jmp     short @@MainS

      @@DrawBlank:
	;Clear screen to total shit!!
;        mov     BarScreenOffset,(160*24)+(2*8)+1 ;Slightly lower bars...

mov     BarScreenOffset,(160*24)+(2*8)+1        ;Vertical
cmp     BarType,0
je      short @@B2
mov     BarScreenOffset,(160*6)+(2*8)+1         ;Horizontal
@@B2:

	mov     ax,03h
	int     010h
	mov     ah,1                    ;;DISABLE CURSOR
	mov     cx,0ffffh
	int     010h

	;mov     si,offset PPTITLE2      ;TheDraw uncrunch routine...
	;mov     ax,PP_VIDseg
	;mov     es,ax
	;mov     di,0
	;mov     cx,PPTITLE2_LENGTH
	;call    uncrunch

	mov     es,PP_VidSeg
	;xor     di,di   ;mov     di,160*8 ;
	;mov     al,'' ;'' ;Shades[bx]           ;Character
	;mov     ah,008h
	;mov     cx,80*25        ;(80*17)
	;rep     stosw



	;comment ~
	mov     si,80*25*2
	;mov     di,0 ;80*25*2

	;push    es
	;xor     ax,ax
	;mov     es,ax
	;mov     cx,[es:046ch]
	;pop     es
	mov     cx,52391                ;Seed
      @@DrawRandom:
	mov     ax,23173
	mul     cx
	add     ax,13849
	adc     dx,0
	xor     dx,cx
	xor     dx,ax
	mov     cx,dx                   ;New Seed

	;mov     ax,dx                   ;Get Value MOD 5
	;xor     dx,dx
	;mov     bx,4 ;5
	;div     bx
	;mov     bx,dx

	mov     bx,dx
	and     bx,11b

	mov     al,Shades[bx]           ;Character
	mov     ah,008h                 ;Attribute
	;stosw
	mov     [es:si],ax
	dec     si
	dec     si
	jnz     short @@DrawRandom
	;~

	@@MainS:
	RET
	ENDP

_Foreground     PROC

	call    _UpdateScreen

	@@Again:
	;CHECK END OF SONG? RESTART BY DEFAULT. QUIT IF DONE.
	test    AM.AM_Status,1 SHL 14
	jz      short @@HaveNotRestarted
	and     AM.AM_Status,NOT (1 SHL 14)     ;Clear flag
	cmp     PP_NoLoopFlag,0                 ;User selected no-loop mode
	je      short @@HaveNotRestarted
	mov     ax,03h
	int     010h
	mov     ax,NEXT_SONG
	jmp     @@Quitting
	@@HaveNotRestarted:

	;Decrement master volume in last pattern for smoother fade-out...
	cmp     PP_NoLoopFlag,0
	je      short @@NoLoopFade
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     bx,[es:di][MusicX.MUSsongPlayLength]
	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	;mov     [es:di][MIX.MIcurrentRow],0
	;mov     [es:di][MIX.MItickCount],1      ;IMMEDIATE RESPONSE
	mov     ax,[es:di][MIX.MIcurrentSequence]
	inc     ax
	cmp     ax,bx                   ;Last row only
	jb      @@NoLoopFade
	mov     PP_FadeFlag,1                   ;1=Fading!
	mov     ax,[es:di][MIX.MIcurrentRow]     ;Decrement at each row...
	neg     ax
	add     ax,63
	mul     MasterVolume
	;shr     ax,6
	;shl     ax,2
	shr     ax,4    ;(shr 6, shl 2)
	push    ax
	call    _AMmasterVolume
	jmp     short @@SkipNoLoopFade
	@@NoLoopFade:
	mov     PP_FadeFlag,0
	mov     ax,MasterVolume         ;If not end, constantly set master
	shl     ax,2                    ;volume (yucky!)
	push    ax
	call    _AMmasterVolume
	@@SkipNoLoopFade:



	;UPDATE OTHER STUFFS
	cmp     PP_screen,1
	ja      short @@NoPyroButDrawBars2
	je      short @@NoPyroTechnics

	;=====Draw PAL/NTSC thingy in main screen
	mov     es,PP_VidSeg
	mov     di,(160*23)+(2*75)      ;At pos 75,23
	mov     bx,PP_MusSystem
	shl     bx,2
	mov     ah,019h                 ;Bright blue over blue
	cld
	mov     al,TxtSystem[bx+0]
	stosw
	mov     al,TxtSystem[bx+1]
	stosw
	mov     al,TxtSystem[bx+2]
	stosw
	mov     al,TxtSystem[bx+3]
	stosw


	;DRAW 'CLOCK' AT BOTTOM RIGHT OF SCREEN...SHOW CPU POWER AVAILABLE
	;8 characters only...
	dec     ClockDelay
	jnz     short @@NotClock
	mov     ClockDelay,ClockSpeed
	mov     bx,ClockCount
	mov     al,ClockChars[bx]
	mov     ah,019h                 ;Clock attribute
	inc     ClockCount
	and     ClockCount,111b
	mov     es,PP_VIDseg
	mov     bx,(160*24)+(2*79)
	mov     es:[bx],ax
	@@NotClock:
	call    DrawPosition
	call    DrawBarRoutine ;s
	;call    DrawScope
	;call    DrawGraphicBars
	jmp     short @@NoPyroTechnics
	@@NoPyroButDrawBars2:
	call    DrawBarRoutine ;DrawBars ;2
	@@NoPyroTechnics:

	mov     ah,1
	int     016h
	jz      @@Again
	mov     ah,0
	int     016h

	cmp     PP_screen,1             ;Hidden message available only in
	je      short @@NotMagic        ;main screen!
	cmp     ax,_ShiftF10            ;MAGIC KEY
	jne     short @@NotMagic
	;mov     ax,0e07h                ;Beep!
	;int     010h
	;===Clear the word Platinum Play 3.2 (grey)
	mov     es,PP_VIDseg
	mov     di,(160*6)+(2*8)
	mov     dx,16   ;16 rows
	@@ClrM:
	push    di
	mov     ax,00820h
	mov     cx,4*16
	rep     stosw
	pop     di
	add     di,160
	dec     dx
	jnz     short @@ClrM
	;===Display magic text
	;mov     es,PP_VIDseg
	mov     bx,(160*5)+(2*13)       ;Start from 5th row...the border.
	xor     si,si
	mov     di,bx
	@@PrtM:
	mov     al,TXT_Magic[si]
	cmp     al,1
	ja      short @@NormalTxt
	jb      short @@DoneMagic
	add     bx,160
	mov     di,bx
	inc     si
	jmp     short @@PrtM
	@@NormalTxt:
	mov     [es:di],al
	inc     si
	inc     di
	inc     di
	jmp     short @@PrtM
	@@DoneMagic:
	;mov     ax,0e07h                ;Beep!
	;int     010h
	@@NotMagic:

;
;WHOOPS!! FORGOT THAT WE NEED AX ALL THE TIME!
;IF WE RETURN AX CHANGED TO SOMETHING ELSE, WE MIGHT DO 2 OPERATIONS!!
;ARRGH!;
;SAVE AX!!
;

	cmp     ax,_accentgrave         ;PAL/NTSC selection!
	jne     short @@NotSys
	push    ax
	xor     PP_MusSystem,1
	push    PP_MusSystem
	call    _AMmusicSetSystem
	pop     ax
	@@NotSys:

	;Fxx keys -- FAST VOLUME SET
	cmp     ax,03b00h
	jb      short @@NotFxx
	cmp     ax,04400h
	ja      short @@NotFxx
	push    ax bx
	sub     ah,03bh                 ;Convert volume to 0-64 from 0-9
	shr     ax,8-6                  ;Move to lower bits, x 64
	mov     bl,9                    ;KeyVal x 64 / 9
	div     bl
	xor     ah,ah
	mov     MasterVolume,ax
	shl     ax,2
	push    ax
	call    _AMmasterVolume
	pop     bx ax
	@@NotFxx:

	cmp     ax,_upperH              ;Help
	je      short @@DoHelp
	cmp     ax,_lowerH
	jne     short @@NotHelp
	@@DoHelp:
	;==========DISPLAY HELP SCREEN===========
	mov     ax,03h  ;07h  ;
	int     010h
	mov     si,offset PPHELP        ;TheDraw uncrunch routine...
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     di,0
	mov     cx,PPHELP_LENGTH
	call    uncrunch
	mov     ah,1                    ;Disable cursor
	mov     cx,0ffffh
	int     010h
	xor     ah,ah
	int     016h
	call    _UpdateScreen
	@@NotHelp:



	cmp     ax,_ESC                 ;QUIT
	jne     short @@NotQuitting
	mov     ax,03h
	int     010h
	mov     ax,END_SONG
	jmp     @@Quitting
	@@NotQuitting:

	cmp     ax,_TAB                 ;SWITCH BETWEEN MAIN SCRN/SAMPLES
	jne     short @@NotS
	push    ax
	xor     PP_Screen,1b
	call    _UpdateScreen
	pop     ax
	@@NotS:

	cmp     ax,_AltF10              ;SWITCH BETWEEN BLANK/MAIN SCRN
	jne     short @@NotB
	;push    ax
	;xor     PP_Screen,10b           ;Set to blank page
	mov     PP_Screen,2
	call    _UpdateScreen
	;pop     ax
	@@NotB:

	cmp     ax,_AltF1               ;Main screen
	jne     short @@NotF1
	mov     PP_Screen,0
	call    _UpdateScreen
	@@NotF1:
	cmp     ax,_AltF2               ;Samples screen screen
	jne     short @@NotF2
	mov     PP_Screen,1
	call    _UpdateScreen
	@@NotF2:

	cmp     ax,_Up                  ;SCREEN 1 FOR SAMPLES 25 ROWS
	jne     short @@NotUp
	mov     PP_SampleScreen,0
	cmp     PP_Screen,1
	jne     short @@NoUpdateU
	call    DrawSamples
	@@NoUpdateU:
	@@NotUp:
	cmp     ax,_Down                ;SCREEN 2 FOR SAMPLES 25 ROWS
	jne     short @@NotDown
	mov     PP_SampleScreen,1
	cmp     PP_Screen,1
	jne     short @@NoUpdateD
	call    DrawSamples
	@@NoUpdateD:
	@@NotDown:

	cmp     ax,_GreyPlus            ;VOLUME INCREASE
	je      @@VolInc
	cmp     ax,_Plus
	jne     short @@NotVolInc
	@@VolInc:
	cmp     PP_FadeFlag,1           ;Disable volume setting when fading
	je      short @@NotVolInc
	mov     ax,MasterVolume
	inc     ax
	cmp     ax,256/4
	jbe     short @@VolIncOK
	mov     ax,256/4
	@@VolIncOK:
	mov     MasterVolume,ax
	shl     ax,2
	push    ax
	call    _AMmasterVolume
	@@NotVolInc:

	cmp     ax,_GreyMinus           ;VOLUME DECREASE
	je      @@VolDec
	cmp     ax,_Minus
	jne     short @@NotVolDec
	@@VolDec:
	cmp     PP_FadeFlag,1           ;Disable volume setting when fading
	je      short @@NotVolDec
	mov     ax,MasterVolume
	dec     ax
	jns     short @@VolDecOK
	xor     ax,ax
	@@VolDecOK:
	mov     MasterVolume,ax
	shl     ax,2
	push    ax
	call    _AMmasterVolume
	@@NotVolDec:

	cmp     ax,_Left                ;LEFT (REVERSE)
	jne     short @@NoLeft
	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	mov     [es:di][MIX.MInextRow],0
	mov     [es:di][MIX.MItickCount],1      ;IMMEDIATE RESPONSE
	mov     ax,[es:di][MIX.MIcurrentSequence]
	sub     ax,1
	jnc     short @@NoLeftProb
	xor     ax,ax
	@@NoLeftProb:
	mov     [es:di][MIX.MInextSequence],ax
	mov     [es:di][MIX.MIcurrentSequence],ax
	;mov     [es:di][MIX.MItargetSequence],65535 ;ax
	@@NoLeft:


	cmp     ax,_pageup              ;Pageup (increase amplification)
	jne     short @@NoPgUp
	cmp     PP_Amplification,32767  ;65535
	jae     short @@NoPgUp
	add     PP_Amplification,5
	push    PP_Amplification
	call    _AMamplification
	@@NoPgUp:

	cmp     ax,_pagedown            ;Pagedown (decrease amplification)
	jne     short @@NoPgDn
	cmp     PP_Amplification,32767  ;65535
	jae     short @@NoPgDn
	cmp     PP_Amplification,5
	jbe     short @@NoPgDn
	sub     PP_Amplification,5
	push    PP_Amplification
	call    _AMamplification
	@@NoPgDn:


	cmp     ax,_Right               ;RIGHT (FAST FORWARD)
	jne     short @@NoRight
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     bx,[es:di][MusicX.MUSsongPlayLength]
	call    _AMmusicGetState
	mov     es,dx
	mov     di,ax
	mov     [es:di][MIX.MInextRow],0
	mov     [es:di][MIX.MItickCount],1      ;IMMEDIATE RESPONSE
	mov     ax,[es:di][MIX.MIcurrentSequence]
	inc     ax
	cmp     ax,bx
	jb      @@NoRightProb

	;RESTART TIME...
	cmp     PP_NoLoopFlag,1                 ;Disabled looping
	jne     short @@NoDisLoop
	mov     ax,03h
	int     010h
	;mov     ax,0e07h
	;int     010h
	mov     ax,NEXT_SONG
	jmp     @@Quitting
	@@NoDisLoop:

	xor     ax,ax
	@@NoRightProb:
	mov     [es:di][MIX.MInextSequence],ax
	mov     [es:di][MIX.MIcurrentSequence],ax
	;mov     [es:di][MIX.MItargetSequence],65535 ;ax
	@@NoRight:

	cmp     ax,_upperN              ;NEXT SONG
	je      short @@WantNext
	cmp     ax,_lowerN
	jne     short @@NotWantNext
	@@WantNext:
	mov     ax,03
	int     010h
	mov     ax,NEXT_SONG
	jmp     @@quitting
	@@NotWantNext:

	cmp     ax,_AltD                ;DOS SHELL
	jne     short @@NoShell

	call    _AMmusicGetState        ;Enable looping first...
	mov     es,dx
	mov     di,ax
	mov     ah,[es:di][MIX.MIflag]
	mov     al,PP_NoLoopFlag
	and     [es:di][MIX.MIflag],not 1
	mov     PP_NoLoopFlag,0
	push    ax

	push    ds
	push    offset COMSPEC
	call    _UTILsearchEnvVar
	jc      @@Again                 ;CAN'T FIND ENV VAR...DON'T SHELL.
	;Go to text mode...
	mov     ax,03h
	int     010h
	mov     dx,offset TXT_Shell     ;Tell user type 'EXIT' to return.
	mov     ah,9
	int     021h


	call    _GMgetBreakFlag
	push    ax
	push    word ptr 1
	call    _GMsetBreakFlag         ;Enable break...

	push    es
	push    di
	push    ds
	push    offset CmdLine
	call    _UTILexec

	call    _GMsetBreakFlag         ;(Param already pushed beforehand)

	call    _AMmusicGetState        ;Restore looping
	mov     es,dx
	mov     di,ax
	pop     ax
	mov     [es:di][MIX.MIflag],ah
	mov     PP_NoLoopFlag,al
	and     AM.AM_Status,NOT (1 SHL 14)     ;Forget about restarts

	;Return to graphic mode. Redraw screen.
	;pushf
	;call    SetupScreen
	call    _UpdateScreen
	;popf
	;jc      @@Again                 ;CAN'T SHELL.
	@@NoShell:


	;;DO EXTRA MIXING...EXTRA SPEED WHILE IN PP3 MENU...
	;call    _AMpoll

	jmp     @@Again

      @@Quitting:
	;Must return AX=Return code of either NEXT_SONG or END_SONG!
	ret
_Foreground     ENDP
;
;
;---------------------------------------------------------------------




.CSEG_ENDS
;
END_PROGRAM     512     ;1/2k is enough! 4096




ULTRA WEIRD HORIZONTAL BARS


;
DrawBars proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

ScreenOffset = (160*6)+8+1      ;(160*21)+8+1
Attribute    = 02AH ;02Ah ;02Ah
BlankAttribute=008H ;019h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	movzx   cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,ScreenOffset
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,1 ;2                            ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	;mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di+2],Attribute
	;mov     byte ptr es:[di+4],Attribute
	;sub     di,160

	mov     byte ptr es:[di],Attribute
	inc     di
	inc     di

	loop    @@DrawActive
	@@NoBar:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,32 ;64 ;16
	jz      short @@NoBlankBar
	@@DrawBlank:
	;mov     byte ptr es:[di],BlankAttribute
	;mov     byte ptr es:[di+2],BlankAttribute
	;mov     byte ptr es:[di+4],BlankAttribute
	;sub     di,160

	mov     byte ptr es:[di],BlankAttribute
	inc     di
	inc     di

	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,(160) ;2*4          ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars endp






NICE HORIZONTAL BARS


;
DrawBars proc   uses ax bx cx dx si di es fs
	local   ChannelNum:word

ScreenOffset = (160*6)+(2*4)+1      ;(160*21)+8+1
Attribute    = 02Ah ;02Ah
BlankAttribute=019h

	;
	;DRAW BARS... :)
	;
	call    _AMmusicGetInfo
	mov     es,dx
	mov     di,ax
	mov     cx,[es:di][Musicx.MUSnumberTracks]
	mov     ax,PP_VIDseg
	mov     es,ax
	mov     ChannelNum,1
	mov     di,ScreenOffset
	CODE_ALIGN
      @@DrawChannelBars:
      push      cx di
	push    ChannelNum
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	mov     cl,[fs:si][TrackX.TRKvolumeBar]
	shr     cl,1 ;2                            ;Div volume bar. Make 0-16!
	xor     ch,ch
	;===DRAW ACTIVE PART===
	push    cx
	or      cx,cx
	jz      short @@NoBar
	@@DrawActive:
	;mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di+2],Attribute
	;mov     byte ptr es:[di+4],Attribute
	;sub     di,160

	mov     byte ptr es:[di],Attribute
	;mov     byte ptr es:[di-1],254
	inc     di
	inc     di

	loop    @@DrawActive
	@@NoBar:
	pop     cx
	;===DRAW BLANK PART===
	neg     cx
	add     cx,32 ;64 ;16
	jz      short @@NoBlankBar
	@@DrawBlank:
	;mov     byte ptr es:[di],BlankAttribute
	;mov     byte ptr es:[di+2],BlankAttribute
	;mov     byte ptr es:[di+4],BlankAttribute
	;sub     di,160

	mov     byte ptr es:[di],BlankAttribute
	inc     di
	inc     di

	loop    @@DrawBlank
	@@NoBlankBar:
      pop       di cx
	add     di,(160) ;2*4          ;Next row...
	inc     ChannelNum
      dec       cx
      jnz       @@DrawChannelBars
	ret
DrawBars endp






