 unit SysProc;

 interface

{ uses
     NewCrt;}

 var
  Dos_Error ,
  Err_Type  : integer;
  Save_Vec  : pointer;

 Type
     Dir = string[64];

 type
   TDateTime = record
     Year, Month, Day, Hour, Min, Sec: Word;
   end;

 type
   TSearchRec = record
     Fill: array[1..21] of Byte;
     Attr: Byte;
     Time: Longint;
     Size: Longint;
     Name: array[0..12] of Char;
   end;

{ Typed-file and untyped-file record }

 type
  TFileRec = record
    Handle: Word;
    Mode: Word;
    RecSize: Word;
    Private: array[1..26] of Byte;
    UserData: array[1..16] of Byte;
    Name: array[0..79] of Char;
  end;

  procedure EnableInt(Interr : byte; IRQHandler : pointer;var Save_Vec : pointer);
  procedure DisableInt(Interr : byte; var Save_Vec : pointer);
  function  GetExecPath : Dir;
  procedure GetFTime(var F; var Time: Longint);
  procedure UnpackTime(P: Longint; var T: TDateTime);
  procedure GetIntVec(IntNo: Byte; var Vector: Pointer);
  procedure SetIntVec(IntNo: Byte; Vector: Pointer);
  procedure Heap_Shrink(var Ok : boolean);
  procedure Heap_Expand;
  function  StrPas(Str: PChar): String;
  function  StrLIComp(Str1, Str2: PChar; MaxLen: Word): Integer;
  function  StrLen(Str: PChar): Word;
  function  StrPCopy(Dest: PChar; Source: String): PChar;
  function  GetEnvVar(VarName: PChar): PChar;
  function  DriveIsReady(I : byte):boolean;
  procedure File_Open(var F:file; RecSize:word);
  procedure File_Clear(var F:file; RecSize:word);
  procedure File_Close(var F:file);
  procedure File_Read(var F:file; var PToBuffer; NRec:word;var BytesRead:word);
  procedure File_Write(var F:file; var PToBuffer; NRec:word;var BytesWritten:word);
  procedure File_Seek(var F:file; Position:longint);
  procedure Delete_File(DataPath : Dir;var Delete_Ok : boolean);

 implementation

 procedure EnableInt(Interr : byte; IRQHandler : pointer;var Save_Vec : pointer);
  var
     Data : byte;
  begin
       if Interr<8 then
        begin
         GetIntVec(Interr+8,Save_Vec);
         SetIntVec(Interr+8,IRQHandler);
         Data:=port[$21];
         port[$21]:=Data and ($FF xor (1 shl Interr));
        end
       else
        begin
         GetIntVec(Interr+$68,Save_Vec);
         SetIntVec(Interr+$68,IRQHandler);
         Data:=port[$A1];
         port[$A1]:=Data and ($FF xor (1 shl (Interr-8)));
        end;
  end;

 procedure DisableInt(Interr : byte; var Save_Vec : pointer);
  var
     Data : byte;
  begin
       if Interr<8 then
        begin
         SetIntVec(Interr+8,Save_Vec);
         Data:=port[$21];
         port[$21]:=Data or (1 shl Interr);
        end
       else
        begin
         SetIntVec(Interr+$68,Save_Vec);
         Data:=port[$A1];
         port[$A1]:=Data or (1 shl (Interr-8));
        end;
  end;

 function GetExecPath : Dir;
  var
   fpos,segenv ,
   savepos     ,
   lastpos     : word;
   pathname    : Dir;
   Cr          : char;
  begin
   asm
     mov ah,62h
     int 21h
     mov segenv,bx
   end;
   segenv:=memw[segenv:$2c];     {word $2c in the psp = offset of environment
                                   block.}
   fpos:=0;
   repeat
     inc(fpos);
   until meml[segenv:fpos]=$00010000;
   inc(fpos,4);
   {the pathname is store after the env. block
    which is terminated by 00010000.}
   pathname:='';
   savepos:=fpos;
   lastpos:=fpos;
   while(mem[segenv:fpos]<>0) do
   begin
     Cr:=chr(mem[segenv:fpos]);
     pathname:=pathname+Cr;
     if Cr='\' then lastpos:=fpos;
     inc(fpos);
   end;
   dec(lastpos,savepos);
   inc(lastpos);
   if lastpos>1 then
    begin
     if pathname[lastpos-1]<>':' then
      savepos:=1
     else
      savepos:=0;
     getexecpath:=copy(pathname,1,lastpos-savepos)
    end;
  end;

{---------------------------------------------------------------------
KENT BRIGGS

Here is what I came up with regarding my problem of needing a large
heap (temporarily) and needing memory for an EXEC routine:
}

procedure heap_shrink;    {free up all unused heap}
 var
    reg_bx : word;
begin
  reg_bx:=memw[seg(heapptr) : ofs(heapptr) + 2] - prefixseg + 1;
  asm
     mov bx,reg_bx
     mov es,PrefixSeg
     mov ah,$4A
     int $21

     les di,Ok
     jnc @@ok
      mov es:byte ptr[di],0
      jmp @@exit
     @@ok:
      mov es:byte ptr[di],1
     @@exit:
  end;
end;

procedure heap_expand;    {reclaim unused heap}
 var
    reg_bx : word;
begin
  reg_bx:=memw[seg(heapend) : ofs(heapend) + 2] - prefixseg;
  asm
     mov bx,reg_bx
     mov es,PrefixSeg
     mov ah,$4A
     int $21
  end;
end;

{
Leave the default heapmax at 655360.  Dispose of all temporary pointers
and call heap_shrink right before exec(my_prgm) and heap_expand right
after.  The memw's get the segment addresses for the heapend and heapptr
variables (see memory map in manual).  Subtract the PSP segment and that
gets you the number of paragraphs (16 byte blocks) to allocate.

Anyone see any dangers with this scheme?  I instantly freed up 110K for
DOS shells in my application.  No problems so far.
------------------------------------------------------------------------}

 procedure GetFTime(var F; var Time: Longint);assembler;
 asm
	 LES	DI,F
	 MOV	BX,ES:[DI].TFileRec.Handle
	 MOV	AX,5700H
	 INT	21H
	 JNC	@@1
	 XOR	CX,CX
	 XOR	DX,DX
	 JMP	@@2
 @@1:	XOR	AX,AX
 @@2:
         MOV	Dos_Error,AX
	 LES	DI,Time
	 CLD
	 XCHG	AX,CX
	 STOSW
	 XCHG	AX,DX
	 STOSW
 end;

 procedure UnpackTime(P: Longint; var T: TDateTime); assembler;
 asm
	 LES	DI,T
	 CLD
	 MOV	AX,P.Word[2]
	 MOV	CL,9
	 SHR	AX,CL
	 ADD	AX,1980
	 STOSW
	 MOV	AX,P.Word[2]
	 MOV	CL,5
	 SHR	AX,CL
	 AND	AX,15
	 STOSW
	 MOV	AX,P.Word[2]
	 AND	AX,31
	 STOSW
	 MOV	AX,P.Word[0]
	 MOV	CL,11
	 SHR	AX,CL
	 STOSW
	 MOV	AX,P.Word[0]
	 MOV	CL,5
	 SHR	AX,CL
	 AND	AX,63
	 STOSW
	 MOV	AX,P.Word[0]
	 AND	AX,31
	 SHL	AX,1
	 STOSW
 end;

  procedure GetIntVec(IntNo: Byte; var Vector: Pointer); assembler;
  asm
	  MOV	AL,IntNo
	  MOV	AH,35H
	  INT	21H
	  MOV	AX,ES
	  LES	DI,Vector
	  CLD
	  XCHG	AX,BX
	  STOSW
	  XCHG	AX,BX
	  STOSW
  end;

  procedure SetIntVec(IntNo: Byte; Vector: Pointer); assembler;
  asm
	  PUSH	DS
	  LDS	DX,Vector
	  MOV	AL,IntNo
	  MOV	AH,25H
	  INT	21H
	  POP	DS
  end;

  function StrLen(Str: PChar): Word; assembler;
  asm
	  CLD
	  LES	DI,Str
	  MOV	CX,0FFFFH
	  XOR	AL,AL
	  REPNE	SCASB
	  MOV	AX,0FFFEH
	  SUB	AX,CX
  end;

  function StrPas(Str: PChar): String; assembler;
  asm
	  PUSH	DS
	  CLD
	  LES	DI,Str
	  MOV	CX,0FFFFH
	  XOR	AL,AL
	  REPNE	SCASB
	  NOT	CX
	  DEC	CX
	  LDS	SI,Str
	  LES	DI,@Result
	  MOV	AL,CL
	  STOSB
	  REP	MOVSB
	  POP	DS
  end;

  function StrLIComp(Str1, Str2: PChar; MaxLen: Word): Integer; assembler;
  asm
	  PUSH	DS
	  CLD
	  LES	DI,Str2
	  MOV	SI,DI
	  MOV	AX,MaxLen
	  MOV	CX,AX
	  JCXZ	@@4
	  XCHG	AX,BX
	  XOR	AX,AX
	  CWD
	  REPNE	SCASB
	  SUB	BX,CX
	  MOV	CX,BX
	  MOV	DI,SI
	  LDS	SI,Str1
  @@1:	REPE	CMPSB
	  JE	@@4
	  MOV	AL,DS:[SI-1]
	  CMP	AL,'a'
	  JB	@@2
	  CMP	AL,'z'
	  JA	@@2
	  SUB	AL,20H
  @@2:	MOV	DL,ES:[DI-1]
	  CMP	DL,'a'
	  JB	@@3
	  CMP	DL,'z'
	  JA	@@3
	  SUB	DL,20H
  @@3:	SUB	AX,DX
	  JE	@@1
  @@4:	POP	DS
  end;

  function StrPCopy(Dest: PChar; Source: String): PChar; assembler;
  asm
	  PUSH	DS
	  CLD
	  LDS	SI,Source
	  LES	DI,Dest
	  MOV	BX,DI
	  MOV	DX,ES
	  LODSB
	  XOR	AH,AH
	  XCHG	AX,CX
	  REP	MOVSB
	  XOR	AL,AL
	  STOSB
	  XCHG	AX,BX
	  POP	DS
  end;

  function GetEnvVar(VarName: PChar): PChar;
  var
    L,I: Word;
    P  : PChar;
  begin
    L := StrLen(VarName);
  {$IFDEF Windows}
    P := GetDosEnvironment;
  {$ELSE}
    P := Ptr(Word(Ptr(PrefixSeg, $2C)^), 0);
  {$ENDIF}
    while P^ <> #0 do
    begin
      if (StrLIComp(P, VarName, L) = 0) then
       begin
       I:=L;
       while ((P[I]=' ') or (P[I]='=')) and (I<255) do inc(I);
       if (I<256) then
       begin
         GetEnvVar := P + I ;
         Exit;
       end;
      end;
      Inc(P, StrLen(P) + 1);
    end;
    GetEnvVar := nil;
  end;

  procedure AnsiDosFunc; assembler;
  asm
	  PUSH	DS
	  MOV	DX,DI
	  PUSH	ES
	  POP	DS
	  INT	21H
	  POP	DS
  end;

  function DriveIsReady;
   var
      Drive_Ok : boolean;
   begin
        asm
           mov ah,$36
           mov dl,I      {Drive 'A' == 1}
           int $21
           cmp ax,$FFFF
           jne @@no_error
            mov Drive_Ok,false
            jmp @@skip
           @@no_error:
            mov Drive_Ok,true
           @@skip:
        end;
       DriveIsReady:=Drive_Ok;
   end;

  procedure File_Open;
   var
      Err:integer;
   begin
        {$i-}
        reset(F,RecSize);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure File_Clear;
   var
      Err:integer;
   begin
        {$i-}
        rewrite(F,RecSize);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure File_Close;
   var
      Err:integer;
   begin
        {$i-}
        close(F);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure File_Read;
   var
      Err:integer;
   begin
        {$i-}
        BlockRead(F,PToBuffer,NRec,BytesRead);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure File_Write;
   var
      Err:integer;
   begin
        {$i-}
        BlockWrite(F,PToBuffer,NRec,BytesWritten);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure File_Seek;
   var
      Err:integer;
   begin
        {$i-}
        Seek(F,Position);
        {$i+}
        Err:=IOResult;
        if Err_Type=0 then Err_Type:=Err;
   end;

  procedure Delete_File;
   var
      StgZ      : string[65];
      PStg      : pointer;
      Ok        : boolean;
   begin
        {efface un fichier}
        StgZ:=DataPath+#0;
        PStg:=@StgZ[1];
        asm
           push ds
           push bp
           mov ah,$41
           lds dx,PStg
           int $21
           pop bp
           pop ds
           nop
           jnc @@ok
            mov Ok,false
            jmp @@fin
           @@ok:
            mov Ok,true
           @@fin:
        end;
       Delete_Ok:=Ok;
    end;

 end.