LOCALS
MODEL large
.286

;//Ŀ
;//                            PUBLIC FUNCTIONS                               
;//

public _GUSPeek
public _GUSPoke
public _GUSFindMem
public _GUSSetVolume
public _GUSSetBalance
public _GUSSetFreq
public _GUSPlayVoice
public _GUSReset
public _GUSStopVoice

public _Base
public _gusdram
public _mute
public _volume

; // UltraSound Ports
StatusPort              Equ 6h
TimerCtrlPort           Equ 8h
TimerDataPort           Equ 9h
MidiCtrlPort            Equ 100h
MidiDataPort            Equ 101h
SelectVoice             Equ 102h
CommandPort             Equ 103h
DataLowPort             Equ 104h
DataHighPort            Equ 105h
DRAMIOPort              Equ 107h

; // UltraSound Commands

WriteVoiceMode          Equ 00h
SetVoiceFreq            Equ 01h         ; // Value=Freq/Divisor
LoopStartLo             Equ 02h
LoopStartHi             Equ 03h
SampleEndLo             Equ 04h
SampleEndHi             Equ 05h
VolRampRate             Equ 06h
VolRampStart            Equ 07h
VolRampEnd              Equ 08h
SetVolume               Equ 09h
SampleStartLo           Equ 0Ah
SampleStartHi           Equ 0Bh
VoiceBalance            Equ 0Ch
VolumeCtrl              Equ 0Dh
VoicesActive            Equ 0Eh
DMACtrl                 Equ 41h
DRAMAddrLo              Equ 43h
DRAMAddrHi              Equ 44h
Initialize              Equ 4Ch
ReadVolume              Equ 89h
VoicePosLo              Equ 8Ah
VoicePosHi              Equ 8Bh
ReadVolCtrl             Equ 8Dh

;//Ŀ
;//                              GLOBAL DATA                                  
;//
dataseg
	_Base  		dw  ?
	_gusdram    dd  ?
	_mute		db  0,0,0,0,0,0,0,0
	_volume		db  0,0,0,0,0,0,0,0
	GUSvol		dw  01500h
				dw	09300h,0A900h,0B400h,0BC00h,0C180h,0C580h,0C980h,0CD80h
				dw	0CF40h,0D240h,0D440h,0D640h,0D840h,0DA40h,0DC40h,0DE40h
				dw	0DEF0h,0DFA0h,0E1A0h,0E2A0h,0E3A0h,0E4A0h,0E5A0h,0E6A0h
				dw	0E7A0h,0E8A0h,0E9A0h,0EAA0h,0EBA0h,0ECA0h,0EDA0h,0EEA0h
				dw	0EEF0h,0EFE0h,0EF60h,0F1E0h,0F160h,0F1E0h,0F260h,0F2E0h
				dw	0F360h,0F3E0h,0F460h,0F4E0h,0F560h,0F5E0h,0F660h,0F6E0h
				dw	0F760h,0F7E0h,0F860h,0F8E0h,0F960h,0F9E0h,0FA60h,0FAF0h
				dw	0FB70h,0FBF0h,0FC70h,0FCF0h,0FD70h,0FD90h,0FDB0h,0FDD0h

;//Ŀ
;//                                 MACROS                                    
;//
GUSDELAY        macro
	push dx
	push ax
	mov  dx, 0300h
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	pop  ax
	pop  dx
endm

;//Ŀ
;//                            CODE STARTS HERE                               
;//
codeseg

RShift          PROC
	   mov  bx,cx
	   shr  ax,7
	   shr  cx,7
	   shl  bx,9
	   or   ax,bx
	   ret
RShift          ENDP

;//Ŀ
;// unsigned char GUSPeek(long int Loc) {                                                       
;//
_GUSPeek        PROC  Loc:dword
		push bp
		mov  bp,sp

		mov  dx, [_Base]
		add  dx, CommandPort
		mov  al, DRAMAddrLo
		out  dx, al

		inc  dx
		mov  ax, word ptr [Loc]
		out  dx, ax
		dec  dx
		mov  al, DRAMAddrHi
		out  dx, al
		add  dx, 2
		mov  al, byte ptr [Loc+2]
		out  dx, al

		add  dx, 2
		in   al, dx

		pop  bp
		ret
_GUSPeek        ENDP


;//Ŀ
;// void GUSPoke(long int Loc, char B) {
;//
_GUSPoke        PROC  Loc:dword, B:byte
		push bp
		mov  bp, sp

		mov  dx, [_Base]
		add  dx, CommandPort
		mov  al, DRAMAddrLo
		out  dx, al

		inc  dx            				;// now base+104
		mov  ax, word ptr [Loc]
		out  dx, ax
		dec  dx                       	;// now base+103
		mov  al, DRAMAddrHi
		out  dx, al

		add  dx, 2                      ;// now base+105
		mov  al, byte ptr [Loc+2]
		out  dx, al

		add  dx, 2                   	;// now base+107
		mov  al, B
		out  dx, al

		pop  bp
		ret
_GUSPoke        ENDP


;//Ŀ
;// dword GUSFindMem() {
;//
_GUSFindMem     PROC
	push    bp
	mov     bp,sp

	sub     sp,4

	mov     al, 0AAh
	push    ax
	mov     ax,4
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,4
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al, 0AAh
	je      short @1@86
	mov     word ptr [bp-2],3
	mov     word ptr [bp-4],65535
	jmp     short @1@254
@1@86:

	mov     al, 0AAh
	push    ax
	mov     ax,8
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,8
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al,170
	je      short @1@142
	mov     word ptr [bp-2],8
	mov     word ptr [bp-4],65535
	jmp     short @1@254

@1@142:
	mov     al,170
	push    ax
	mov     ax,12
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,12
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al,170
	je      short @1@198
	mov     word ptr [bp-2],12
	jmp     short @1@226
@1@198:

	mov     word ptr [bp-2],15
@1@226:
	mov     word ptr [bp-4],65535
@1@254:

	mov     dx,word ptr [bp-2]
	mov     ax,word ptr [bp-4]
	jmp     short @1@282
@1@282:

	mov     sp,bp
	pop     bp
	ret
_GUSFindMem     ENDP

;//Ŀ
;// void GUSSetVolume(byte Voice, byte Volume) {
;//
_GUSSetVolume  PROC  Voice:byte, Volume:byte
	push bp
	mov  bp,sp
	push es
	push bx

	mov  bx, word ptr Voice
	mov  al, [_mute+bx]			;// check for muted channel
	cmp  al, 0
	je   nomute
	mov  Volume, 0				;// if it is set the channels volume to 0
nomute:
	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al
	inc  dx
	mov  al, SetVolume
	out  dx, al
	inc  dx
	mov  bx, word ptr Volume  	;// put requested volume in here
	shl  bx, 1					;// we are looking up a word table, so *2
	mov  ax, [GUSvol+bx]		;// now reference the right GUS volume.
	out  dx, ax

	pop  bx
	pop  es
	pop  bp
	ret
_GUSSetVolume  ENDP

;//Ŀ
;// void GUSSetBalance(unsigned char Voice, unsigned char Balance) {
;//
_GUSSetBalance  PROC  Voice:byte, Balance:byte
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al
	inc  dx
	mov  al, VoiceBalance
	out  dx, al
	inc  dx
	inc  dx
	mov  al, Balance
	out  dx, al
	pop  bp
	ret
_GUSSetBalance ENDP


;//Ŀ
;// void GUSSetFreq(unsigned char Voice, int Freq) {
;//
_GUSSetFreq     PROC  Voice:byte, Freq:word
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al
	inc  dx
	mov  al, SetVoiceFreq
	out  dx, al
	inc  dx
	mov  ax, Freq
	out  dx, ax

	pop  bp
	ret
_GUSSetFreq     ENDP


;//Ŀ
;// void GUSStopVoice(unsigned char Voice) {
;//
_GUSStopVoice   PROC    Voice:byte
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al

	inc  dx
	mov  al, 080h
	out  dx, al

	add  dx, 2
	in   ax, dx
	mov  cx, ax

	sub  dx, 2
	mov  al, 0
	out  dx, al
	add  dx, 2
	and  cx, 0dfh
	or   cx, 3
	mov  ax, cx
	out  dx, ax
	GUSDELAY
	sub  dx, 2
	mov  al, 0
	out  dx, al
	add  dx, 2
	mov  ax, cx
	out  dx, ax

	pop  bp
	ret
_GUSStopVoice   ENDP

;//Ŀ
;//void GUSPlayVoice(byte Voice,byte Mode,dword VBegin,dword VStart,dword VEnd) {
;//
_GUSPlayVoice  PROC  Voice:byte, Mode:byte, VBegin:dword, VStart:dword, VEnd:dword
	push bp
	mov  bp, sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al

	xor  ax, ax
	mov  al, Voice
	push ax
	call _GUSStopVoice          ;// first stop the voice
	pop  ax

	mov  dx, [_Base]
	add  dx, 0103h		        ;//CommandPort 103h

	;//VSTART
	mov  al, 2
	out  dx, al
	inc  dx                  	;//DataLowPort 104h
	mov  ax, Word Ptr [VStart]
	push cx
	mov  cx, Word Ptr [VStart+2]
	call RShift
	pop  cx
	out  dx, ax

	dec     dx                  ;//CommandPort 103h
	mov  al, 3
	out  dx, al
	inc     dx                  ;//DataLowPort 104h
	mov     ax, Word Ptr [VStart]
	shl  ax, 9
	out  dx, ax

	;// VBEGIN;
	dec     dx                                      ;//now CommandPort 103h
	mov     al, SampleStartLo               ;//0Ah
	out  dx, al
	inc     dx                                      ;//DataLowPort 104h
	mov     ax, Word Ptr [VBegin]    ;//high part in ax
	push cx
	mov     cx, Word Ptr [VBegin+2]  ;//low part in cx
	call RShift
	pop  cx
	out  dx, ax

	dec     dx                                      ;//CommandPort 103h
	mov     al, SampleStartHi
	out  dx, al
	inc     dx                                      ;//DataLowPort 104h
	mov     ax, Word Ptr [VBegin]
	shl  ax, 9
	out  dx, ax

	;//VEND
	dec     dx                                      ;//CommandPort 103h
	mov  al, 4
	out  dx, al
	inc     dx                                      ;//DataLowPort 104h
	mov     ax, Word Ptr [VEnd]
	push cx
	mov     cx, Word Ptr [VEnd+2]
	call RShift
	pop  cx
	out  dx, ax

	dec     dx                                      ;//CommandPort 103h
	mov  al,5
	out  dx,al
	inc     dx                                      ;//DataLowPort 104h
	mov     ax,Word Ptr [VEnd]
	shl  ax,9
	out  dx,ax

	;// MODE
	dec  dx                                 ;// now 103h
	mov  al, 0
	out  dx, al
	add  dx, 2                              ;// now 105h
	mov  al, Mode
	out  dx, al

	pop  bp
	ret
_GUSPlayVoice  ENDP


;//Ŀ
;// void GUSReset(byte NumVoices) {
;//
_GUSReset       PROC    NumVoices:byte
		push bp
		mov  bp,sp
		pusha

		mov     bx, [_Base]
		mov     cx, bx
		add     bx, CommandPort
		add     cx, DataHighPort
		mov     dx, bx
		mov     al, Initialize
		out     dx, al
		mov     dx, cx
		mov     al, 0
		out     dx, al
		mov     dx, [_Base]
		GUSDELAY
		mov     dx, bx
		mov     al, 4Ch
		out     dx, al
		mov     dx, cx
		mov     al, 1
		out     dx, al
		mov     dx, [_Base]
		GUSDELAY
		mov     dx, bx
		mov     al, DMACtrl
		out     dx, al
		mov     dx, cx
		mov     al, 0
		out     dx, al
		mov     dx, bx
		mov     al, 45h
		out     dx, al
		mov     dx, cx
		mov     al, 0
		out     dx, al
		mov     dx, bx
		mov     al, 49h
		out     dx, al
		mov     dx, cx
		mov     al, 0
		out     dx, al

		mov     dx, bx
		mov     al, VoicesActive
		out     dx, al
		mov     dx, cx
		mov     al, NumVoices
		dec     al
		or      al, 0C0h
		out     dx, al

		mov     dx, cs:[_Base]
		add     dx, StatusPort
		in      al, dx
		mov     dx, bx
		mov     al, DMACtrl
		out     dx, al
		mov     dx, cx
		in      al, dx
		mov     dx, bx
		mov     al, 49h
		out     dx, al
		mov     dx, cx
		in      al, dx
		mov     dx, bx
		mov     al, 8Fh
		out     dx, al
		mov     dx, cx
		in      al, dx

		push    cx
		mov     cx, 32
VoiceClearLoop:
		mov     dx, [_Base]
		add     dx, SelectVoice
		mov     al, cl
		dec     al
		out     dx, al
		inc     dx
		mov     al, 0
		out     dx, al
		add     dx, 2
		mov     al, 3   ; // Voice Off
		out     dx, al
		sub     dx, 2
		mov     al, 0Dh
		out     dx, al
		add     dx, 2
		mov     al, 3   ; // Ramp Off
		out     dx, al
		loop    VoiceClearLoop
		pop     cx

		mov     dx, bx
		mov     al, DMACtrl
		out     dx, al
		mov     dx, cx
		in      al, dx
		mov     dx, bx
		mov     al, 49h
		out     dx, al
		mov     dx, cx
		in      al, dx
		mov     dx, bx
		mov     al, 8Fh
		out     dx, al
		mov     dx, cx
		in      al, dx

		mov     dx, bx
		mov     al, Initialize
		out     dx, al
		mov     dx, cx
		mov     al, 7
		out     dx, al

		mov     cx, word ptr [NumVoices]
SetRampRateLoop:
		mov     dx, [_Base]
		add     dx, SelectVoice
		mov     al, NumVoices
		sub     al, cl
		out     dx, al

		mov     dx, [_Base]
		add     dx, CommandPort
		mov     al, VolRampRate
		out     dx, al
		mov     al, 00111111b
		mov     dx, [_Base]
		add     dx, DataHighPort
		out     dx, al

		mov     dx, [_Base]
		add     dx, CommandPort
		mov     al, SetVolume
		out     dx, al
		mov     ax, 0
		mov     dx, [_Base]
		add     dx, DataLowPort
		out     dx, ax
		loop    SetRampRateLoop

		mov  dx, [_Base]
		mov  ax, 0
		out  dx, ax

		popa
		pop  bp
		ret
_GUSReset       ENDP

end
