//
// PrintFFF version 1.0 (from GIPC 1.11) (C) 1996 by ChAr
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "types.hpp"


// InterWave data patch file defs.

struct iw_disk_id {
  int major_id;
  int minor_id;
};

union ID {
  iw_disk_id id;
  void __far *p;
};

struct iw_program {
  ID id;
  ID version;
};

struct iw_envp_header {
  char num_envelopes;
  char flags;
  char mode;
  char index_type;
};

struct iw_envp {
  ID id;
  iw_envp_header h;
};

struct iw_envp_record {
  int nattack;
  int nrelease;
  word sustain_offset;
  word sustain_rate;
  word release_rate;
  byte hirange;
  byte pad;
};

struct iw_wave {
  ID id;
  dword size;
  dword start;
  dword loopstart;
  dword loopend;
  dword m_start;
  dword sample_ratio;
  char attenuation;
  char low_note;
  char high_note;
  byte format;
  byte m_format;
  ID data_id;
};

struct LFO {
  word freq;
  int depth;
  int sweep;
  byte shape;
  byte delay;
};

struct iw_layer {
  ID id;
  char nwaves;
  char flags;
  char high_range;
  char low_range;
  char pan;
  char pan_freq_scale;
  LFO tremolo;
  LFO vibrato;
  char velocity_mode;
  char attenuation;
  int freq_scale;
  char freq_center;
  char layer_event;
  ID penv;
  ID venv;
  iw_wave __far *waves;
};

struct iw_patch {
  ID id;
  int nlayers;
  char layer_mode;
  char exclusion_mode;
  int exclusion_group;
  char effect1;
  char effect1_depth;
  char effect2;
  char effect2_depth;
  byte bank;
  byte program;
  iw_layer __far *layers;
};



// Helper functions

void SkipDummyBytes(FILE *fr, long skipCount) {
  char c;
  if (skipCount > 0) {
    printf("... skipping %ld bytes.", skipCount);
  }
  while (skipCount-- > 0) {
    fread(&c, 1, 1, fr);
  }
}


void ProcessPROG(FILE *fr, long &blockSize) {
  long blockId, sizePtch, sizeLayr, sizeWave;
  iw_patch iwPatch;

  // 1. subsection musi byt "PTCH"
  while (blockSize > 0) {
    fread(&blockId, 4, 1, fr);
    fread(&sizePtch, 4, 1, fr);
    blockSize -= 8;
    if (blockId!=0x48435450) { // "PTCH"
      printf(" - expecting PTCH but blockId=%08lX.\n", blockId);
      return;
    }
    // it is PTCH, read infos
    fread(&iwPatch, sizeof iwPatch, 1, fr);
    blockSize -= sizeof iwPatch;
    sizePtch -= sizeof iwPatch;
    printf(" PTCH: %04X:%04X  Lrs=%04X, Lmod=%02X, ExM=%02X, ExG=%04X\n"
        "      Ef1=%02X, Ef1d=%02X, Ef2=%02X, Ef2d=%02X, Bnk=%02X, Prg=%02X\n",
        iwPatch.id.id.major_id, iwPatch.id.id.minor_id,
        iwPatch.nlayers, (word)iwPatch.layer_mode, (word)iwPatch.exclusion_mode,
        iwPatch.exclusion_group, (word)iwPatch.effect1, (word)iwPatch.effect1_depth,
        (word)iwPatch.effect2, (word)iwPatch.effect2_depth, (word)iwPatch.bank,
        (word)iwPatch.program);
    // Read layer infos
    for (int layer=0; layer<iwPatch.nlayers; layer++) {
      iw_layer iwLayer;
      fread(&blockId, 4, 1, fr);
      fread(&sizeLayr, 4, 1, fr);
      blockSize = -8;
      sizePtch -= 8;
      if (blockId != 0x5259414C) { // "LAYR"
        printf("  - expecting LAYR byt blockId=%08lX.\n", blockId);
        return;
      }
      // it is LAYR, read infos
      fread(&iwLayer, sizeof iwLayer, 1, fr);
      blockSize -= sizeof iwLayer;
      sizePtch -= sizeof iwLayer;
      sizeLayr -= sizeof iwLayer;
      printf("  LAYR %02X:  %04X:%04X  Waws=%02X, Flg=%02X, Hi=%02X, Lo=%02X\n"
          "          Pan=%02X, Pfrq=%02X, VMod=%02X, Att=%02X, FrS=%04X\n"
          "          FrC=%02X, LEv=%02X, PEnv=%04X:%04X, VEnv=%04X:%04X\n",
          layer, iwLayer.id.id.major_id, iwLayer.id.id.minor_id,
          (word)iwLayer.nwaves, (word)iwLayer.flags, (word)iwLayer.high_range,
          (word)iwLayer.low_range,
          (word)iwLayer.pan, (word)iwLayer.pan_freq_scale, (word)iwLayer.velocity_mode,
          (word)iwLayer.attenuation, iwLayer.freq_scale, (word)iwLayer.freq_center,
          (word)iwLayer.layer_event, iwLayer.penv.id.major_id,
          iwLayer.penv.id.minor_id, iwLayer.venv.id.major_id,
          iwLayer.venv.id.minor_id);
      printf("          Tremolo: Freq=%04X, Depth=%04X, Sweep=%04X, Shape=%02X, "
          "Delay=%02X\n", iwLayer.tremolo.freq, iwLayer.tremolo.depth,
          iwLayer.tremolo.sweep, (word)iwLayer.tremolo.shape, (word)iwLayer.tremolo.delay);
      printf("          Vibrato: Freq=%04X, Depth=%04X, Sweep=%04X, Shape=%02X, "
          "Delay=%02X\n", iwLayer.vibrato.freq, iwLayer.vibrato.depth,
          iwLayer.vibrato.sweep, (word)iwLayer.vibrato.shape, (word)iwLayer.vibrato.delay);
      // now there must be WAVE, read infos
      for (int wave=0; wave<iwLayer.nwaves; wave++) {
        iw_wave iwWave;
        fread(&blockId, 4, 1, fr);
        fread(&sizeWave, 4, 1, fr);
        blockSize -= 8;
        sizePtch -= 8;
        sizeLayr -= 8;
        if (blockId != 0x45564157) { // "WAVE"
          printf("   - expecting WAVE, but blockId=%08lX.\n", blockId);
          return;
        }
        fread(&iwWave, sizeof iwWave, 1, fr);
        blockSize -= sizeof iwWave;
        sizePtch -= sizeof iwWave;
        sizeLayr -= sizeof iwWave;
        sizeWave -= sizeof iwWave;
        printf("   WAVE %02X: %04X:%04X\n"
            "            Size=%08lX, Start=%08lX, LoopS=%08lX, "
            "LoopE=%08lX, MStart=%08lX\n"
            "            SamRat=%08lX, Att=%02X, Lo=%02X, Hi=%02X, Fmt=%02X,"
            " MFmt=%02X, Data %04X:%04X\n",
            wave,
            iwWave.id.id.major_id, iwWave.id.id.minor_id,
            iwWave.size, iwWave.start, iwWave.loopstart, iwWave.loopend,
            iwWave.m_start, iwWave.sample_ratio, (word)iwWave.attenuation,
            (word)iwWave.low_note, (word)iwWave.high_note, (word)iwWave.format,
            (word)iwWave.m_format, iwWave.data_id.id.major_id,
            iwWave.data_id.id.minor_id);
        SkipDummyBytes(fr, sizeWave);
      }
      SkipDummyBytes(fr, sizeLayr);
    }
    SkipDummyBytes(fr, sizePtch);
  }
}


int main(int argc, char *argv[]) {
  FILE *fffHandle;
  long fffSize, blockId, blockSize;

  printf("PrintFFF  version 1.0 (C) 1996 by ChAr\n");

  if (argc != 2) {
    printf("Usage: PrintFFF fffFile.fff\nThis program will print information"
        " about contents and structure\nof FFF file. Supported is FFF versio"
        "n 1.0 from GIPC 1.11\n");
    return -1;
  }

  // Open FFF file
  if ((fffHandle = fopen(argv[1], "rb"))==NULL) {
    printf("ERROR: Cannot open '%s'.\n", argv[1]);
    return -1;
  }

  // Read in FFF header
  if ((fread(&fffSize, 4, 1, fffHandle)!=1)||(fffSize != 0x46464646)) {
    printf("ERROR: Not a FFF file, invalid header ID!\n");
    fclose(fffHandle);
    return -1;
  }

  // Read in overal FFF size
  if (fread(&fffSize, 4, 1, fffHandle)!=1) {
    printf("ERROR: Not a FFF file, invalid header ID!\n");
    fclose(fffHandle);
    return -1;
  }

  // Now do parsing of FFF file
  printf("Dump of file '%s' reported size = %ld\n", argv[1], fffSize);

  while (fffSize > 0L) {
    // read in block identifier dword and size
    if (fread(&blockId, 4, 1, fffHandle)!=1) {
      printf("ERROR: Cannot read block identifier.\n");
      fclose(fffHandle);
      return -1;
    }
    fffSize -= 4;
    if (fread(&blockSize, 4, 1, fffHandle)!=1) { // read length
      printf("ERROR: Cannot read block size identifier.\n");
      fclose(fffHandle);
    }
    fffSize -= 4;
    fffSize -= blockSize;
    // what type is this block?
    if (blockId==0x54525043) { // "CPRT" - copyright
      char copyright[128];
      if (blockSize>128) {
        printf("ERROR: CPRT size > 128!\n");
        fclose(fffHandle);
        return -2;
      }
      fread(copyright, 1, blockSize, fffHandle);
      copyright[blockSize] = 0x00;
      printf("\nCPRT: Copyright '%s'.\n", copyright);
      continue;
    }
    if (blockId==0x41544144) { // "DATA" - DAT file block
      iw_disk_id diskID;
      char datName[128];
      if (blockSize>132) {
        printf("ERROR: DATA size > 132!\n");
        fclose(fffHandle);
        return -2;
      }
      fread(&diskID, 4, 1, fffHandle);
      fread(&datName, 1, blockSize-4, fffHandle);
      printf("\nDATA: diskId.Major=%4X, diskId.Minor=%4X, fileDat=%s\n",
        diskID.major_id, diskID.minor_id, datName);
      continue;
    }
    if (blockId==0x50564E45) { // "ENVP" - envelope block
      iw_envp iwEnvp;
      iw_envp_record iwEnvpRec;
      word envPoints[128]; // rate,offset dvojice
      fread(&iwEnvp, sizeof iwEnvp, 1, fffHandle); blockSize-=sizeof iwEnvp;
      printf("\nENVP: %04X:%04X, Envp=%02X, Flgs=%02X, Mode=%02X, Index=%02X\n",
          iwEnvp.id.id.major_id, iwEnvp.id.id.minor_id, (word)iwEnvp.h.num_envelopes,
          (word)iwEnvp.h.flags, (word)iwEnvp.h.mode, (word)iwEnvp.h.index_type);
      for (int i=0; i<iwEnvp.h.num_envelopes; i++) {
        fread(&iwEnvpRec, sizeof iwEnvpRec, 1, fffHandle);
        blockSize -= sizeof iwEnvpRec;
        printf(" %2d: Att=%04X, Rel=%04X, SusO=%04X, SusR=%04X, RelR=%04X, Hi=%02X"
            ", Pad=%02X.\n", i, iwEnvpRec.nattack, iwEnvpRec.nrelease,
            iwEnvpRec.sustain_offset, iwEnvpRec.sustain_rate,
            iwEnvpRec.release_rate, (word)iwEnvpRec.hirange,
            (word)iwEnvpRec.pad);
        fread(&envPoints, 4, iwEnvpRec.nattack, fffHandle);
        blockSize -= 4*iwEnvpRec.nattack;
        printf("    Attack : ");
        for (int ep=0; ep<iwEnvpRec.nattack; ep++) {
          printf("%03X:%03X ", envPoints[ep*2], envPoints[ep*2+1]);
        }
        printf("\n    Release: ");
        fread(&envPoints, 4, iwEnvpRec.nrelease, fffHandle);
        blockSize -= 4*iwEnvpRec.nrelease;
        for (ep=0; ep<iwEnvpRec.nrelease; ep++) {
          printf("%03X:%03X ", envPoints[ep*2], envPoints[ep*2+1]);
        }
        printf("\n");
      }
      SkipDummyBytes(fffHandle, blockSize);
      continue;
    }
    if (blockId==0x474F5250) { // "PROG" - program block
      iw_program iwProgram;
      fread(&iwProgram, sizeof iwProgram, 1, fffHandle);
      blockSize-=sizeof iwProgram;
      printf("\nPROG: %4X:%4X, version %d.%d\n", iwProgram.id.id.major_id,
          iwProgram.id.id.minor_id, iwProgram.version.id.major_id,
          iwProgram.version.id.minor_id);
      ProcessPROG(fffHandle, blockSize);
      SkipDummyBytes(fffHandle, blockSize);
      continue;
    }
    printf("Unknown item ID:%08lX.\n", blockId);
    SkipDummyBytes(fffHandle, blockSize);
  }

  printf(".\n");
  fclose(fffHandle);

  return 0;
}
