/* Power Render Morphing Interface */

#ifndef _PRMORPH_
#define _PRMORPH_

#ifdef __cplusplus
  extern "C" {
#endif



void PR_Morph (PR_VERTEX *vert1, PR_VERTEX *vert2,
               PR_VERTEX *vertdest, PR_DWORD numvert, PR_REAL t);
/* -----------------------------------------------------------------------
   Function:   PR_Morph
   Purpose:    Morphs between two vertex lists.
   Parameters: vert1 - First vertex list
               vert2 - Second vertex list
               vertdest - List to contain the result
               numvert - Number of vertices in list
               t - A fraction from 0 to 1
   Return:     None
   ----------------------------------------------------------------------- */



void PR_MorphWithNormals (PR_VERTEX *vert1, PR_VERTEX *vert2,
                          PR_VERTEX *vertdest, PR_DWORD numvert, PR_REAL t);
/* -----------------------------------------------------------------------
   Function:   PR_MorphWithNormals
   Purpose:    Morphs between two vertex lists, including normals.
   Parameters: vert1 - First vertex list
               vert2 - Second vertex list
               vertdest - List to contain the result
               numvert - Number of vertices in list
               t - A fraction from 0 to 1
   Return:     None
   ----------------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif
