;

align 4
spheremap_coords        dd ?
spheremap_parallax      dd ?

;
;I tried to type up all the math for this, but I've forgotten it exactly!
;I got it from John De Goes' tutorial.
;This shouldn't be too hard to copy, even to convert to C.

align 32
proc    init_spheremap n

        ;This scales things to look like 320 screen res
        fild    [mode_x]
        fdiv    [@@320]
        fmul    [sm_z]
        fstp    [sm_z]

        ;Alloc ram for coords 
        mov     ecx, [mode_x]
        imul    ecx, [mode_y]
        add     ecx, ecx
        mov     eax, [_himembase]
        add     [_himembase], ecx
        mov     [spheremap_coords], eax

        mov     edi, [spheremap_coords]
        call    @@calc_coords    

        cmp     [parallax], 1
        jne     @@no_para

        mov     ecx, [mode_x]
        imul    ecx, [mode_y]
        add     ecx, ecx
        mov     eax, [_himembase]
        add     [_himembase], ecx
        mov     [spheremap_parallax], eax

        fld     [sm_z]
        fadd    [sm_z]
        fstp    [sm_z]
        mov     edi, [spheremap_parallax]
        call    @@calc_coords

@@no_para:
        clc
        ret

@@calc_coords:
        ;Figure out du & dv
        mov     eax, [mode_y]
        shr     eax, 1
        neg     eax
        mov     [@@sm_yprime], eax
        mov     eax, [mode_x]
        shr     eax, 1
        neg     eax
        mov     [@@sm_xprime], eax

        fild    [@@sm_xprime]
        fld     st
        fmul
        fild    [@@sm_yprime]
        fld     st
        fmul
        fld     [sm_z]
        fld     st
        fmul
        fadd
        fadd
        fsqrt
        fmul    [sm_umin]
        fidiv   [@@sm_xprime]
        fstp    [sm_du]

        fild    [@@sm_xprime]
        fld     st
        fmul
        fild    [@@sm_yprime]
        fld     st
        fmul
        fld     [sm_z]
        fld     st
        fmul
        fadd
        fadd
        fsqrt
        fmul    [sm_vmin]
        fidiv   [@@sm_yprime]
        fstp    [sm_dv]

        ;Calculate the coords
        mov     ebp, [mode_y]
        
@@calc_row:
        mov     eax, [mode_x]
        shr     eax, 1
        neg     eax
        mov     [@@sm_xprime], eax
        mov     ecx, [mode_x]

@@calc_pixel:
        ;We're projecting a sphere onto a plane or something like that
        fld1
        fild    [@@sm_xprime]
        fld     st
        fmul
        fild    [@@sm_yprime]
        fld     st
        fmul
        fld     [sm_z]
        fmul    [sm_z]
        fadd
        fadd
        fsqrt
        fdiv

        fild    [@@sm_xprime]
        fmul    st, st(1)
        fmul    [sm_du]
        fadd    [sm_umid]
        fistp   [@@result]
        mov     eax, [@@result]
        mov     [edi], al

        fild    [@@sm_yprime]
        fmul
        fmul    [sm_dv]
        fadd    [sm_vmid]
        fistp   [@@result]
        mov     eax, [@@result]
        mov     [edi + 1], al

        inc     [@@sm_xprime]
        add     edi, 2
        dec     ecx
        jnz     @@calc_pixel

        inc     [@@sm_yprime]
        dec     ebp
        jnz     @@calc_row

@@done:
        clc
        ret

@@error:
        stc
        ret

@@sm_xprime     dd ?
@@sm_yprime     dd ?
@@result        dd ?
@@320           dd 320.0

endp

sm_umin         dd -128.0       ;These dictate where in the tmap the coords
sm_vmin         dd -128.0       ;are, and how large.  If you don't use
sm_umid         dd 128.0        ;a 256x256 map, you'll have to mask the 
sm_vmid         dd 128.0        ;coords.
sm_z            dd 128.0        ;This is something like the radius of the
                                ;sphere.  When I first tried this algorithm
                                ;I thought I'd got it wrong, but I'd just
                                ;had a big value for z, which made it look
                                ;really flat.  Small values of z make it
                                ;look really wild.  
sm_du           dd ?
sm_dv           dd ?

;
;In:
;       ebx: texture map (64k aligned)
;       ecx: u, v offsets
;       edi: dest
;       ebp: number of pixels to map (multiple of 4)

align 32
proc    spheremap n

        cmp     [parallax], 1
        jne     @@no_para

        push    ebx ecx edi ebp

        add     cl, 128
        add     ch, 128

        mov     edx, ebx
        mov     esi, [spheremap_parallax]

        add     edi, ebp
        lea     esi, [esi + ebp*2]
        shr     ebp, 2
        neg     ebp

@@sm_p:
        mov     bx, [esi + 4 + ebp*8]           ;reverse this (+4, +0) when gen. tbl.
        mov     dx, [esi + 2 + 4 + ebp*8]       ;for nice cache

        add     bl, cl
        add     dl, cl

        add     bh, ch
        add     dh, ch

        mov     al, [ebx]
        mov     ah, [edx]

        shl     eax, 16
        mov     bx, [esi + ebp*8]               ;reverse this (+4, +0) when gen. tbl.

        mov     dx, [esi + 2 + ebp*8]           ;reverse this (+4, +0) when gen. tbl.
        add     bl, cl

        add     dl, cl
        add     bh, ch

        add     dh, ch
        mov     al, [ebx]

        mov     ah, [edx]
        mov     [edi + ebp*4], eax              ;Do four pixels at a time

        inc     ebp
        jnz     @@sm_p

        pop     ebp edi ecx ebx

@@no_para:
        mov     edx, ebx
        mov     esi, [spheremap_coords]

        add     edi, ebp
        lea     esi, [esi + ebp*2]
        shr     ebp, 2
        neg     ebp

@@sm:
        mov     bx, [esi + 4 + ebp*8]           ;reverse this (+4, +0) when gen. tbl.
        mov     dx, [esi + 2 + 4 + ebp*8]       ;for nice cache

        add     bl, cl
        add     dl, cl

        add     bh, ch
        add     dh, ch

        mov     al, [ebx]
        mov     ah, [edx]

        shl     eax, 16
        mov     bx, [esi + ebp*8]               ;reverse this (+4, +0) when gen. tbl.

        mov     dx, [esi + 2 + ebp*8]           ;reverse this (+4, +0) when gen. tbl.
        add     bl, cl

        add     dl, cl
        add     bh, ch

        add     dh, ch
        mov     al, [ebx]

        mov     ah, [edx]

        shr     [d edi + ebp*4], 1              ;This is the motion blur bit
        shr     eax, 1

        and     [d edi + ebp*4], 7f7f7f7fh
        and     eax, 7f7f7f7fh

        add     [edi + ebp*4], eax              ;Do four pixels at a time

        inc     ebp
        jnz     @@sm

        ret

endp

;
;In:
;       ebx: texture map (128k aligned)
;       ecx: u, v offsets
;       edi: dest
;       ebp: number of pixels to map (multiple of 2)

align 32
proc    spheremap_hi n

        cmp     [parallax], 1
        jne     @@no_para

        push    ebx ecx edi ebp

        add     cl, 128
        add     ch, 128

        shr     ebx, 1
        mov     edx, ebx
        mov     esi, [spheremap_parallax]

        lea     edi, [edi + ebp*2]
        lea     esi, [esi + ebp*2]
        shr     ebp, 1
        neg     ebp

@@sm_p:
        mov     bx, [esi + ebp*4]
        mov     dx, [esi + 2 + ebp*4]

        add     bl, cl
        add     dl, cl

        add     bh, ch
        add     dh, ch

        mov     ax, [edx*2]
        shl     eax, 16
        mov     ax, [ebx*2]

        mov     [edi + ebp*4], eax              ;Do two pixels at a time

        inc     ebp
        jnz     @@sm_p

        pop     ebp edi ecx ebx

@@no_para:
        shr     ebx, 1
        mov     edx, ebx
        mov     esi, [spheremap_coords]

        lea     edi, [edi + ebp*2]
        lea     esi, [esi + ebp*2]
        shr     ebp, 1
        neg     ebp

@@sm:
        mov     bx, [esi + ebp*4]
        mov     dx, [esi + 2 + ebp*4]

        add     bl, cl
        add     dl, cl

        add     bh, ch
        add     dh, ch

        mov     ax, [edx*2]
        shl     eax, 16
        mov     ax, [ebx*2]

        shr     [d edi + ebp*4], 1              ;This is the motion blur bit
        shr     eax, 1

        and     [d edi + ebp*4], 01111011111011110111101111101111b
        and     eax, 01111011111011110111101111101111b

        add     [edi + ebp*4], eax              ;Do two pixels at a time

        inc     ebp
        jnz     @@sm

        ret

endp

;
