p486
p487
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
q equ qword
s equ short
n equ near
f equ far

;

include "pmode\pmode.inc"
include "file\file.inc"
include "video\video.inc"
include "routines\routines.inc"
include "argc\argc.inc"
include "pcx\pcx.inc"
include "fmath\fmath.inc"
include "polysort\polysort.inc"
include "scan\scan.inc"
include "scan\scan_lll.inc"
include "include\strucs.inc"

include "include\macros.inc"

;

segment code32 page public use32
        assume cs:code32, ds:code32

;

align 4
frames_done             dd ?
average_fps             dd ?

texture_mem             dd ?
shape_mem               dd ?
shape_size              dd ?
num_shape_frames        dd ?
shape_numpts            dd ?
shape_numpolys          dd ?

shape_pts               dd 9 dup ( ? )
shape_polys             dd 9 dup ( ? )

morph_mem               dd ?
morph_size              dd ?

temp_pts                dd ?
rot_pts                 dd ?
proj_pts                dd ?
btree_start             dd ?
btree_end               dd ?

sky_ptr                 dd ?

seconds                 dq ?
last                    dd ?, ?

if HIGH_COLOUR
tmap_file               db "gfx\tmap.raw", 0
sky_file                db "gfx\skymap.raw", 0
else
tmap_file               db "gfx\tmap.pcx", 0
sky_file                db "gfx\skymap.pcx", 0
endif
shape_file              db "3d\shape0.3d", 0, "$"

sync                    db 1
parallax                db 1

;

public _main

align 32
proc    _main n

        ;Initialise hardware, alloc ram, load data etc.
        call    startup

        ;main program loop
        call    main

        ;Reset hardware, unload data, etc.
        call    exit

endp

;

;Initialise hardware, alloc ram, load data etc.
include "startup.inc"

;Reset hardware, unload data, etc.
include "exit.inc"

;Draw a frame
include "render.inc"

;
;This came from John McCarthy's 3dvect37

macro   wait_esc
local   cont, test_kb, cont2
; test escape key - if none, continue

        push    eax
        in      al, 60h                 ; test keyboard
        cmp     al, 1
        jne     cont

test_kb:
        in      al, 60h                 ; test keyboard
        cmp     al, 1
        je      test_kb

        stc
        jmp     cont2

cont:
        clc

cont2:
        pop     eax

endm

;
;Main program loop

align 32
proc    main n

        ;Setup the timer
        mov     [frames_done], 0
        call    init_elapse

@@main_loop:
        ;Update the animation
        call    update_frame

        ;Draw a frame
        call    draw_frame

        ;Transfer frame to screen
        call    blt_frame

        ;Increase counter (for FPS)
        inc     [frames_done]

        ;Has ESC been pressed?
        wait_esc
        jnc     @@main_loop

        ;Get the total time taken during rendering
        call    elapse

        ;Calculate FPS by (frames_done / total time taken)
        call    fps
        ret

endp

;

ends    code32

;

end


