;-----------------------------------------------------------------------------
; RealFlatMode initializing code by X-wizard
;-----------------------------------------------------------------------------

DOSSEG
.MODEL huge
.STACK 1024h
.CODE
.386p

assume ds:mygdt,cs:code16
Mygdt SEGMENT PARA PUBLIC 'DATA' use16;also our datasegment
GDT dw 4 dup(0)    ;defines a Global Descriptor Table,starting with a null entry
GDT_code16=8
dw 0ffffh,0,9a00h,0    ;descriptor for a 16-bit code segment
GDT_code32=16
dw 0ffffh,0,9a00h,0cfh ;descriptor for a 32-bit code segment
GDT_data16=24
dw 0ffffh,0,9200h,0    ;descriptor for a 64Kb data segment
GDT_data32=32
dw 0ffffh,0,9200h,8fh  ;descriptor for a 4Gb data segment
ptr_GDT label fword
dw 40-1                ;GDT size-1
dd offset mygdt:gdt
dw 0                   ;a pointer to your GDT

save_nmi db 0
copyright db 'FMM By X-Wizard of DCC in 1994.',13,10
          db 'All rights removed...',13,10,'$'
Mygdt ENDS


code16 SEGMENT PARA PUBLIC 'code' use16
start:
mov ax,mygdt
mov ds,ax
mov ax,code16   ;we initialise code16 descriptor
movzx eax,ax
shl eax,4             ;now eax=physical adress of code16 seg
mov word ptr GDT[GDT_code16+2],ax
ror eax,16
mov byte ptr GDT[GDT_code16+4],al ;now code16 descriptor contains
                                  ;starting of code16 segment
mov ax,mygdt      ;dgroup is the name of a group from
                  ;which you can access to the GDT
movzx eax,ax
shl eax,4
add dword ptr ptr_GDT+2,eax
                       ;now ptr_GDT+2 contains the physical
                       ;adress of the GDT table in memory
lgdt fword ptr ptr_GDT ;load this info in GDT register.
cli
in al,70h
mov save_NMI,al
mov al,80h
out 70h,al
mov eax,cr0
or al,1
mov cr0,eax
db 0eah   ;this is a FAR JMP
dw offset pmode   ;dd offset pmode if we are in a 32 bits code segment
dw GDT_code16     ;we assume pmode is located in segment code16
                  ;please notice that as we are now
                  ;running in protected mode, we used
                  ;code16 descriptor instead of just
                  ;code16 segment (GDT_code16) instead
                  ;of just (code16)
pmode:
mov ax,GDT_data32 ;load descriptor for 4Gb segment
mov ds,ax         ;now ds limit is set to 4Gb
                  ;the other segments are still limited
                  ;to 64Kb but you can initialize them
                  ;too if you need :
mov es,ax
mov fs,ax
mov gs,ax         ;here all data segments are set to 4Gb
mov eax,cr0
and al,0feh
mov cr0,eax
db 0eah           ;this is a FAR JMP
dw offset rmode   ;dd offset rmode
                  ;if we are in a 32 bits code segment
dw code16         ;we assume rmode is in segment code16
rmode:
sti
mov al,save_NMI
out 70h,al
mov     ax,4c00h
int     21h
ends code16

end
