#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <3ds.h>
#include <ctype.h>


int read_line(char *s, FILE *f);

int read_line(char *s, FILE *f)
	{
	if(fgets(s,250,f)==0)
		return -1;

	s[strlen(s)-1]=0;
	return 0;
	}


object *read_3ds_file(char *filename, int print_progress)
	{
	FILE *f;
	float A,B,C;
	long a,b,c,x,y,z;
	char s[256];
	object *o;
	face *fa;
	long *index;


	f=fopen(filename,"r");
	if(!f)
		{
		return 0; /* error */
		}

	do
		{
		if(read_line(s,f))
			return 0;
		}
	while(memcmp(s,"Tri-mesh",8));

	for(a=0;s[a]!=':';a++) {}
	a+=2;
	x=atol(s+a);

	for(;s[a]!=':';a++) {}
	a+=2;
	y=atol(s+a);

	index=malloc(sizeof(long)*y*3);
	if(!index)
		return 0;

	o=alloc_object(x,y);
	if(!o)
		{
		free(index);
		return 0;
		}

	/* ok now read verticies */

	if(read_line(s,f))
		{
		free_object(o);
		return 0;
		}

	if(print_progress)
		{
		printf("Now reading file %s, %li vertices and %li faces.\n",
			filename,x,y);
		}

	for(a=0;a<x;a++)
		{
		if(read_line(s,f))
			{
			free_object(o);
			return 0;
			}
		if(memcmp(s,"Vertex",6))
			{
			a--;
			continue;
			}
		b=atol(s+7);
		if(print_progress)
			{
			if(!(a&127))
				{
				printf("Vertex #%li\n",b);
				}
			}
		if(a!=b)
			{
			if(print_progress)
				puts("Vertex discrepancy");
			free_object(o);
			return 0;
			}
		for(c=0;s[c]!='X';c++) {}
		A=strtod(s+c+2,0);
		for(;s[c]!='Y';c++) {}
		B=strtod(s+c+2,0);
		for(;s[c]!='Z';c++) {}
		C=strtod(s+c+2,0);

		o->pts_data->vertex[b].location[0]=floattoreal(A);
		o->pts_data->vertex[b].location[1]=floattoreal(B);
		o->pts_data->vertex[b].location[2]=floattoreal(C);
		}

	if(read_line(s,f))
		{
		free_object(o);
		return 0;
		}

	if(print_progress)
		puts("Reading faces");
	fa=o->face_data->face;
	for(a=0;a<y;a++)
		{
		if(read_line(s,f))
			{
			free_object(o);
			return 0;
			}
		if(memcmp(s,"Face",4))
			{
			a--;
			continue;
			}

		b=atol(s+5);
		if(b!=a)
			{
			if(print_progress)
				puts("Face discrepancy");
			free_object(o);
			}
		fa->index=index;
		if(print_progress)
			{
			if(!(a&127))
				{
				printf("Face #%li\n",b);
				}
			}

		for(c=5;s[c]!='A';c++) {}
		c+=2;
		fa->index[2]=atol(s+c);
		for(;s[c]!='B';c++) {}
		c+=2;
		fa->index[1]=atol(s+c);
		for(;s[c]!='C';c++) {}
		c+=2;
		fa->index[0]=atol(s+c);

		fa->numpoints=3;

		index+=3;
		fa++;
		}

	fclose(f);

	if(print_progress)
		puts("Done reading. Initializing normals");
	init_normals(o);
	normalize_object(o);

	if(print_progress)
		puts("Done.");

	return o;
	}




