/************************************************************************/
/* objects.h, objektinksittely-tauhkat.                                */
/************************************************************************/

#ifndef _chem_objects_h
#define _chem_objects_h

#include "bstructs.h"
#include "ialot.h"
#include "matrix.h"
#include "vector.h"
#include "loadasc.h"

/************************************************************************/
/* defines:                                                             */
/************************************************************************/
#define p_flat 0
#define p_gouraud 1
#define p_texture 2
#define p_texturegouraud 3
#define p_gouraudtexture 3
#define p_phong 4
#define p_envmap 5
// hidden face removal enabled:
#define p_hfre 16
// see bstructs.h and scene.h for more inphormatzion.


/************************************************************************/
/* vapauttaa objektille varatun muistin.                                */
/************************************************************************/
void dispose_object(scene_type *scene, int nro);


/************************************************************************/
/* alustaa objektien latausrutiinit ja varaa objektien struktuureille   */
/* tilaa.                                                               */
/************************************************************************/
void obj_loader_init(scene_type *scene, int max_objects);


/************************************************************************/
/* vapauttaa objektien varaaman strukture-tilan.                        */
/************************************************************************/
void free_object_structs(scene_type *scene);


/************************************************************************/
/* tt kutsutaan kun kaikki objektit on ladattu                        */
/************************************************************************/
void all_objects_loaded(scene_type *scene);

/************************************************************************/
/* laskee objektille verteksinormaalit. trke funkkari.                */
/* IN: scene=scene, nro=objektin numero (handle)                        */
/************************************************************************/

void calc_object_data(scene_type *scene, unsigned int nro);

/************************************************************************/
/* asettaa objektin kaikkien facejen liput.                             */
/************************************************************************/
void set_flags(objtype *obu, unsigned int flgs, unsigned char textnro,
               unsigned char r, unsigned char g, unsigned char b);

/************************************************************************/
/* lataa 3D Studion .ASC-filen ja ottaa sen ohjelman kyttn.          */
/************************************************************************/
/* IN:                                                                  */
/*  scene=mihin sceneen objekti ladataan                                */
/*  filename=ladattan ASC:n filename                                    */
/*  mul=objektin kokokerroin. esim 0.5 puolittaa objektin koon jne.     */
/*  (xpos,ypos,zpos)=objektin origo                                     */
/*  flags=objektin facejen attribuutit                                  */
/*  textnro: jos texturemappaus, niin mit texturea kytetn.          */
/*  r,g,b: jos ei tm, niin mik on objektin vri                        */
/* OUT:                                                                 */
/*  -1  error                                                           */
/*  >=0 a handle for the object                                         */
/************************************************************************/
signed int new_obj(scene_type *scene, char *filename,float mul,
                   float xpos, float ypos, float zpos,
                   unsigned int flags, unsigned char textnro,
                   unsigned char r, unsigned char g, unsigned char b);

/************************************************************************/
/* liikuttaa objektia:                                                  */
/************************************************************************/
void object_liikuta(scene_type *scene, unsigned int nro,
                    float xa, float ya, float za,
                    float s_rt, float s_dn, float s_fw);

/************************************************************************/
/* listn objekti piirrettvksi.                                     */
/************************************************************************/
void putobject(scene_type *scene, unsigned int nro, kamera_type *kamera);

#endif
