//
// Timer class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_TIMER_H
#define __PTC_TIMER_H




class Timer
{
    public:

        // setup
        Timer();
        ~Timer();

        // set time
        void set(float time);

        // control
        void start();
        void stop();

        // time data
        float time();
        float delta();
        float resolution();
    
        // operators
        Timer& operator =(const Timer &timer);
        bool operator ==(const Timer &timer) const;
        bool operator !=(const Timer &timer) const;

    private:

        // clock time
        float clock();

        // data
        float m_old;
        float m_time;
        float m_start;
        bool m_running;
};




#endif
