//
// Main include file for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_H
#define __PTC_H



//
// Platform signature define
// -------------------------
//
// You must change the following #define to be a platform dependent
// signature define to match your platform.
//
// This define will be used by programmers to check what implementation
// of PTC they are running under and what extensions are available
// (see extend.txt for more information on extensions).
//
// Some examples of signature defines:
//
// #define __PTC_WIN32__      // win32 implementation
// #define __PTC_X11__        // x11 implementation
// #define __PTC_GGI__        // ggi implementation
//
// Basically, the define should be either:
// a) the name of the platform
// b) the name of the graphics interface
//
// The define should be all uppercase.
//
// If there is more than one implementation for the given platform,
// ie. under LINUX there will be SVGALIB and GGI implementations
// so __PTC_LINUX__ is not acceptable. In this case the name of
// the graphics interface is used, not the platform.
//
#define __PTC_DOS__


// include files
#include "Key.h"
#include "Area.h"
#include "Timer.h"
#include "Error.h"
#include "Color.h"
#include "Format.h"
#include "Palette.h"
#include "Surface.h"
#include "Console.h"




#endif
