// Accelerator.h: interface for the CAccelerator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACCELERATOR_H__3278C161_9F12_11D5_AD0F_50D456C10027__INCLUDED_)
#define AFX_ACCELERATOR_H__3278C161_9F12_11D5_AD0F_50D456C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

class CAccelerator : public CEfx  
{
private:

	CSimpleMesh				m_smAccelerator;
	
	PDIRECT3DVERTEXBUFFER8	m_pvbWireframe;	

	PDIRECT3DVERTEXBUFFER8	m_pvbFxPod;
	PDIRECT3DVERTEXBUFFER8	m_pvbFxPod2;	

	PDIRECT3DVERTEXBUFFER8	m_pvbBassPod;

	BOOL					m_bRenderBass;

	PDIRECT3DVERTEXBUFFER8	m_pvbParticle;

	PDIRECT3DVERTEXBUFFER8	m_pvbSphere;
	PDIRECT3DINDEXBUFFER8	m_pibSphere;

	FLOAT					m_ppfSphere[14*8+2][2];
	DWORD					m_pdwSyncIndex[14*8+2];
	
	PDIRECT3DVERTEXBUFFER8	m_pvbFxPlane;
	PDIRECT3DINDEXBUFFER8	m_pibFxPlane;

	FLOAT					m_fRotation;

	PDIRECT3DTEXTURE8		m_ptexHoles;
	PDIRECT3DTEXTURE8		m_ptextCaust[32];

	CParticleSystem			m_psAccelerator;
	CPointEmiter			m_peEmiters[27];

	CImageQuad*				m_piqFade;
	CImageQuad*				m_piqHole;

	BOOL					m_bRenderFade;

	INT						m_ppiWater[2][2500];
	DWORD					m_dwCurrentWaterPage;
	
	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwKeyCount[6];

	FLOATKEY				m_fBassSync[10];

	CTextureRenderer*		m_ptrSphere;
	CTextureRenderer*		m_ptrBass;

public:

	CAccelerator( PDIRECT3DDEVICE8 pDevice );
	virtual ~CAccelerator();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_ACCELERATOR_H__3278C161_9F12_11D5_AD0F_50D456C10027__INCLUDED_)
