// Octopus.h: interface for the COctopus class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OCTOPUS_H__3804DF76_8311_453E_9362_8F06D239E0F6__INCLUDED_)
#define AFX_OCTOPUS_H__3804DF76_8311_453E_9362_8F06D239E0F6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "Efx.h"

class COctopus : public CEfx
{
private:

	PDIRECT3DVERTEXBUFFER8	m_pvbSphere;
	PDIRECT3DINDEXBUFFER8	m_pibSphere;

	PDIRECT3DVERTEXBUFFER8	m_pvbWireframeSphere;
	PDIRECT3DINDEXBUFFER8	m_pibWireframeSphere;

	PDIRECT3DVERTEXBUFFER8	m_pvbFxLines;

	PDIRECT3DVERTEXBUFFER8	m_pvbFxHalo;
	PDIRECT3DINDEXBUFFER8	m_pibFxHalo;

	he3d_CVector			m_vDir[200];
	he3d_CVector			m_vBasePos[200][8];
	DWORD					m_dwSyncIndex[200];

	he3d_CVector			m_vHalo[202];
	FLOAT					m_fScaleShift[202];
	
	he3d_CMatrix			m_mtxFxSphere;

	CSimpleMesh				m_smOctopus;
	CSimpleMesh				m_smOrnament;	

	CImageQuad*				m_piqFade;
	CImageQuad*				m_piqDisp;

	BOOL					m_bRenderFade;

	he3d_CVector*			m_vOctopus;

	he3d_CMatrix			m_mtxSphere;

	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwKeyCount[6];

public:

	COctopus( PDIRECT3DDEVICE8 pDevice );
	virtual ~COctopus();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_OCTOPUS_H__3804DF76_8311_453E_9362_8F06D239E0F6__INCLUDED_)
