// Mirrors.h: interface for the CMirrors class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MIRRORS_H__DD812801_A137_11D5_AD0F_80D756C10027__INCLUDED_)
#define AFX_MIRRORS_H__DD812801_A137_11D5_AD0F_80D756C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

class CMirrors : public CEfx  
{
private:

	PDIRECT3DVERTEXBUFFER8	m_pvbMirrosPod;
	PDIRECT3DVERTEXBUFFER8	m_pvbRectangles[5];

	PDIRECT3DVERTEXBUFFER8	m_pvbTrinagles;

	PDIRECT3DVERTEXBUFFER8	m_pvbOrnament;

	// mirors attribs	
	he3d_CVector			m_vPosition[16];
	D3DVIEWPORT8			m_d3dvpMirrors[16];

	he3d_CMatrix			m_mtxMirrors;

	he3d_CMatrix			m_mtxRectangles[5];

	he3d_CMatrix			m_mtxTriangles[5];

	// particle system
	CParticleSystem			m_psEnergy[2];
	CPointEmiter			m_peEmiter[20];	

	// mirror texture
	CTextureRenderer*		m_ptrMirrors[2];
	DWORD					m_dwCurrentPage;

	FLOAT					m_fTexture;

	CImageQuad*				m_piqText[5];
	BOOL					m_bRenderText;

	CImageQuad*				m_piqMask;

	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwKeyCount[6];

	CImageQuad*				m_piqFlash;

	CImageQuad*				m_piqFade;
	BOOL					m_bRenderFade;

public:

	CMirrors( PDIRECT3DDEVICE8 pDevice );
	virtual ~CMirrors();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_MIRRORS_H__DD812801_A137_11D5_AD0F_80D756C10027__INCLUDED_)
