// Console.h: interface for the CConsole class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONSOLE_H__4E897501_A522_11D5_AD0F_E0DA56C10027__INCLUDED_)
#define AFX_CONSOLE_H__4E897501_A522_11D5_AD0F_E0DA56C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define	MAX_SYSTEM_NAME		255
#define	MAX_SEQUENCE_NAME	100

class CConsoleOutput
{
public:
	
	CConsoleOutput();
	virtual CConsoleOutput();
	
	virtual CConsoleOutput& operator<< ( const unsigned char* ) = 0;
	virtual CConsoleOutput& operator<< ( const signed char* ) = 0;
	virtual CConsoleOutput& operator<< ( const char* ) = 0;
	virtual CConsoleOutput& operator<< ( int ) = 0;
	virtual CConsoleOutput& operator<< ( unsigned int ) = 0;
	virtual CConsoleOutput& operator<< ( short ) = 0;
	virtual CConsoleOutput& operator<< ( unsigned short ) = 0;
	virtual CConsoleOutput& operator<< ( char ) = 0;
	virtual CConsoleOutput& operator<< ( unsigned char ) = 0;
	virtual CConsoleOutput& operator<< ( float ) = 0;
	virtual CConsoleOutput& operator<< ( double ) = 0;

	virtual CConsoleOutput& flush();
};

inline CConsoleOutput& endl( CConsoleOutput& console )
{
	console << (char)('\n');
	console.flush();

	return console;
}

class CConsoleFileOutput : public CConsoleOutput
{
private:

	ofstream				stream;

public:

	CConsoleFileOutput( char filename[] );
	~CConsoleFileOutput();

	CConsoleOutput& operator<< ( const unsigned char* );
	CConsoleOutput& operator<< ( const signed char* );
	CConsoleOutput& operator<< ( const char* );
	CConsoleOutput& operator<< ( int );
	CConsoleOutput& operator<< ( unsigned int );
	CConsoleOutput& operator<< ( short );
	CConsoleOutput& operator<< ( unsigned short );
	CConsoleOutput& operator<< ( char );
	CConsoleOutput& operator<< ( unsigned char );
	CConsoleOutput& operator<< ( float );
	CConsoleOutput& operator<< ( double );

	CConsoleOutput& flush();
};

class CConsole
{
private:
	
	CConsoleOutput*			m_pcoOutput;
	BOOL					m_bIsAttached;
	char					m_pstrSystemName[MAX_SYSTEM_NAME+1];

public:

	CConsole();
	CConsole( char pstrSystemName[] );
	virtual ~CConsole();

	virtual VOID Attach( CConsoleOutput* output );	
	virtual VOID Detach();
	virtual VOID BeginSequence( char ptsSequence[] );
	virtual VOID EndSequence();
	virtual VOID LogAction( char pstrAction[] );
	virtual VOID ActionSucceeded();
	virtual VOID ActionFailed( char pstrReason[] );
	virtual VOID ActionFailed();

	virtual BOOL IsAttached();
	virtual CConsoleOutput& output();
};

#endif // !defined(AFX_CONSOLE_H__4E897501_A522_11D5_AD0F_E0DA56C10027__INCLUDED_)
