{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$M 1024,0,64768}
unit ADP;

{ Format pliku ADP:
  spakowany znacznikowo format AST:
                         ekran  0fa00h bajtw
                         paleta 00300h bajtw
                         --------------------
                         razem  0fd00h bajtw
  Jezeli sa wiecej niz 4 takie same bajty, to zostaja zastapione przez:
            250                            249
          ilosc: Byte          lub       ilosc: Word
           bajt                           bajt

  gdzie '250' i '249' to kody informujace o powtrzeniu, 'ilosc' to
  ilosc bajtw do odpakowania (typu Byte lub Word), zas 'bajt' to
  kod powtarzajacego sie bajtu.

  Procedura asemblerowa UnPack wymaga nastepujacych danych:
     ds:si - tablica zrdlowa
     es:di - tablica docelowa (o rozmiarze 0fd00h bajtw dla obrazka)
        dx - ilosc bajtw do odpakowania. }

interface

type wz=array[0..64767] of Byte;
var wt: ^wz;

procedure LoadADP(nz: string);
procedure SaveADP(nz: string);
procedure UnPackADP(nz: string; var tb);
procedure UnPack;


implementation

procedure LoadADP(nz: string);
var   sz: Word;
      fl: file;
const ad: Word=$a000;
begin
  if Pos('.',nz)=0 then nz:=nz+'.adp';
  Assign(fl,nz);
  Reset(fl,1);
  if (IOResult=2) then Halt;
  sz:=FileSize(fl);
  GetMem(wt,sz);
  BlockRead(fl,wt^,sz);
  Close(fl);
  asm
     mov ax,1201h
     mov bl,36h
     int 10h

     push ds
     mov es,ad
     xor di,di
     lds si,wt
     mov dx,sz
     call UnPack
     pop ds

     push ds
     mov si,0a000h
     mov ds,si
     mov si,0fa00h
     sub ah,ah
     mov dx,3c9h
     cld

@d6: dec dx
     mov al,ah
     out dx,al
     inc dx
     lodsb
     out dx,al
     lodsb
     out dx,al
     lodsb
     out dx,al
     inc ah
     jnz @d6
     pop ds

     mov ax,1200h
     mov bl,36h
     int 10h
  end;
  FreeMem(wt,sz)
end;

procedure SaveADP(nz: string);
var   fl: file;
   sr,dt: Word;
   rt,mm: Word;
const ad: Word=$a000;
begin
  New(wt);
  sr:=0;
  dt:=0;
  asm
    mov ax,1017h
    xor bx,bx
    mov cx,256
    mov es,ad
    mov dx,0fa00h
    int 10h
  end;
  repeat
    rt:=1;
    mm:=Mem[ad:sr];
    while (sr+rt<=64767) and (mm=Mem[ad:sr+rt]) do
      Inc(rt);
    if (rt<4) and (mm<>249) and (mm<>250) then
    begin
      Move(Mem[ad:sr],wt^[dt],rt);
      Inc(dt,rt)
    end
    else
    begin
      if (rt>255) then
      begin
        wt^[dt]:=249;
        Move(rt,wt^[dt+1],2);
        wt^[dt+3]:=mm;
        Inc(dt,4)
      end
      else
      begin
        wt^[dt]:=250;
        wt^[dt+1]:=rt;
        wt^[dt+2]:=mm;
        Inc(dt,3)
      end
    end;
    Inc(sr,rt)
  until (sr=64768);
  if (dt<sr) then
  begin
    if (Pos('.',nz)=0) then nz:=nz+'.adp';
    Assign(fl,nz);
    Rewrite(fl,1);
    BlockWrite(fl,wt^,dt);
    Close(fl);
  end;
  Dispose(wt)
end;

procedure UnPackADP(nz: string; var tb);
var   sz: Word;
      fl: file;
      pt: Pointer;
begin
  if Pos('.',nz)=0 then nz:=nz+'.adp';
  Assign(fl,nz);
  Reset(fl,1);
  if (IOResult=2) then Halt;
  sz:=FileSize(fl);
  GetMem(wt,sz);
  BlockRead(fl,wt^,sz);
  Close(fl);
  pt:=@tb;
  asm
     push ds
     les di,pt
     lds si,wt
     mov dx,sz
     call UnPack
     pop ds
  end;
  FreeMem(wt,sz)
end;

procedure UnPack; assembler;
asm
     cld
     add dx,si
@d1: lodsb
     cmp al,0fah
     je @d2
     cmp al,0f9h
     je @d3
     jne @d5
@d2: lodsb
     xor ah,ah
     jz @d4
@d3: lodsw
@d4: mov cx,ax
     lodsb
     rep
@d5: stosb
     cmp si,dx
     jb @d1
     ret
end;


end.