{$N+,E-,D-,L-,F-}
unit tools3d;

interface

type
  lang = (bin, as, c, pas);

var
  output        : lang;
  ext           : array [bin..pas] of string;

  procedure getcfg;
  procedure openout(n:string);
  procedure closeout;
  procedure header( np, nf: integer);
  procedure faceheader;
  procedure ending;
  procedure triad( xl, yl, zl: integer; ost: boolean);

implementation

procedure normals; forward;

const
  copyright = '3DMaker 2.3 (c) Warlock/AME, FiL/ENZ';

var
  binout        : file;
  txtout        : text;
  vert_n        : string;
  vert_t        : string;
  vert_a        : string;
  faces_n       : string;
  faces_t       : string;
  faces_a       : string;
  fnorm_t       : string;
  fnorm_a       : string;
  vnorm_t       : string;
  vnorm_a       : string;
  cfg           : text;
  fnorm, vnorm  : boolean;
  normlang      : lang;
  normname      : string;

function getpara(var f: text; key: string; def: string): string;
var
  ln: string;
begin
  {$I-}
  reset(f);
  if IOresult = 0 then
    while not eof(f) do
    begin
      readln(f,ln);
      if pos(key,ln) = 1 then
      begin
        delete(ln,1,length(key)+1);
        getpara := ln;
        exit
      end
    end;
  getpara := def
  {$I+}
end;

function getlang(s: string): lang;
begin
  if (s = 'bin') or (s = 'BIN') or (s = '666') then
    getlang := bin;
  if (s = 'asm') or (s = 'ASM') or (s = 'best') then
    getlang := as;
  if (s = 'pas') or (s = 'PAS') then
    getlang := pas;
  if (s = 'c') or (s = 'C') then
    getlang := c;
end;

function getbool(s: string): boolean;
begin
  if (s = 'on') or (s = 'ON') or (s = 'yes') or (s = 'YES') then
    getbool := true
  else
    getbool := false
end;

procedure getcfg;
begin
  writeln;
  writeln(copyright);
  assign(cfg,'3dmaker.cfg');
  output := getlang(getpara(cfg,'lang','asm'));
  vert_n := getpara(cfg,'vert_n','NPoints');
  vert_t := getpara(cfg,'vert_t','TPoint');
  vert_a := getpara(cfg,'vert_a','Points');
  faces_n := getpara(cfg,'faces_n','NFaces');
  faces_t := getpara(cfg,'faces_t','TFace');
  faces_a := getpara(cfg,'faces_a','Faces');
  fnorm_t := getpara(cfg,'fnorm_t','TPoint');
  fnorm_a := getpara(cfg,'fnorm_a','FNorms');
  vnorm_t := getpara(cfg,'vnorm_t','TPoint');
  vnorm_a := getpara(cfg,'vnorm_a','PNorms');
  ext[bin] := getpara(cfg,'bin_ext','bin');
  ext[as] := getpara(cfg,'asm_ext','inc');
  ext[c] := getpara(cfg,'c_ext','h');
  ext[pas] := getpara(cfg,'pas_ext','inc');
  fnorm := getbool(getpara(cfg,'fnormals','off'));
  vnorm := getbool(getpara(cfg,'vnormals','off'));
end;

procedure openout(n:string);
begin
  if fnorm or vnorm then
  begin
    normlang := output;
    output := bin;
    normname := n;
    n := 'temp';
  end;
  if output = bin then
  begin
    assign (binout,n+'.'+ext[bin]);
    rewrite(binout,1)
  end
  else
  begin
    assign(txtout,n+'.'+ext[output]);
    rewrite(txtout)
  end
end;

procedure closeout;
begin
  if output = bin then
    close(binout)
  else
    close(txtout);
  if fnorm or vnorm then
  begin
    output := normlang;
    normals;
  end;
end;

procedure header( np, nf: integer);
begin
  case output of
    bin:
    begin
      blockwrite (binout,np,2);
      blockwrite (binout,nf,2);
    end;
    as:
    begin
      writeln(txtout,'; ',copyright);
      writeln(txtout);
      writeln(txtout,vert_n,' equ ',np);
      writeln(txtout,faces_n,' equ ',nf);
      writeln(txtout);
      writeln(txtout, vert_a, ':');
    end;
    pas:
    begin
      writeln(txtout,'{ ',copyright,' }');
      writeln(txtout);
      writeln(txtout, 'const');
      writeln(txtout, '  ',vert_n,' = ',np,';');
      writeln(txtout, '  ',faces_n,' = ',nf,';');
      writeln(txtout);
      writeln(txtout,'  ',vert_a,': array[0..',vert_n,'-1] of TPoint = (');
    end;
    c:
    begin
      writeln(txtout,'/* ',copyright,' */');
      writeln(txtout);
      writeln(txtout, '#define ',vert_n,' ',np);
      writeln(txtout, '#define ',faces_n,' ',nf);
      writeln(txtout);
      writeln(txtout,vert_t,' ',vert_a,'[',vert_n,'] = {');
    end;
  end
end;

procedure faceheader;
begin
  case output of
    bin: ;
    as:
    begin
      writeln(txtout);
      writeln(txtout,faces_a,':');
    end;
    pas:
    begin
      writeln (txtout,'  );');
      writeln (txtout);
      writeln (txtout,'  ',faces_a,': array[0..',faces_n,'-1] of ',faces_t,' = (');
    end;
    c:
    begin
      writeln (txtout,'  };');
      writeln (txtout);
      writeln(txtout,faces_t,' ',faces_a,'[',faces_n,'] = {');
    end;
  end;
end;

procedure fnormheader;
begin
  case output of
    bin: ;
    as:
    begin
      writeln(txtout);
      writeln(txtout,fnorm_a,':');
    end;
    pas:
    begin
      writeln (txtout,'  );');
      writeln (txtout);
      writeln (txtout,'  ',fnorm_a,': array[0..',faces_n,'-1] of ',fnorm_t,' = (');
    end;
    c:
    begin
      writeln (txtout,'  };');
      writeln (txtout);
      writeln(txtout,fnorm_t,' ',fnorm_a,'[',faces_n,'] = {');
    end;
  end;
end;

procedure vnormheader;
begin
  case output of
    bin: ;
    as:
    begin
      writeln(txtout);
      writeln(txtout,vnorm_a,':');
    end;
    pas:
    begin
      writeln (txtout,'  );');
      writeln (txtout);
      writeln (txtout,'  ',vnorm_a,': array[0..',vert_n,'-1] of ',vnorm_t,' = (');
    end;
    c:
    begin
      writeln (txtout,'  };');
      writeln (txtout);
      writeln(txtout, vnorm_t,' ',vnorm_a,'[',vert_n,'] = {');
    end;
  end;
end;

procedure ending;
begin
  case output of
    bin: ;
    as: ;
    pas:
      writeln(txtout,'  );');
    c:
      writeln(txtout,'  };');
  end;
end;

procedure triad( xl, yl, zl: integer; ost: boolean);
begin
  case output of
    bin:
    begin
      blockwrite (binout,xl,2);
      blockwrite (binout,yl,2);
      blockwrite (binout,zl,2);
    end;
    as:
      writeln(txtout,'    dw ',xl:5,',',yl:5,',',zl:5);
    pas:
    begin
      write(txtout,'    (',xl:5,',',yl:5,',',zl:5,')');
      if ost then
        writeln(txtout)
      else
        writeln(txtout,',')
    end;
    c:
    begin
      write(txtout,'     ',xl:5,',',yl:5,',',zl:5,'');
      if ost then
        writeln(txtout)
      else
        writeln(txtout,',')
    end
  end
end;

type
  triword = record x,y,z: integer end;
  tritab = array [0..10000] of triword;

procedure unitvect( var x,y,z: longint );
var
  l: real;
begin
  l := sqrt(sqr(x*1.0)+sqr(y*1.0)+sqr(z*1.0));
  if l = 0 then
  begin
    writeln('invalid normal vector');
    halt(1);
  end;
  x := round( x / l * (1 shl 15 - 1) );
  y := round( y / l * (1 shl 15 - 1) );
  z := round( z / l * (1 shl 15 - 1) );
end;

procedure normals;
var
  sf: file;
  nverts, nfaces, f,v: word;
  faces, verts, fnorms: ^tritab;
  _fnorm, _vnorm: boolean;
  x1,x2,y1,y2,z1,z2,vnx, vny, vnz: longint;
begin
  assign(sf,'temp.bin');
  reset(sf,2);
  blockread(sf, nverts, 1);
  blockread(sf, nfaces, 1);
  if (nverts > 10000) or (nverts > 10000) then
  begin
    writeln('object too large');
    close(sf);
    erase(sf);
    exit
  end;
  getmem(verts,nverts*6);
  getmem(faces,nfaces*6);
  getmem(fnorms,nfaces*6);
  blockread(sf,verts^,nverts*3);
  blockread(sf,faces^,nfaces*3);
  close(sf);
  erase(sf);

  for f := 0 to nfaces-1 do
  begin
    x1 := verts^[faces^[f].y].x - verts^[faces^[f].x].x;
    x2 := verts^[faces^[f].z].x - verts^[faces^[f].x].x;
    y1 := verts^[faces^[f].y].y - verts^[faces^[f].x].y;
    y2 := verts^[faces^[f].z].y - verts^[faces^[f].x].y;
    z1 := verts^[faces^[f].y].z - verts^[faces^[f].x].z;
    z2 := verts^[faces^[f].z].z - verts^[faces^[f].x].z;

    vnx:= y1*z2-y2*z1;
    vny:= x2*z1-x1*z2;
    vnz:= x1*y2-x2*y1;
    unitvect(vnx,vny,vnz);

    fnorms^[f].x := vnx;
    fnorms^[f].y := vny;
    fnorms^[f].z := vnz;

  end;
  _fnorm := fnorm;
  fnorm := false;
  _vnorm := vnorm;
  vnorm := false;
  openout(normname);
  header(nverts, nfaces);
  for v := 0 to nverts-1 do
    triad( verts^[v].x, verts^[v].y, verts^[v].z, v = nverts-1 );
  faceheader;
  for f := 0 to nfaces-1 do
    triad( faces^[f].x, faces^[f].y, faces^[f].z, f = nfaces-1 );
  if _fnorm then
  begin
    fnormheader;
    for f := 0 to nfaces-1 do
      triad( fnorms^[f].x, fnorms^[f].y, fnorms^[f].z, f = nfaces-1 );
  end;
  if _vnorm then
  begin
    vnormheader;
    for v := 0 to nverts-1 do
    begin
      vnx := 0; vny := 0; vnz := 0;
      for f := 0 to nfaces-1 do
        if (faces^[f].x = v) or (faces^[f].y = v) or (faces^[f].z = v) then
        begin
          vnx := vnx + fnorms^[f].x;
          vny := vny + fnorms^[f].y;
          vnz := vnz + fnorms^[f].z;
        end;
      unitvect(vnx,vny,vnz);
      triad( vnx, vny, vnz, v = nverts-1);
    end;
  end;
  ending;
  closeout;
  fnorm := _fnorm;
  vnorm := _vnorm;
  freemem(verts,nverts*6);
  freemem(faces,nfaces*6);
  freemem(fnorms,nfaces*6);
end;

end.