; ***************************************************************************
; * rexload.asm                                                             *
; *  this is the .REX loader used by both the internal and external loader  *
; * functions:                                                              *
; * rex_getinfo                                                             *
; *  in:                                                                    *
; *   esi=pointer to executable header+reloc table                          *
; *  out:                                                                   *
; *   esi=pointer to execdata if the executable was given as input          *
; *   edi=pointer to destination for executable                             *
; *   ecx=size in bytes of executable                                       *
; *                                                                         *
; * rex_start                                                               *
; *  in:                                                                    *
; *   none                                                                  *
; *  out:                                                                   *
; *   never returns                                                         *
; ***************************************************************************
.386p

public rex_getinfo
public rex_start

public stubsize

CODE32 segment public use32 'code'
assume cs:code32,ds:code32

stubsize    dd 0           ;* dummy value under internal, stubsize if a stub

execsize    dd 0           ;* executable size
headersize  dd 0           ;* size of header

extramem    dd 0           ;* Memory to allocate above the execitself

execdata    dd 0           ;* pointer to exec to be loaded
execoffset  dd 0           ;* place to load the exec to
            
relocitems  dd 0           ;* relocation items
relocoffset dd 0           ;* start of relocation table

reg_esp     dd 0           ;* starting stack pointer
reg_eip     dd 0           ;* starting execpointer

rex_getinfo:
  mov edx,esi
  movzx eax,word ptr[edx+4]
  dec eax
  shl eax,9
  movzx ebx,word ptr[edx+2]
  add eax,ebx
  sub eax,stubsize                  ; Needed for stubloader!
  mov execsize,eax

  movzx eax,word ptr[edx+8]
  shl eax,4
  sub eax,stubsize                  ; Needed for stubloader!
  mov headersize,eax
  sub execsize,eax

  movzx eax,word ptr[edx+0ah]
  shl eax,12
  mov extramem,eax

  mov eax,dword ptr[edx+0eh]
  mov reg_esp,eax
  mov eax,dword ptr[edx+014h]
  mov reg_eip,eax

  movzx eax,word ptr[edx+018h]
  add eax,edx
  mov relocoffset,eax
  movzx eax,word ptr[edx+06h]
  mov relocitems,eax

  mov eax,edx
  add eax,headersize
  mov execdata,eax

  push edx
   mov edx,execsize
   add edx,extramem
   mov ax,0ee42h
   int 31h
   mov execoffset,edx
  pop edx

  mov esi,execdata
  mov edi,execoffset
  mov ecx,execsize
ret

rex_start:
  xor ecx,ecx
  mov edi,execoffset
  add ecx,relocitems
  jz no_reloc
   mov esi,relocoffset
   reloc_loop:
     lodsd
     and eax,07fffffffh
     add eax,edi
     add [eax],edi
   loop reloc_loop
no_reloc:

  mov edi,execoffset
  add reg_esp,edi
  add reg_eip,edi

  mov esp,reg_esp
  jmp [reg_eip]
CODE32 ends
end
