; ***************************************************************************
; * Stubloader                                                              *
; *                                                                         *
; * loads dos32 v3.5 executables linked with dlink                          *
; ***************************************************************************
.386p

public start32                                      ; Public startingpoint

extrn d32_getinfo:near                              ; misc loading code
extrn d32_start:near                                ; starting overlay
extrn install_ext21:near                            ; installing extended
                                                    ; int21h functions

extrn stubsize:dword

CODE32 segment public use32 'code'
assume cs:code32,ds:code32

 start32:                                          ; Startingpoint
  call install_ext21                               ; Adding extended int21h func

  mov edx,offset starttext
  mov ah,9
  int 21h                                          ; Startup message

  mov ax,0ee02h
  int 31h
  mov exename,ecx                                  ; Getting name of itself




  mov edx,exename
  mov ax,3d00h
  mov ecx,0
  int 21h                                          ; Open itself

  mov exenum,ax                                    ; store filehandle

  mov bx,exenum
  mov edx,0
  mov ax,4200h
  int 21h                                          ; search to 0
  
  mov edx,offset mz_header
  mov ecx,6
  mov ah,3fh
  mov bx,exenum
  int 21h                                          ; load in MZ header to get
                                                   ; stubsize

  mov ax,4202h
  mov bx,exenum
  mov edx,0
  int 21h                                          ; get total lenght of file

  mov edx,eax
  mov realtotal,eax

  movzx eax,mz_header+4
  movzx ebx,mz_header+2
  dec eax
  shl eax,9
  add eax,ebx                                      ; Calculate stubsize
  cmp eax,edx                                      
  je error_nostub                                  ; if stubsize=total size
                                                   ; then no overlay,exit
  mov ovroffset,eax                                ; offset of overlay

  pushad
   mov edx,eax
   mov ax,4200h
   mov bx,exenum
   int 21h                                         ; Search to start of overlay
  popad

  mov ah,3fh                                       ; Function
  mov ecx,02ch                                     ; Normal size of header
  mov edx,offset d32header                         ; Pointer to header
  mov bx,exenum                                    ; Filehandle
  int 21h                                          ; Load REX header

  cmp dword ptr[d32header],'madA'                  ; Right kind of stub?
  jne error_errstub                                ; nope, exit
                                                   ; yes , continue

  mov esi,offset d32header
  call d32_getinfo

  pushad
   mov edx,ovroffset
   add edx,44
   mov ax,4200h
   mov bx,exenum
   int 21h                                         ; Search to start of overlay data
  popad

  ; Ecx is set to bytes to load on startup
  ; Edi is destination memory
  ; Esi is source memory *ignore when stubloading*
  push ecx
  push edi
  mov ah,3fh
  mov edx,edi
  mov bx,exenum
  int 21h


  pop eax
  pop ebx

  mov ah,3eh
  mov bx,exenum
  int 21h                                          ; Close file

  call d32_start

error_nostub:                                      ; Error, nostub
  mov edx,offset error_nostub_string
  jmp err_exit
 
error_errstub:                                     ; Error, wrong stub
  mov edx,offset error_errstub_string
  jmp err_exit

err_exit:                                          ; Common exit
  mov ah,9
  int 21h

  mov ah,3eh
  mov bx,exenum
  int 21h

  mov ax,4c01h
  int 21h


error_nostub_string db 'Error: no overlay$'
error_errstub_string db 'Error: overlay is not a Dos32 v3.5 file$'

starttext db 'WexT Dos32 stubloader v1.0',13,10,'$'

exename   dd 0

exenum    dw 0

mz_header dw 0,0,0

ovroffset dd 0

d32header db 44 dup (0)

realtotal dd 0


CODE32 ends
end
