;***************************************************************************** 
;* wextlibs                                                                  *
;*                                                                           *
;* tiny startupcode for Watcom C/C++ under WexT386                           *
;*                                                                           *
;* Publics:                                                                  *
;* START32           , Called by the dosextender at startup                  *
;* protected_offset  , Tells where the program starts                        *
;* psp_offset        , Tells where the PSP is located                        *
;* env_offset        , Tells where the ENVIRONMENT is located                *
;*                                                                           *
;* Externals:                                                                *
;* main_             , The main C proc, called by the startupcode            *
;* system_memoryinit , The call that initates the memory heap                *
;***************************************************************************** 


; *************** Model define *******************
.386p
.model flat

; *************** Standard defines ***************
include defines.inc

; *************** Initial Stack ******************
; change here to enter stack size
.stack 1*1024*1024                        ; 1 meg
                                          ; this should even be enuff for a
                                          ; raytracer with alot of recursive
                                          ; calls
                                          ; (flex^blocc told that his needed 90k)

; *************** Publics ************************

public START32                            ; make the starting point public
public _cstart_                           ; make the starting point public

public protected_offset
public psp_offset
public env_offset

public ___exit_terminator                 ; provided to the exit(x); function

; *************** Externals **********************
extrn main_:near                          ; C starting point
extrn system_memoryinit:near              ; proc to init memory system with

; *************** Data *************************
.data
protected_offset dd 0    ; the start of all code
psp_offset dd 0          ; the offset of the psp
env_offset dd 0          ; the offset of the psp

orig_stack_esp dd 0
orig_stack_ss  dw 0
; *************** Code *************************
.code
 START32:                ; WexT386 starting point
 _cstart_:               ; WexT386 starting point

  mov ax,0ee02h             ; Get WexT386/dos32 memory information
  int 31h                   ; the call
  neg ebx                   ; relative address, negate to make it a offset
  mov protected_offset,ebx  ; set the offset
  mov psp_offset,esi        ; set the psp pointer
  mov env_offset,edi        ; set the env pointer

  call system_memoryinit     ; Startup memory systems

   sti
   call main_                 ; yeah that bloody C code! :>
___exit_terminator:

cli
  mov esp,orig_stack_esp
  mov ax,orig_stack_ss
  mov ax,ss

  mov ah,4ch                ; Hey our all so nice Exit code
  int 21h                   ; exiting

; *************** End *************************
END _cstart_
