; vesa.asm
; part of the woorlic Truecolor lib

vesa_nummodes        dd   0

;                     Mode    Width    Height   Bpp   Type
vesa_modes        dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0
                  dd   0   ,     0   ,    0   ,   0  , 0

vesa_temp1 dd 0
vesa_temp2 dd 0
vesa_temp3 dd 0

vesa_rmS dd 0
vesa_rmO dd 0

vesa_modebuffer dd 0    ; ptr to mode numbers

vesa_modeinfo_number dd 0
vesa_modeinfo_type   dd 0
vesa_modeinfo_bpp    dd 0
vesa_modeinfo_width  dd 0
vesa_modeinfo_height dd 0

vesa_modeinfo_possible_lfb dd 0

vesa_modeinfo_writebuffer dd 0

vesa_modeinfo_blocks    dd 0
vesa_modeinfo_blocksize dd 0

vesa_handler:
 pushad
  cmp eax,1
  je vesa_init
  cmp eax,2
  je vesa_start
  cmp eax,3
  je vesa_blit
  cmp eax,4
  je vesa_kill
 popad
 mov eax,0
ret

vesa_init:
 mov vesa_modeinfo_number,ebx

 mov eax,vesa_rmS
 mov rm_eax,04f01h
 mov rm_ecx,ebx
 mov rm_edi,0
 mov rm_es,ax
 mov ax,10h
 call i_callrm

 mov esi,vesa_rmO
 movzx eax,byte ptr[esi+25]
 mov vesa_modeinfo_bpp,eax
 movzx eax,word ptr[esi+18]
 mov vesa_modeinfo_width,eax
 movzx eax,word ptr[esi+20]
 mov vesa_modeinfo_width,eax

 movzx eax,word ptr[esi]
 shr eax,6
 xor eax,1
 mov vesa_modeinfo_type,eax

 mov eax,[esi+40]
 mov vesa_modeinfo_possible_lfb,eax

 popad
 mov eax,2
ret

vesa_start:
  test vesa_modeinfo_type,2
  jnz vesa_start_lfb
  test vesa_modeinfo_type,1
  jnz vesa_start_banked
 popad
 mov eax,0
ret

vesa_start_lfb:
  mov esi,vesa_modeinfo_possible_lfb
  mov ecx,256*256*4
  call i_mapmem
  mov vesa_modeinfo_writebuffer,eax

  mov eax,vesa_modeinfo_number
  mov rm_eax,04f02h
  mov rm_ebx,eax
  or rm_ebx,4000h
  mov ax,10h
  call i_callrm

  cmp word ptr[rm_eax],0004fh
  jne vesa_start_fail

  mov rm_eax,04f07h
  mov rm_ebx,0
  mov rm_ecx,0
  mov rm_edx,0
  mov ax,10h
  call i_callrm

  mov vesa_modeinfo_blocks,1
  mov vesa_modeinfo_blocksize,64000
 popad
 mov eax,2
ret

vesa_start_banked:
 popad
 mov eax,0
ret

vesa_start_fail:
 popad
 mov eax,0
ret

vesa_blit:

 mov esi,tcono
 mov edi,vesa_modeinfo_writebuffer
 call i_getls
 add edi,eax
 mov ebx,vesa_modeinfo_blocks
 vesa_blit_l1:
  push offset vesa_blit_cont
  cmp vesa_modeinfo_bpp,32
  je vesa_blit_32bpp
  cmp vesa_modeinfo_bpp,24
  je vesa_blit_24bpp
  cmp vesa_modeinfo_bpp,16
  je vesa_blit_16bpp
  cmp vesa_modeinfo_bpp,15
  je vesa_blit_15bpp

  vesa_blit_cont:
  test vesa_modeinfo_type,2
  jnz vesa_modeinfo_nobank
   ; vesa setbank
  vesa_modeinfo_nobank:
 dec ebx
 jnz vesa_blit_l1

 popad
 mov eax,2
ret

vesa_blit_32bpp:
 finit
 mov ecx,vesa_modeinfo_blocksize

 shr ecx,2
 vesa_blit_32bpp_inner:
  fld qword ptr[esi]
  fld qword ptr[esi+8]
  add esi,16
  fstp qword ptr[edi+8]
  add edi,16
  fstp qword ptr[edi-16]
 loop vesa_blit_32bpp_inner

ret

vesa_blit_24bpp:
 mov ecx,vesa_modeinfo_blocksize
 vesa_blit_24bpp_inner:
  lodsd
  stosd
  dec edi
 loop vesa_blit_24bpp_inner
ret

vesa_blit_16bpp:
 push ebx
 mov ecx,vesa_modeinfo_blocksize
 shr ecx,1
 vesa_blit_16bpp_inner:
    mov eax,[esi+4]
    mov ebx,[esi+4]
    mov edx,[esi]
    shr bh,2
    mov ax,[esi+2]
    shr dh,2
    and ebx,000003ff8h
    shl eax,8
    and edx,000003ff8h
    shl ebx,13
    and eax,0f800f800h
    shr edx,3
    add ebx,eax
    add edi,4
    add ebx,edx
    add esi,8
    mov [edi-4],ebx
 loop vesa_blit_16bpp_inner
 pop ebx
ret


vesa_blit_15bpp:
 mov ecx,vesa_modeinfo_blocksize
 shr ecx,1
 vesa_blit_15bpp_inner:
  mov eax,[esi+4]
  mov edx,[esi]

   shr eax,3
   shr edx,3
   shl al,3
   shl dl,3
   shl ax,3
   shl dx,3
   shl edx,10
   shr eax,6

   shld eax,edx,16
   stosd
   add esi,8
 loop vesa_blit_15bpp_inner
ret


vesa_kill:
 popad
 mov eax,2
ret


vesa_add_modes:
 pushad
  call vesa_getinfo
  mov vesa_temp1,320
  mov vesa_temp2,200
  mov vesa_temp3,32
  call vesa_getmode
  mov vesa_temp3,24
  call vesa_getmode
  mov vesa_temp3,16
  call vesa_getmode
  mov vesa_temp3,15
  call vesa_getmode
 popad
 mov ecx,vesa_nummodes
 mov esi,offset vesa_modes
ret

vesa_getmode:
pushad
 mov esi,vesa_modebuffer
 sub esi,2
vesa_getmode_loop:
 add esi,2
 cmp word ptr[esi],-1
 je vesa_getmode_end

  movzx eax,word ptr[esi]
  mov ebx,vesa_rmS
  mov rm_eax,04f01h
  mov rm_ecx,eax
  mov rm_edi,0
  mov rm_es,bx
  mov ax,10h
  call i_callrm

  mov edi,vesa_rmO

  mov eax,vesa_temp2
  cmp ax,[edi+20]
  jne vesa_getmode_loop

  mov eax,vesa_temp1
  cmp ax,[edi+18]
  jne vesa_getmode_loop

  mov eax,vesa_temp3
  cmp al,[edi+25]
  jne vesa_getmode_loop

  test byte ptr[edi+0],1
  jz vesa_getmode_loop

  mov edi,vesa_nummodes
  shl edi,2
  lea edi,[edi*4+edi+offset vesa_modes]
  inc vesa_nummodes

  movzx eax,word ptr[esi]
  mov dword ptr[edi],eax
  mov eax,vesa_temp1
  mov dword ptr[edi+4],eax
  mov eax,vesa_temp2
  mov dword ptr[edi+8],eax
  mov eax,vesa_temp3
  mov dword ptr[edi+12],eax
  mov dword ptr[edi+16],0

vesa_getmode_end:
popad
ret

vesa_getinfo:
 call i_getrm          ; Get some realmode mem to play in
 mov vesa_rmS,eax      ; Store Seg
 shl eax,4
 mov vesa_rmO,eax      ; Store ofs
 call i_getls
 add vesa_rmO,eax      ; Fixup ofs

 mov esi,vesa_rmO

 mov byte ptr[esi+0],'V'
 mov byte ptr[esi+1],'B'
 mov byte ptr[esi+2],'E'
 mov byte ptr[esi+3],'2'

 mov eax,vesa_rmS
 mov rm_eax,04f00h
 mov rm_edi,0
 mov rm_es,ax
 mov ax,10h
 call i_callrm
 cmp rm_eax,04fh
; je error , fuck vesa..

 movzx ebx,word ptr[esi+14]
 movzx eax,word ptr[esi+16]
 shl eax,4
 add ebx,eax
 call i_getls
 add ebx,eax

 mov vesa_modebuffer,ebx
ret


