; mode13.asm
; part of the woorlic Truecolor lib

;                     Mode    Width    Height   Bpp   Type
mode_default_mode dd   0   ,   320   ,  200   ,   8  , 2

; 1 - Init
; 2 - Startup
; 3 - Blit
; 4 - Killof
mode_handler:
 pushad
  cmp eax,1
  je mode13_init
  cmp eax,2
  je mode13_start
  cmp eax,3
  je mode13_blit
  cmp eax,4
  je mode13_kill
 popad
 mov eax,0
ret

mode13_init:

 popad
 mov eax,2
ret

mode13_start:
  mov eax,13h
  int 10h
  call mode13_setpal
 popad
 mov eax,2
ret

mode13_blit:
 mov edi,0a0000h
 call i_getls
 add edi,eax
 mov esi,tcono
 mov ebp,16000

 mode13_blit_loop:
  mov eax,[esi+8]
  mov ebx,[esi+4]
  mov ecx,[esi+12]
  mov edx,[esi]

  shr eax,5
  shr ebx,5
  shr ecx,5
  shr edx,5
  shl al,5
  shl bl,5
  shl cl,5
  shl dl,5
  shr eax,1
  shr ebx,1
  shr ecx,1
  shr edx,1
  shl ax,6
  shl bx,6
  shl cx,6
  shl dx,6
  shr eax,10
  shr ebx,10
  shr ecx,10
  shr edx,10

  mov ah,cl
  shl eax,16
  mov ah,bl
  mov al,dl

  stosd
  add esi,16
 dec ebp
 jnz mode13_blit_loop

 popad
 mov eax,2
ret

mode13_kill:

 popad
 mov eax,2
ret

mode13_setpal:
  mov dx,3c8h
  mov al,0
  out dx,al
  inc dx

  mov esi,0                ; Red=0
mode13_setpal_r:
  mov edi,0                ; Green=0
mode13_setpal_g:
  mov ecx,8                ; Blue="0"
mode13_setpal_b:
   mov eax,esi
   lea eax,[eax*4+eax]
   shl eax,2
   out dx,al               ; Output, Ri*5*4
   mov eax,edi
   lea eax,[eax*2+eax]
   lea eax,[eax*2+eax]
   out dx,al               ; Output, Gi*3*3
   mov eax,8
   sub eax,ecx
   lea eax,[eax*2+eax]
   lea eax,[eax*2+eax]
   out dx,al               ; Output, Bi*3*3
  loop mode13_setpal_b
  inc edi
  cmp edi,8
  jne mode13_setpal_g
  inc esi
  cmp esi,4
  jne mode13_setpal_r
ret


mode_add_modes:
 mov ecx,1
 mov esi,offset mode_default_mode
ret

