/*
 * Judas Player. This program plays MODs, XMs and S3Ms and shows how to set up
 * the signal handlers to ensure proper JUDAS shutdown even in the case of user
 * break.
 *
 * It uses the timer routines in TIMER.C & TIMERASM.ASM. These don't
 * "officially" belong to JUDAS V2.0 but feel free to use them!
 *
 * This is not good C programming, not even intended to be!
 */

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include "judas.h"
#include "timer.h"

int main(int argc, char **argv);
static void handle_int(int a);

int main(int argc, char **argv)
{
        int mixrate = 44100;
        int mixmode = SIXTEENBIT | STEREO;
        int interpolation = 1;
        int mastervolume = 40;
        int filetype = 0;

        /* Set uninit functions to be called at exit */
        atexit(judas_uninit);
        atexit(timer_uninit);

        /* Set signal handlers */
        signal(SIGINT, handle_int);
        signal(SIGBREAK, handle_int);

        /* Print some shit */
        printf("-------------------------------------------------\n"
               "JUDAS V2.0 player by Faust - plays XMs+MODs+S3Ms.\n"
               "Press D to shell to DOS or any other key to quit.\n"
               "-------------------------------------------------\n");

        /* Check we have enough commandline parameters */
        if (argc == 1)
        {
               printf("Usage: jplay musicfile <options>\n"
                      "Options: -rxxxxx set mixrate\n"
                      "         -vxxx   set mastervolume (0-255, default 40)\n"
                      "         -m      force mono\n"
                      "         -8      force 8bit audio\n"
                      "         -n      turn interpolation off\n");
               return 1;
        }

        /* Parse options */
        if (argc > 2)
        {
                int count = 2;
                while (count < argc)
                {
                        char *ptr = argv[count];
                        if ((ptr[0] == '-') || (ptr[0] == '/'))
                        {
                                switch(tolower(ptr[1]))
                                {
                                        case 'r':
                                        sscanf(&ptr[2], "%d", &mixrate);
                                        break;

                                        case 'v':
                                        sscanf(&ptr[2], "%d", &mastervolume);
                                        if (mastervolume < 0) mastervolume = 0;
                                        if (mastervolume > 255) mastervolume = 255;
                                        break;

                                        case 'm':
                                        mixmode &= SIXTEENBIT;
                                        break;

                                        case '8':
                                        mixmode &= STEREO;
                                        break;

                                        case 'n':
                                        interpolation = 0;
                                        break;
                                }
                        }
                        count++;
                }
        }

        /* Autoconfigure by using enviroment */
        judas_config();

        /* Try to init */
        if (!judas_init(mixrate, mixmode, interpolation)) goto ERROR;

        /* Set mastervolume of channels */
        judas_setmusicmastervolume(CHANNELS, mastervolume);

        /* Hook timer to update sound */
        timer_init(0x4300, judas_update);

        /* Print some info */
        printf("Using %s at port %X IRQ %d DMA %d\nwith %s %s sound at %d Hz\n", judas_devname[judas_device], judas_port, judas_irq, judas_dma, judas_ipmodename[interpolation], judas_mixmodename[judas_mixmode], judas_mixrate);

        /*
         * Try to load, first XM, then MOD, then S3M
         */
        filetype = 1;
        judas_loadxm(argv[1]);
        if (judas_error == JUDAS_OK) goto PLAYIT;
        if (judas_error != JUDAS_WRONG_FORMAT) goto ERROR;
        filetype = 2;
        judas_loadmod(argv[1]);
        if (judas_error == JUDAS_OK) goto PLAYIT;
        if (judas_error != JUDAS_WRONG_FORMAT) goto ERROR;
        filetype = 3;
        judas_loads3m(argv[1]);
        if (judas_error == JUDAS_OK) goto PLAYIT;

        ERROR:
        printf("JUDAS ERROR:%s\n", judas_errortext[judas_error]);
        return 1;

        PLAYIT:
        switch(filetype)
        {
                case 1:
                printf("XM name:%s\n", judas_getxmname());
                printf("Channels:%d\n", judas_getxmchannels());
                judas_playxm();
                break;

                case 2:
                printf("Module name:%s\n", judas_getmodname());
                printf("Channels:%d\n", judas_getmodchannels());
                judas_playmod();
                break;

                case 3:
                printf("S3M name:%s\n", judas_gets3mname());
                printf("Channels:%d\n", judas_gets3mchannels());
                judas_plays3m();
                break;
        }

        for (;;)
        {
                char c;

                while (!kbhit())
                {
                        switch(filetype)
                        {
                                case 1:
                                printf("\rPos:%3d Line:%3d Tick:%3d", judas_getxmpos(), judas_getxmline(), judas_getxmtick());
                                break;

                                case 2:
                                printf("\rPos:%3d Line:%3d Tick:%3d", judas_getmodpos(), judas_getmodline(), judas_getmodtick());
                                break;

                                case 3:
                                printf("\rPos:%3d Line:%3d Tick:%3d", judas_gets3mpos(), judas_gets3mline(), judas_gets3mtick());
                                break;
                        }
                }

                c = toupper(getch());
                if (c == 'D')
                {
                        spawnl(P_WAIT, getenv("COMSPEC"), NULL);
                }
                else
                {
                        switch(filetype)
                        {
                                /*
                                 * Freeing isn't necessary but we do it just
                                 * to make sure it doesn't crash (page fault
                                 * will occur when freeing memory if heap has
                                 * been corrupted by the player!)
                                 */
                                case 1:
                                judas_freexm();
                                break;

                                case 2:
                                judas_freemod();
                                break;

                                case 3:
                                judas_frees3m();
                                break;
                        }
                        break;
                }
        }
        return 0;
}

static void handle_int(int a)
{
        exit(0); /* Atexit functions will be called! */
}
